//
//  MPreferenceEditor.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 1/8/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MPreferenceEditor.h"
#import "MConnectionEditor.h"
#import "MNibOwner.h"

@implementation MPreferenceEditor


- (id)initForConnectionsFile:(NSString*)file
{
  self= [super init];
  if (self)
  {
    if (![NSBundle loadNibNamed:@"PreferencesEditor" owner:self])
    {
      NSLog(@"Could not load PreferencesEditor nib file");
      [self release];
      return nil;
    }    
    _connectionEditor= [[MConnectionEditor alloc] initForFile:file];
    [[tabView tabViewItemAtIndex:0] setView: _connectionEditor->topView];
    
    _pages= [[NSMutableArray alloc] init];
  }
  return self;
}


- (void)registerPageNib:(NSString*)nibName withLabel:(NSString*)label
{
  MNibOwner *owner= [[MNibOwner alloc] init];
  NSTabViewItem *tabItem= [[NSTabViewItem alloc] initWithIdentifier:label];
  
  if (![NSBundle loadNibNamed:nibName owner:owner])
    NSLog(@"Can't load nib");

  [tabItem setLabel:label];
  [tabItem setView:owner->view];
  [tabView addTabViewItem:tabItem];
  [tabItem release];
  
  [_pages addObject:owner];
  [owner release];
}


- (void)dealloc
{
  [_pages release];
  [_connectionEditor release];
  [super dealloc];
}


- (NSWindow*)window
{
  return window;
}

- (void)windowWillClose:(NSNotification *)aNotification
{
  [_connectionEditor save:self];
  
  if (_inModalLoop)
    [NSApp stopModal];
  
  if (_releaseOnClose)
    [self release];
}


- (void)setReleaseOnClose:(BOOL)flag
{
  _releaseOnClose= flag;
}


- (void)show
{
  [window makeKeyAndOrderFront:nil];
}


- (int)runConnectionEditor
{
  [window makeKeyAndOrderFront:nil];
  _inModalLoop= YES;
  return [NSApp runModalForWindow:window];
}

@end
