/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kaction.h>
#include <kactioncollection.h>

#include "memopopupview.h"
#include "../util/emoticon.h"
#include "../util/common.h"

MemoPopupView::MemoPopupView(QWidget *parent, const char *name)
	: MemoPopup(parent, name),
pEmoticon(0),
sOrigText( QString::null ),
sUUID( QString::null ),
m_sTitle( QString::null ),
m_sDate( QString::null )
{
	connect(buttonReply, SIGNAL( clicked() ), SLOT( slotReply() ) );
	connect(buttonReplyAll, SIGNAL( clicked() ), SLOT( slotReplyAll() ) );
	connect(buttonForward, SIGNAL( clicked() ), SLOT( slotForward() ) );
	connect(buttonDelete, SIGNAL( clicked() ), SLOT( slotDelete() ) );

	if (!pEmoticon)
		pEmoticon = Emoticon::instance(); // pEmoticon = new Emoticon();
	config = kapp->config();
	config->setGroup( "MemoPopup" );
	resize( config->readSizeEntry("Size", &QSize( 480,320 ) ) );
	
	/// 쪽지 보내기 단축
	KActionCollection *ac =  new KActionCollection ( this );
	new KAction( i18n("&Send1"), "memo_send1", KShortcut( Qt::CTRL + Qt::Key_R ) , this, SLOT( slotReply() ), ac, "memo_send1" );
	new KAction( i18n("&Send2"), "memo_send2", KShortcut( Qt::CTRL + Qt::Key_F ) , this, SLOT( slotForward() ), ac, "memo_send2" );
	new KAction( i18n("&Send3"), "memo_send3", KShortcut( Qt::CTRL + Qt::SHIFT + Qt::Key_R ) , this, SLOT( slotReplyAll() ), ac, "memo_send3" );
	new KAction( i18n("&Send4"), "memo_send4", KShortcut( Qt::Key_Escape ) , this, SLOT( close() ), ac, "memo_send4" );
}


MemoPopupView::~MemoPopupView()
{
	config->writeEntry("Size", size() );
	config->sync();
	// if (pEmoticon) delete pEmoticon;
}

void MemoPopupView::setSender(const QString &sSender)
{
	labelSender->setText(sSender);
}

void MemoPopupView::setReceiver(const QString &sReceiver)
{
	labelReceiver->setText(sReceiver);
}

void MemoPopupView::setBody(const QString &sBody)
{
	QString sTemp( sBody );
	// sTemp.replace("&", "&amp;" );
	// sTemp.replace("<", "&lt;");
	// sTemp.replace(">", "&gt;");
	/*! 원문 저장 */
	Common::fixOutString( sTemp );
	sTemp.replace("\n", "<br>");
	labelMemo->setText( sTemp );
	
	sOrigText = "From: ";
	sOrigText += labelSender->text();
	sOrigText += "<br>";
	sOrigText += "To: ";
	sOrigText += labelReceiver->text();
	sOrigText += "<br>";
	sOrigText += "Sent: ";
	sOrigText += m_sDate;
	sOrigText += "<br>";
	sOrigText += "Subject: ";
	sOrigText += m_sTitle;
	sOrigText += "<br>";
	sOrigText += sBody;
}

void MemoPopupView::slotReply()
{
	emit replyMemo( MemoPopupView::Reply, labelSender->text(), sOrigText );
	close();
}

void MemoPopupView::slotReplyAll()
{
	emit replyMemo( MemoPopupView::ReplyAll, labelSender->text() + ";" + labelReceiver->text(), sOrigText );
	close();
}

void MemoPopupView::slotForward()
{
	emit replyMemo( MemoPopupView::Forward, "", sOrigText );
	close();
}

void MemoPopupView::slotDelete()
{
	int result = KMessageBox::  questionYesNo(this, QString::fromUtf8("쪽지를 삭제 하시겠습니까?"), i18n("쪽지 삭제") );
	
	if ( result == KMessageBox::No ) return;
	
	emit deleteMemo( sUUID );
	close();
}

void MemoPopupView::closeEvent(QCloseEvent * e)
{
	emit closeMemoPopup( this );
	MemoPopup::closeEvent( e );
}

void MemoPopupView::setTitle(const QString & sTitle)
{
	m_sTitle = sTitle; 
	Common::fixOutString( m_sTitle ); 
#if 0
	kdDebug() << "XXXXXXXXXXXXx [" << m_sTitle << "]" << endl;
#endif
}


#include "memopopupview.moc"
