using System;

public class Fraction {

	public this(mutable  numerator : int,mutable  denominator :  int) {
		Console.WriteLine("In Fraction Constructor(int, int)");
		this.numerator = numerator;
		this.denominator = denominator;
	}

	public this(mutable  wholeNumber : int) {
		Console.WriteLine("In Fraction Constructor(int)");
		numerator = wholeNumber;
		denominator = 1;
	}

	// this function is not recognised by mcs further down
	public static @:( theInt : int) :  Fraction {
		Console.WriteLine("In implicit conversion to Fraction");
		  Fraction(theInt);
	}

	public static @:>( theFraction : Fraction) :  int {
		Console.WriteLine("In explicit conversion to int");
		 theFraction.numerator /
			theFraction.denominator;
	}

	public static @==( lhs : Fraction, rhs :  Fraction) :  bool {
		Console.WriteLine("In operator ==");
		if (lhs.denominator == rhs.denominator &&
		    lhs.numerator == rhs.numerator)
		{ {
			 true;
		}
		}
		else { {
		// code here to handle unlike fraction
		 false;
	}
	}
	}

	public static @!=( lhs : Fraction, rhs :  Fraction) :  bool {
		Console.WriteLine("In operator !=");
		 !(lhs == rhs);
	}

	public override Equals(mutable  o : object) :  bool {
		Console.WriteLine("In method Equals");
		if (! (o is Fraction))
		{ {
			 false;
		}
		}
		else { {
		 this == ( o :> Fraction);
	}
	}
	}
  
	public static @+( lhs : Fraction, rhs :  Fraction) :  Fraction {
		Console.WriteLine("In operator +");
		if (lhs.denominator == rhs.denominator)
		{ {
			  Fraction(lhs.numerator + rhs.numerator,
					    lhs.denominator);
		}
		}
		else { {

		// simplistic solution for unlike fractions
		// 1/2 + 3/4 == (1*4) + (3*2) / (2*4) == 10/8
		mutable  firstProduct = lhs.numerator * rhs.denominator;
		mutable  secondProduct = lhs.denominator * rhs.numerator;
		  Fraction(
				    firstProduct + secondProduct,
				    lhs.denominator * rhs.denominator);
	}
	}
	}

	public override ToString() :  string {
		mutable  s = numerator.ToString() + "/" +
			denominator.ToString();
		 s;
	}

	private  mutable  numerator : int;
	private  mutable  denominator : int;
}

public class Tester {
	public static Main() :  int {

		mutable  f1 =  Fraction(3,4);
		Console.WriteLine("f1: {0}", f1.ToString());

		mutable  f2 =  Fraction(2,4);
		Console.WriteLine("f2: {0}", f2.ToString());

		mutable  f3 = f1 + f2;
		Console.WriteLine("f1 + f2 = f3: {0}", f3.ToString());

		mutable  f4 = f3 + 5;
		Console.WriteLine("f3 + 5 = f4: {0}", f4.ToString());

		mutable  f5 =  Fraction(2, 4); {
		when (f5 == f2) 
			Console.WriteLine("f5: {0} == f2: {1}",	f5.ToString(), f2.ToString());
		

		 0;
	}
	}
}
/*
BEGIN-OUTPUT
In Fraction Constructor(int, int)
f1: 3/4
In Fraction Constructor(int, int)
f2: 2/4
In operator +
In Fraction Constructor(int, int)
f1 + f2 = f3: 5/4
In implicit conversion to Fraction
In Fraction Constructor(int)
In operator +
In Fraction Constructor(int, int)
f3 + 5 = f4: 25/4
In Fraction Constructor(int, int)
In operator ==
f5: 2/4 == f2: 2/4
END-OUTPUT
*/
