using System;

struct A
{
	public  mutable  a : int;
	private  mutable  b : long;
	private  mutable  c : float;

	public this (mutable  foo : int)
	{
		a = foo;
		b = 8;
		c = 9.0F;
	}
}

struct B
{
	public  mutable  a : int;
}

struct C
{
	public  mutable  b : long;

	public this (mutable  foo : long)
	{
		b = foo;
	}

	// has `this' initializer, no need to initialize fields.
	public this (mutable  _foo : string)
	{
		 this (500); }
}

struct D
{
	public  mutable  foo : int;
}

struct E
{
	public  mutable  d : D;
	public  mutable  e : bool;

	public this (mutable  _foo : int)
	{
		this.e = true;
		this.d.foo = 9;
	}
}

struct F
{
	public  mutable  e : E;
	public  mutable  f : float;
}

class X
{
	static test_output (mutable  _x : A) :  void
	{ }

	static test_output (mutable  _y : B) :  void
	{ }

	static test_output (mutable  _e : E) :  void
	{ }

	static test_output (mutable  _f : F) :  void
	{ }

	static test1 () :  void
	{
		mutable  x = Nemerle.Extensions.DefaultValue (A);

		x.a = 5;
		Console.WriteLine (x.a);
	}

	static test2 () :  void
	{
		mutable  y = Nemerle.Extensions.DefaultValue (B);

		y.a = 5;
		Console.WriteLine (y.a);
		Console.WriteLine (y);
	}

	static test3 () :  void
	{
		mutable  x =  A (85);

		Console.WriteLine (x);
	}

	static test4 (mutable  x : A) :  void
	{
		x.a = 5;
	}

	static test5 (mutable  x : out A) :  void
	{
		x =  A (85);
	}

	static test6 (mutable  y : out B) :  void
	{
		y.a = 1;
	}

	static test7 () :  void
	{
		mutable  e = Nemerle.Extensions.DefaultValue (E);
		e.e = true;
		e.d.foo = 5;

		test_output (e);
	}

	static test8 () :  void
	{
		mutable  f = Nemerle.Extensions.DefaultValue (F);
		f.e.e = true;
		f.e.d.foo = 5;
		f.f = 3.14F;

		test_output (f);
	}

	static test9 () :  void
	{
		mutable  e =  E (5);
		Console.WriteLine (e.d.foo);
	}

	static test10 () :  void
	{
		mutable  f = Nemerle.Extensions.DefaultValue (F);
		f.e =  E (10);
		Console.WriteLine (f.e.d.foo);
		Console.WriteLine (f.e.d);
		f.f = 3.14F;
		Console.WriteLine (f);
	}

	public static Main () :  int
	{
		// Compilation-only test.
		 0;
	}
}
/*
BEGIN-OUTPUT
END-OUTPUT
*/
