//
// Tests for bug #51446, where MCS did not pick the right enumerator
// from a class.
//

using System;
using System.Collections;
using System.Collections.Specialized;

namespace MonoBUG
{

	public class Bug
	{
		public static Main(mutable  _args :  array [string]) :  int
		{
			mutable  l =  FooList();
			mutable  f1 =  Foo("First");
			mutable  f2 =  Foo("Second");

			l.Add(f1);
			l.Add(f2);

			foreach ( _f : Foo in l) {
			}

			if (FooList.foo_current_called != true)

			{
				 1;

			}

			else
		{
		{
			if (FooList.ienumerator_current_called != false)
			{
				 2;
			}
			else
		{
		{
			Console.WriteLine ("Test passes");
			 0;
		}
		}
		}
		}
		}
	}

	public class Foo
	{
		private  mutable  m_name : string;
		
		public this(mutable  name : string)
		{
			m_name = name;
		}
		
		public Name : string {
			get {  m_name; }
		}
	}

	[Serializable()]
	public class FooList : DictionaryBase  
	{
		public static  mutable  foo_current_called : bool = false;
		public static  mutable  ienumerator_current_called : bool = false;
			
		public this() 
		{
		}
		
		public Add(mutable  value : Foo) :  void 
		{
			Dictionary.Add(value.Name, value);
		}
		
		public new GetEnumerator() :  FooEnumerator 
		{
			  FooEnumerator(this);
		}
		
		public class FooEnumerator : object, IEnumerator 
		{
			
			private  mutable  baseEnumerator : IEnumerator;
			
			private  mutable  temp : IEnumerable;
			
			public this(mutable  mappings : FooList) 
			{
				this.temp = ( (mappings) : IEnumerable);
				this.baseEnumerator = temp.GetEnumerator();
			}
			
			public Current : Foo 
			{
				get 
				{
					Console.WriteLine("Foo Current()");
					foo_current_called = true;
					 ( (( (baseEnumerator.Current) :> DictionaryEntry)).Value :> Foo);
				}
			}
			
			 IEnumerator_Current : object implements IEnumerator.Current 
			{
				get 
				{
					Console.WriteLine("object IEnumerator.Current()");
					ienumerator_current_called = true;
					 baseEnumerator.Current;
				}
			}
			
			public MoveNext() :  bool 
			{
				 baseEnumerator.MoveNext();
			}
			
			 IEnumerator_MoveNext() : bool implements IEnumerator.MoveNext 
			{
				 baseEnumerator.MoveNext();
			}
			
			public Reset() :  void 
			{
				baseEnumerator.Reset();
			}
			
			 IEnumerator_Reset() : void implements IEnumerator.Reset 
			{
				baseEnumerator.Reset();
			}
		}
	}
}
/*
BEGIN-OUTPUT
Foo Current()
Foo Current()
Test passes
END-OUTPUT
*/
