using Nemerle.IO;

module M {
  foo (x : int) : int
  {
    ret : {
      when (x < 17)
        ret (42);
      when (x < 33)
        ret (4242);
      x * 33
    }
  }
  
  bar (x : int) : int
  {
    brk : {
      for (mutable tmp = x; tmp > 0; tmp--) {
        when (tmp == 42)
          brk(42);
      }
      x
    }
  }
  
  bar2 (x : int) : int
  {
    brk : { 
      for (mutable tmp = x; tmp > 0; tmp--) {
        when (tmp == 42)
          brk(42);
      }
      brk(x)
    }
  }

  foobar (x : int) : string
  {
    mutable res = "";
    brk : {
      for (mutable i = 0; i < x; ++i) {
        when (i == 13)
          brk ();
        res += "x";
      }
    }
    res
  }
  
  quxx () : void
  {
    mutable x = 3;
    x = throw System.Exception ();
    while (true) {} // W: skipped in code generation because of unreachable
  }

  Exceptions () : void {
    ret: {
      try {
        Nemerle.IO.print ("try 1\n");
        ret ();
      }
      catch {
        | _ => ()
      }
    }

    ret: {
      try {
        Nemerle.IO.print ("catch 1\n");
        throw System.Exception ();
      }
      catch {
        | _ =>
          Nemerle.IO.print ("catch 2\n");
          ret ();
      }
    }
    double_ret: {
      try {
        try {
          Nemerle.IO.print ("try try 1\n");
          double_ret ();
        }
        catch { _ => () }
        Nemerle.IO.print ("try try 2\n");
      }
      catch { _ => () }
    }
    ret: {
      try {
        Nemerle.IO.print ("try-fin 1\n");
        ret ();
      }
      finally {
        Nemerle.IO.print ("try-fin 2\n");
        // returns are not allowed from finally
      }
    }
  }


  try_foo () : int
  {
    ret : {
      try {
        ret (42);
      } finally {
        Nemerle.IO.print ("must be finally\n");
      }
    }
  }

  
  Main () : void
  {
    assert (foo (3) == 42);
    assert (foo (20) == 4242);
    assert (foo (333) == 33 * 333);
    assert (bar (3) == 3);
    assert (bar (50) == 42);
    assert (bar2 (3) == 3);
    assert (bar2 (50) == 42);
    assert (foobar (3) == "xxx");
    assert (foobar (33) == "xxxxxxxxxxxxx");
    Exceptions ();
    assert (try_foo () == 42);

    // bug #501:
    def res = [1,2,3];
    def res =
      ret : {
        foreach (elem in res)
          when (elem == 3)
            ret (res.Filter (fun (mem) {
              ! (mem == 3)
            }));
        ret (res)
      }
    System.Console.WriteLine (res);
  }
}

/*
BEGIN-OUTPUT
try 1
catch 1
catch 2
try try 1
try-fin 1
try-fin 2
must be finally
[1, 2]
END-OUTPUT
*/
