 
using System;
using Nemerle;

class M
{
  static foo ([Lazy] x : int, y : bool) : void {
    if (y) {
      Console.WriteLine (x);
      Console.WriteLine (x);
    }
    else
      Console.WriteLine ("nothing");
  }

  static SideEffect : int {
    get {
      Console.WriteLine ("somebody is fetching me");
      1
    }
  }

  static WillThrow : int {
    get {
      Console.WriteLine ("I will throw HAHAHA!");      
      throw System.Exception ();
    }
  }
  
  static LazyLiteral () : LazyValue [double]
  {
    def x = lazy (7.0);
    assert (x == 7.0);
    x
  }
  
  public static Main() : void
  {
    def laz = lazy (SideEffect + 1);
    foo (laz, false);
    foo (laz, true);

    def l = lazy ("2" + "3");    
    IO.printf ("%s\n", l);
    
    def laz1 = lazy (WillThrow + 1);
    foo (laz1, false);
    try { foo (laz1, true); }
    catch { _ => Console.WriteLine ("catched") }
    try { foo (laz1, true); }
    catch { _ => Console.WriteLine ("catched") }

    mutable inflist = InfList (0);
    repeat (10) {
      IO.printf ("%d ", inflist.Val);
      inflist = inflist.Next;
    }
    IO.printf ("\n");
    
    _ = LazyLiteral ();
  }
}

class InfList {
  public Val : int;
  public Next : LazyValue [InfList];

  public this (v : int) {
    Val = v;
    Next = lazy (InfList (v + 1)); 
  }
}


/*
BEGIN-OUTPUT
nothing
somebody is fetching me
2
2
23
nothing
I will throw HAHAHA!
catched
catched
0 1 2 3 4 5 6 7 8 9
END-OUTPUT
*/
