
module TestsNullable 
{
  print (x : int?) : void {
    def isnull = x == null;  
    def isnotnull = x != null;
    assert (isnull == (null == x));
    assert (isnotnull == (null != x));
    assert (isnull != isnotnull);
    Nemerle.IO.print ("isnull=$isnull value=$x\n");
  }
  
  basic () : void {
    print (1);  
    print (null); 
  }

  equals () : void {
    mutable x = null;
#if !RUNTIME_MONO    
    // mono release and svn from 5.5.2006 does not handle this correctly
    assert (x.Equals (null));
#endif
    _ = x : int?;
  }
    
  Main () : void {
    basic();
    equals ();
  }
}

/*
BEGIN-OUTPUT
isnull=False value=1
isnull=True value=
END-OUTPUT
*/