/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
using Sioux;
using Nemerle.Xml;
using System.Xml;
using System.Xml.Xsl;

public class Upload : Application
{
    override protected DoGet() : void
    {
        def xg = XmlGenerator("docs/upload/upload.xml");
        FormTemplate = Some(XmlPipeline.Process(xg,[]));
    }
    
    override protected DoPost() : void
    {
        def sb = System.Text.StringBuilder();
        
        def print_posted_file(name : string,infos : string * string * int)
        {
            ignore(sb.Append("Form name: " + name + "<br/>"));
            match(infos)
            {
                | (rn,tn,s) =>
                  ignore(sb.Append("File name: " + rn + "<br/>"));
                  ignore(sb.Append("Temp name: " + tn + "<br/>"));
                  ignore(sb.Append("Size: " + s.ToString() + "<br/><br/>"));
            }
            
        }
        
        match(PageName)
        {
            | "/upload.xml" =>
              ignore(sb.Append("[html][head][title]Upload file example</title></head>[body][h4]Uploaded file</h4>"));
              PostedFiles.Iter(print_posted_file);
              match(PostVars.Get("submitter"))
              {
                  | Some(subm) => ignore(sb.Append("Sent by: " + subm + "<br/>"));
                  | None => ()
              }
              ignore(sb.Append("</body></html>"));
              def doc = XmlDocument();
              doc.LoadXml(sb.ToString());

              def xg = XmlGenerator(doc);
              FormTemplate = Some(XmlPipeline.Process(xg,[]));
            | _ => def xg = XmlGenerator("docs/upload/upload.xml");
              FormTemplate = Some(XmlPipeline.Process(xg,[]));
        }
    }
}