#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#
 desc = "
Matt Wright's Formmail CGI is installed on the remote host.
The product exposes its version number, and in addition, 
early versions of the product suffered from security 
vulnerabilities, which include: allowing SPAM, file disclosure, 
enviroment variable disclosure, and more.

Solution: Upgrade to the latest version.

Risk factor : Low

Additional information:
http://www.securiteam.com/cgi-bin/htsearch?config=htdigSecuriTeam&words=Formmail";

if(description)
{
 script_id(10782);

 name["english"] = "Formmail Version Information Disclosure";
 script_name(english:name["english"]);

 script_description(english:desc);

 summary["english"] = "Formmail Version Information Disclosure";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[0] = "/cgi-local/";
dir[1] = "/cgi-bin/common/";
dir[2] = "/scripts/";
dir[3] = "/cgi_bin/";
dir[4] = cgibin();

program[0] = "formmail.pl";
program[1] = "formmail.pl.cgi";
program[2] = "FormMail.cgi";

port = get_kb_item("Services/www");
if (!port) port = 80;

for (i = 0; dir[i] ; i = i + 1)
{
 for (j = 0; program[j] ; j = j + 1)
 {
  url = string(dir[i], program[j]);
#  display("Trying: ", url, "\n");
  if (is_cgi_installed(url))
  {
   req = http_get(item:url, port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:1000);

#    display(buf);

    find_type_1 = string("<title>FormMail v");
    find_type_2 = string("FormMail</a> V");
    if ( ((find_type_1 >< buf) && ("Version " >< buf)) || (find_type_2 >< buf))
    {
     report = string(desc, "\n", "Version : ", version);
     security_note(port:port, data:version);
    }
   }
   exit(0); 
  }
 }
}
