#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com> 
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10739); 
 
 name["english"] = "Novell Web Server NDS Tree Browsing";
 script_name(english:name["english"]);
 
 desc["english"] = "The Novell Web Server default ndsobj.nlm CGI (LCGI) was 
detected. This CGI allows browsing of the NDS Tree without any need for 
authentication.

Gaining access to the NDS Tree reveals sensitive information to an attacker.

Solution: Configure your Novell Web Server to block access to this CGI, 
or delete it if you do not use it.

For More Information: http://www.securiteam.com/securitynews/5XP0L1555W.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Novell Web Server NDS Tree Browsing";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

 dir[0] = "/lcgi";
 dir[1] = "/lcgi-bin";
 dir[2] = "/LCGI";
 dir[3] = "/apage/lcgi-bin";

 port = get_kb_item("Services/www");
 if (!port) port = 80;

 if (get_port_state(port))
 { #1
  soctcp80 = open_sock_tcp(port);

  if (soctcp80)
  { #2
   cgi_dir = "false";
   for (i = 0; dir[i] ; i = i + 1)
   {
    check_dir = string(dir[i],"/ndsobj.nlm");
    if (is_cgi_installed(check_dir))
    {
     cgi_dir = check_dir;
    }
   }
   #display(cgi_dir);

   if ("false" >< cgi_dir)
   {
    exit(0);
   }

   data = http_get(item:cgi_dir, port:port);
   resultsend = send(socket:soctcp80, data:data);
   resultrecv = recv(socket:soctcp80, length:8192);
   close(soctcp80);

   if ("Available NDS Trees" >< resultrecv)
   { #3
    security_hole(port:port);
   } #3

#   if ("CGIWrap Error" >< resultrecv)
#   {
#    display("Wrapper exists, cannot access");
#   }

   close(soctcp80);
  } #2
 }
