#TRUSTED 559dd4094bf9961bb2609b5ce8f308ce119972a238bc42dad5f0072853b913dc08835962987456b280f7fbe262c53a0c8705df11fa05e8ce572f978dfd804799d244f1f01e56b160e19f6ea3dcd0e5fb33ea594b712b7eca0e42d50a287065a24934924032696a916c4e81d2ed50fde04d8fdc6ab9d48a43f4a7f4ff07acfc20c163d1349f2079a9412637911f317ec46700a7b2c09515aec39071eb9e99238aa0594a3d1b8ec1f91b816dc1901e69b21a070e52fe97410b08666f908872ace3d9956e4b5332f97e6a784fce6ef3fdc648cd2af9dbd99265b32407b2dcc1d3c80f1f5e9a184622f77757f4fd2255b636826656521150c9f0f3a6fd13b8f795fabb85f40959109eddb90a89c8405a5b1d2697414dade306f575ef32cd2ceeaff9811c312491e39d644af26c5d2620ea334227025a3942793f9e001b98f983e59f2c62058fc22c7fd4d9bf71aa0dd1143e3be5ccd0d1f8ca14554f1cb7483303463b38bc63c3cb36cc5fa22e40910a2166662517322858b800bebe40339abc830f453a0bb7a1668c973bc43b5deff14f63da981d3352ce28ab8334e4626593ce92be3b1b7f20b4dfcca42e1ed0561604a19cb7e22a14b3be1784c3ce564b192927e65705e7ff2fe14ac39858acf47145691c08196cde1b803a189e1a4638e2012508d94cf618833986549d5a092c059950bae15d5c73a8ebfc8f7b9fef543018d8
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15889);
 script_version ("1.3");
 name["english"] = "Hydra: telnet";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find telnet passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force telnet authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "doublecheck_std_services.nasl", "telnetserver_detect_type_nd_version.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
thorough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< thorough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/telnet");
if (! port) exit(0);	# port = 23;
if (! get_port_state(port)) exit(0);

# Check that this is not a router
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if ("Password:" >< r) exit(0);	# Probably a CISCO

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd != NULL)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "telnet";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/telnet/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following Telnet accounts:\n' + report);
