/*  VER 166  TAB P   $Id: proto.h,v 1.31 1999/04/19 03:32:39 src Exp $
 *
 *  function prototypes
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: proto.h,v $
 *  Revision 1.31  1999/04/19 03:32:39  src
 *  Standard profile in $PATHETC/newsx.conf
 *
 *  Revision 1.30  1999/04/07 20:09:16  src
 *  Implemented configuration reading, and eval mechanism
 *
 *  Revision 1.29  1999/04/07 08:02:11  src
 *  Implemented --profile
 *
 *  Revision 1.28  1999/04/05 19:01:51  src
 *  Lock for scanlogs
 *
 *  Revision 1.27  1999/03/24 03:53:00  src
 *  Implemented "newsx" as magic exclude pattern
 *
 *  Revision 1.26  1999/03/16 08:12:46  src
 *  Moved clean_active() to active.c
 *
 *  Revision 1.25  1999/03/16 08:03:30  src
 *  Renamed lock() to do_lock()
 *
 *  Revision 1.24  1999/03/11 07:30:01  src
 *  Implemented check for spool free space
 *
 *  Revision 1.23  1999/03/07 14:58:19  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.22  1998/11/22 18:02:32  src
 *  Filtering repaired
 *
 *  Revision 1.21  1998/11/22 08:23:07  src
 *  Added --forget-inactive
 *
 *  Revision 1.20  1998/11/22 08:00:08  src
 *  Option --no-queue
 *
 *  Revision 1.19  1998/11/21 19:14:24  src
 *  Added --filter option
 *
 *  Revision 1.18  1998/10/25 04:08:56  src
 *  A little more debugging on lockfiles.
 *
 *  Revision 1.17  1998/09/21 10:04:29  src
 *  Added new command line options for --inews
 *
 *  Revision 1.16  1998/09/14 06:30:25  src
 *  *** empty log message ***
 *
 *  Revision 1.15  1998/09/11 16:37:44  src
 *  Lockfile for logfile of posted articles and for posted article folder.
 *
 *  Revision 1.14  1998/09/11 09:17:43  src
 *  Check path consistency (--no-path) and length (--max-path)
 *  GNU style option --help, --version, --dry-run, changed --noxx to --no-xx
 *  Check for putenv and setenv, added xstrcpy
 *
 *  Revision 1.13  1998/09/09 07:32:13  src
 *  Version 1.1
 *
 *  Revision 1.12  1998/09/03 05:14:30  src
 *  Improved bad syntax messages
 *
 *  Revision 1.11  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.10  1998/09/02 06:50:31  src
 *  newsx version 1.0
 *
 *  Revision 1.9  1998/09/02 06:34:41  src
 *  Support @-syntax in newsfeeds, and support AUTHINFO GENERIC
 */

/* main.c */
void
pickargs(int argc,char *argv[],char *envp[]);

/* doit.c */
int 
doit(void);
void
exit_cleanup(int exitcode);

/* statistics.c */
void        
statistics(time_t starttime,time_t endtime);

/* despool.c */
void 
despool(char *article_name);
char *
despool_line(void);

/* putarticle.c */
char *
submit_article(char *articlename);
int
is_tag(char *line, char *tag);
void
close_article(void);

/* lock.c */
int
do_lock(char *dir_name,char *lock_name,int giveup);
void 
unlock_one(int id);
void 
unlock_all(void);
void 
unlock_exit(int n);
int
check_lock(char* name);

/* util.c */
int 
append_file(FILE *f,char *name,FILE *af);
int 
rename_file(char *from,char *to);
int 
is_regular(FILE *f, char *name, long *sizep);
void 
build_alt_filename(char *where,char *home,char *fixed,char *alt);
void 
build_filename(char *where,char *arg1,char *arg2,char *arg3,char *arg4);
char *
text_time(time_t t);
char *
skipsp(char *p);
void *
xmalloc(unsigned int size);
void * 
xrealloc(void *p,unsigned int size);
char *
xstrcpy(const char *str);

/* logmsg.c */
void 
log_open(void);
void
show_activity(void);
void 
log_msg(int type, char *fmt, ...);
char *
str_error(int err);

/* server.c */
SOCKET_D *current_socket();
int 
open_server(char *host,char *port);
int
close_server(int urgent);
int 
get_server_nntp(char *line, int size);
int 
get_server_nntp_nf(char *line, int size);
int 
get_server_msg(char *line, int size);
int
put_server_nolog(char *line);
int
put_server(char *line);
int 
put_server_msg(char *line);
RETSIGTYPE 
sig_alrm(int signo);

/* socket.c */
int 
socket_open(char *hostname, char *service, SOCKET_D *sock);
void 
socket_close(SOCKET_D *sock);
int 
get_socket(char *line, int size, SOCKET_D *sock);
int 
put_socket(char *line, SOCKET_D *sock);

/* getarticle.c */
int 
select_group(char *group,long *firstp,long *lastp);
int 
fetch_article(long where,int more,char* group);

/* request.c */
int 
put_request(char *request, int (*fn)(char *,long,char *), 
					long where, char *group);
int 
process_request(void);
int 
flush_request(void);

/* pull.c */
int
pull(char *hostname);
void 
pull_cleanup(int urgent);

/* incoming.c */
int 
write_incoming(char *buffer,long bytecount,int is_a_path);
int 
flush_spool(int urgent);

/* active.c */
int 
is_active(char *group);
int 
is_in_active(char *group);
int 
unseen_active(char *group);
void 
load_active(int again);
int
bad_syntax(char *buf,int was,int expect,char *where);

/* sys.c */
void
add_extra(char *group_list);
void 
load_sys(void);
int 
sys_allow(char *group);

/* auth.c */
void 
get_authinfo(char *file);
void 
do_authinfo(char *username,char *password);
void
do_mode_reader(void);

/* history.c */
void 
history_done(void);
int 
history_lookup(char *msgid);

/* msgid.c */
int 
new_msgid(char *msgid);

/* hash.c */
int 
hashindex(char *key,int hashlen);

/* exec.c */
int 
ctlinnd(char *arg1, char *arg2);
int 
script(char *program, int in, int out);
int        
wait_pid(int pid);
void 
program_open(char *program, SOCKET_D *sock);
FILE *
fork_write(char *path, int *pidp, char *arg1, char *arg2);
FILE *
fork_read(char *path,int *pidp,char *arg);
FILE *
open_any(char *any,int *pidp);
int     
close_any(FILE *f,int pid);

/* telnet.c */
int 
read_telnet(char *line, int size, SOCKET_D *sock);
int 
write_telnet(char *line, SOCKET_D *sock);

/* script.c */
void 
chat_update(char *line,SOCKET_D *sock);

/* title.c */
void 
begintitle(int argc, char **argv, char **envp);
void 
settitle(char *name);
void 
progtitle(char *what);
void 
progtitle2(char *what,char *more);

/* wildmat.c */
int 
wildmat(char *text, char *p);

/* bounce.c */
int  
bounce_msg(char *to, char *a_data,int a_len,time_t a_arrived,
			char *filename, char *msgid, char *reason);

/* rnews.c */
FILE *
open_rnews(int *pid);
int 
close_rnews(FILE *f, int pid);

/* filter.c */
int  
do_filter(char *msgid, char *group);
void
filter_line(char *line);
int  
filter_reject(char *msgid);

/* mfilter.c */
int  
do_mfilter(char *msgid);

/* list.c */
void 
get_list(void);
void 
get_desc(void);

/* path.c */
void
add_exclusion(char *path);
char *
get_exclusion(void);
int
path_match(char *path);
int
traverse_path(char *path);
int
path_bangs(char *path);

/* config.c */
int
load_config(char *configname);

/* freespc.c */
int 
freespace(char *path, long *kbytep, long *inodep);

/* split.c */
void
split_file(char *name,char *envp[],int complain);
