/*  VER 302   TAB P   $Id: main.c,v 1.45.2.3 2002/01/29 19:40:37 egil Exp $
 *
 *  an NNTP news exchange client
 *
 *  copyright 1996, 1997, 1998 Egil Kvaleberg, egil@kvaleberg.no
 *  Husebybakken 14A, N-0379 Oslo, Norway         
 *
 *  this program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  this program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  see the
 *  GNU General Public License for more details.
 *
 *  you should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Log: main.c,v $
 *  Revision 1.45.2.3  2002/01/29 19:40:37  egil
 *  Spool name with a slash
 *
 *  Revision 1.45.2.2  2002/01/29 06:44:48  egil
 *  Changing from xmalloc, xrealloc, xstrcpy to
 *  malloc_perfect, realloc_perfect and strdup_perfect
 *
 *  Revision 1.45.2.1  2001/02/14 06:55:40  egil
 *  Fixes from Winston Edmond
 *
 *  Revision 1.45  1999/04/19 04:20:07  src
 *  Profile for specific spool
 *
 *  Revision 1.44  1999/04/19 03:51:03  src
 *  Added config options for newsq
 *
 *  Revision 1.43  1999/04/19 03:32:38  src
 *  Standard profile in $PATHETC/newsx.conf
 *
 *  Revision 1.42  1999/04/17 15:00:52  src
 *  Documentation for 1.4
 *
 *  Revision 1.41  1999/04/08 07:31:29  src
 *  Support for a list of runtime configuration files.
 *
 *  Revision 1.40  1999/04/08 06:31:09  src
 *  Support for full runtime configuration
 *
 *  Revision 1.39  1999/04/07 20:09:16  src
 *  Implemented configuration reading, and eval mechanism
 *
 *  Revision 1.38  1999/04/07 08:02:11  src
 *  Implemented --profile
 *
 *  Revision 1.37  1999/04/07 07:46:46  src
 *  Changes longopts slightly
 *
 *  Revision 1.36  1999/04/07 07:10:55  src
 *  Implemented --tag
 *
 *  Revision 1.35  1999/04/05 19:01:51  src
 *  Lock for scanlogs
 *
 *  Revision 1.34  1999/03/30 17:43:56  src
 *  Got rid of "subscript has type char" warning message
 *
 *  Revision 1.33  1999/03/16 17:35:38  src
 *  Version 1.4pre
 *
 *  Revision 1.32  1999/03/14 08:47:54  src
 *  Uprated log for innreport.
 *
 *  Revision 1.31  1999/03/11 07:30:00  src
 *  Implemented check for spool free space
 *
 *  Revision 1.30  1999/03/07 15:40:58  src
 *  Removed DBZ_VERSION from configuration
 *
 *  Revision 1.29  1999/03/07 14:58:18  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.28  1999/03/05 11:20:43  src
 *  Delayed decision of dbz v3 vz. 6 to runtime.
 *
 *  Revision 1.27  1998/11/23 12:25:49  src
 *  Default window size 10.
 *
 *  Revision 1.26  1998/11/22 18:37:10  src
 *  Filter test.
 *
 *  Revision 1.25  1998/11/22 18:02:32  src
 *  Filtering repaired
 *
 *  Revision 1.24  1998/11/22 08:23:07  src
 *  Added --forget-inactive
 *
 *  Revision 1.23  1998/11/22 08:00:08  src
 *  Option --no-queue
 *
 *  Revision 1.22  1998/11/21 19:14:23  src
 *  Added --filter option
 *
 *  Revision 1.21  1998/10/25 04:08:56  src
 *  A little more debugging on lockfiles.
 *
 *  Revision 1.20  1998/10/23 06:10:57  src
 *  Fixed --without-history
 *
 *  Revision 1.19  1998/10/21 07:31:22  src
 *  Opened syslog at an an earlier stage
 *
 *  Revision 1.18  1998/09/21 10:04:29  src
 *  Added new command line options for --inews
 *
 *  Revision 1.17  1998/09/18 07:30:59  src
 *  Implemented --inews
 *
 *  Revision 1.16  1998/09/13 13:52:05  src
 *  Moved getopt to lib
 *
 *  Revision 1.15  1998/09/11 16:37:44  src
 *  Lockfile for logfile of posted articles and for posted article folder.
 *
 *  Revision 1.14  1998/09/11 09:17:42  src
 *  Check path consistency (--no-path) and length (--max-path)
 *  GNU style option --help, --version, --dry-run, changed --noxx to --no-xx
 *  Check for putenv and setenv, added xstrcpy
 *
 *  Revision 1.13  1998/09/09 07:32:12  src
 *  Version 1.1
 *
 *  Revision 1.12  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.11  1998/09/02 06:50:31  src
 *  newsx version 1.0
 *
 *  Revision 1.10  1998/09/02 06:34:41  src
 *  Support @-syntax in newsfeeds, and support AUTHINFO GENERIC
 *
 *  Revision 1.9  1998/08/24 06:17:15  src
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "self.h"
#include "news.h"
#include "patchlevel.h"

#define INIT_CONFIG 1
#include "newsconfig.h"

#if HAVE_GETOPT_LONG
#include <getopt.h>
#else
#include "../lib/getopt.h"
#endif

#if HAVE_SYS_STAT_H
#  include <sys/stat.h>
#endif

static void
load_profile(char *name, char *envp[],int complain);
static void
lnumarg(char *arg,long *where, char option);
static void
numarg(char *arg,int *where, char option);
static void 
usage(void);
static void 
stringarg(char *arg,char **where, char option);
static void 
timearg(char *arg,long *where, char dflt, char option);

char *newline = "\r\n";
static int did_stat_attempts = 0;

/*
 *  long command line options
 */
static int option_index = -1;
static char *long_list = {
    "a:b:cde:f:gh:ikl:mnopq:rs:t:uvw:x:y:zA:B:H:I:LM:N:P:RT:W:X:Z?"
} ;
static struct option long_options[] = {
   /* char *name, int has_arg, int *flag, int val */
    {"auth",            1, 0, 'a'},
    {"size",            1, 0, 'b'},
    {"cnews",           0, 0, 'c'},
    {"verbose",         0, 0, 'd'},
    {"end",             1, 0, 'e'},
    {"posted",          1, 0, 'f'},
    {"nofetch",         0, 0, 'g'},
    {"no-fetch",        0, 0, 'g'},
    {"history",         1, 0, 'h'},
    {"inn",             0, 0, 'i'},
    {"keep-path",       0, 0, 'k'},
    {"keeppath",        0, 0, 'k'},
    {"log",             1, 0, 'l'},
    {"nomsgid",         0, 0, 'm'},
    {"no-msgid",        0, 0, 'm'},
    {"noaction",        0, 0, 'n'},
    {"dry-run",         0, 0, 'n'},
    {"keepold",         0, 0, 'o'},
    {"nopost",          0, 0, 'p'},
    {"no-post",         0, 0, 'p'},
    {"enquire",         1, 0, 'q'},
    {"reader",          0, 0, 'r'},
    {"spool",           1, 0, 's'},
    {"timeout",         1, 0, 't'},
    {"noforce",         0, 0, 'u'},
    {"no-force",        0, 0, 'u'},
    {"version",         0, 0, 'v'},
    {"chat",            1, 0, 'w'},
    {"exec",            1, 0, 'x'},
    {"connect",         1, 0, 'y'},
    {"sync",            0, 0, 'z'},
    {"active",          1, 0, 'A'},
    {"batch",           1, 0, 'B'},
    {"home",            1, 0, 'H'},
    {"incoming",        1, 0, 'I'},
    {"list",            1, 0, 'L'},
    {"missing",         1, 0, 'M'},
    {"newsfeeds",       1, 0, 'N'},
    {"bounce",          1, 0, 'O'},
    {"profile",         1, 0, 'P'},
    {"stat",            1, 0, 'Q'},
    {"reset",           0, 0, 'R'},
    {"sys",             1, 0, 'S'},
    {"togo",            1, 0, 'T'},
    {"rnews",           0, 0, 'U'},
    {"window",          1, 0, 'W'},
    {"maxnew",          1, 0, 'X'},
    {"syncnew",         0, 0, 'Z'},
    {"help",            0, 0, '?'},
    {"attach",          1, 0,  1},
    {"desc",            1, 0,  2},
    {"alldesc",         1, 0,  3},
    {"ctlinnd",         1, 0,  4},
    {"locks",           1, 0,  5},
    {"mfilter",         1, 0,  6},
    {"maxart",          1, 0,  7},
    {"newline",         0, 0,  8},
    {"nops",            0, 0,  9},
    {"authgeneric",     0, 0, 10},
    {"debug",           1, 0, 11},
    {"fail",            1, 0, 12},
    {"max-path",        1, 0, 13},
    {"inews",           0, 0, 14},
    {"inews-options",   1, 0, 15},
    {"add-header",      1, 0, 16},
    {"pipe-to",         1, 0, 17},
    {"rnews-to",        1, 0, 18},
    {"filter",          1, 0, 19},
    {"groups",          1, 0, 20},
    {"config",          0, 0, 21},
    {"config-is",       1, 0, 22},
    {"minfree",         1, 0, 23},
    {"newlist",         1, 0, 24},
    {"ihave",           0, 0, 25},
    {"inhosts",         1, 0, 26},
    {"spoolname",       1, 0, 27},
    {"hostname",        1, 0, 28},
    {"port",            1, 0, 29},
    {"readbeforeauth",  0, &readbeforeauth_opt, 1}, /* do AUTHINFO after MODE READER */
    {"no-path",         0, &nopath_opt,         1},
    {"no-ps",           0, &no_ps,              1},
    {"nohostlock",      0, &no_host_lock,       1},
    {"no-hostlock",     0, &no_host_lock,       1},
    {"nonext",          0, &no_next,            1},
    {"no-next",         0, &no_next,            1},
    {"continue",        0, &conterr,            1}, /* continue, ignoring some errors */
    {"noreader",        0, &mode_reader_opt,   -1}, /* don't do a 'MODE READER' */
    {"no-reader",       0, &mode_reader_opt,   -1},
    {"noqueue",         0, &noqueue,            1},
    {"no-queue",        0, &noqueue,            1},
    {"forget-inactive", 0, &forget_inactive,    1},
    {"keep-fake",       0, &keep_fake,          1},
    {"scanlogs",        0, &scanlogs_lock,      1},
    {"tag",             0, &tag_opt,            1},
    {"verify",          0, &verify_opt,         1},
    {0, 0, 0, 0}
};

/*
 *  main 
 */
int 
main(int argc, char *argv[], char *envp[])
{
    char *p,*q;
    int ok;

    /* initialize and set the name of the program */
    for (q=argv[0]; (p=strchr(q,'/')); ) q = p+1;
    stringarg(q,&pname,0);
    begintitle(argc,argv,envp);

    /* find out who we are */
    my_pid = getpid();
    gethostname(my_hostname, sizeof(my_hostname)-1);

    log_open();

    /* plus some command line defaults */
    nopull_opt = 0;
    inn_opt = INN_MODE;
    minspool = MINSPOOL;
    ai_isgeneric = 0;
    readbeforeauth_opt = 0;
    window = 10;
    max_path = 1;

    /* use the default umask for news */
    umask(NEWSUMASK);

    /*
     *  check if runtime configuration is required
     *  BUG: what if newshome specified on command line
     */
    if (!cfg_newshome[0]) {
	if (debug_opt)
	    fprintf(stderr,"doing runtime config from \"%s\"\n",NEWSCONFIG);
	load_config(NEWSCONFIG);
    }

    /*
     *  load the standard profile, if any
     *  NOTE: debug flags are not active now...
     */
    if (cfg_etc[0]) {
	char name[PATH_MAX];
	build_filename(name,cfg_etc,"/",NEWSX_CONF,NULL);
	load_profile(name, envp, 0);
    }

    /* parse the args */
    pickargs(argc,argv,envp);

    /* defaults */
    if (!hostname || !hostname[0]) hostname = spoolname;
    if (!hostport || !hostport[0]) hostport = NNTP_PORT;
    if (!spoolname) spoolname = getenv("NNTPSERVER");
    if (!spooldir) stringarg(SPOOL,&spooldir,0);
    if (!did_stat_attempts) stat_attempts = (window==0) ? 0:2;

    /* sanity checks */
    if (spoolname && strchr(spoolname,'/')) {
	fprintf(stderr, "spool name cannot contain a '/': %s\n",spoolname);
	unlock_exit(2);
    }
    if (!enquire_opt && (!spoolname || !spoolname[0])) {
	fprintf(stderr, "spool name missing\n");
	usage();
	unlock_exit(2);
    }

    if (spoolname) {
	char name[PATH_MAX+PATH_MAX];

	/* set the program title for "ps" */
	sprintf(name,"%s(%s)",pname,spoolname);
	settitle(name);

	/* load per-host profile */
	build_filename(name,cfg_inhosts,"/",spoolname,_CONF);
	load_profile(name, envp, 0);
    }

    /* do what we were told */
    ok = doit();

    /* remove locks */
    history_done();
    unlock_all();

    return ok;
}

/*
 *  pick arguments from command line
 *  NOTE: the actual command line will be cleared after this,
 *        so all strings will be lost and must thus be copied as reqd.
 */
void
pickargs(int argc,char *argv[],char *envp[])
{
    int c;
    char *p;

    optind = 0;                 /* tell getopt to reset internal variables */

    for (;;) {
	option_index = -1;
	c = getopt_long(argc,argv, long_list, long_options, &option_index);
	if (c == EOF) break;

	switch (c) {
	case 'a':                       /* do an authinfo */
	    if (ai_username) goto usage;
	    get_authinfo(optarg);
	    break;
	case 'b':                       /* min spool size in bytes */
	    lnumarg(optarg,&minspool,c);
	    break;
	case 'c':                       /* C News mode */
	    inn_opt=0;
	    break;
	case 'd':                       /* debugging on */
	    debug_opt++;
	    break;
	case 'e':                       /* end at tag */
	    /* remove any leading blanks */
	    for (p=optarg; isspace((unsigned char)(*p)); ++p) ;
	    stringarg(p,&end_tag,c);
	    break;
	case 'f':                       /* folder */
	    stringarg(optarg,&folder,c);
	    break;
	case 'h':                       /* history file */
	    stringarg(optarg,&cfg_history,c);
	    if (!cfg_history || !cfg_history[0]) {
		/* disable history */
#if WITH_HISTORY
		extern int hist_open;
		hist_open = -1;
#else
	    } else {
		fprintf(stderr, "%s: history not supported\n", pname);
#endif
	    }
	    break;
	case 'g':                       /* don't get news */
	    ++nopull_opt;
	    break;
	case 'i':                       /* INN mode */
	    inn_opt=1;
	    break;
	case 'k':                       /* keep "Path" */
	    keep_path_opt = 1;
	    break;
	case 'l':                       /* logfile */
	    stringarg(optarg,&logfile,c);
	    break;
	case 'n':                       /* do nothing */
	    noaction_opt++;
	    break;
	case 'm':                       /* skip message ID */
	    if (ihave_opt) goto usage;  /* impossible */
	    nomsgid_opt++;
	    break;
	case 'o':                       /* keep .old */
	    keep_old_opt++;
	    break;
	case 'p':                       /* no posting */
	    nopost_opt++;
	    break;
	case 'r':                       /* do a 'MODE READER' */
	    mode_reader_opt = 1;
	    break;
	case 'q':                       /* enquire */
	    stringarg(optarg,&enquire_opt,c);
	    break;
	case 's':                       /* spool */
	    stringarg(optarg,&spooldir,c);
	    break;
	case 't':                       /* timeout in seconds */
	    timearg(optarg,&timeout,'s',c);
	    break;
	case 'u':                       /* no unlock by force */
	    noforce_opt++;
	    break;
	case 'w':                       /* -w chat */
	    stringarg(optarg,&chat_file,c);
	    break;
	case 'v':                       /* version */
	    printf("%s version %s%s\n", pname, VERSION, PATCHLEVEL);
	    /* keep the lawyers busy */
	    printf("%s\n", COPYRIGHT);
	    printf("This is free software; the GNU General Public License applies.\n");
	    printf("There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n");
	    printf("PARTICULAR PURPOSE.\n");
	    unlock_exit(0); /* leave it at that */
	    break;
	case 'x':                       /* -x connect script */
	    stringarg(optarg,&connect_exec,c);
	    break;
	case 'y':                       /* -y connect via */
	    stringarg(optarg,&via_exec,c);
	    break;
	case 'z':                       /* zero incoming */
	    if (reset_opt || zapnew_opt) goto usage;
	    zap_opt++;
	    break;
	case 'A':                       /* active file */
	    stringarg(optarg,&cfg_active,c);
	    break;
	case 'B':                       /* batch directory */
	    stringarg(optarg,&cfg_batch,c);
	    break;
	case 'H':                       /* news home directory */
	    stringarg(optarg,&cfg_newshome,c);
	    break;
	case 'I':                       /* incoming directory */
	    stringarg(optarg,&cfg_incoming,c);
	    break;
	case 'L':                       /* get list of groups */
	    stringarg(optarg,&group_list,c);
	    break;
	case 'M':                       /* missing num */
	    numarg(optarg,&stat_attempts,c);
	    ++did_stat_attempts;
	    break;
	case 'N':                       /* newsfeeds file */
	case 'S':                       /* sys file */
	    stringarg(optarg,&cfg_newsfeeds,c);
	    break;
	case 'O':                       /* bounce */
	    stringarg(optarg,&bounce,c);
	    break;
	case 'P':                       /* profile */
	    load_profile(optarg,envp,1);
	    break;
	case 'Q':                       /* stat */
	    stringarg(optarg,&statfile,c);
	    break;
	case 'R':                       /* reset incoming */
	    if (zap_opt || zapnew_opt) goto usage;
	    reset_opt++;
	    break;
	case 'T':                       /* togo file */
	    stringarg(optarg,&togo,c);
	    break;
	case 'U':                       /* rnews */
	    if (rnews_path) {
	      rnews_and_inews:
		fprintf(stderr,
		"%s: can't combine --inews, --rnews, --rnews-to and --pipe-to\n",
								    pname);
		goto usage;
	    }
	    rnews_opt++;
	    rnews_path = RNEWS_PATH;
	    rnews_name = "rnews";
	    break;
	case 'W':                       /* window size */
	    numarg(optarg,&window,c);
	    break;
	case 'X':                       /* maxnew */
	    numarg(optarg,&max_new,c);
	    break;
	case 'Z':                       /* zero new groups */
	    if (reset_opt || zap_opt) goto usage;
	    zapnew_opt++;
	    break;
	case '?':                       /* help */
	    usage();
	    printf("Report bugs to %s\n", BUGCATCHER);
	    unlock_exit(0); /* that's ok */
	    break;
	case 1:                         /* attach */
	    if (strcmp(optarg,"mime")==0 || strcmp(optarg,"m")==0) {
		attach = 0; /* default */
	    } else if (strcmp(optarg,"yes")==0 || strcmp(optarg,"y")==0) {
		attach = 'y';
	    } else if (strcmp(optarg,"no")==0 || strcmp(optarg,"n")==0) {
		attach = 'n';
	    } else {
		fprintf(stderr,"%s: unknown --attach mode: %s\n",
				pname,                     optarg);
	    }
	    break;
	case 2:                         /* get description of groups */
	    stringarg(optarg,&group_desc,c);
	    break;
	case 3:                         /* get description of all groups */
	    stringarg(optarg,&group_alldesc,c);
	    break;
	case 4:                         /* ctlinnd program */
	    stringarg(optarg,&ctlpgm,c);
	    break;
	case 5:                         /* locks */
	    stringarg(optarg,&cfg_locks,c);
	    break;
	case 6:                         /* mfilter */
	    stringarg(optarg,&mfilter,c);
	    break;
	case 7:                         /* maxart */
	    numarg(optarg,&max_articles,c);
	    break;
	case 8:                         /* newline */
	    newline = "\n";
	    break;
	case 10:
	    /* --authgeneric : authenticate using AUTHINFO GENERIC */
	    /* if we've already parsed an argument specifying authentication */
	    if (ai_username) goto usage;
	    /* might as well grab the NNTPAUTH info now */
	    ai_username = getenv("NNTPAUTH");
	    if (!ai_username) {
		fprintf(stderr,"--authgeneric specified, but NNTPAUTH envariable not set\n");
		unlock_exit(10); /* exit: authinfo error */
	    }
	    /*
	     * the GNU libc docs say that the string returned by getenv()
	     * could be clobbered by another getenv() on some non-GNU systems.
	     * To be safe, we copy it into fresh memory.
	     */
	    ai_username = strdup_perfect(ai_username);
	    /*
	     * Note that we are generic. We could do this just by noticing
	     * that for generic the password string will be NULL, but that's
	     * a bit icky :->
	     */
	    ai_isgeneric = 1;
	    break;
	case 11:                        /* debug */
	    numarg(optarg,&debug_opt,c);
	    break;
	case 12:                        /* fail after specified time */
	    if (strcmp(optarg,"never")==0) {
		failtime=0;
	    } else {
		timearg(optarg,&failtime,'h',c);
		if (failtime==0) failtime=1;
	    }
	    break;
	case 13:                        /* maxpath */
	    numarg(optarg,&max_path,c);
	    break;
	case 14:                       /* inews */
	    if (rnews_path) goto rnews_and_inews;
	    inews_opt++;
	    rnews_path = INEWS_PATH;
	    rnews_name = "inews";
	    if (!inews_options) inews_options = "-hOS";
			    /*
			     * -h = complete with headers
			     * -O = don't add organization
			     * -S = don't add signature
			     * -R = reject control messages
			     */
	    break;
	case 15:                        /* inews-options */
	    if (inews_options) inews_options = NULL;
	    stringarg(optarg,&inews_options,c);
	    break;
	case 16:                        /* add-header */
	    stringarg(optarg,&add_header,c);
	    break;
	case 17:                       /* pipe-to */
	    if (rnews_path) goto rnews_and_inews;
	    inews_opt++; /* one message per process mode... */
	    stringarg(optarg,&rnews_path,c);
	    rnews_name = rnews_path;
	    break;
	case 18:                       /* rnews-to */
	    if (rnews_path) goto rnews_and_inews;
	    rnews_opt++; /* continouos mode... */
	    stringarg(optarg,&rnews_path,c);
	    rnews_name = rnews_path;
	    break;
	case 19:                        /* filter */
	    stringarg(optarg,&filter,c);
	    break;
	case 20:                        /* groups */
	    add_extra(optarg);
	    break;
	case 21:                        /* load standard config */
	    load_config(NEWSCONFIG);
	    break;
	case 22:                        /* config file, as specified */
	    load_config(optarg);
	    break;
	case 23:                        /* min spool free in kbytes */
	    lnumarg(optarg,&minfree,c);
	    break;
	case 24:                        /* get list of new groups */
	    stringarg(optarg,&group_newlist,c);
	    break;
	case 25:                        /* ihave */
	    if (nomsgid_opt) goto usage;
	    ihave_opt++;
	    break;
	case 26:                        /* in.hosts directory */
	    stringarg(optarg,&cfg_inhosts,c);
	    break;
	case 27:                        /* spoolname */
	    stringarg(optarg,&spoolname,c);
	    break;
	case 28:                        /* hostname */
	    stringarg(optarg,&hostname,c);
	    break;
	case 29:                        /* port */
	    stringarg(optarg,&hostport,c);
	    break;
	case 0:
	    break;
		
	default:
	  usage:
	    usage();
	    unlock_exit(2);
	}
    }
	
    /* get spool name */
    if (optind < argc) {
	if (argv[optind][0]) stringarg(argv[optind],&spoolname,0);
	++optind;
    } 

    /* get server name */
    if (optind < argc) {
	if (argv[optind][0]) stringarg(argv[optind],&hostname,0);
	++optind;
    }
	
    /* get port name */
    if (optind < argc) {
	if (argv[optind][0]) stringarg(argv[optind],&hostport,0);
	++optind;
    } 

    if (optind < argc) {
	fprintf(stderr, "excess arguments\n");
	goto usage;
    }
}

/*
 *  say how to use it
 *  BUG: have a more complete list!
 */
static void 
usage(void)
{
    printf("Usage:\n");
    printf("\tnewsx [options] spoolname [[hostname] port]\n");
    printf("Some commonly used options:\n");
    printf("\t--dry-run      Don't touch anything\n");
    printf("\t--log file     Keep log of posted articles in file\n");
    printf("\t--maxnew N     Fetch at most N articles from a group\n");
    printf("\t--no-post      Don't post\n");
    printf("\t--no-fetch     Don't fetch\n");
    printf("\t--posted file  Copy of all articles posted to file\n");
    printf("\t--verbose      Give more information\n");
    printf("\t--version\n");
    printf("\t--window N     Use a pipeline of size N to speed things up\n");
    printf("For further information, try:\n");
    printf("\tman 8 newsx\n");
}

/*
 *  load a profile
 */
static void
load_profile(char *name, char *envp[], int complain)
{
    static int include = 0;
    if (++include >= 20) {
	fprintf(stderr,"too deep --profile nesting for \"%s\"\n",
							    name);
	unlock_exit(2);
    }
    split_file(name,envp,complain);
    --include;
}

/*
 *  make proper name of option, for error reporting
 *  returns static buffer, so beware
 */
static char *
namopt(char short_option)
{
    static char buf[50];

    if (option_index >= 0) { /* it was a long option */
	sprintf(buf,"--%s",long_options[option_index].name);
    } else {
	sprintf(buf,"-%c",short_option);
    }
    return buf;
}

/*
 *  handle numeric long argument
 */
static void
lnumarg(char *arg,long *where, char option)
{
    long a;
    char *p;

    a = strtol(arg,&p,10);
    if (p == arg || *p) {
	fprintf(stderr,"%s: bad numeric spec for option %s: %s\n",
			pname,              namopt(option), arg);
	return;
    }

#if 0 /* BUG: find other way of doing this */
    if (*where != 0 && *where != a) {
	fprintf(stderr,"%s: option %s was \"%d\", respecified as \"%d\"\n",
		     pname, namopt(option), *where,                a);
    }
#endif
    *where = a;
}

/*
 *  handle numeric argument
 */
static void 
numarg(char *arg,int *where, char option)
{
    long a = *where;

    lnumarg(arg,&a,option);
    *where = a;
}

/*
 *  handle string argument
 *  move to heap
 */
static void 
stringarg(char *arg,char **where, char option)
{
    if (*where) {
	fprintf(stderr,"%s: option %s was \"%s\", respecified as \"%s\"\n",
		     pname, namopt(option), *where,                arg);
    }
    *where = strdup_perfect(arg);
}

/*
 *  time multiplier
 */
static int  
timemul(char c, long *where)
{
    switch (c) {
    case 'w': /* weeks */
	*where *= 7;
    case 'd': /* days */
	*where *= 24;
    case 'h': /* hours */
	*where *= 60;
    case 'm': /* minutes */
	*where *= 60;
    case 's': /* seconds */
	return 1;
    default:
	return 0;
    }
}
/*
 *  handle expire time argument
 */
static void 
timearg(char *arg,long *where, char dflt, char option)
{
    int a = 0;
    long n;
    char *p;

    if (*where) {
	fprintf(stderr,"%s: option %s was respecified as \"%s\"\n",
			pname, namopt(option),             arg);
    }
    *where = 0;
    do {
	++a;
	n = strtol(arg,&p,10);
	if (p == arg) {
	    fprintf(stderr,"%s: bad time spec for option %s: %s\n",
			    pname,            namopt(option), arg);
	    break;
	}
	if (timemul(*p,&n)) ++p;
	else if (!*p) timemul(dflt,&n);
	*where += n;
    } while (*(arg = p));
}


