/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import mlsub.typing.FunType;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Typing;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Kind;
import mlsub.typing.lowlevel.Unsatisfiable;

public class FunTypeKind
implements Kind {
    private static FunTypeKind[] funtypeKinds;
    public int domainArity;

    public static FunTypeKind get(int domainArity) {
        if (funtypeKinds[domainArity] == null) {
            FunTypeKind.funtypeKinds[domainArity] = new FunTypeKind(domainArity);
        }
        return funtypeKinds[domainArity];
    }

    public static void reset() {
        funtypeKinds = new FunTypeKind[400];
    }

    private FunTypeKind(int domainArity) {
        this.domainArity = domainArity;
        Engine.getConstraint(this);
    }

    public Monotype freshMonotype(boolean existential) {
        MonotypeVar codomain = new MonotypeVar(existential);
        Typing.introduce(codomain);
        Element[] domain = MonotypeVar.news(this.domainArity, existential);
        Typing.introduce(domain);
        return new FunType(this, (Monotype[])domain, codomain);
    }

    public void register(Element e) {
    }

    public void leq(Element e1, Element e2, boolean initial) throws Unsatisfiable {
        if (initial) {
            throw new InternalError("initial leq in FunTypeKind");
        }
        this.leq(e1, e2);
    }

    public void leq(Element e1, Element e2) throws Unsatisfiable {
        FunType t1 = this.ft(e1);
        FunType t2 = this.ft(e2);
        Engine.leq(t2.domain(), t1.domain());
        Engine.leq(t1.codomain(), t2.codomain());
    }

    private FunType ft(Element e) {
        try {
            return (FunType)((Monotype)e).equivalent();
        }
        catch (ClassCastException ex) {
            throw new InternalError(e + " was expected to be a functional type, " + " it's a " + e.getClass());
        }
    }

    public String toString() {
        return "Fun(" + this.domainArity + ")";
    }
}

