/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.repository;

import gnu.expr.ModuleBody;
import gnu.expr.ModuleMethod;
import gnu.mapping.Procedure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import nice.lang.AssertionFailed;
import nice.lang.rawArray;
import nice.tools.locator.Locator;
import nice.tools.repository.IncompatibleVersions;
import nice.tools.repository.VersionTracker;
import nice.tools.repository.dispatch;
import nice.tools.repository.fun$copy;
import nice.tools.repository.fun$latestVersionLocal;
import nice.tools.repository.fun$latestVersionRemote;
import nice.tools.repository.fun$load;
import nice.tools.repository.fun$save;

public class fun
extends ModuleBody {
    public static final File cache;
    public static int id;
    static final boolean $assertionsEnabled;
    public static final Procedure deleteAll;
    static final Character Lit0;
    static final Character Lit1;
    public static final fun $instance;

    public static void main(String[] args) {
        dispatch._testSingle();
    }

    public static void _testMultipleMemory2() {
        File f = new File("/tmp/versions");
        f.delete();
        VersionTracker vt = new VersionTracker(f, new HashMap());
        Locator locator = dispatch._setupMultiple(vt);
        if ($assertionsEnabled && !dispatch.is(locator.get("foo/bar/a.txt#1"), "a1")) {
            throw new AssertionFailed("locator.get(\"foo/bar/a.txt#1\").is(\"a1\") failed at tests.nice:103");
        }
        vt.save();
        if ($assertionsEnabled && locator.get("foo/bar/b.txt") != null) {
            throw new AssertionFailed("`==`(locator.get(\"foo/bar/b.txt\"), null) failed at tests.nice:105");
        }
    }

    public static void _testMultipleMemory1() {
        File f = new File("/tmp/versions");
        f.delete();
        VersionTracker vt = new VersionTracker(f, new HashMap());
        Locator locator = dispatch._setupMultiple(vt);
        if ($assertionsEnabled && !dispatch.is(locator.get("foo/bar/a.txt#1"), "a1")) {
            throw new AssertionFailed("locator.get(\"foo/bar/a.txt#1\").is(\"a1\") failed at tests.nice:92");
        }
        vt.save();
        if ($assertionsEnabled && !dispatch.is(locator.get("foo/bar/a.txt"), "a1")) {
            throw new AssertionFailed("locator.get(\"foo/bar/a.txt\").is(\"a1\") failed at tests.nice:94");
        }
    }

    public static void _testMultipleConflict() {
        Locator locator = dispatch._setupMultiple(null);
        if ($assertionsEnabled && !dispatch.is(locator.get("foo/bar/a.txt"), "a2")) {
            throw new AssertionFailed("locator.get(\"foo/bar/a.txt\").is(\"a2\") failed at tests.nice:78");
        }
        try {
            locator.get("foo/bar/a.txt#1");
            throw new AssertionFailed("Incompatible versions expected");
        }
        catch (IncompatibleVersions incompatibleVersions) {
            return;
        }
    }

    public static void _testMultipleUnknown() {
        if ($assertionsEnabled && dispatch._setupMultiple(null).get("foo/bar/a.txt#42") != null) {
            throw new AssertionFailed("`==`(`_setupMultiple`().get(\"foo/bar/a.txt#42\"), null) failed at tests.nice:73");
        }
    }

    public static void _testMultipleNew() {
        if ($assertionsEnabled && !dispatch.is(dispatch._setupMultiple(null).get("foo/bar/a.txt#2"), "a2")) {
            throw new AssertionFailed("`_setupMultiple`().get(\"foo/bar/a.txt#2\").is(\"a2\") failed at tests.nice:72");
        }
    }

    public static void _testMultipleOld() {
        if ($assertionsEnabled && !dispatch.is(dispatch._setupMultiple(null).get("foo/bar/a.txt#1"), "a1")) {
            throw new AssertionFailed("`_setupMultiple`().get(\"foo/bar/a.txt#1\").is(\"a1\") failed at tests.nice:71");
        }
    }

    public static void _testMultipleLatest() {
        if ($assertionsEnabled && !dispatch.is(dispatch._setupMultiple(null).get("foo/bar/a.txt"), "a2")) {
            throw new AssertionFailed("`_setupMultiple`().get(\"foo/bar/a.txt\").is(\"a2\") failed at tests.nice:70");
        }
    }

    public static void _testMultipleLatest2() {
        File tmp = dispatch.makeTempDir();
        dispatch.addJar(tmp, "foo.bar", "2", new String[]{"foo/bar/a.txt", "a2", "foo/bar/b.txt", "b2"});
        dispatch.addJar(tmp, "foo.bar", "1", new String[]{"foo/bar/a.txt", "a1"});
        Locator locator = new Locator(new URL[]{new VersionTracker(null, new HashMap()).repository(tmp.toURL())});
        if ($assertionsEnabled && !dispatch.is(locator.get("foo/bar/a.txt"), "a2")) {
            throw new AssertionFailed("locator.get(\"foo/bar/a.txt\").is(\"a2\") failed at tests.nice:67");
        }
    }

    public static Locator _setupMultiple(VersionTracker vt) {
        URL[] uRLArray;
        File tmp = dispatch.makeTempDir();
        dispatch.addJar(tmp, "foo.bar", "1", new String[]{"foo/bar/a.txt", "a1"});
        dispatch.addJar(tmp, "foo.bar", "2", new String[]{"foo/bar/a.txt", "a2", "foo/bar/b.txt", "b2"});
        VersionTracker versionTracker = vt;
        if (versionTracker == null) {
            versionTracker = new VersionTracker(null, new HashMap());
        }
        VersionTracker v = versionTracker;
        URL[] path = new URL[]{v.repository(tmp.toURL())};
        if (path != null) {
            int n = path.length;
            URL[] uRLArray2 = new URL[n];
            System.arraycopy(path, 0, uRLArray2, 0, n);
            uRLArray = uRLArray2;
        } else {
            uRLArray = null;
        }
        return new Locator(uRLArray);
    }

    public static boolean is(URLConnection c, String value) {
        return c != null ? dispatch.readAll(c.getInputStream()).equals(value) : false;
    }

    public static void _testSingle() {
        if ($assertionsEnabled && !dispatch.is(dispatch._setupSingle().get("foo/bar/a.txt"), "a")) {
            throw new AssertionFailed("`_setupSingle`().get(\"foo/bar/a.txt\").is(\"a\") failed at tests.nice:37");
        }
        if ($assertionsEnabled && !dispatch.is(dispatch._setupSingle().get("foo/bar/a.txt#1"), "a")) {
            throw new AssertionFailed("`_setupSingle`().get(\"foo/bar/a.txt#1\").is(\"a\") failed at tests.nice:38");
        }
        if ($assertionsEnabled && dispatch._setupSingle().get("foo/bar/a.txt#42") != null) {
            throw new AssertionFailed("`==`(`_setupSingle`().get(\"foo/bar/a.txt#42\"), null) failed at tests.nice:39");
        }
    }

    public static void addJar(File dir, String pkg, String ver, String[] content) {
        String filename = nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b(dispatch.packagePath(pkg), pkg), nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("-", ver), ".jar"));
        File file = new File(dir, filename);
        ((File)nice.lang.dispatch.notNull(file.getParentFile())).mkdirs();
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(file));
        int i = 0;
        while (i < content.length) {
            String name = content[i];
            String value = content[i + 1];
            jar.putNextEntry(new JarEntry(name));
            jar.write(value.getBytes());
            i += 2;
        }
        jar.close();
    }

    public static void deleteAll(File f) {
        if (f.isDirectory()) {
            File[] fileArray;
            Object object = nice.lang.dispatch.notNull(f.listFiles());
            if (object instanceof File[]) {
                fileArray = (File[])object;
            } else {
                Object[] objectArray = (Object[])object;
                if (objectArray != null) {
                    int n = objectArray.length;
                    File[] fileArray2 = new File[n];
                    System.arraycopy(objectArray, 0, fileArray2, 0, n);
                    fileArray = fileArray2;
                } else {
                    fileArray = null;
                }
            }
            nice.lang.dispatch.foreach(rawArray.make(fileArray), deleteAll);
        }
        f.delete();
    }

    /*
     * WARNING - void declaration
     */
    public static File makeTempDir() {
        void var0;
        File f = new File(nice.lang.dispatch.$$002b("/tmp/ntl", (Object)new Integer(id++)));
        dispatch.deleteAll(f);
        f.mkdirs();
        return var0;
    }

    public static Locator _setupSingle() {
        URL[] uRLArray;
        File tmp = dispatch.makeTempDir();
        dispatch.addJar(tmp, "foo.bar", "1", new String[]{"foo/bar/a.txt", "a"});
        VersionTracker vt = new VersionTracker(null, new HashMap());
        URL[] path = new URL[]{vt.repository(tmp.toURL())};
        if (path != null) {
            int n = path.length;
            URL[] uRLArray2 = new URL[n];
            System.arraycopy(path, 0, uRLArray2, 0, n);
            uRLArray = uRLArray2;
        } else {
            uRLArray = null;
        }
        return new Locator(uRLArray);
    }

    public static String readAll(InputStream in) {
        int len;
        StringBuffer res = new StringBuffer(in.available());
        InputStreamReader reader = new InputStreamReader(in);
        char[] buf = new char[100];
        while ((len = reader.read(buf)) > 0) {
            res.append(buf, 0, len);
        }
        return res.toString();
    }

    public static void save(VersionTracker this_, File store) {
        fun$save fun$save = new fun$save();
        fun$save.out = new PrintWriter(new FileWriter(store));
        nice.lang.dispatch.foreach(this_.versions, (Procedure)fun$save.lambda$Fn11);
        fun$save.out.close();
    }

    public static void save(VersionTracker this_) {
        if (this_.store != null && this_.versions.size() > 0) {
            this_.save((File)nice.lang.dispatch.notNull(this_.store));
        }
    }

    public static void load(VersionTracker this_, File store) {
        fun$load fun$load = new fun$load();
        fun$load.this = this_;
        dispatch.lines(new FileInputStream(store), (Procedure)fun$load.lambda$Fn12);
    }

    public static void copy(InputStream in, File dest) {
        fun$copy fun$copy = new fun$copy();
        fun$copy.in = in;
        fun$copy.out = new FileOutputStream(dest);
        nice.lang.dispatch.using(fun$copy.out, fun$copy.lambda$Fn13);
    }

    /*
     * WARNING - void declaration
     */
    public static File download(URL repo, String jar) {
        void var3_3;
        URL url = new URL(repo, jar);
        File cached = new File(cache, jar);
        if (!cached.exists()) {
            nice.lang.dispatch.println(nice.lang.dispatch.$$002b("Downloading ", (Object)url));
            ((File)nice.lang.dispatch.notNull(cached.getParentFile())).mkdirs();
            dispatch.copy(url.openStream(), cached);
        }
        return var3_3;
    }

    public static URL localCopy(URL repo, String jar) {
        if (!dispatch.remote(repo)) {
            return new URL(repo, jar);
        }
        return dispatch.download(repo, jar).toURL();
    }

    public static boolean remote(URL url) {
        String protocol = url.getProtocol();
        return !protocol.equals("file");
    }

    public static String latestVersionLocal(URL repo, String pkg) {
        fun$latestVersionLocal fun$latestVersionLocal = new fun$latestVersionLocal();
        fun$latestVersionLocal.pkg = pkg;
        fun$latestVersionLocal.latest = null;
        URL url = new URL(repo, dispatch.packagePath(fun$latestVersionLocal.pkg));
        try {
            dispatch.lines(url.openStream(), (Procedure)fun$latestVersionLocal.lambda$Fn14);
        }
        catch (IOException e) {
            // empty catch block
        }
        String res = fun$latestVersionLocal.latest;
        if (res == null) {
            return null;
        }
        return res.substring(res.lastIndexOf(45) + 1, res.lastIndexOf(46));
    }

    /*
     * WARNING - void declaration
     */
    public static void lines(BufferedReader in, Procedure action) {
        String string;
        while ((string = in.readLine()) != null) {
            void line;
            action.apply1(line);
        }
    }

    public static void lines(InputStream i, Procedure action) {
        dispatch.lines(new BufferedReader(new InputStreamReader(i)), action);
    }

    public static String packagePath(String pkg) {
        return nice.lang.dispatch.$$002b(pkg.replace('.', '/'), (Object)Lit1);
    }

    public static String latestVersionRemote(URL repo, String pkg) {
        fun$latestVersionRemote fun$latestVersionRemote = new fun$latestVersionRemote();
        fun$latestVersionRemote.latest = null;
        URL url = new URL(repo, nice.lang.dispatch.$$002b(dispatch.packagePath(pkg), "/latest"));
        try {
            dispatch.lines(url.openStream(), (Procedure)fun$latestVersionRemote.lambda$Fn15);
        }
        catch (IOException e) {}
        return fun$latestVersionRemote.latest;
    }

    public static String latestVersion(URL repo, String pkg) {
        if (dispatch.remote(repo)) {
            return dispatch.latestVersionRemote(repo, pkg);
        }
        return dispatch.latestVersionLocal(repo, pkg);
    }

    public static String getPackage(String resource) {
        return resource.substring(0, resource.lastIndexOf(47)).replace('/', '.');
    }

    public static Object[] parseRepoURL(URL url) {
        String ver;
        String resource;
        String s = url.toString();
        int sep = s.indexOf(33);
        if (sep == -1) {
            return new Object[]{null, "", null};
        }
        URL repo = new URL(s.substring(0, sep));
        int pver = s.indexOf(35, sep);
        if (pver == -1) {
            resource = s.substring(sep + 2);
            ver = null;
        } else {
            resource = s.substring(sep + 2, pver);
            ver = s.substring(pver + 1);
        }
        return new Object[]{repo, resource, ver};
    }

    public static URLConnection openConnection(VersionTracker this_, URL url) {
        Object[] tupleRef = dispatch.parseRepoURL(url);
        URL repo = (URL)tupleRef[0];
        String resource = (String)tupleRef[1];
        String ver = (String)tupleRef[2];
        if (repo == null) {
            return null;
        }
        String pkg = dispatch.getPackage(resource);
        String currentVer = (String)this_.versions.get(pkg);
        if (ver == null) {
            String string = currentVer;
            if (string == null) {
                string = ver = dispatch.latestVersion(repo, pkg);
            }
            if (ver == null) {
                return null;
            }
        } else if (currentVer != null && !ver.equals(currentVer)) {
            throw new IncompatibleVersions(currentVer, ver);
        }
        this_.versions.put(pkg, (String)nice.lang.dispatch.notNull(ver));
        URL jar = dispatch.localCopy(repo, nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b(dispatch.packagePath(pkg), dispatch.getPackage(resource)), nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("-", (Object)ver), ".jar")));
        URL res = new URL("jar", "", nice.lang.dispatch.$$002b((Object)jar, nice.lang.dispatch.$$002b("!/", resource)));
        return res.openConnection();
    }

    public static VersionTracker versionTracker(File store) {
        return new VersionTracker(store, new HashMap());
    }

    public static URL repository(VersionTracker vt, URL base) {
        return new URL(base, "!/", vt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean bl;
        $instance = new fun();
        Lit1 = new Character('/');
        Lit0 = new Character(':');
        try {
            bl = Class.forName("nice.tools.repository.fun").desiredAssertionStatus();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            bl = System.getProperty("assertions") != null;
        }
        $assertionsEnabled = bl;
        deleteAll = new ModuleMethod($instance, 16, "deleteAll", 4097);
        cache = new File(System.getProperty("user.home"), ".nice-repository");
    }

    public Object apply1(ModuleMethod moduleMethod, Object object) {
        if (moduleMethod.selector == 16) {
            dispatch.deleteAll((File)object);
            return null;
        }
        throw new RuntimeException("bad case value!");
    }
}

