/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite;

import java.util.Iterator;
import nice.tools.testsuite.CompilerBugException;
import nice.tools.testsuite.TestCase;
import nice.tools.testsuite.TestNice;
import nice.tools.testsuite.TestSuite;
import nice.tools.testsuite.TestSuiteException;

public class FailTestCase
extends TestCase {
    public FailTestCase(TestSuite suite) {
        super(suite);
    }

    @Override
    public void performTest() {
        super.performTest();
        try {
            this.compilePackages();
        }
        catch (TestSuiteException e) {
            if (!this.noLocation && this.getFailPositions().isEmpty()) {
                TestNice.getOutput().log("warning", "Failure position not checked");
                this.warning();
                return;
            }
            this.checkFailPositions();
            if (this.getFailPositions().isEmpty()) {
                this.pass();
            } else {
                this.warning();
            }
            return;
        }
        catch (CompilerBugException e) {
            this.fail();
            return;
        }
        TestNice.getOutput().log("Compilation was expected to fail, but it succeeded.");
        this.fail();
    }

    private void checkFailPositions() {
        String compilerMessages = this.getCompilerMessages();
        Iterator iter = this.getFailPositions().iterator();
        while (iter.hasNext()) {
            TestCase.FailPosition failPosition = (TestCase.FailPosition)iter.next();
            String s = failPosition.getFileName() + ": line " + failPosition.getLine() + ", column " + failPosition.getColumn() + ":";
            if (compilerMessages.indexOf(s) == -1) {
                TestNice.getOutput().log("warning", "Failure not at expected position (" + failPosition.getFileName() + ": line " + failPosition.getLine() + ", column " + failPosition.getColumn() + ")");
                continue;
            }
            iter.remove();
        }
        if (!this.getFailPositions().isEmpty()) {
            TestNice.getOutput().log("warning", "more expected failures than compiler failures");
        }
    }
}

