#!/bin/sh
# Generated from niminst
# Template is in tools/niminst/buildsh.nimf
# To regenerate run ``niminst csource`` or ``koch csource``

set -e

while :
do
  case "$1" in
    --os)
      optos=$2
      shift 2
      ;;
    --cpu)
      optcpu=$2
      shift 2
      ;;
    --osname)
      optosname=$2
      shift 2
      ;;
    --parallel)
      parallel=$2
      shift 2
      ;;
    --extraBuildArgs)
      extraBuildArgs=" $2"
      shift 2
      ;;
    -h | --help)
      echo "Options:"
      echo "  --os <OS>"
      echo "  --cpu <CPU architecture>"
      echo "  --osname <name>           Additional OS specification (used for Android)"
      echo "  --extraBuildArgs <args>   Additional arguments passed to the compiler"
      echo "  --parallel <number>       Multiprocess build. Requires GNU parallel"
      exit 0
      ;;
    --) # End of all options
      shift
      break;
      ;;
    -*)
      echo 2>&1 "Error: Unknown option: $1" >&2
      exit 1
      ;;
    *)  # No more options
      break
      ;;
  esac
done

parallel="${parallel:-0}"
CC="${CC:-gcc}"
if [ "$parallel" -gt 1 ]; then
  if ! command -v sem > /dev/null; then
    echo "Error: GNU parallel is required to use --parallel"
    exit 1
  fi
  CC="sem -j $parallel --id $$ ${CC}"
fi
COMP_FLAGS="${CPPFLAGS:-} ${CFLAGS:-} -w -fmax-errors=3 -O3 -fno-strict-aliasing -fno-ident $extraBuildArgs"
LINK_FLAGS="${LDFLAGS:-} "
PS4=""
# platform detection
ucpu=`uname -m`
uos=`uname`
uosname=
# bin dir detection
binDir=bin

if [ -s ../koch.nim ]; then
  binDir="../bin"
fi

if [ ! -d $binDir ]; then
  mkdir $binDir
fi

# override OS, CPU and OS Name with command-line arguments
if [ -n "$optos" ]; then
  uos="$optos"
fi
if [ -n "$optcpu" ]; then
  ucpu="$optcpu"
fi
if [ -n "$optcpu" ]; then
  uosname="$optosname"
fi

# convert to lower case:
ucpu=`echo $ucpu | tr "[:upper:]" "[:lower:]"`
uos=`echo $uos | tr "[:upper:]" "[:lower:]"`
uosname=`echo $uosname | tr "[:upper:]" "[:lower:]"`

case $uos in
  *linux* )
    myos="linux"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lrt"
    ;;
  *dragonfly* )
    myos="dragonfly"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *freebsd* )
    myos="freebsd"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *crossos* )
    myos="crossos"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *openbsd* )
    myos="openbsd"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *netbsd* )
    myos="netbsd"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *darwin* )
    myos="macosx"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm"
    if [ "$HOSTTYPE" = "x86_64" ] ; then
      ucpu="amd64"
    fi
    ;;
  *aix* )
    myos="aix"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm"
    ;;
  *solaris* | *sun* )
    myos="solaris"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lsocket -lnsl"
    ;;
  *SunOS* )
    myos="solaris"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lsocket -lnsl"
    isOpenIndiana="yes"
    ;;
  *haiku* )
    myos="haiku"
    LINK_FLAGS="$LINK_FLAGS -lroot -lnetwork"
    ;;
  *mingw* | *msys* )
    myos="windows"
    ;;
  *android* )
    myos="android"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lrt"
    LINK_FLAGS="$LINK_FLAGS -landroid-glob"
    ;;
  *)
    echo 2>&1 "Error: unknown operating system: $uos"
    exit 1
    ;;
esac

case $ucpu in
  *i386* | *i486* | *i586* | *i686* | *bepc* | *i86pc* )
    if [ isOpenIndiana -eq "yes" ] ; then
      mycpu="amd64"
    else
      mycpu="i386"
    fi
    ;;
  *amd*64* | *x86-64* | *x86_64* )
    mycpu="amd64" ;;
  *sparc*|*sun* )
    mycpu="sparc"
    if [ "$myos" = "linux" ] ; then
      if [ "$(getconf LONG_BIT)" = "64" ]; then
        mycpu="sparc64"
      elif [ "$(isainfo -b)" = "64" ]; then
        mycpu="sparc64"
      fi
    fi
    ;;
  *ppc64le* )
    mycpu="powerpc64el" ;;
  *ppc64* )
    if [ "$myos" = "linux" ] ; then
      COMP_FLAGS="$COMP_FLAGS -m64"
      LINK_FLAGS="$LINK_FLAGS -m64"
    fi
    mycpu="powerpc64" ;;
  *power*|*ppc* )
    if [ "$myos" = "freebsd" ] ; then
      COMP_FLAGS="$COMP_FLAGS -m64"
      LINK_FLAGS="$LINK_FLAGS -m64"
      mycpu=`uname -p`
      case $mycpu in
        powerpc64le)
        mycpu="powerpc64el"
      esac
    else
      mycpu="powerpc"
    fi
    ;;
  *hppa*)
    mycpu="hppa" ;;
  *ia64*)
    mycpu="ia64" ;;
  *m68k*)
    mycpu="m68k" ;;
  *mips* )
    mycpu="$("$CC" -dumpmachine | sed 's/-.*//')"
    case $mycpu in
      mips|mipsel|mips64|mips64el)
        ;;
      *)
        echo 2>&1 "Error: unknown MIPS target: $mycpu"
        exit 1
    esac
    ;;
  *alpha* )
    mycpu="alpha" ;;
  *aarch64*|*arm64* )
    mycpu="arm64" ;;
  *arm*|*armv6l*|*armv7l*|*armv8l* )
    mycpu="arm" ;;
  *riscv64|riscv* )
    mycpu="riscv64" ;;
  *)
    echo 2>&1 "Error: unknown processor: $ucpu"
    exit 1
    ;;
esac

case $uosname in
  *android* )
    LINK_FLAGS="$LINK_FLAGS -landroid-glob"
    myosname="android"
    myos="android"
    ;;
esac

# call the compiler:
echo \# OS:  $myos
echo \# CPU: $mycpu

case $myos in
windows)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_assertions.nim.c -o c_code/1_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_widestrs.nim.c -o c_code/1_1/stdlib_widestrs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_io.nim.c -o c_code/1_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_system.nim.c -o c_code/1_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_parseutils.nim.c -o c_code/1_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_math.nim.c -o c_code/1_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_unicode.nim.c -o c_code/1_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_strutils.nim.c -o c_code/1_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_pathnorm.nim.c -o c_code/1_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dynlib.nim.c -o c_code/1_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_winlean.nim.c -o c_code/1_1/stdlib_winlean.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_times.nim.c -o c_code/1_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_win_setenv.nim.c -o c_code/1_1/stdlib_win_setenv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_os.nim.c -o c_code/1_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_parseopt.nim.c -o c_code/1_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_strtabs.nim.c -o c_code/1_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_strformat.nim.c -o c_code/1_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_terminal.nim.c -o c_code/1_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpathutils.nim.c -o c_code/1_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mropes.nim.c -o c_code/1_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlineinfos.nim.c -o c_code/1_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplatform.nim.c -o c_code/1_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimpaths.nim.c -o c_code/1_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_globs.nim.c -o c_code/1_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@moptions.nim.c -o c_code/1_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mstrutils2.nim.c -o c_code/1_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmsgs.nim.c -o c_code/1_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_streams.nim.c -o c_code/1_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_cpuinfo.nim.c -o c_code/1_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_osproc.nim.c -o c_code/1_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_sha1.nim.c -o c_code/1_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_parsejson.nim.c -o c_code/1_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_json.nim.c -o c_code/1_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_jsonutils.nim.c -o c_code/1_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mextccomp.nim.c -o c_code/1_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimblecmd.nim.c -o c_code/1_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@midents.nim.c -o c_code/1_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mint128.nim.c -o c_code/1_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mast.nim.c -o c_code/1_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcommands.nim.c -o c_code/1_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mllstream.nim.c -o c_code/1_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlexer.nim.c -o c_code/1_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mparser.nim.c -o c_code/1_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrenderer.nim.c -o c_code/1_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mfilters.nim.c -o c_code/1_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mfilter_tmpl.nim.c -o c_code/1_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msyntaxes.nim.c -o c_code/1_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_intsets.nim.c -o c_code/1_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastalgo.nim.c -o c_code/1_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@srodfiles.nim.c -o c_code/1_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sic.nim.c -o c_code/1_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodulegraphs.nim.c -o c_code/1_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypes.nim.c -o c_code/1_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmagicsys.nim.c -o c_code/1_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimsets.nim.c -o c_code/1_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemfold.nim.c -o c_code/1_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodulepaths.nim.c -o c_code/1_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmdef.nim.c -o c_code/1_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemdata.nim.c -o c_code/1_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlinter.nim.c -o c_code/1_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimfix@sprettybase.nim.c -o c_code/1_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlookups.nim.c -o c_code/1_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mconcepts.nim.c -o c_code/1_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemtypinst.nim.c -o c_code/1_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mparampatterns.nim.c -o c_code/1_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlowerings.nim.c -o c_code/1_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msigmatch.nim.c -o c_code/1_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mimporter.nim.c -o c_code/1_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprocfind.nim.c -o c_code/1_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpragmas.nim.c -o c_code/1_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mreorder.nim.c -o c_code/1_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpasses.nim.c -o c_code/1_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msaturate.nim.c -o c_code/1_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mguards.nim.c -o c_code/1_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvarpartitions.nim.c -o c_code/1_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnilcheck.nim.c -o c_code/1_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msighashes.nim.c -o c_code/1_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mndi.nim.c -o c_code/1_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgendata.nim.c -o c_code/1_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mliftdestructors.nim.c -o c_code/1_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msempass2.nim.c -o c_code/1_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgmeth.nim.c -o c_code/1_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mliftlocals.nim.c -o c_code/1_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlambdalifting.nim.c -o c_code/1_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mclosureiters.nim.c -o c_code/1_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtransf.nim.c -o c_code/1_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmgen.nim.c -o c_code/1_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmdeps.nim.c -o c_code/1_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmmarshal.nim.c -o c_code/1_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mgorgeimpl.nim.c -o c_code/1_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmprofiler.nim.c -o c_code/1_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mevaltempl.nim.c -o c_code/1_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvm.nim.c -o c_code/1_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpatterns.nim.c -o c_code/1_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemmacrosanity.nim.c -o c_code/1_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sitersgen.nim.c -o c_code/1_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mspawn.nim.c -o c_code/1_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msem.nim.c -o c_code/1_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdfa.nim.c -o c_code/1_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@moptimizer.nim.c -o c_code/1_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@minjectdestructors.nim.c -o c_code/1_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemparallel.nim.c -o c_code/1_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgen.nim.c -o c_code/1_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sreplayer.nim.c -o c_code/1_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodules.nim.c -o c_code/1_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mscriptconfig.nim.c -o c_code/1_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimconf.nim.c -o c_code/1_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpassaux.nim.c -o c_code/1_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdepends.nim.c -o c_code/1_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sdce.nim.c -o c_code/1_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@scbackend.nim.c -o c_code/1_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sintegrity.nim.c -o c_code/1_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@snavigator.nim.c -o c_code/1_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msourcemap.nim.c -o c_code/1_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mjsgen.nim.c -o c_code/1_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_rstast.nim.c -o c_code/1_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_rst.nim.c -o c_code/1_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_rstgen.nim.c -o c_code/1_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypesrenderer.nim.c -o c_code/1_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrenderverbatim.nim.c -o c_code/1_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdocgen.nim.c -o c_code/1_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdocgen2.nim.c -o c_code/1_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmain.nim.c -o c_code/1_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcmdlinehelper.nim.c -o c_code/1_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_browsers.nim.c -o c_code/1_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnim.nim.c -o c_code/1_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/1_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/1_1/stdlib_widestrs.nim.o \
c_code/1_1/stdlib_io.nim.o \
c_code/1_1/stdlib_system.nim.o \
c_code/1_1/stdlib_parseutils.nim.o \
c_code/1_1/stdlib_math.nim.o \
c_code/1_1/stdlib_unicode.nim.o \
c_code/1_1/stdlib_strutils.nim.o \
c_code/1_1/stdlib_pathnorm.nim.o \
c_code/1_1/stdlib_dynlib.nim.o \
c_code/1_1/stdlib_winlean.nim.o \
c_code/1_1/stdlib_times.nim.o \
c_code/1_1/stdlib_win_setenv.nim.o \
c_code/1_1/stdlib_os.nim.o \
c_code/1_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/1_1/stdlib_strtabs.nim.o \
c_code/1_1/stdlib_strformat.nim.o \
c_code/1_1/stdlib_terminal.nim.o \
c_code/1_1/@mpathutils.nim.o \
c_code/1_1/@mropes.nim.o \
c_code/1_1/@mlineinfos.nim.o \
c_code/1_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/1_1/@mnimpaths.nim.o \
c_code/1_1/stdlib_globs.nim.o \
c_code/1_1/@moptions.nim.o \
c_code/1_1/@mstrutils2.nim.o \
c_code/1_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/stdlib_streams.nim.o \
c_code/1_1/stdlib_cpuinfo.nim.o \
c_code/1_1/stdlib_osproc.nim.o \
c_code/1_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/1_1/stdlib_parsejson.nim.o \
c_code/1_1/stdlib_json.nim.o \
c_code/1_1/stdlib_jsonutils.nim.o \
c_code/1_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/1_1/@mnimblecmd.nim.o \
c_code/1_1/@midents.nim.o \
c_code/1_1/@mint128.nim.o \
c_code/1_1/@mast.nim.o \
c_code/1_1/@mcommands.nim.o \
c_code/1_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/1_1/@mlexer.nim.o \
c_code/1_1/@mparser.nim.o \
c_code/1_1/@mrenderer.nim.o \
c_code/1_1/@mfilters.nim.o \
c_code/1_1/@mfilter_tmpl.nim.o \
c_code/1_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/1_1/stdlib_intsets.nim.o \
c_code/1_1/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/1_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/1_1/@mic@sic.nim.o \
c_code/1_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/1_1/@mtypes.nim.o \
c_code/1_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/1_1/@mnimsets.nim.o \
c_code/1_1/@msemfold.nim.o \
c_code/1_1/@mmodulepaths.nim.o \
c_code/1_1/@mvmdef.nim.o \
c_code/1_1/@msemdata.nim.o \
c_code/1_1/@mlinter.nim.o \
c_code/1_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/1_1/@mlookups.nim.o \
c_code/1_1/@mconcepts.nim.o \
c_code/1_1/@msemtypinst.nim.o \
c_code/1_1/@mparampatterns.nim.o \
c_code/1_1/@mlowerings.nim.o \
c_code/1_1/@msigmatch.nim.o \
c_code/1_1/@mimporter.nim.o \
c_code/1_1/@mprocfind.nim.o \
c_code/1_1/@mpragmas.nim.o \
c_code/1_1/@mreorder.nim.o \
c_code/1_1/@mpasses.nim.o \
c_code/1_1/@msaturate.nim.o \
c_code/1_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/1_1/@mvarpartitions.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/1_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@msighashes.nim.o \
c_code/1_1/@mndi.nim.o \
c_code/1_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/1_1/@mliftdestructors.nim.o \
c_code/1_1/@msempass2.nim.o \
c_code/1_1/@mcgmeth.nim.o \
c_code/1_1/@mliftlocals.nim.o \
c_code/1_1/@mlambdalifting.nim.o \
c_code/1_1/@mclosureiters.nim.o \
c_code/1_1/@mtransf.nim.o \
c_code/1_1/@mvmgen.nim.o \
c_code/1_1/@mvmdeps.nim.o \
c_code/1_1/@mvmmarshal.nim.o \
c_code/1_1/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/1_1/@mvmprofiler.nim.o \
c_code/1_1/@mevaltempl.nim.o \
c_code/1_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/1_1/@mpatterns.nim.o \
c_code/1_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/1_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/1_1/@mspawn.nim.o \
c_code/1_1/@msem.nim.o \
c_code/1_1/@mdfa.nim.o \
c_code/1_1/@moptimizer.nim.o \
c_code/1_1/@minjectdestructors.nim.o \
c_code/1_1/@msemparallel.nim.o \
c_code/1_1/@mcgen.nim.o \
c_code/1_1/@mic@sreplayer.nim.o \
c_code/1_1/@mmodules.nim.o \
c_code/1_1/@mscriptconfig.nim.o \
c_code/1_1/@mnimconf.nim.o \
c_code/1_1/@mpassaux.nim.o \
c_code/1_1/@mdepends.nim.o \
c_code/1_1/@mic@sdce.nim.o \
c_code/1_1/@mic@scbackend.nim.o \
c_code/1_1/@mic@sintegrity.nim.o \
c_code/1_1/@mic@snavigator.nim.o \
c_code/1_1/@msourcemap.nim.o \
c_code/1_1/@mjsgen.nim.o \
c_code/1_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/1_1/stdlib_rst.nim.o \
c_code/1_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/1_1/@mtypesrenderer.nim.o \
c_code/1_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/1_1/@mdocgen.nim.o \
c_code/1_1/@mdocgen2.nim.o \
c_code/1_1/@mmain.nim.o \
c_code/1_1/@mcmdlinehelper.nim.o \
c_code/1_1/stdlib_browsers.nim.o \
c_code/1_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_assertions.nim.c -o c_code/1_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_widestrs.nim.c -o c_code/1_2/stdlib_widestrs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_io.nim.c -o c_code/1_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_system.nim.c -o c_code/1_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_parseutils.nim.c -o c_code/1_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_math.nim.c -o c_code/1_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_unicode.nim.c -o c_code/1_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_strutils.nim.c -o c_code/1_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_pathnorm.nim.c -o c_code/1_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dynlib.nim.c -o c_code/1_2/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_winlean.nim.c -o c_code/1_2/stdlib_winlean.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_times.nim.c -o c_code/1_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_win_setenv.nim.c -o c_code/1_2/stdlib_win_setenv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_os.nim.c -o c_code/1_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_parseopt.nim.c -o c_code/1_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_strtabs.nim.c -o c_code/1_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_strformat.nim.c -o c_code/1_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_terminal.nim.c -o c_code/1_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpathutils.nim.c -o c_code/1_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mropes.nim.c -o c_code/1_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlineinfos.nim.c -o c_code/1_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplatform.nim.c -o c_code/1_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimpaths.nim.c -o c_code/1_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_globs.nim.c -o c_code/1_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@moptions.nim.c -o c_code/1_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mstrutils2.nim.c -o c_code/1_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmsgs.nim.c -o c_code/1_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_streams.nim.c -o c_code/1_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_cpuinfo.nim.c -o c_code/1_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_osproc.nim.c -o c_code/1_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_sha1.nim.c -o c_code/1_2/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_parsejson.nim.c -o c_code/1_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_json.nim.c -o c_code/1_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_jsonutils.nim.c -o c_code/1_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mextccomp.nim.c -o c_code/1_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimblecmd.nim.c -o c_code/1_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@midents.nim.c -o c_code/1_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mint128.nim.c -o c_code/1_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mast.nim.c -o c_code/1_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcommands.nim.c -o c_code/1_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mllstream.nim.c -o c_code/1_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlexer.nim.c -o c_code/1_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mparser.nim.c -o c_code/1_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrenderer.nim.c -o c_code/1_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mfilters.nim.c -o c_code/1_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mfilter_tmpl.nim.c -o c_code/1_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msyntaxes.nim.c -o c_code/1_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_intsets.nim.c -o c_code/1_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastalgo.nim.c -o c_code/1_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@srodfiles.nim.c -o c_code/1_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sic.nim.c -o c_code/1_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodulegraphs.nim.c -o c_code/1_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypes.nim.c -o c_code/1_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmagicsys.nim.c -o c_code/1_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimsets.nim.c -o c_code/1_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemfold.nim.c -o c_code/1_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodulepaths.nim.c -o c_code/1_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmdef.nim.c -o c_code/1_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemdata.nim.c -o c_code/1_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlinter.nim.c -o c_code/1_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimfix@sprettybase.nim.c -o c_code/1_2/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlookups.nim.c -o c_code/1_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mconcepts.nim.c -o c_code/1_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemtypinst.nim.c -o c_code/1_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mparampatterns.nim.c -o c_code/1_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlowerings.nim.c -o c_code/1_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msigmatch.nim.c -o c_code/1_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mimporter.nim.c -o c_code/1_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprocfind.nim.c -o c_code/1_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpragmas.nim.c -o c_code/1_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mreorder.nim.c -o c_code/1_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpasses.nim.c -o c_code/1_2/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msaturate.nim.c -o c_code/1_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mguards.nim.c -o c_code/1_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvarpartitions.nim.c -o c_code/1_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnilcheck.nim.c -o c_code/1_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msighashes.nim.c -o c_code/1_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mndi.nim.c -o c_code/1_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgendata.nim.c -o c_code/1_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mliftdestructors.nim.c -o c_code/1_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msempass2.nim.c -o c_code/1_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgmeth.nim.c -o c_code/1_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mliftlocals.nim.c -o c_code/1_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlambdalifting.nim.c -o c_code/1_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mclosureiters.nim.c -o c_code/1_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtransf.nim.c -o c_code/1_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmgen.nim.c -o c_code/1_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmdeps.nim.c -o c_code/1_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmmarshal.nim.c -o c_code/1_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mgorgeimpl.nim.c -o c_code/1_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmprofiler.nim.c -o c_code/1_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mevaltempl.nim.c -o c_code/1_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvm.nim.c -o c_code/1_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpatterns.nim.c -o c_code/1_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemmacrosanity.nim.c -o c_code/1_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sitersgen.nim.c -o c_code/1_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mspawn.nim.c -o c_code/1_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msem.nim.c -o c_code/1_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdfa.nim.c -o c_code/1_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@moptimizer.nim.c -o c_code/1_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@minjectdestructors.nim.c -o c_code/1_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemparallel.nim.c -o c_code/1_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgen.nim.c -o c_code/1_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sreplayer.nim.c -o c_code/1_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodules.nim.c -o c_code/1_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mscriptconfig.nim.c -o c_code/1_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimconf.nim.c -o c_code/1_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpassaux.nim.c -o c_code/1_2/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdepends.nim.c -o c_code/1_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sdce.nim.c -o c_code/1_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@scbackend.nim.c -o c_code/1_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sintegrity.nim.c -o c_code/1_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@snavigator.nim.c -o c_code/1_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msourcemap.nim.c -o c_code/1_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mjsgen.nim.c -o c_code/1_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_rstast.nim.c -o c_code/1_2/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_rst.nim.c -o c_code/1_2/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_rstgen.nim.c -o c_code/1_2/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypesrenderer.nim.c -o c_code/1_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrenderverbatim.nim.c -o c_code/1_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdocgen.nim.c -o c_code/1_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdocgen2.nim.c -o c_code/1_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmain.nim.c -o c_code/1_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcmdlinehelper.nim.c -o c_code/1_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_browsers.nim.c -o c_code/1_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnim.nim.c -o c_code/1_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/1_2/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/1_2/stdlib_widestrs.nim.o \
c_code/1_2/stdlib_io.nim.o \
c_code/1_2/stdlib_system.nim.o \
c_code/1_2/stdlib_parseutils.nim.o \
c_code/1_2/stdlib_math.nim.o \
c_code/1_2/stdlib_unicode.nim.o \
c_code/1_2/stdlib_strutils.nim.o \
c_code/1_2/stdlib_pathnorm.nim.o \
c_code/1_2/stdlib_dynlib.nim.o \
c_code/1_2/stdlib_winlean.nim.o \
c_code/1_2/stdlib_times.nim.o \
c_code/1_2/stdlib_win_setenv.nim.o \
c_code/1_2/stdlib_os.nim.o \
c_code/1_2/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/1_2/stdlib_strtabs.nim.o \
c_code/1_2/stdlib_strformat.nim.o \
c_code/1_2/stdlib_terminal.nim.o \
c_code/1_2/@mpathutils.nim.o \
c_code/1_2/@mropes.nim.o \
c_code/1_2/@mlineinfos.nim.o \
c_code/1_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/1_2/@mnimpaths.nim.o \
c_code/1_2/stdlib_globs.nim.o \
c_code/1_2/@moptions.nim.o \
c_code/1_2/@mstrutils2.nim.o \
c_code/1_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/stdlib_streams.nim.o \
c_code/1_2/stdlib_cpuinfo.nim.o \
c_code/1_2/stdlib_osproc.nim.o \
c_code/1_2/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/1_2/stdlib_parsejson.nim.o \
c_code/1_2/stdlib_json.nim.o \
c_code/1_2/stdlib_jsonutils.nim.o \
c_code/1_2/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/1_2/@mnimblecmd.nim.o \
c_code/1_2/@midents.nim.o \
c_code/1_2/@mint128.nim.o \
c_code/1_2/@mast.nim.o \
c_code/1_2/@mcommands.nim.o \
c_code/1_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/1_2/@mlexer.nim.o \
c_code/1_2/@mparser.nim.o \
c_code/1_2/@mrenderer.nim.o \
c_code/1_2/@mfilters.nim.o \
c_code/1_2/@mfilter_tmpl.nim.o \
c_code/1_2/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/1_2/stdlib_intsets.nim.o \
c_code/1_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/1_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/1_2/@mic@sic.nim.o \
c_code/1_2/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/1_2/@mtypes.nim.o \
c_code/1_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/1_2/@mnimsets.nim.o \
c_code/1_2/@msemfold.nim.o \
c_code/1_2/@mmodulepaths.nim.o \
c_code/1_2/@mvmdef.nim.o \
c_code/1_2/@msemdata.nim.o \
c_code/1_2/@mlinter.nim.o \
c_code/1_2/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/1_2/@mlookups.nim.o \
c_code/1_2/@mconcepts.nim.o \
c_code/1_2/@msemtypinst.nim.o \
c_code/1_2/@mparampatterns.nim.o \
c_code/1_2/@mlowerings.nim.o \
c_code/1_2/@msigmatch.nim.o \
c_code/1_2/@mimporter.nim.o \
c_code/1_2/@mprocfind.nim.o \
c_code/1_2/@mpragmas.nim.o \
c_code/1_2/@mreorder.nim.o \
c_code/1_2/@mpasses.nim.o \
c_code/1_2/@msaturate.nim.o \
c_code/1_2/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/1_2/@mvarpartitions.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/1_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@msighashes.nim.o \
c_code/1_2/@mndi.nim.o \
c_code/1_2/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/1_2/@mliftdestructors.nim.o \
c_code/1_2/@msempass2.nim.o \
c_code/1_2/@mcgmeth.nim.o \
c_code/1_2/@mliftlocals.nim.o \
c_code/1_2/@mlambdalifting.nim.o \
c_code/1_2/@mclosureiters.nim.o \
c_code/1_2/@mtransf.nim.o \
c_code/1_2/@mvmgen.nim.o \
c_code/1_2/@mvmdeps.nim.o \
c_code/1_2/@mvmmarshal.nim.o \
c_code/1_2/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/1_2/@mvmprofiler.nim.o \
c_code/1_2/@mevaltempl.nim.o \
c_code/1_2/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/1_2/@mpatterns.nim.o \
c_code/1_2/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/1_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/1_2/@mspawn.nim.o \
c_code/1_2/@msem.nim.o \
c_code/1_2/@mdfa.nim.o \
c_code/1_2/@moptimizer.nim.o \
c_code/1_2/@minjectdestructors.nim.o \
c_code/1_2/@msemparallel.nim.o \
c_code/1_2/@mcgen.nim.o \
c_code/1_2/@mic@sreplayer.nim.o \
c_code/1_2/@mmodules.nim.o \
c_code/1_2/@mscriptconfig.nim.o \
c_code/1_2/@mnimconf.nim.o \
c_code/1_2/@mpassaux.nim.o \
c_code/1_2/@mdepends.nim.o \
c_code/1_2/@mic@sdce.nim.o \
c_code/1_2/@mic@scbackend.nim.o \
c_code/1_2/@mic@sintegrity.nim.o \
c_code/1_2/@mic@snavigator.nim.o \
c_code/1_2/@msourcemap.nim.o \
c_code/1_2/@mjsgen.nim.o \
c_code/1_2/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/1_2/stdlib_rst.nim.o \
c_code/1_2/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/1_2/@mtypesrenderer.nim.o \
c_code/1_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/1_2/@mdocgen.nim.o \
c_code/1_2/@mdocgen2.nim.o \
c_code/1_2/@mmain.nim.o \
c_code/1_2/@mcmdlinehelper.nim.o \
c_code/1_2/stdlib_browsers.nim.o \
c_code/1_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
linux)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_assertions.nim.c -o c_code/2_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_io.nim.c -o c_code/2_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_system.nim.c -o c_code/2_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseutils.nim.c -o c_code/2_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strutils.nim.c -o c_code/2_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_pathnorm.nim.c -o c_code/2_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_times.nim.c -o c_code/2_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_os.nim.c -o c_code/2_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseopt.nim.c -o c_code/2_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strtabs.nim.c -o c_code/2_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strformat.nim.c -o c_code/2_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_terminal.nim.c -o c_code/2_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplatform.nim.c -o c_code/2_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptions.nim.c -o c_code/2_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmsgs.nim.c -o c_code/2_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_streams.nim.c -o c_code/2_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_osproc.nim.c -o c_code/2_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parsejson.nim.c -o c_code/2_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_json.nim.c -o c_code/2_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_jsonutils.nim.c -o c_code/2_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mextccomp.nim.c -o c_code/2_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimblecmd.nim.c -o c_code/2_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcommands.nim.c -o c_code/2_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mllstream.nim.c -o c_code/2_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlexer.nim.c -o c_code/2_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderer.nim.c -o c_code/2_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msyntaxes.nim.c -o c_code/2_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_intsets.nim.c -o c_code/2_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtrees.nim.c -o c_code/2_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimfix@sprettybase.nim.c -o c_code/2_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msigmatch.nim.c -o c_code/2_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpragmas.nim.c -o c_code/2_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpasses.nim.c -o c_code/2_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtreetab.nim.c -o c_code/2_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mgorgeimpl.nim.c -o c_code/2_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmacrocacheimpl.nim.c -o c_code/2_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvm.nim.c -o c_code/2_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@slocals.nim.c -o c_code/2_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@menumtostr.nim.c -o c_code/2_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msem.nim.c -o c_code/2_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_dynlib.nim.c -o c_code/2_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgen.nim.c -o c_code/2_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mscriptconfig.nim.c -o c_code/2_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimconf.nim.c -o c_code/2_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpassaux.nim.c -o c_code/2_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mjsgen.nim.c -o c_code/2_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstast.nim.c -o c_code/2_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rst.nim.c -o c_code/2_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstgen.nim.c -o c_code/2_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen.nim.c -o c_code/2_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen2.nim.c -o c_code/2_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmain.nim.c -o c_code/2_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_browsers.nim.c -o c_code/2_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnim.nim.c -o c_code/2_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_1/stdlib_io.nim.o \
c_code/2_1/stdlib_system.nim.o \
c_code/2_1/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_1/stdlib_strutils.nim.o \
c_code/2_1/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_1/stdlib_times.nim.o \
c_code/2_1/stdlib_os.nim.o \
c_code/2_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_1/stdlib_strtabs.nim.o \
c_code/2_1/stdlib_strformat.nim.o \
c_code/2_1/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_1/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_1/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_1/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_1/stdlib_parsejson.nim.o \
c_code/2_1/stdlib_json.nim.o \
c_code/2_1/stdlib_jsonutils.nim.o \
c_code/2_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@mnimblecmd.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_1/@mast.nim.o \
c_code/2_1/@mcommands.nim.o \
c_code/2_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_1/@mlexer.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/2_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_1/stdlib_intsets.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/2_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_1/@msigmatch.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_1/@mpragmas.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mtreetab.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_1/@mgorgeimpl.nim.o \
c_code/2_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/2_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_1/@menumtostr.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_1/@msem.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/stdlib_dynlib.nim.o \
c_code/2_1/@mcgen.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@mscriptconfig.nim.o \
c_code/2_1/@mnimconf.nim.o \
c_code/2_1/@mpassaux.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/2_1/@mjsgen.nim.o \
c_code/2_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_1/stdlib_rst.nim.o \
c_code/2_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_1/@mdocgen.nim.o \
c_code/2_1/@mdocgen2.nim.o \
c_code/2_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_1/stdlib_browsers.nim.o \
c_code/2_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_assertions.nim.c -o c_code/2_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_io.nim.c -o c_code/2_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_system.nim.c -o c_code/2_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseutils.nim.c -o c_code/2_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strutils.nim.c -o c_code/2_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_pathnorm.nim.c -o c_code/2_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_posix.nim.c -o c_code/2_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_times.nim.c -o c_code/2_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_os.nim.c -o c_code/2_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseopt.nim.c -o c_code/2_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strtabs.nim.c -o c_code/2_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strformat.nim.c -o c_code/2_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_terminal.nim.c -o c_code/2_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mropes.nim.c -o c_code/2_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplatform.nim.c -o c_code/2_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptions.nim.c -o c_code/2_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmsgs.nim.c -o c_code/2_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_streams.nim.c -o c_code/2_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_cpuinfo.nim.c -o c_code/2_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_osproc.nim.c -o c_code/2_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_sha1.nim.c -o c_code/2_2/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parsejson.nim.c -o c_code/2_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_json.nim.c -o c_code/2_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_jsonutils.nim.c -o c_code/2_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mextccomp.nim.c -o c_code/2_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimblecmd.nim.c -o c_code/2_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcommands.nim.c -o c_code/2_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mllstream.nim.c -o c_code/2_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlexer.nim.c -o c_code/2_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderer.nim.c -o c_code/2_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msyntaxes.nim.c -o c_code/2_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_intsets.nim.c -o c_code/2_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtrees.nim.c -o c_code/2_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@srodfiles.nim.c -o c_code/2_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sic.nim.c -o c_code/2_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimfix@sprettybase.nim.c -o c_code/2_2/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msigmatch.nim.c -o c_code/2_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpragmas.nim.c -o c_code/2_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpasses.nim.c -o c_code/2_2/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtreetab.nim.c -o c_code/2_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mndi.nim.c -o c_code/2_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdeps.nim.c -o c_code/2_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mgorgeimpl.nim.c -o c_code/2_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmacrocacheimpl.nim.c -o c_code/2_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvm.nim.c -o c_code/2_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@slocals.nim.c -o c_code/2_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@menumtostr.nim.c -o c_code/2_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msem.nim.c -o c_code/2_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_dynlib.nim.c -o c_code/2_2/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgen.nim.c -o c_code/2_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mscriptconfig.nim.c -o c_code/2_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimconf.nim.c -o c_code/2_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpassaux.nim.c -o c_code/2_2/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mjsgen.nim.c -o c_code/2_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rstast.nim.c -o c_code/2_2/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rst.nim.c -o c_code/2_2/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rstgen.nim.c -o c_code/2_2/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen.nim.c -o c_code/2_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmain.nim.c -o c_code/2_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_browsers.nim.c -o c_code/2_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnim.nim.c -o c_code/2_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_2/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_2/stdlib_io.nim.o \
c_code/2_2/stdlib_system.nim.o \
c_code/2_2/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_2/stdlib_strutils.nim.o \
c_code/2_2/stdlib_pathnorm.nim.o \
c_code/2_2/stdlib_posix.nim.o \
c_code/2_2/stdlib_times.nim.o \
c_code/2_2/stdlib_os.nim.o \
c_code/2_2/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_2/stdlib_strtabs.nim.o \
c_code/2_2/stdlib_strformat.nim.o \
c_code/2_2/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_2/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_2/stdlib_streams.nim.o \
c_code/2_2/stdlib_cpuinfo.nim.o \
c_code/2_2/stdlib_osproc.nim.o \
c_code/2_2/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_2/stdlib_parsejson.nim.o \
c_code/2_2/stdlib_json.nim.o \
c_code/2_2/stdlib_jsonutils.nim.o \
c_code/2_2/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@mnimblecmd.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_2/@mcommands.nim.o \
c_code/2_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_2/@mlexer.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/2_2/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/2_2/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_2/stdlib_intsets.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/2_2/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@msigmatch.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpragmas.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mtreetab.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_2/@mvmdeps.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_2/@mgorgeimpl.nim.o \
c_code/2_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_2/@menumtostr.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msem.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/stdlib_dynlib.nim.o \
c_code/2_2/@mcgen.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@mscriptconfig.nim.o \
c_code/2_2/@mnimconf.nim.o \
c_code/2_2/@mpassaux.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/2_2/@mjsgen.nim.o \
c_code/2_2/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_2/stdlib_rst.nim.o \
c_code/2_2/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_2/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_2/stdlib_browsers.nim.o \
c_code/2_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_io.nim.c -o c_code/2_3/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_system.nim.c -o c_code/2_3/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parseutils.nim.c -o c_code/2_3/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strutils.nim.c -o c_code/2_3/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_pathnorm.nim.c -o c_code/2_3/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_os.nim.c -o c_code/2_3/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parseopt.nim.c -o c_code/2_3/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strtabs.nim.c -o c_code/2_3/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mropes.nim.c -o c_code/2_3/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplatform.nim.c -o c_code/2_3/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_streams.nim.c -o c_code/2_3/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_osproc.nim.c -o c_code/2_3/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_sha1.nim.c -o c_code/2_3/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_json.nim.c -o c_code/2_3/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypes.nim.c -o c_code/2_3/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemfold.nim.c -o c_code/2_3/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulepaths.nim.c -o c_code/2_3/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimfix@sprettybase.nim.c -o c_code/2_3/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdeps.nim.c -o c_code/2_3/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_dynlib.nim.c -o c_code/2_3/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rst.nim.c -o c_code/2_3/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstgen.nim.c -o c_code/2_3/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_browsers.nim.c -o c_code/2_3/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_3/stdlib_io.nim.o \
c_code/2_3/stdlib_system.nim.o \
c_code/2_3/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_3/stdlib_strutils.nim.o \
c_code/2_3/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/2_3/stdlib_os.nim.o \
c_code/2_3/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_3/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_3/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/2_3/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_3/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_3/stdlib_osproc.nim.o \
c_code/2_3/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/2_3/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_3/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/2_3/@msemfold.nim.o \
c_code/2_3/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_3/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/stdlib_dynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_3/stdlib_rst.nim.o \
c_code/2_3/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/2_3/stdlib_browsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  ia64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplatform.nim.c -o c_code/2_4/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_json.nim.c -o c_code/2_4/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rst.nim.c -o c_code/2_4/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstgen.nim.c -o c_code/2_4/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/2_4/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_4/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_4/stdlib_rst.nim.o \
c_code/2_4/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  alpha)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_5/@mplatform.nim.c -o c_code/2_5/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_json.nim.c -o c_code/2_4/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rst.nim.c -o c_code/2_4/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstgen.nim.c -o c_code/2_4/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/2_5/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_4/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_4/stdlib_rst.nim.o \
c_code/2_4/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mplatform.nim.c -o c_code/2_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/stdlib_sha1.nim.c -o c_code/2_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_json.nim.c -o c_code/2_4/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rst.nim.c -o c_code/2_4/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstgen.nim.c -o c_code/2_4/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/2_6/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_4/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_4/stdlib_rst.nim.o \
c_code/2_4/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_digitsutils.nim.c -o c_code/2_7/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_assertions.nim.c -o c_code/2_7/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dragonbox.nim.c -o c_code/2_7/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_schubfach.nim.c -o c_code/2_7/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_formatfloat.nim.c -o c_code/2_7/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dollars.nim.c -o c_code/2_7/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_io.nim.c -o c_code/2_7/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_system.nim.c -o c_code/2_7/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parseutils.nim.c -o c_code/2_7/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_math.nim.c -o c_code/2_7/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_unicode.nim.c -o c_code/2_7/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strutils.nim.c -o c_code/2_7/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_pathnorm.nim.c -o c_code/2_7/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_posix.nim.c -o c_code/2_7/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_times.nim.c -o c_code/2_7/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_os.nim.c -o c_code/2_7/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parseopt.nim.c -o c_code/2_7/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_hashes.nim.c -o c_code/2_7/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strtabs.nim.c -o c_code/2_7/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strformat.nim.c -o c_code/2_7/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_terminal.nim.c -o c_code/2_7/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpathutils.nim.c -o c_code/2_7/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mropes.nim.c -o c_code/2_7/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlineinfos.nim.c -o c_code/2_7/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplatform.nim.c -o c_code/2_7/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprefixmatches.nim.c -o c_code/2_7/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimpaths.nim.c -o c_code/2_7/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_globs.nim.c -o c_code/2_7/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptions.nim.c -o c_code/2_7/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mstrutils2.nim.c -o c_code/2_7/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmsgs.nim.c -o c_code/2_7/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcondsyms.nim.c -o c_code/2_7/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_streams.nim.c -o c_code/2_7/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_cpuinfo.nim.c -o c_code/2_7/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_osproc.nim.c -o c_code/2_7/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_sha1.nim.c -o c_code/2_7/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_lexbase.nim.c -o c_code/2_7/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parsejson.nim.c -o c_code/2_7/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_json.nim.c -o c_code/2_7/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_jsonutils.nim.c -o c_code/2_7/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mextccomp.nim.c -o c_code/2_7/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mwordrecg.nim.c -o c_code/2_7/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimblecmd.nim.c -o c_code/2_7/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@midents.nim.c -o c_code/2_7/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mint128.nim.c -o c_code/2_7/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mast.nim.c -o c_code/2_7/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcommands.nim.c -o c_code/2_7/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mllstream.nim.c -o c_code/2_7/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimlexbase.nim.c -o c_code/2_7/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlexer.nim.c -o c_code/2_7/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparser.nim.c -o c_code/2_7/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderer.nim.c -o c_code/2_7/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilters.nim.c -o c_code/2_7/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilter_tmpl.nim.c -o c_code/2_7/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msyntaxes.nim.c -o c_code/2_7/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_packedsets.nim.c -o c_code/2_7/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_intsets.nim.c -o c_code/2_7/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastalgo.nim.c -o c_code/2_7/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtrees.nim.c -o c_code/2_7/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_md5.nim.c -o c_code/2_7/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@srodfiles.nim.c -o c_code/2_7/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@spacked_ast.nim.c -o c_code/2_7/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sic.nim.c -o c_code/2_7/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulegraphs.nim.c -o c_code/2_7/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastmsgs.nim.c -o c_code/2_7/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypes.nim.c -o c_code/2_7/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmagicsys.nim.c -o c_code/2_7/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbitsets.nim.c -o c_code/2_7/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimsets.nim.c -o c_code/2_7/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemfold.nim.c -o c_code/2_7/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulepaths.nim.c -o c_code/2_7/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdef.nim.c -o c_code/2_7/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemdata.nim.c -o c_code/2_7/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlinter.nim.c -o c_code/2_7/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimfix@sprettybase.nim.c -o c_code/2_7/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_editdistance.nim.c -o c_code/2_7/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlookups.nim.c -o c_code/2_7/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mconcepts.nim.c -o c_code/2_7/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemtypinst.nim.c -o c_code/2_7/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparampatterns.nim.c -o c_code/2_7/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlowerings.nim.c -o c_code/2_7/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msigmatch.nim.c -o c_code/2_7/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mimporter.nim.c -o c_code/2_7/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprocfind.nim.c -o c_code/2_7/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpragmas.nim.c -o c_code/2_7/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mreorder.nim.c -o c_code/2_7/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpasses.nim.c -o c_code/2_7/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msaturate.nim.c -o c_code/2_7/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mguards.nim.c -o c_code/2_7/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypeallowed.nim.c -o c_code/2_7/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@misolation_check.nim.c -o c_code/2_7/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvarpartitions.nim.c -o c_code/2_7/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtreetab.nim.c -o c_code/2_7/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnilcheck.nim.c -o c_code/2_7/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@merrorhandling.nim.c -o c_code/2_7/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msighashes.nim.c -o c_code/2_7/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mndi.nim.c -o c_code/2_7/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgendata.nim.c -o c_code/2_7/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mccgutils.nim.c -o c_code/2_7/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftdestructors.nim.c -o c_code/2_7/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msempass2.nim.c -o c_code/2_7/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgmeth.nim.c -o c_code/2_7/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftlocals.nim.c -o c_code/2_7/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlambdalifting.nim.c -o c_code/2_7/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mclosureiters.nim.c -o c_code/2_7/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtransf.nim.c -o c_code/2_7/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmgen.nim.c -o c_code/2_7/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdeps.nim.c -o c_code/2_7/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmmarshal.nim.c -o c_code/2_7/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mgorgeimpl.nim.c -o c_code/2_7/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmacrocacheimpl.nim.c -o c_code/2_7/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmprofiler.nim.c -o c_code/2_7/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mevaltempl.nim.c -o c_code/2_7/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvm.nim.c -o c_code/2_7/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@maliases.nim.c -o c_code/2_7/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpatterns.nim.c -o c_code/2_7/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemmacrosanity.nim.c -o c_code/2_7/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpluginsupport.nim.c -o c_code/2_7/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@slocals.nim.c -o c_code/2_7/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sitersgen.nim.c -o c_code/2_7/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sactive.nim.c -o c_code/2_7/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@menumtostr.nim.c -o c_code/2_7/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mspawn.nim.c -o c_code/2_7/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msem.nim.c -o c_code/2_7/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdfa.nim.c -o c_code/2_7/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptimizer.nim.c -o c_code/2_7/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@minjectdestructors.nim.c -o c_code/2_7/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemparallel.nim.c -o c_code/2_7/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dynlib.nim.c -o c_code/2_7/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgen.nim.c -o c_code/2_7/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sreplayer.nim.c -o c_code/2_7/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodules.nim.c -o c_code/2_7/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mscriptconfig.nim.c -o c_code/2_7/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimconf.nim.c -o c_code/2_7/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpassaux.nim.c -o c_code/2_7/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdepends.nim.c -o c_code/2_7/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sdce.nim.c -o c_code/2_7/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@scbackend.nim.c -o c_code/2_7/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sintegrity.nim.c -o c_code/2_7/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@snavigator.nim.c -o c_code/2_7/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msourcemap.nim.c -o c_code/2_7/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mjsgen.nim.c -o c_code/2_7/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_rstast.nim.c -o c_code/2_7/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_highlite.nim.c -o c_code/2_7/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_rst.nim.c -o c_code/2_7/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_rstgen.nim.c -o c_code/2_7/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_xmltree.nim.c -o c_code/2_7/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypesrenderer.nim.c -o c_code/2_7/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderverbatim.nim.c -o c_code/2_7/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_base64.nim.c -o c_code/2_7/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_uri.nim.c -o c_code/2_7/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdocgen.nim.c -o c_code/2_7/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdocgen2.nim.c -o c_code/2_7/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmain.nim.c -o c_code/2_7/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcmdlinehelper.nim.c -o c_code/2_7/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_browsers.nim.c -o c_code/2_7/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnim.nim.c -o c_code/2_7/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_7/stdlib_digitsutils.nim.o \
c_code/2_7/stdlib_assertions.nim.o \
c_code/2_7/stdlib_dragonbox.nim.o \
c_code/2_7/stdlib_schubfach.nim.o \
c_code/2_7/stdlib_formatfloat.nim.o \
c_code/2_7/stdlib_dollars.nim.o \
c_code/2_7/stdlib_io.nim.o \
c_code/2_7/stdlib_system.nim.o \
c_code/2_7/stdlib_parseutils.nim.o \
c_code/2_7/stdlib_math.nim.o \
c_code/2_7/stdlib_unicode.nim.o \
c_code/2_7/stdlib_strutils.nim.o \
c_code/2_7/stdlib_pathnorm.nim.o \
c_code/2_7/stdlib_posix.nim.o \
c_code/2_7/stdlib_times.nim.o \
c_code/2_7/stdlib_os.nim.o \
c_code/2_7/stdlib_parseopt.nim.o \
c_code/2_7/stdlib_hashes.nim.o \
c_code/2_7/stdlib_strtabs.nim.o \
c_code/2_7/stdlib_strformat.nim.o \
c_code/2_7/stdlib_terminal.nim.o \
c_code/2_7/@mpathutils.nim.o \
c_code/2_7/@mropes.nim.o \
c_code/2_7/@mlineinfos.nim.o \
c_code/2_7/@mplatform.nim.o \
c_code/2_7/@mprefixmatches.nim.o \
c_code/2_7/@mnimpaths.nim.o \
c_code/2_7/stdlib_globs.nim.o \
c_code/2_7/@moptions.nim.o \
c_code/2_7/@mstrutils2.nim.o \
c_code/2_7/@mmsgs.nim.o \
c_code/2_7/@mcondsyms.nim.o \
c_code/2_7/stdlib_streams.nim.o \
c_code/2_7/stdlib_cpuinfo.nim.o \
c_code/2_7/stdlib_osproc.nim.o \
c_code/2_7/stdlib_sha1.nim.o \
c_code/2_7/stdlib_lexbase.nim.o \
c_code/2_7/stdlib_parsejson.nim.o \
c_code/2_7/stdlib_json.nim.o \
c_code/2_7/stdlib_jsonutils.nim.o \
c_code/2_7/@mextccomp.nim.o \
c_code/2_7/@mwordrecg.nim.o \
c_code/2_7/@mnimblecmd.nim.o \
c_code/2_7/@midents.nim.o \
c_code/2_7/@mint128.nim.o \
c_code/2_7/@mast.nim.o \
c_code/2_7/@mcommands.nim.o \
c_code/2_7/@mllstream.nim.o \
c_code/2_7/@mnimlexbase.nim.o \
c_code/2_7/@mlexer.nim.o \
c_code/2_7/@mparser.nim.o \
c_code/2_7/@mrenderer.nim.o \
c_code/2_7/@mfilters.nim.o \
c_code/2_7/@mfilter_tmpl.nim.o \
c_code/2_7/@msyntaxes.nim.o \
c_code/2_7/stdlib_packedsets.nim.o \
c_code/2_7/stdlib_intsets.nim.o \
c_code/2_7/@mastalgo.nim.o \
c_code/2_7/@mtrees.nim.o \
c_code/2_7/stdlib_md5.nim.o \
c_code/2_7/@mic@srodfiles.nim.o \
c_code/2_7/@mic@spacked_ast.nim.o \
c_code/2_7/@mic@sic.nim.o \
c_code/2_7/@mmodulegraphs.nim.o \
c_code/2_7/@mastmsgs.nim.o \
c_code/2_7/@mtypes.nim.o \
c_code/2_7/@mmagicsys.nim.o \
c_code/2_7/@mbitsets.nim.o \
c_code/2_7/@mnimsets.nim.o \
c_code/2_7/@msemfold.nim.o \
c_code/2_7/@mmodulepaths.nim.o \
c_code/2_7/@mvmdef.nim.o \
c_code/2_7/@msemdata.nim.o \
c_code/2_7/@mlinter.nim.o \
c_code/2_7/@mnimfix@sprettybase.nim.o \
c_code/2_7/stdlib_editdistance.nim.o \
c_code/2_7/@mlookups.nim.o \
c_code/2_7/@mconcepts.nim.o \
c_code/2_7/@msemtypinst.nim.o \
c_code/2_7/@mparampatterns.nim.o \
c_code/2_7/@mlowerings.nim.o \
c_code/2_7/@msigmatch.nim.o \
c_code/2_7/@mimporter.nim.o \
c_code/2_7/@mprocfind.nim.o \
c_code/2_7/@mpragmas.nim.o \
c_code/2_7/@mreorder.nim.o \
c_code/2_7/@mpasses.nim.o \
c_code/2_7/@msaturate.nim.o \
c_code/2_7/@mguards.nim.o \
c_code/2_7/@mtypeallowed.nim.o \
c_code/2_7/@misolation_check.nim.o \
c_code/2_7/@mvarpartitions.nim.o \
c_code/2_7/@mtreetab.nim.o \
c_code/2_7/@mnilcheck.nim.o \
c_code/2_7/@merrorhandling.nim.o \
c_code/2_7/@msighashes.nim.o \
c_code/2_7/@mndi.nim.o \
c_code/2_7/@mcgendata.nim.o \
c_code/2_7/@mccgutils.nim.o \
c_code/2_7/@mliftdestructors.nim.o \
c_code/2_7/@msempass2.nim.o \
c_code/2_7/@mcgmeth.nim.o \
c_code/2_7/@mliftlocals.nim.o \
c_code/2_7/@mlambdalifting.nim.o \
c_code/2_7/@mclosureiters.nim.o \
c_code/2_7/@mtransf.nim.o \
c_code/2_7/@mvmgen.nim.o \
c_code/2_7/@mvmdeps.nim.o \
c_code/2_7/@mvmmarshal.nim.o \
c_code/2_7/@mgorgeimpl.nim.o \
c_code/2_7/@mmacrocacheimpl.nim.o \
c_code/2_7/@mvmprofiler.nim.o \
c_code/2_7/@mevaltempl.nim.o \
c_code/2_7/@mvm.nim.o \
c_code/2_7/@maliases.nim.o \
c_code/2_7/@mpatterns.nim.o \
c_code/2_7/@msemmacrosanity.nim.o \
c_code/2_7/@mpluginsupport.nim.o \
c_code/2_7/@mplugins@slocals.nim.o \
c_code/2_7/@mplugins@sitersgen.nim.o \
c_code/2_7/@mplugins@sactive.nim.o \
c_code/2_7/@menumtostr.nim.o \
c_code/2_7/@mspawn.nim.o \
c_code/2_7/@msem.nim.o \
c_code/2_7/@mdfa.nim.o \
c_code/2_7/@moptimizer.nim.o \
c_code/2_7/@minjectdestructors.nim.o \
c_code/2_7/@msemparallel.nim.o \
c_code/2_7/stdlib_dynlib.nim.o \
c_code/2_7/@mcgen.nim.o \
c_code/2_7/@mic@sreplayer.nim.o \
c_code/2_7/@mmodules.nim.o \
c_code/2_7/@mscriptconfig.nim.o \
c_code/2_7/@mnimconf.nim.o \
c_code/2_7/@mpassaux.nim.o \
c_code/2_7/@mdepends.nim.o \
c_code/2_7/@mic@sdce.nim.o \
c_code/2_7/@mic@scbackend.nim.o \
c_code/2_7/@mic@sintegrity.nim.o \
c_code/2_7/@mic@snavigator.nim.o \
c_code/2_7/@msourcemap.nim.o \
c_code/2_7/@mjsgen.nim.o \
c_code/2_7/stdlib_rstast.nim.o \
c_code/2_7/stdlib_highlite.nim.o \
c_code/2_7/stdlib_rst.nim.o \
c_code/2_7/stdlib_rstgen.nim.o \
c_code/2_7/stdlib_xmltree.nim.o \
c_code/2_7/@mtypesrenderer.nim.o \
c_code/2_7/@mrenderverbatim.nim.o \
c_code/2_7/stdlib_base64.nim.o \
c_code/2_7/stdlib_uri.nim.o \
c_code/2_7/@mdocgen.nim.o \
c_code/2_7/@mdocgen2.nim.o \
c_code/2_7/@mmain.nim.o \
c_code/2_7/@mcmdlinehelper.nim.o \
c_code/2_7/stdlib_browsers.nim.o \
c_code/2_7/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_io.nim.c -o c_code/2_8/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_system.nim.c -o c_code/2_8/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_parseutils.nim.c -o c_code/2_8/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_strutils.nim.c -o c_code/2_8/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_pathnorm.nim.c -o c_code/2_8/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_os.nim.c -o c_code/2_8/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_parseopt.nim.c -o c_code/2_8/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_hashes.nim.c -o c_code/2_8/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_strtabs.nim.c -o c_code/2_8/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mropes.nim.c -o c_code/2_8/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mlineinfos.nim.c -o c_code/2_8/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mplatform.nim.c -o c_code/2_8/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@moptions.nim.c -o c_code/2_8/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mmsgs.nim.c -o c_code/2_8/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_streams.nim.c -o c_code/2_3/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_osproc.nim.c -o c_code/2_8/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_sha1.nim.c -o c_code/2_3/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_json.nim.c -o c_code/2_8/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mextccomp.nim.c -o c_code/2_8/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mnimblecmd.nim.c -o c_code/2_8/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@midents.nim.c -o c_code/2_8/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mcommands.nim.c -o c_code/2_8/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mlexer.nim.c -o c_code/2_8/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mparser.nim.c -o c_code/2_8/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mrenderer.nim.c -o c_code/2_8/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mfilter_tmpl.nim.c -o c_code/2_8/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@msyntaxes.nim.c -o c_code/2_8/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mic@sic.nim.c -o c_code/2_8/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypes.nim.c -o c_code/2_3/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemfold.nim.c -o c_code/2_3/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulepaths.nim.c -o c_code/2_3/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mnimfix@sprettybase.nim.c -o c_code/2_8/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mlookups.nim.c -o c_code/2_8/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@msigmatch.nim.c -o c_code/2_8/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mpragmas.nim.c -o c_code/2_8/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mreorder.nim.c -o c_code/2_8/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mtreetab.nim.c -o c_code/2_8/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdeps.nim.c -o c_code/2_3/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mvm.nim.c -o c_code/2_8/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@msem.nim.c -o c_code/2_8/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_dynlib.nim.c -o c_code/2_8/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mcgen.nim.c -o c_code/2_8/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mscriptconfig.nim.c -o c_code/2_8/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mnimconf.nim.c -o c_code/2_8/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mic@sdce.nim.c -o c_code/2_8/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mic@snavigator.nim.c -o c_code/2_8/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@msourcemap.nim.c -o c_code/2_8/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mjsgen.nim.c -o c_code/2_8/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_rst.nim.c -o c_code/2_8/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_rstgen.nim.c -o c_code/2_8/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mtypesrenderer.nim.c -o c_code/2_8/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mdocgen.nim.c -o c_code/2_8/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_browsers.nim.c -o c_code/2_8/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_8/stdlib_io.nim.o \
c_code/2_8/stdlib_system.nim.o \
c_code/2_8/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_8/stdlib_strutils.nim.o \
c_code/2_8/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/2_8/stdlib_os.nim.o \
c_code/2_8/stdlib_parseopt.nim.o \
c_code/2_8/stdlib_hashes.nim.o \
c_code/2_8/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_8/@mropes.nim.o \
c_code/2_8/@mlineinfos.nim.o \
c_code/2_8/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_8/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_8/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_3/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_8/stdlib_osproc.nim.o \
c_code/2_3/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/2_8/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/2_8/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_8/@mnimblecmd.nim.o \
c_code/2_8/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_8/@mcommands.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_8/@mlexer.nim.o \
c_code/2_8/@mparser.nim.o \
c_code/2_8/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_8/@mfilter_tmpl.nim.o \
c_code/2_8/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_8/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_3/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/2_3/@msemfold.nim.o \
c_code/2_3/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_8/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_8/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_8/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_8/@mpragmas.nim.o \
c_code/2_8/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_8/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_3/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/2_8/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/2_8/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_8/stdlib_dynlib.nim.o \
c_code/2_8/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/2_8/@mscriptconfig.nim.o \
c_code/2_8/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_8/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_8/@mic@snavigator.nim.o \
c_code/2_8/@msourcemap.nim.o \
c_code/2_8/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_8/stdlib_rst.nim.o \
c_code/2_8/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_8/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_8/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/2_8/stdlib_browsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_hashes.nim.c -o c_code/2_9/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_strtabs.nim.c -o c_code/2_9/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mropes.nim.c -o c_code/2_9/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mlineinfos.nim.c -o c_code/2_9/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mplatform.nim.c -o c_code/2_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@moptions.nim.c -o c_code/2_9/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mmsgs.nim.c -o c_code/2_9/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/stdlib_sha1.nim.c -o c_code/2_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_json.nim.c -o c_code/2_9/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mnimblecmd.nim.c -o c_code/2_9/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@midents.nim.c -o c_code/2_9/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@sic.nim.c -o c_code/2_9/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mtreetab.nim.c -o c_code/2_9/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mvm.nim.c -o c_code/2_9/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mcgen.nim.c -o c_code/2_9/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@sdce.nim.c -o c_code/2_9/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@snavigator.nim.c -o c_code/2_9/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_rst.nim.c -o c_code/2_9/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_rstgen.nim.c -o c_code/2_9/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mdocgen.nim.c -o c_code/2_9/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/2_9/stdlib_hashes.nim.o \
c_code/2_9/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_9/@mropes.nim.o \
c_code/2_9/@mlineinfos.nim.o \
c_code/2_9/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_9/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_9/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_9/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_9/@mnimblecmd.nim.o \
c_code/2_9/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_9/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_9/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_9/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_9/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_9/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_9/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_9/stdlib_rst.nim.o \
c_code/2_9/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_9/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  m68k)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_io.nim.c -o c_code/2_10/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_system.nim.c -o c_code/2_10/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_os.nim.c -o c_code/2_10/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseopt.nim.c -o c_code/2_10/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mplatform.nim.c -o c_code/2_10/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@moptions.nim.c -o c_code/2_10/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mmsgs.nim.c -o c_code/2_10/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_streams.nim.c -o c_code/2_3/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_osproc.nim.c -o c_code/2_10/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_sha1.nim.c -o c_code/2_3/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_json.nim.c -o c_code/2_3/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mextccomp.nim.c -o c_code/2_10/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimblecmd.nim.c -o c_code/2_10/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcommands.nim.c -o c_code/2_10/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlexer.nim.c -o c_code/2_10/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypes.nim.c -o c_code/2_3/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemfold.nim.c -o c_code/2_3/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulepaths.nim.c -o c_code/2_3/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msigmatch.nim.c -o c_code/2_10/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mpragmas.nim.c -o c_code/2_10/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdeps.nim.c -o c_code/2_3/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mvm.nim.c -o c_code/2_10/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msem.nim.c -o c_code/2_10/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcgen.nim.c -o c_code/2_10/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mscriptconfig.nim.c -o c_code/2_10/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimconf.nim.c -o c_code/2_10/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rst.nim.c -o c_code/2_10/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rstgen.nim.c -o c_code/2_10/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mdocgen.nim.c -o c_code/2_10/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_browsers.nim.c -o c_code/2_10/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_10/stdlib_io.nim.o \
c_code/2_10/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/2_10/stdlib_os.nim.o \
c_code/2_10/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/2_10/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_10/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_10/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_3/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_10/stdlib_osproc.nim.o \
c_code/2_3/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/2_3/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/2_10/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_10/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_10/@mcommands.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_10/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_3/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/2_3/@msemfold.nim.o \
c_code/2_3/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_10/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_10/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_3/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/2_10/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/2_10/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/2_10/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/2_10/@mscriptconfig.nim.o \
c_code/2_10/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_10/stdlib_rst.nim.o \
c_code/2_10/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_10/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/2_10/stdlib_browsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mips)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_io.nim.c -o c_code/2_10/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_system.nim.c -o c_code/2_10/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_os.nim.c -o c_code/2_10/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseopt.nim.c -o c_code/2_10/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_11/@mplatform.nim.c -o c_code/2_11/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@moptions.nim.c -o c_code/2_10/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mmsgs.nim.c -o c_code/2_10/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_streams.nim.c -o c_code/2_3/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_osproc.nim.c -o c_code/2_10/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_sha1.nim.c -o c_code/2_3/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_json.nim.c -o c_code/2_3/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mextccomp.nim.c -o c_code/2_10/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimblecmd.nim.c -o c_code/2_10/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcommands.nim.c -o c_code/2_10/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlexer.nim.c -o c_code/2_10/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypes.nim.c -o c_code/2_3/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemfold.nim.c -o c_code/2_3/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulepaths.nim.c -o c_code/2_3/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msigmatch.nim.c -o c_code/2_10/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mpragmas.nim.c -o c_code/2_10/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdeps.nim.c -o c_code/2_3/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mvm.nim.c -o c_code/2_10/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msem.nim.c -o c_code/2_10/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcgen.nim.c -o c_code/2_10/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mscriptconfig.nim.c -o c_code/2_10/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimconf.nim.c -o c_code/2_10/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rst.nim.c -o c_code/2_10/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rstgen.nim.c -o c_code/2_10/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mdocgen.nim.c -o c_code/2_10/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_browsers.nim.c -o c_code/2_10/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_10/stdlib_io.nim.o \
c_code/2_10/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/2_10/stdlib_os.nim.o \
c_code/2_10/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/2_11/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_10/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_10/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_3/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_10/stdlib_osproc.nim.o \
c_code/2_3/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/2_3/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/2_10/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_10/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_10/@mcommands.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_10/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_3/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/2_3/@msemfold.nim.o \
c_code/2_3/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_10/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_10/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_3/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/2_10/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/2_10/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/2_10/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/2_10/@mscriptconfig.nim.o \
c_code/2_10/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_10/stdlib_rst.nim.o \
c_code/2_10/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_10/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/2_10/stdlib_browsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mipsel)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_io.nim.c -o c_code/2_10/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_system.nim.c -o c_code/2_10/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_os.nim.c -o c_code/2_10/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseopt.nim.c -o c_code/2_10/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_12/@mplatform.nim.c -o c_code/2_12/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@moptions.nim.c -o c_code/2_10/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mmsgs.nim.c -o c_code/2_10/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_streams.nim.c -o c_code/2_3/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_osproc.nim.c -o c_code/2_10/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_json.nim.c -o c_code/2_3/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mextccomp.nim.c -o c_code/2_10/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimblecmd.nim.c -o c_code/2_10/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcommands.nim.c -o c_code/2_10/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlexer.nim.c -o c_code/2_10/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypes.nim.c -o c_code/2_3/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemfold.nim.c -o c_code/2_3/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulepaths.nim.c -o c_code/2_3/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msigmatch.nim.c -o c_code/2_10/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mpragmas.nim.c -o c_code/2_10/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdeps.nim.c -o c_code/2_3/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mvm.nim.c -o c_code/2_10/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msem.nim.c -o c_code/2_10/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcgen.nim.c -o c_code/2_10/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mscriptconfig.nim.c -o c_code/2_10/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimconf.nim.c -o c_code/2_10/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rst.nim.c -o c_code/2_10/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rstgen.nim.c -o c_code/2_10/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mdocgen.nim.c -o c_code/2_10/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_browsers.nim.c -o c_code/2_10/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_10/stdlib_io.nim.o \
c_code/2_10/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/2_10/stdlib_os.nim.o \
c_code/2_10/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/2_12/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_10/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_10/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_3/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_10/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/2_3/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/2_10/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_10/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_10/@mcommands.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_10/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_3/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/2_3/@msemfold.nim.o \
c_code/2_3/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_10/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_10/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_3/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/2_10/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/2_10/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/2_10/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/2_10/@mscriptconfig.nim.o \
c_code/2_10/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_10/stdlib_rst.nim.o \
c_code/2_10/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_10/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/2_10/stdlib_browsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_13/@mplatform.nim.c -o c_code/2_13/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/stdlib_sha1.nim.c -o c_code/2_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_json.nim.c -o c_code/2_4/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rst.nim.c -o c_code/2_4/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstgen.nim.c -o c_code/2_4/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/2_13/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_4/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_4/stdlib_rst.nim.o \
c_code/2_4/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_14/@mplatform.nim.c -o c_code/2_14/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_json.nim.c -o c_code/2_4/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rst.nim.c -o c_code/2_4/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstgen.nim.c -o c_code/2_4/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/2_14/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_4/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_4/stdlib_rst.nim.o \
c_code/2_4/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_io.nim.c -o c_code/2_10/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_system.nim.c -o c_code/2_10/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_os.nim.c -o c_code/2_10/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseopt.nim.c -o c_code/2_10/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_15/@mplatform.nim.c -o c_code/2_15/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@moptions.nim.c -o c_code/2_10/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mmsgs.nim.c -o c_code/2_10/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_streams.nim.c -o c_code/2_3/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_osproc.nim.c -o c_code/2_10/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_sha1.nim.c -o c_code/2_3/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_json.nim.c -o c_code/2_3/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mextccomp.nim.c -o c_code/2_10/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimblecmd.nim.c -o c_code/2_10/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcommands.nim.c -o c_code/2_10/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlexer.nim.c -o c_code/2_10/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypes.nim.c -o c_code/2_3/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemfold.nim.c -o c_code/2_3/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulepaths.nim.c -o c_code/2_3/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msigmatch.nim.c -o c_code/2_10/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mpragmas.nim.c -o c_code/2_10/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdeps.nim.c -o c_code/2_3/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mvm.nim.c -o c_code/2_10/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msem.nim.c -o c_code/2_10/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcgen.nim.c -o c_code/2_10/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mscriptconfig.nim.c -o c_code/2_10/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimconf.nim.c -o c_code/2_10/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rst.nim.c -o c_code/2_10/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rstgen.nim.c -o c_code/2_10/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mdocgen.nim.c -o c_code/2_10/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_browsers.nim.c -o c_code/2_10/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_10/stdlib_io.nim.o \
c_code/2_10/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/2_10/stdlib_os.nim.o \
c_code/2_10/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/2_15/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_10/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_10/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_3/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_10/stdlib_osproc.nim.o \
c_code/2_3/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/2_3/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/2_10/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_10/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_10/@mcommands.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_10/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_3/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/2_3/@msemfold.nim.o \
c_code/2_3/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_10/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_10/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_3/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/2_10/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/2_10/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/2_10/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/2_10/@mscriptconfig.nim.o \
c_code/2_10/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_10/stdlib_rst.nim.o \
c_code/2_10/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_10/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/2_10/stdlib_browsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_16/@mplatform.nim.c -o c_code/2_16/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_json.nim.c -o c_code/2_4/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rst.nim.c -o c_code/2_4/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstgen.nim.c -o c_code/2_4/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/2_16/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_4/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_4/stdlib_rst.nim.o \
c_code/2_4/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_digitsutils.nim.c -o c_code/2_17/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_assertions.nim.c -o c_code/2_17/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dragonbox.nim.c -o c_code/2_17/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_schubfach.nim.c -o c_code/2_17/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_formatfloat.nim.c -o c_code/2_17/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dollars.nim.c -o c_code/2_17/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_io.nim.c -o c_code/2_17/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_system.nim.c -o c_code/2_17/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parseutils.nim.c -o c_code/2_17/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_math.nim.c -o c_code/2_17/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_unicode.nim.c -o c_code/2_17/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strutils.nim.c -o c_code/2_17/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_pathnorm.nim.c -o c_code/2_17/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_posix.nim.c -o c_code/2_17/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_times.nim.c -o c_code/2_17/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_os.nim.c -o c_code/2_17/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parseopt.nim.c -o c_code/2_17/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_hashes.nim.c -o c_code/2_17/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strtabs.nim.c -o c_code/2_17/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strformat.nim.c -o c_code/2_17/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_terminal.nim.c -o c_code/2_17/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpathutils.nim.c -o c_code/2_17/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mropes.nim.c -o c_code/2_17/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlineinfos.nim.c -o c_code/2_17/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplatform.nim.c -o c_code/2_17/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprefixmatches.nim.c -o c_code/2_17/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimpaths.nim.c -o c_code/2_17/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_globs.nim.c -o c_code/2_17/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptions.nim.c -o c_code/2_17/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mstrutils2.nim.c -o c_code/2_17/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmsgs.nim.c -o c_code/2_17/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcondsyms.nim.c -o c_code/2_17/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_streams.nim.c -o c_code/2_17/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_cpuinfo.nim.c -o c_code/2_17/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_osproc.nim.c -o c_code/2_17/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_sha1.nim.c -o c_code/2_17/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_lexbase.nim.c -o c_code/2_17/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parsejson.nim.c -o c_code/2_17/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_json.nim.c -o c_code/2_17/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_jsonutils.nim.c -o c_code/2_17/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mextccomp.nim.c -o c_code/2_17/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mwordrecg.nim.c -o c_code/2_17/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimblecmd.nim.c -o c_code/2_17/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@midents.nim.c -o c_code/2_17/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mint128.nim.c -o c_code/2_17/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mast.nim.c -o c_code/2_17/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcommands.nim.c -o c_code/2_17/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mllstream.nim.c -o c_code/2_17/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimlexbase.nim.c -o c_code/2_17/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlexer.nim.c -o c_code/2_17/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparser.nim.c -o c_code/2_17/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderer.nim.c -o c_code/2_17/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilters.nim.c -o c_code/2_17/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilter_tmpl.nim.c -o c_code/2_17/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msyntaxes.nim.c -o c_code/2_17/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_packedsets.nim.c -o c_code/2_17/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_intsets.nim.c -o c_code/2_17/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastalgo.nim.c -o c_code/2_17/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtrees.nim.c -o c_code/2_17/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_md5.nim.c -o c_code/2_17/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@srodfiles.nim.c -o c_code/2_17/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@spacked_ast.nim.c -o c_code/2_17/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sic.nim.c -o c_code/2_17/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulegraphs.nim.c -o c_code/2_17/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastmsgs.nim.c -o c_code/2_17/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypes.nim.c -o c_code/2_17/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmagicsys.nim.c -o c_code/2_17/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mbitsets.nim.c -o c_code/2_17/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimsets.nim.c -o c_code/2_17/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemfold.nim.c -o c_code/2_17/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulepaths.nim.c -o c_code/2_17/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmdef.nim.c -o c_code/2_17/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemdata.nim.c -o c_code/2_17/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlinter.nim.c -o c_code/2_17/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimfix@sprettybase.nim.c -o c_code/2_17/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_editdistance.nim.c -o c_code/2_17/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlookups.nim.c -o c_code/2_17/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mconcepts.nim.c -o c_code/2_17/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemtypinst.nim.c -o c_code/2_17/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparampatterns.nim.c -o c_code/2_17/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlowerings.nim.c -o c_code/2_17/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msigmatch.nim.c -o c_code/2_17/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mimporter.nim.c -o c_code/2_17/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprocfind.nim.c -o c_code/2_17/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpragmas.nim.c -o c_code/2_17/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mreorder.nim.c -o c_code/2_17/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpasses.nim.c -o c_code/2_17/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msaturate.nim.c -o c_code/2_17/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mguards.nim.c -o c_code/2_17/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypeallowed.nim.c -o c_code/2_17/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@misolation_check.nim.c -o c_code/2_17/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvarpartitions.nim.c -o c_code/2_17/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtreetab.nim.c -o c_code/2_17/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnilcheck.nim.c -o c_code/2_17/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@merrorhandling.nim.c -o c_code/2_17/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msighashes.nim.c -o c_code/2_17/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mndi.nim.c -o c_code/2_17/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgendata.nim.c -o c_code/2_17/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mccgutils.nim.c -o c_code/2_17/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftdestructors.nim.c -o c_code/2_17/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msempass2.nim.c -o c_code/2_17/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgmeth.nim.c -o c_code/2_17/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftlocals.nim.c -o c_code/2_17/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlambdalifting.nim.c -o c_code/2_17/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mclosureiters.nim.c -o c_code/2_17/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtransf.nim.c -o c_code/2_17/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmgen.nim.c -o c_code/2_17/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmdeps.nim.c -o c_code/2_17/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmmarshal.nim.c -o c_code/2_17/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mgorgeimpl.nim.c -o c_code/2_17/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmacrocacheimpl.nim.c -o c_code/2_17/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmprofiler.nim.c -o c_code/2_17/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mevaltempl.nim.c -o c_code/2_17/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvm.nim.c -o c_code/2_17/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliases.nim.c -o c_code/2_17/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpatterns.nim.c -o c_code/2_17/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemmacrosanity.nim.c -o c_code/2_17/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpluginsupport.nim.c -o c_code/2_17/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@slocals.nim.c -o c_code/2_17/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sitersgen.nim.c -o c_code/2_17/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sactive.nim.c -o c_code/2_17/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@menumtostr.nim.c -o c_code/2_17/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mspawn.nim.c -o c_code/2_17/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msem.nim.c -o c_code/2_17/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdfa.nim.c -o c_code/2_17/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptimizer.nim.c -o c_code/2_17/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@minjectdestructors.nim.c -o c_code/2_17/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemparallel.nim.c -o c_code/2_17/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dynlib.nim.c -o c_code/2_17/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgen.nim.c -o c_code/2_17/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sreplayer.nim.c -o c_code/2_17/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodules.nim.c -o c_code/2_17/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mscriptconfig.nim.c -o c_code/2_17/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimconf.nim.c -o c_code/2_17/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpassaux.nim.c -o c_code/2_17/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdepends.nim.c -o c_code/2_17/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sdce.nim.c -o c_code/2_17/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@scbackend.nim.c -o c_code/2_17/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sintegrity.nim.c -o c_code/2_17/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@snavigator.nim.c -o c_code/2_17/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msourcemap.nim.c -o c_code/2_17/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mjsgen.nim.c -o c_code/2_17/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_rstast.nim.c -o c_code/2_17/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_highlite.nim.c -o c_code/2_17/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_rst.nim.c -o c_code/2_17/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_rstgen.nim.c -o c_code/2_17/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_xmltree.nim.c -o c_code/2_17/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypesrenderer.nim.c -o c_code/2_17/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderverbatim.nim.c -o c_code/2_17/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_base64.nim.c -o c_code/2_17/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_uri.nim.c -o c_code/2_17/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdocgen.nim.c -o c_code/2_17/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdocgen2.nim.c -o c_code/2_17/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmain.nim.c -o c_code/2_17/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcmdlinehelper.nim.c -o c_code/2_17/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_browsers.nim.c -o c_code/2_17/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnim.nim.c -o c_code/2_17/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_17/stdlib_digitsutils.nim.o \
c_code/2_17/stdlib_assertions.nim.o \
c_code/2_17/stdlib_dragonbox.nim.o \
c_code/2_17/stdlib_schubfach.nim.o \
c_code/2_17/stdlib_formatfloat.nim.o \
c_code/2_17/stdlib_dollars.nim.o \
c_code/2_17/stdlib_io.nim.o \
c_code/2_17/stdlib_system.nim.o \
c_code/2_17/stdlib_parseutils.nim.o \
c_code/2_17/stdlib_math.nim.o \
c_code/2_17/stdlib_unicode.nim.o \
c_code/2_17/stdlib_strutils.nim.o \
c_code/2_17/stdlib_pathnorm.nim.o \
c_code/2_17/stdlib_posix.nim.o \
c_code/2_17/stdlib_times.nim.o \
c_code/2_17/stdlib_os.nim.o \
c_code/2_17/stdlib_parseopt.nim.o \
c_code/2_17/stdlib_hashes.nim.o \
c_code/2_17/stdlib_strtabs.nim.o \
c_code/2_17/stdlib_strformat.nim.o \
c_code/2_17/stdlib_terminal.nim.o \
c_code/2_17/@mpathutils.nim.o \
c_code/2_17/@mropes.nim.o \
c_code/2_17/@mlineinfos.nim.o \
c_code/2_17/@mplatform.nim.o \
c_code/2_17/@mprefixmatches.nim.o \
c_code/2_17/@mnimpaths.nim.o \
c_code/2_17/stdlib_globs.nim.o \
c_code/2_17/@moptions.nim.o \
c_code/2_17/@mstrutils2.nim.o \
c_code/2_17/@mmsgs.nim.o \
c_code/2_17/@mcondsyms.nim.o \
c_code/2_17/stdlib_streams.nim.o \
c_code/2_17/stdlib_cpuinfo.nim.o \
c_code/2_17/stdlib_osproc.nim.o \
c_code/2_17/stdlib_sha1.nim.o \
c_code/2_17/stdlib_lexbase.nim.o \
c_code/2_17/stdlib_parsejson.nim.o \
c_code/2_17/stdlib_json.nim.o \
c_code/2_17/stdlib_jsonutils.nim.o \
c_code/2_17/@mextccomp.nim.o \
c_code/2_17/@mwordrecg.nim.o \
c_code/2_17/@mnimblecmd.nim.o \
c_code/2_17/@midents.nim.o \
c_code/2_17/@mint128.nim.o \
c_code/2_17/@mast.nim.o \
c_code/2_17/@mcommands.nim.o \
c_code/2_17/@mllstream.nim.o \
c_code/2_17/@mnimlexbase.nim.o \
c_code/2_17/@mlexer.nim.o \
c_code/2_17/@mparser.nim.o \
c_code/2_17/@mrenderer.nim.o \
c_code/2_17/@mfilters.nim.o \
c_code/2_17/@mfilter_tmpl.nim.o \
c_code/2_17/@msyntaxes.nim.o \
c_code/2_17/stdlib_packedsets.nim.o \
c_code/2_17/stdlib_intsets.nim.o \
c_code/2_17/@mastalgo.nim.o \
c_code/2_17/@mtrees.nim.o \
c_code/2_17/stdlib_md5.nim.o \
c_code/2_17/@mic@srodfiles.nim.o \
c_code/2_17/@mic@spacked_ast.nim.o \
c_code/2_17/@mic@sic.nim.o \
c_code/2_17/@mmodulegraphs.nim.o \
c_code/2_17/@mastmsgs.nim.o \
c_code/2_17/@mtypes.nim.o \
c_code/2_17/@mmagicsys.nim.o \
c_code/2_17/@mbitsets.nim.o \
c_code/2_17/@mnimsets.nim.o \
c_code/2_17/@msemfold.nim.o \
c_code/2_17/@mmodulepaths.nim.o \
c_code/2_17/@mvmdef.nim.o \
c_code/2_17/@msemdata.nim.o \
c_code/2_17/@mlinter.nim.o \
c_code/2_17/@mnimfix@sprettybase.nim.o \
c_code/2_17/stdlib_editdistance.nim.o \
c_code/2_17/@mlookups.nim.o \
c_code/2_17/@mconcepts.nim.o \
c_code/2_17/@msemtypinst.nim.o \
c_code/2_17/@mparampatterns.nim.o \
c_code/2_17/@mlowerings.nim.o \
c_code/2_17/@msigmatch.nim.o \
c_code/2_17/@mimporter.nim.o \
c_code/2_17/@mprocfind.nim.o \
c_code/2_17/@mpragmas.nim.o \
c_code/2_17/@mreorder.nim.o \
c_code/2_17/@mpasses.nim.o \
c_code/2_17/@msaturate.nim.o \
c_code/2_17/@mguards.nim.o \
c_code/2_17/@mtypeallowed.nim.o \
c_code/2_17/@misolation_check.nim.o \
c_code/2_17/@mvarpartitions.nim.o \
c_code/2_17/@mtreetab.nim.o \
c_code/2_17/@mnilcheck.nim.o \
c_code/2_17/@merrorhandling.nim.o \
c_code/2_17/@msighashes.nim.o \
c_code/2_17/@mndi.nim.o \
c_code/2_17/@mcgendata.nim.o \
c_code/2_17/@mccgutils.nim.o \
c_code/2_17/@mliftdestructors.nim.o \
c_code/2_17/@msempass2.nim.o \
c_code/2_17/@mcgmeth.nim.o \
c_code/2_17/@mliftlocals.nim.o \
c_code/2_17/@mlambdalifting.nim.o \
c_code/2_17/@mclosureiters.nim.o \
c_code/2_17/@mtransf.nim.o \
c_code/2_17/@mvmgen.nim.o \
c_code/2_17/@mvmdeps.nim.o \
c_code/2_17/@mvmmarshal.nim.o \
c_code/2_17/@mgorgeimpl.nim.o \
c_code/2_17/@mmacrocacheimpl.nim.o \
c_code/2_17/@mvmprofiler.nim.o \
c_code/2_17/@mevaltempl.nim.o \
c_code/2_17/@mvm.nim.o \
c_code/2_17/@maliases.nim.o \
c_code/2_17/@mpatterns.nim.o \
c_code/2_17/@msemmacrosanity.nim.o \
c_code/2_17/@mpluginsupport.nim.o \
c_code/2_17/@mplugins@slocals.nim.o \
c_code/2_17/@mplugins@sitersgen.nim.o \
c_code/2_17/@mplugins@sactive.nim.o \
c_code/2_17/@menumtostr.nim.o \
c_code/2_17/@mspawn.nim.o \
c_code/2_17/@msem.nim.o \
c_code/2_17/@mdfa.nim.o \
c_code/2_17/@moptimizer.nim.o \
c_code/2_17/@minjectdestructors.nim.o \
c_code/2_17/@msemparallel.nim.o \
c_code/2_17/stdlib_dynlib.nim.o \
c_code/2_17/@mcgen.nim.o \
c_code/2_17/@mic@sreplayer.nim.o \
c_code/2_17/@mmodules.nim.o \
c_code/2_17/@mscriptconfig.nim.o \
c_code/2_17/@mnimconf.nim.o \
c_code/2_17/@mpassaux.nim.o \
c_code/2_17/@mdepends.nim.o \
c_code/2_17/@mic@sdce.nim.o \
c_code/2_17/@mic@scbackend.nim.o \
c_code/2_17/@mic@sintegrity.nim.o \
c_code/2_17/@mic@snavigator.nim.o \
c_code/2_17/@msourcemap.nim.o \
c_code/2_17/@mjsgen.nim.o \
c_code/2_17/stdlib_rstast.nim.o \
c_code/2_17/stdlib_highlite.nim.o \
c_code/2_17/stdlib_rst.nim.o \
c_code/2_17/stdlib_rstgen.nim.o \
c_code/2_17/stdlib_xmltree.nim.o \
c_code/2_17/@mtypesrenderer.nim.o \
c_code/2_17/@mrenderverbatim.nim.o \
c_code/2_17/stdlib_base64.nim.o \
c_code/2_17/stdlib_uri.nim.o \
c_code/2_17/@mdocgen.nim.o \
c_code/2_17/@mdocgen2.nim.o \
c_code/2_17/@mmain.nim.o \
c_code/2_17/@mcmdlinehelper.nim.o \
c_code/2_17/stdlib_browsers.nim.o \
c_code/2_17/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_io.nim.c -o c_code/2_10/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_system.nim.c -o c_code/2_10/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_posix.nim.c -o c_code/2_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_os.nim.c -o c_code/2_10/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseopt.nim.c -o c_code/2_10/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplatform.nim.c -o c_code/2_18/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@moptions.nim.c -o c_code/2_10/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mmsgs.nim.c -o c_code/2_10/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_streams.nim.c -o c_code/2_3/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_osproc.nim.c -o c_code/2_10/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_json.nim.c -o c_code/2_3/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mextccomp.nim.c -o c_code/2_10/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimblecmd.nim.c -o c_code/2_10/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcommands.nim.c -o c_code/2_10/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlexer.nim.c -o c_code/2_10/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypes.nim.c -o c_code/2_3/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemfold.nim.c -o c_code/2_3/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulepaths.nim.c -o c_code/2_3/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msigmatch.nim.c -o c_code/2_10/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mpragmas.nim.c -o c_code/2_10/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdeps.nim.c -o c_code/2_3/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mvm.nim.c -o c_code/2_10/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msem.nim.c -o c_code/2_10/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mcgen.nim.c -o c_code/2_10/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mscriptconfig.nim.c -o c_code/2_10/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimconf.nim.c -o c_code/2_10/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rst.nim.c -o c_code/2_10/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_rstgen.nim.c -o c_code/2_10/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mdocgen.nim.c -o c_code/2_10/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_browsers.nim.c -o c_code/2_10/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/2_10/stdlib_io.nim.o \
c_code/2_10/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/2_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/2_10/stdlib_os.nim.o \
c_code/2_10/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/2_18/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/2_10/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/2_10/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/2_3/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/2_10/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/2_3/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/2_10/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_10/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_10/@mcommands.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/2_10/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/2_3/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/2_3/@msemfold.nim.o \
c_code/2_3/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_10/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_10/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_3/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/2_10/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/2_10/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/2_10/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/2_10/@mscriptconfig.nim.o \
c_code/2_10/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/2_10/stdlib_rst.nim.o \
c_code/2_10/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/2_10/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/2_10/stdlib_browsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_io.nim.c -o c_code/2_4/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_system.nim.c -o c_code/2_4/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_posix.nim.c -o c_code/2_4/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_os.nim.c -o c_code/2_4/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseopt.nim.c -o c_code/2_4/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_19/@mplatform.nim.c -o c_code/2_19/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_streams.nim.c -o c_code/2_4/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_osproc.nim.c -o c_code/2_4/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_json.nim.c -o c_code/2_4/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypes.nim.c -o c_code/2_4/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemfold.nim.c -o c_code/2_4/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulepaths.nim.c -o c_code/2_4/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rst.nim.c -o c_code/2_4/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstgen.nim.c -o c_code/2_4/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen2.nim.c -o c_code/2_4/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_browsers.nim.c -o c_code/2_4/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/2_4/stdlib_io.nim.o \
c_code/2_4/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/2_4/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/2_4/stdlib_os.nim.o \
c_code/2_4/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/2_19/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/2_4/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/2_4/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/2_4/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/2_4/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/2_4/@msemfold.nim.o \
c_code/2_4/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/2_4/stdlib_rst.nim.o \
c_code/2_4/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_4/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/2_4/stdlib_browsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
macosx)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_assertions.nim.c -o c_code/2_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_io.nim.c -o c_code/3_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_system.nim.c -o c_code/3_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseutils.nim.c -o c_code/2_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_strutils.nim.c -o c_code/3_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_pathnorm.nim.c -o c_code/2_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_posix.nim.c -o c_code/3_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_times.nim.c -o c_code/3_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_os.nim.c -o c_code/3_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_parseopt.nim.c -o c_code/3_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strtabs.nim.c -o c_code/2_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strformat.nim.c -o c_code/2_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_terminal.nim.c -o c_code/3_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mropes.nim.c -o c_code/3_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mplatform.nim.c -o c_code/3_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimpaths.nim.c -o c_code/3_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@moptions.nim.c -o c_code/3_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mstrutils2.nim.c -o c_code/1_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmsgs.nim.c -o c_code/3_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_streams.nim.c -o c_code/3_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_cpuinfo.nim.c -o c_code/3_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_osproc.nim.c -o c_code/3_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_sha1.nim.c -o c_code/3_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parsejson.nim.c -o c_code/2_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_json.nim.c -o c_code/3_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_jsonutils.nim.c -o c_code/2_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mextccomp.nim.c -o c_code/3_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimblecmd.nim.c -o c_code/3_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mcommands.nim.c -o c_code/3_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mllstream.nim.c -o c_code/3_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mlexer.nim.c -o c_code/3_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mrenderer.nim.c -o c_code/3_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msyntaxes.nim.c -o c_code/3_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_intsets.nim.c -o c_code/2_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtrees.nim.c -o c_code/2_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@srodfiles.nim.c -o c_code/3_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@sic.nim.c -o c_code/3_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mtypes.nim.c -o c_code/3_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msemfold.nim.c -o c_code/3_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodulepaths.nim.c -o c_code/3_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mlinter.nim.c -o c_code/3_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimfix@sprettybase.nim.c -o c_code/2_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msigmatch.nim.c -o c_code/3_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mpragmas.nim.c -o c_code/3_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpasses.nim.c -o c_code/2_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtreetab.nim.c -o c_code/2_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mndi.nim.c -o c_code/3_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmdeps.nim.c -o c_code/3_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mgorgeimpl.nim.c -o c_code/3_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmacrocacheimpl.nim.c -o c_code/2_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmprofiler.nim.c -o c_code/3_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvm.nim.c -o c_code/3_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@slocals.nim.c -o c_code/2_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@menumtostr.nim.c -o c_code/2_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msem.nim.c -o c_code/3_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_dynlib.nim.c -o c_code/2_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mcgen.nim.c -o c_code/3_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodules.nim.c -o c_code/3_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mscriptconfig.nim.c -o c_code/3_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimconf.nim.c -o c_code/3_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpassaux.nim.c -o c_code/2_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mjsgen.nim.c -o c_code/3_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstast.nim.c -o c_code/2_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_rst.nim.c -o c_code/3_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_rstgen.nim.c -o c_code/3_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen.nim.c -o c_code/3_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen2.nim.c -o c_code/3_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmain.nim.c -o c_code/3_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_browsers.nim.c -o c_code/3_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnim.nim.c -o c_code/3_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/3_1/stdlib_io.nim.o \
c_code/3_1/stdlib_system.nim.o \
c_code/2_1/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/3_1/stdlib_strutils.nim.o \
c_code/2_1/stdlib_pathnorm.nim.o \
c_code/3_1/stdlib_posix.nim.o \
c_code/3_1/stdlib_times.nim.o \
c_code/3_1/stdlib_os.nim.o \
c_code/3_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_1/stdlib_strtabs.nim.o \
c_code/2_1/stdlib_strformat.nim.o \
c_code/3_1/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/3_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/3_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/3_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/3_1/@moptions.nim.o \
c_code/1_1/@mstrutils2.nim.o \
c_code/3_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/3_1/stdlib_streams.nim.o \
c_code/3_1/stdlib_cpuinfo.nim.o \
c_code/3_1/stdlib_osproc.nim.o \
c_code/3_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_1/stdlib_parsejson.nim.o \
c_code/3_1/stdlib_json.nim.o \
c_code/2_1/stdlib_jsonutils.nim.o \
c_code/3_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/3_1/@mnimblecmd.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_1/@mast.nim.o \
c_code/3_1/@mcommands.nim.o \
c_code/3_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/3_1/@mlexer.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/3_1/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/3_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_1/stdlib_intsets.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/2_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/3_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/3_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/3_1/@mtypes.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/3_1/@msemfold.nim.o \
c_code/3_1/@mmodulepaths.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/3_1/@mlinter.nim.o \
c_code/2_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/3_1/@msigmatch.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/3_1/@mpragmas.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mtreetab.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/3_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/3_1/@mvmdeps.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/3_1/@mgorgeimpl.nim.o \
c_code/2_1/@mmacrocacheimpl.nim.o \
c_code/3_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/3_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_1/@menumtostr.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/3_1/@msem.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/stdlib_dynlib.nim.o \
c_code/3_1/@mcgen.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/3_1/@mmodules.nim.o \
c_code/3_1/@mscriptconfig.nim.o \
c_code/3_1/@mnimconf.nim.o \
c_code/2_1/@mpassaux.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/3_1/@mjsgen.nim.o \
c_code/2_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/3_1/stdlib_rst.nim.o \
c_code/3_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/3_1/@mdocgen.nim.o \
c_code/3_1/@mdocgen2.nim.o \
c_code/3_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/3_1/stdlib_browsers.nim.o \
c_code/3_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_assertions.nim.c -o c_code/2_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_io.nim.c -o c_code/3_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_system.nim.c -o c_code/3_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseutils.nim.c -o c_code/2_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_strutils.nim.c -o c_code/3_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_pathnorm.nim.c -o c_code/2_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_times.nim.c -o c_code/3_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_os.nim.c -o c_code/3_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_parseopt.nim.c -o c_code/3_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strtabs.nim.c -o c_code/2_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strformat.nim.c -o c_code/2_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_terminal.nim.c -o c_code/3_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mropes.nim.c -o c_code/3_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mplatform.nim.c -o c_code/3_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimpaths.nim.c -o c_code/3_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@moptions.nim.c -o c_code/3_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mstrutils2.nim.c -o c_code/1_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmsgs.nim.c -o c_code/3_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_streams.nim.c -o c_code/3_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_osproc.nim.c -o c_code/3_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_sha1.nim.c -o c_code/3_2/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parsejson.nim.c -o c_code/2_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_json.nim.c -o c_code/3_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_jsonutils.nim.c -o c_code/2_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mextccomp.nim.c -o c_code/3_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimblecmd.nim.c -o c_code/3_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mcommands.nim.c -o c_code/3_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mllstream.nim.c -o c_code/3_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mlexer.nim.c -o c_code/3_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mrenderer.nim.c -o c_code/3_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msyntaxes.nim.c -o c_code/3_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_intsets.nim.c -o c_code/2_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtrees.nim.c -o c_code/2_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@srodfiles.nim.c -o c_code/3_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@sic.nim.c -o c_code/3_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mtypes.nim.c -o c_code/3_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msemfold.nim.c -o c_code/3_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodulepaths.nim.c -o c_code/3_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mlinter.nim.c -o c_code/3_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimfix@sprettybase.nim.c -o c_code/2_2/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msigmatch.nim.c -o c_code/3_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpragmas.nim.c -o c_code/3_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpasses.nim.c -o c_code/2_2/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtreetab.nim.c -o c_code/2_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mndi.nim.c -o c_code/3_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdeps.nim.c -o c_code/3_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mgorgeimpl.nim.c -o c_code/3_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmacrocacheimpl.nim.c -o c_code/2_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmprofiler.nim.c -o c_code/3_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvm.nim.c -o c_code/3_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@slocals.nim.c -o c_code/2_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@menumtostr.nim.c -o c_code/2_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msem.nim.c -o c_code/3_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_dynlib.nim.c -o c_code/2_2/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mcgen.nim.c -o c_code/3_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodules.nim.c -o c_code/3_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mscriptconfig.nim.c -o c_code/3_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimconf.nim.c -o c_code/3_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpassaux.nim.c -o c_code/2_2/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mjsgen.nim.c -o c_code/3_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rstast.nim.c -o c_code/2_2/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_rst.nim.c -o c_code/3_2/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_rstgen.nim.c -o c_code/3_2/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen.nim.c -o c_code/3_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen2.nim.c -o c_code/3_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmain.nim.c -o c_code/3_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_browsers.nim.c -o c_code/3_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnim.nim.c -o c_code/3_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_2/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/3_2/stdlib_io.nim.o \
c_code/3_2/stdlib_system.nim.o \
c_code/2_2/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/3_2/stdlib_strutils.nim.o \
c_code/2_2/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/3_2/stdlib_times.nim.o \
c_code/3_2/stdlib_os.nim.o \
c_code/3_2/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_2/stdlib_strtabs.nim.o \
c_code/2_2/stdlib_strformat.nim.o \
c_code/3_2/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/3_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/3_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/3_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/3_2/@moptions.nim.o \
c_code/1_2/@mstrutils2.nim.o \
c_code/3_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/3_2/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/3_2/stdlib_osproc.nim.o \
c_code/3_2/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_2/stdlib_parsejson.nim.o \
c_code/3_2/stdlib_json.nim.o \
c_code/2_2/stdlib_jsonutils.nim.o \
c_code/3_2/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/3_2/@mnimblecmd.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_2/@mast.nim.o \
c_code/3_2/@mcommands.nim.o \
c_code/3_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/3_2/@mlexer.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/3_2/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/3_2/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_2/stdlib_intsets.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/2_2/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/3_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/3_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_2/@mtypes.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/3_2/@msemfold.nim.o \
c_code/3_2/@mmodulepaths.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/3_2/@mlinter.nim.o \
c_code/2_2/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/3_2/@msigmatch.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/3_2/@mpragmas.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mtreetab.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/3_2/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/3_2/@mvmdeps.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/3_2/@mgorgeimpl.nim.o \
c_code/2_2/@mmacrocacheimpl.nim.o \
c_code/3_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/3_2/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_2/@menumtostr.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/3_2/@msem.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/stdlib_dynlib.nim.o \
c_code/3_2/@mcgen.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/3_2/@mmodules.nim.o \
c_code/3_2/@mscriptconfig.nim.o \
c_code/3_2/@mnimconf.nim.o \
c_code/2_2/@mpassaux.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/3_2/@mjsgen.nim.o \
c_code/2_2/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/3_2/stdlib_rst.nim.o \
c_code/3_2/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/3_2/@mdocgen.nim.o \
c_code/3_2/@mdocgen2.nim.o \
c_code/3_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/3_2/stdlib_browsers.nim.o \
c_code/3_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_io.nim.c -o c_code/3_6/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_system.nim.c -o c_code/3_6/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_strutils.nim.c -o c_code/3_6/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_times.nim.c -o c_code/3_6/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_os.nim.c -o c_code/3_6/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_parseopt.nim.c -o c_code/3_6/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_terminal.nim.c -o c_code/3_6/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mropes.nim.c -o c_code/3_6/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mplatform.nim.c -o c_code/3_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimpaths.nim.c -o c_code/3_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@moptions.nim.c -o c_code/3_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mstrutils2.nim.c -o c_code/1_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmsgs.nim.c -o c_code/3_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_streams.nim.c -o c_code/3_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_osproc.nim.c -o c_code/3_6/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_sha1.nim.c -o c_code/3_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_json.nim.c -o c_code/3_6/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mextccomp.nim.c -o c_code/3_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimblecmd.nim.c -o c_code/3_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mcommands.nim.c -o c_code/3_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mllstream.nim.c -o c_code/3_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mlexer.nim.c -o c_code/3_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mrenderer.nim.c -o c_code/3_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msyntaxes.nim.c -o c_code/3_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mic@srodfiles.nim.c -o c_code/3_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mic@sic.nim.c -o c_code/3_6/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mlinter.nim.c -o c_code/3_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msigmatch.nim.c -o c_code/3_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mpragmas.nim.c -o c_code/3_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mndi.nim.c -o c_code/3_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvmdeps.nim.c -o c_code/3_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mgorgeimpl.nim.c -o c_code/3_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvmprofiler.nim.c -o c_code/3_6/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvm.nim.c -o c_code/3_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msem.nim.c -o c_code/3_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mcgen.nim.c -o c_code/3_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodules.nim.c -o c_code/3_6/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mscriptconfig.nim.c -o c_code/3_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mjsgen.nim.c -o c_code/3_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_rst.nim.c -o c_code/3_6/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_rstgen.nim.c -o c_code/3_6/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen.nim.c -o c_code/3_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmain.nim.c -o c_code/3_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_browsers.nim.c -o c_code/3_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnim.nim.c -o c_code/3_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/3_6/stdlib_io.nim.o \
c_code/3_6/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/3_6/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/3_6/stdlib_times.nim.o \
c_code/3_6/stdlib_os.nim.o \
c_code/3_6/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/3_6/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/3_6/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/3_6/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/3_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/3_6/@moptions.nim.o \
c_code/1_2/@mstrutils2.nim.o \
c_code/3_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/3_6/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/3_6/stdlib_osproc.nim.o \
c_code/3_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/3_6/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/3_6/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/3_6/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/3_6/@mcommands.nim.o \
c_code/3_6/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/3_6/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/3_6/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/3_6/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/3_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/3_6/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/3_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/3_6/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/3_6/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/3_2/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/3_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/3_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/3_6/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/3_6/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/3_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/3_6/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/3_6/@mmodules.nim.o \
c_code/3_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/3_6/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/3_6/stdlib_rst.nim.o \
c_code/3_6/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/3_6/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/3_6/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/3_2/stdlib_browsers.nim.o \
c_code/3_6/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_digitsutils.nim.c -o c_code/2_17/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_assertions.nim.c -o c_code/2_17/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dragonbox.nim.c -o c_code/2_17/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_schubfach.nim.c -o c_code/2_17/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_formatfloat.nim.c -o c_code/2_17/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dollars.nim.c -o c_code/2_17/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_io.nim.c -o c_code/3_17/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_system.nim.c -o c_code/3_17/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parseutils.nim.c -o c_code/2_17/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_math.nim.c -o c_code/2_17/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_unicode.nim.c -o c_code/2_17/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_strutils.nim.c -o c_code/3_17/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_pathnorm.nim.c -o c_code/2_17/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_posix.nim.c -o c_code/3_17/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_times.nim.c -o c_code/3_17/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_os.nim.c -o c_code/3_17/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_parseopt.nim.c -o c_code/3_17/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_hashes.nim.c -o c_code/2_17/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strtabs.nim.c -o c_code/2_17/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strformat.nim.c -o c_code/2_17/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_terminal.nim.c -o c_code/3_17/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpathutils.nim.c -o c_code/2_17/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mropes.nim.c -o c_code/3_17/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlineinfos.nim.c -o c_code/2_17/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mplatform.nim.c -o c_code/3_17/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprefixmatches.nim.c -o c_code/2_17/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnimpaths.nim.c -o c_code/3_17/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_globs.nim.c -o c_code/2_17/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@moptions.nim.c -o c_code/3_17/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mstrutils2.nim.c -o c_code/3_17/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmsgs.nim.c -o c_code/3_17/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcondsyms.nim.c -o c_code/2_17/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_streams.nim.c -o c_code/3_17/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_cpuinfo.nim.c -o c_code/3_17/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_osproc.nim.c -o c_code/3_17/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_sha1.nim.c -o c_code/3_17/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_lexbase.nim.c -o c_code/2_17/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parsejson.nim.c -o c_code/2_17/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_json.nim.c -o c_code/3_17/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_jsonutils.nim.c -o c_code/2_17/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mextccomp.nim.c -o c_code/3_17/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mwordrecg.nim.c -o c_code/2_17/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnimblecmd.nim.c -o c_code/3_17/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@midents.nim.c -o c_code/2_17/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mint128.nim.c -o c_code/2_17/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mast.nim.c -o c_code/2_17/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mcommands.nim.c -o c_code/3_17/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mllstream.nim.c -o c_code/3_17/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimlexbase.nim.c -o c_code/2_17/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mlexer.nim.c -o c_code/3_17/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparser.nim.c -o c_code/2_17/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mrenderer.nim.c -o c_code/3_17/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilters.nim.c -o c_code/2_17/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilter_tmpl.nim.c -o c_code/2_17/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msyntaxes.nim.c -o c_code/3_17/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_packedsets.nim.c -o c_code/2_17/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_intsets.nim.c -o c_code/2_17/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastalgo.nim.c -o c_code/2_17/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtrees.nim.c -o c_code/2_17/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_md5.nim.c -o c_code/2_17/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mic@srodfiles.nim.c -o c_code/3_17/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@spacked_ast.nim.c -o c_code/2_17/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mic@sic.nim.c -o c_code/3_17/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulegraphs.nim.c -o c_code/2_17/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastmsgs.nim.c -o c_code/2_17/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mtypes.nim.c -o c_code/3_17/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmagicsys.nim.c -o c_code/2_17/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mbitsets.nim.c -o c_code/2_17/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimsets.nim.c -o c_code/2_17/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msemfold.nim.c -o c_code/3_17/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmodulepaths.nim.c -o c_code/3_17/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmdef.nim.c -o c_code/2_17/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemdata.nim.c -o c_code/2_17/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mlinter.nim.c -o c_code/3_17/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimfix@sprettybase.nim.c -o c_code/2_17/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_editdistance.nim.c -o c_code/2_17/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlookups.nim.c -o c_code/2_17/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mconcepts.nim.c -o c_code/2_17/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemtypinst.nim.c -o c_code/2_17/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparampatterns.nim.c -o c_code/2_17/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlowerings.nim.c -o c_code/2_17/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msigmatch.nim.c -o c_code/3_17/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mimporter.nim.c -o c_code/2_17/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprocfind.nim.c -o c_code/2_17/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mpragmas.nim.c -o c_code/3_17/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mreorder.nim.c -o c_code/2_17/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpasses.nim.c -o c_code/2_17/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msaturate.nim.c -o c_code/2_17/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mguards.nim.c -o c_code/2_17/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypeallowed.nim.c -o c_code/2_17/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@misolation_check.nim.c -o c_code/2_17/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvarpartitions.nim.c -o c_code/2_17/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtreetab.nim.c -o c_code/2_17/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnilcheck.nim.c -o c_code/2_17/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@merrorhandling.nim.c -o c_code/2_17/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msighashes.nim.c -o c_code/2_17/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mndi.nim.c -o c_code/3_17/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgendata.nim.c -o c_code/2_17/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mccgutils.nim.c -o c_code/2_17/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftdestructors.nim.c -o c_code/2_17/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msempass2.nim.c -o c_code/2_17/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgmeth.nim.c -o c_code/2_17/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftlocals.nim.c -o c_code/2_17/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlambdalifting.nim.c -o c_code/2_17/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mclosureiters.nim.c -o c_code/2_17/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtransf.nim.c -o c_code/2_17/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmgen.nim.c -o c_code/2_17/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvmdeps.nim.c -o c_code/3_17/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmmarshal.nim.c -o c_code/2_17/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mgorgeimpl.nim.c -o c_code/3_17/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmacrocacheimpl.nim.c -o c_code/2_17/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvmprofiler.nim.c -o c_code/3_17/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mevaltempl.nim.c -o c_code/2_17/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvm.nim.c -o c_code/3_17/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliases.nim.c -o c_code/2_17/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpatterns.nim.c -o c_code/2_17/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemmacrosanity.nim.c -o c_code/2_17/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpluginsupport.nim.c -o c_code/2_17/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@slocals.nim.c -o c_code/2_17/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sitersgen.nim.c -o c_code/2_17/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sactive.nim.c -o c_code/2_17/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@menumtostr.nim.c -o c_code/2_17/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mspawn.nim.c -o c_code/2_17/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msem.nim.c -o c_code/3_17/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdfa.nim.c -o c_code/2_17/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptimizer.nim.c -o c_code/2_17/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@minjectdestructors.nim.c -o c_code/2_17/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemparallel.nim.c -o c_code/2_17/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dynlib.nim.c -o c_code/2_17/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mcgen.nim.c -o c_code/3_17/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sreplayer.nim.c -o c_code/2_17/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmodules.nim.c -o c_code/3_17/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mscriptconfig.nim.c -o c_code/3_17/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnimconf.nim.c -o c_code/3_17/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpassaux.nim.c -o c_code/2_17/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdepends.nim.c -o c_code/2_17/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sdce.nim.c -o c_code/2_17/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@scbackend.nim.c -o c_code/2_17/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sintegrity.nim.c -o c_code/2_17/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@snavigator.nim.c -o c_code/2_17/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msourcemap.nim.c -o c_code/2_17/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mjsgen.nim.c -o c_code/3_17/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_rstast.nim.c -o c_code/2_17/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_highlite.nim.c -o c_code/2_17/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_rst.nim.c -o c_code/3_17/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_rstgen.nim.c -o c_code/3_17/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_xmltree.nim.c -o c_code/2_17/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypesrenderer.nim.c -o c_code/2_17/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderverbatim.nim.c -o c_code/2_17/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_base64.nim.c -o c_code/2_17/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_uri.nim.c -o c_code/2_17/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mdocgen.nim.c -o c_code/3_17/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mdocgen2.nim.c -o c_code/3_17/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmain.nim.c -o c_code/3_17/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcmdlinehelper.nim.c -o c_code/2_17/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_browsers.nim.c -o c_code/3_17/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnim.nim.c -o c_code/3_17/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_17/stdlib_digitsutils.nim.o \
c_code/2_17/stdlib_assertions.nim.o \
c_code/2_17/stdlib_dragonbox.nim.o \
c_code/2_17/stdlib_schubfach.nim.o \
c_code/2_17/stdlib_formatfloat.nim.o \
c_code/2_17/stdlib_dollars.nim.o \
c_code/3_17/stdlib_io.nim.o \
c_code/3_17/stdlib_system.nim.o \
c_code/2_17/stdlib_parseutils.nim.o \
c_code/2_17/stdlib_math.nim.o \
c_code/2_17/stdlib_unicode.nim.o \
c_code/3_17/stdlib_strutils.nim.o \
c_code/2_17/stdlib_pathnorm.nim.o \
c_code/3_17/stdlib_posix.nim.o \
c_code/3_17/stdlib_times.nim.o \
c_code/3_17/stdlib_os.nim.o \
c_code/3_17/stdlib_parseopt.nim.o \
c_code/2_17/stdlib_hashes.nim.o \
c_code/2_17/stdlib_strtabs.nim.o \
c_code/2_17/stdlib_strformat.nim.o \
c_code/3_17/stdlib_terminal.nim.o \
c_code/2_17/@mpathutils.nim.o \
c_code/3_17/@mropes.nim.o \
c_code/2_17/@mlineinfos.nim.o \
c_code/3_17/@mplatform.nim.o \
c_code/2_17/@mprefixmatches.nim.o \
c_code/3_17/@mnimpaths.nim.o \
c_code/2_17/stdlib_globs.nim.o \
c_code/3_17/@moptions.nim.o \
c_code/3_17/@mstrutils2.nim.o \
c_code/3_17/@mmsgs.nim.o \
c_code/2_17/@mcondsyms.nim.o \
c_code/3_17/stdlib_streams.nim.o \
c_code/3_17/stdlib_cpuinfo.nim.o \
c_code/3_17/stdlib_osproc.nim.o \
c_code/3_17/stdlib_sha1.nim.o \
c_code/2_17/stdlib_lexbase.nim.o \
c_code/2_17/stdlib_parsejson.nim.o \
c_code/3_17/stdlib_json.nim.o \
c_code/2_17/stdlib_jsonutils.nim.o \
c_code/3_17/@mextccomp.nim.o \
c_code/2_17/@mwordrecg.nim.o \
c_code/3_17/@mnimblecmd.nim.o \
c_code/2_17/@midents.nim.o \
c_code/2_17/@mint128.nim.o \
c_code/2_17/@mast.nim.o \
c_code/3_17/@mcommands.nim.o \
c_code/3_17/@mllstream.nim.o \
c_code/2_17/@mnimlexbase.nim.o \
c_code/3_17/@mlexer.nim.o \
c_code/2_17/@mparser.nim.o \
c_code/3_17/@mrenderer.nim.o \
c_code/2_17/@mfilters.nim.o \
c_code/2_17/@mfilter_tmpl.nim.o \
c_code/3_17/@msyntaxes.nim.o \
c_code/2_17/stdlib_packedsets.nim.o \
c_code/2_17/stdlib_intsets.nim.o \
c_code/2_17/@mastalgo.nim.o \
c_code/2_17/@mtrees.nim.o \
c_code/2_17/stdlib_md5.nim.o \
c_code/3_17/@mic@srodfiles.nim.o \
c_code/2_17/@mic@spacked_ast.nim.o \
c_code/3_17/@mic@sic.nim.o \
c_code/2_17/@mmodulegraphs.nim.o \
c_code/2_17/@mastmsgs.nim.o \
c_code/3_17/@mtypes.nim.o \
c_code/2_17/@mmagicsys.nim.o \
c_code/2_17/@mbitsets.nim.o \
c_code/2_17/@mnimsets.nim.o \
c_code/3_17/@msemfold.nim.o \
c_code/3_17/@mmodulepaths.nim.o \
c_code/2_17/@mvmdef.nim.o \
c_code/2_17/@msemdata.nim.o \
c_code/3_17/@mlinter.nim.o \
c_code/2_17/@mnimfix@sprettybase.nim.o \
c_code/2_17/stdlib_editdistance.nim.o \
c_code/2_17/@mlookups.nim.o \
c_code/2_17/@mconcepts.nim.o \
c_code/2_17/@msemtypinst.nim.o \
c_code/2_17/@mparampatterns.nim.o \
c_code/2_17/@mlowerings.nim.o \
c_code/3_17/@msigmatch.nim.o \
c_code/2_17/@mimporter.nim.o \
c_code/2_17/@mprocfind.nim.o \
c_code/3_17/@mpragmas.nim.o \
c_code/2_17/@mreorder.nim.o \
c_code/2_17/@mpasses.nim.o \
c_code/2_17/@msaturate.nim.o \
c_code/2_17/@mguards.nim.o \
c_code/2_17/@mtypeallowed.nim.o \
c_code/2_17/@misolation_check.nim.o \
c_code/2_17/@mvarpartitions.nim.o \
c_code/2_17/@mtreetab.nim.o \
c_code/2_17/@mnilcheck.nim.o \
c_code/2_17/@merrorhandling.nim.o \
c_code/2_17/@msighashes.nim.o \
c_code/3_17/@mndi.nim.o \
c_code/2_17/@mcgendata.nim.o \
c_code/2_17/@mccgutils.nim.o \
c_code/2_17/@mliftdestructors.nim.o \
c_code/2_17/@msempass2.nim.o \
c_code/2_17/@mcgmeth.nim.o \
c_code/2_17/@mliftlocals.nim.o \
c_code/2_17/@mlambdalifting.nim.o \
c_code/2_17/@mclosureiters.nim.o \
c_code/2_17/@mtransf.nim.o \
c_code/2_17/@mvmgen.nim.o \
c_code/3_17/@mvmdeps.nim.o \
c_code/2_17/@mvmmarshal.nim.o \
c_code/3_17/@mgorgeimpl.nim.o \
c_code/2_17/@mmacrocacheimpl.nim.o \
c_code/3_17/@mvmprofiler.nim.o \
c_code/2_17/@mevaltempl.nim.o \
c_code/3_17/@mvm.nim.o \
c_code/2_17/@maliases.nim.o \
c_code/2_17/@mpatterns.nim.o \
c_code/2_17/@msemmacrosanity.nim.o \
c_code/2_17/@mpluginsupport.nim.o \
c_code/2_17/@mplugins@slocals.nim.o \
c_code/2_17/@mplugins@sitersgen.nim.o \
c_code/2_17/@mplugins@sactive.nim.o \
c_code/2_17/@menumtostr.nim.o \
c_code/2_17/@mspawn.nim.o \
c_code/3_17/@msem.nim.o \
c_code/2_17/@mdfa.nim.o \
c_code/2_17/@moptimizer.nim.o \
c_code/2_17/@minjectdestructors.nim.o \
c_code/2_17/@msemparallel.nim.o \
c_code/2_17/stdlib_dynlib.nim.o \
c_code/3_17/@mcgen.nim.o \
c_code/2_17/@mic@sreplayer.nim.o \
c_code/3_17/@mmodules.nim.o \
c_code/3_17/@mscriptconfig.nim.o \
c_code/3_17/@mnimconf.nim.o \
c_code/2_17/@mpassaux.nim.o \
c_code/2_17/@mdepends.nim.o \
c_code/2_17/@mic@sdce.nim.o \
c_code/2_17/@mic@scbackend.nim.o \
c_code/2_17/@mic@sintegrity.nim.o \
c_code/2_17/@mic@snavigator.nim.o \
c_code/2_17/@msourcemap.nim.o \
c_code/3_17/@mjsgen.nim.o \
c_code/2_17/stdlib_rstast.nim.o \
c_code/2_17/stdlib_highlite.nim.o \
c_code/3_17/stdlib_rst.nim.o \
c_code/3_17/stdlib_rstgen.nim.o \
c_code/2_17/stdlib_xmltree.nim.o \
c_code/2_17/@mtypesrenderer.nim.o \
c_code/2_17/@mrenderverbatim.nim.o \
c_code/2_17/stdlib_base64.nim.o \
c_code/2_17/stdlib_uri.nim.o \
c_code/3_17/@mdocgen.nim.o \
c_code/3_17/@mdocgen2.nim.o \
c_code/3_17/@mmain.nim.o \
c_code/2_17/@mcmdlinehelper.nim.o \
c_code/3_17/stdlib_browsers.nim.o \
c_code/3_17/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
solaris)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_assertions.nim.c -o c_code/2_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_io.nim.c -o c_code/4_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_system.nim.c -o c_code/4_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseutils.nim.c -o c_code/2_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strutils.nim.c -o c_code/2_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_pathnorm.nim.c -o c_code/2_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_posix.nim.c -o c_code/4_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_times.nim.c -o c_code/4_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_os.nim.c -o c_code/4_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_parseopt.nim.c -o c_code/4_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strtabs.nim.c -o c_code/2_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strformat.nim.c -o c_code/2_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_terminal.nim.c -o c_code/3_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mropes.nim.c -o c_code/3_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplatform.nim.c -o c_code/4_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@moptions.nim.c -o c_code/4_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmsgs.nim.c -o c_code/4_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_streams.nim.c -o c_code/3_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_osproc.nim.c -o c_code/4_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_sha1.nim.c -o c_code/3_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parsejson.nim.c -o c_code/2_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_json.nim.c -o c_code/3_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_jsonutils.nim.c -o c_code/2_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mextccomp.nim.c -o c_code/4_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimblecmd.nim.c -o c_code/4_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcommands.nim.c -o c_code/4_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mllstream.nim.c -o c_code/4_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlexer.nim.c -o c_code/4_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mrenderer.nim.c -o c_code/3_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msyntaxes.nim.c -o c_code/3_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_intsets.nim.c -o c_code/2_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtrees.nim.c -o c_code/2_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@srodfiles.nim.c -o c_code/3_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@sic.nim.c -o c_code/3_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mtypes.nim.c -o c_code/3_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msemfold.nim.c -o c_code/3_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodulepaths.nim.c -o c_code/3_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimfix@sprettybase.nim.c -o c_code/2_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msigmatch.nim.c -o c_code/4_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpragmas.nim.c -o c_code/4_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpasses.nim.c -o c_code/2_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtreetab.nim.c -o c_code/2_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mndi.nim.c -o c_code/3_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmdeps.nim.c -o c_code/3_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mgorgeimpl.nim.c -o c_code/3_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmacrocacheimpl.nim.c -o c_code/2_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvm.nim.c -o c_code/4_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@slocals.nim.c -o c_code/2_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@menumtostr.nim.c -o c_code/2_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msem.nim.c -o c_code/3_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_dynlib.nim.c -o c_code/2_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgen.nim.c -o c_code/4_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mscriptconfig.nim.c -o c_code/4_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimconf.nim.c -o c_code/2_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpassaux.nim.c -o c_code/2_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mjsgen.nim.c -o c_code/3_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstast.nim.c -o c_code/2_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_rst.nim.c -o c_code/4_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_rstgen.nim.c -o c_code/4_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdocgen.nim.c -o c_code/4_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen2.nim.c -o c_code/3_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmain.nim.c -o c_code/4_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_browsers.nim.c -o c_code/4_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnim.nim.c -o c_code/4_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/4_1/stdlib_io.nim.o \
c_code/4_1/stdlib_system.nim.o \
c_code/2_1/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_1/stdlib_strutils.nim.o \
c_code/2_1/stdlib_pathnorm.nim.o \
c_code/4_1/stdlib_posix.nim.o \
c_code/4_1/stdlib_times.nim.o \
c_code/4_1/stdlib_os.nim.o \
c_code/4_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_1/stdlib_strtabs.nim.o \
c_code/2_1/stdlib_strformat.nim.o \
c_code/3_1/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/3_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/4_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/4_1/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/4_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/3_1/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/4_1/stdlib_osproc.nim.o \
c_code/3_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_1/stdlib_parsejson.nim.o \
c_code/3_1/stdlib_json.nim.o \
c_code/2_1/stdlib_jsonutils.nim.o \
c_code/4_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/4_1/@mnimblecmd.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_1/@mast.nim.o \
c_code/4_1/@mcommands.nim.o \
c_code/4_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/4_1/@mlexer.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/3_1/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/3_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_1/stdlib_intsets.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/2_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/3_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/3_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/3_1/@mtypes.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/3_1/@msemfold.nim.o \
c_code/3_1/@mmodulepaths.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/4_1/@msigmatch.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/4_1/@mpragmas.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mtreetab.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/3_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/3_1/@mvmdeps.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/3_1/@mgorgeimpl.nim.o \
c_code/2_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/4_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_1/@menumtostr.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/3_1/@msem.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/stdlib_dynlib.nim.o \
c_code/4_1/@mcgen.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/4_1/@mscriptconfig.nim.o \
c_code/2_1/@mnimconf.nim.o \
c_code/2_1/@mpassaux.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/3_1/@mjsgen.nim.o \
c_code/2_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/4_1/stdlib_rst.nim.o \
c_code/4_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/4_1/@mdocgen.nim.o \
c_code/3_1/@mdocgen2.nim.o \
c_code/4_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/4_1/stdlib_browsers.nim.o \
c_code/4_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_assertions.nim.c -o c_code/2_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_io.nim.c -o c_code/4_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_system.nim.c -o c_code/4_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseutils.nim.c -o c_code/2_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strutils.nim.c -o c_code/2_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_pathnorm.nim.c -o c_code/2_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_posix.nim.c -o c_code/4_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_times.nim.c -o c_code/4_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_os.nim.c -o c_code/4_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_parseopt.nim.c -o c_code/4_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strtabs.nim.c -o c_code/2_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strformat.nim.c -o c_code/2_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_terminal.nim.c -o c_code/3_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mropes.nim.c -o c_code/3_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplatform.nim.c -o c_code/4_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptions.nim.c -o c_code/4_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmsgs.nim.c -o c_code/4_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_streams.nim.c -o c_code/3_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_osproc.nim.c -o c_code/4_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_sha1.nim.c -o c_code/3_2/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parsejson.nim.c -o c_code/2_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_json.nim.c -o c_code/3_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_jsonutils.nim.c -o c_code/2_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mextccomp.nim.c -o c_code/4_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimblecmd.nim.c -o c_code/4_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcommands.nim.c -o c_code/4_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mllstream.nim.c -o c_code/4_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlexer.nim.c -o c_code/4_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mrenderer.nim.c -o c_code/3_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msyntaxes.nim.c -o c_code/3_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_intsets.nim.c -o c_code/2_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtrees.nim.c -o c_code/2_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@srodfiles.nim.c -o c_code/3_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@sic.nim.c -o c_code/3_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mtypes.nim.c -o c_code/3_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msemfold.nim.c -o c_code/3_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodulepaths.nim.c -o c_code/3_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimfix@sprettybase.nim.c -o c_code/2_2/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msigmatch.nim.c -o c_code/4_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpragmas.nim.c -o c_code/4_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpasses.nim.c -o c_code/2_2/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtreetab.nim.c -o c_code/2_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mndi.nim.c -o c_code/3_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdeps.nim.c -o c_code/3_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mgorgeimpl.nim.c -o c_code/3_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmacrocacheimpl.nim.c -o c_code/2_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvm.nim.c -o c_code/4_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@slocals.nim.c -o c_code/2_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@menumtostr.nim.c -o c_code/2_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msem.nim.c -o c_code/3_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_dynlib.nim.c -o c_code/2_2/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgen.nim.c -o c_code/4_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mscriptconfig.nim.c -o c_code/4_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimconf.nim.c -o c_code/2_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpassaux.nim.c -o c_code/2_2/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mjsgen.nim.c -o c_code/3_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rstast.nim.c -o c_code/2_2/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_rst.nim.c -o c_code/4_2/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_rstgen.nim.c -o c_code/4_2/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdocgen.nim.c -o c_code/4_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen2.nim.c -o c_code/3_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmain.nim.c -o c_code/4_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_browsers.nim.c -o c_code/4_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnim.nim.c -o c_code/4_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_2/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/4_2/stdlib_io.nim.o \
c_code/4_2/stdlib_system.nim.o \
c_code/2_2/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_2/stdlib_strutils.nim.o \
c_code/2_2/stdlib_pathnorm.nim.o \
c_code/4_2/stdlib_posix.nim.o \
c_code/4_2/stdlib_times.nim.o \
c_code/4_2/stdlib_os.nim.o \
c_code/4_2/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_2/stdlib_strtabs.nim.o \
c_code/2_2/stdlib_strformat.nim.o \
c_code/3_2/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/3_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/4_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/4_2/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/4_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/3_2/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/4_2/stdlib_osproc.nim.o \
c_code/3_2/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_2/stdlib_parsejson.nim.o \
c_code/3_2/stdlib_json.nim.o \
c_code/2_2/stdlib_jsonutils.nim.o \
c_code/4_2/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/4_2/@mnimblecmd.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_2/@mast.nim.o \
c_code/4_2/@mcommands.nim.o \
c_code/4_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_2/@mlexer.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/3_2/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/3_2/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_2/stdlib_intsets.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/2_2/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/3_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/3_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_2/@mtypes.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/3_2/@msemfold.nim.o \
c_code/3_2/@mmodulepaths.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/4_2/@msigmatch.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/4_2/@mpragmas.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mtreetab.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/3_2/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/3_2/@mvmdeps.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/3_2/@mgorgeimpl.nim.o \
c_code/2_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/4_2/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_2/@menumtostr.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/3_2/@msem.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/stdlib_dynlib.nim.o \
c_code/4_2/@mcgen.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/4_2/@mscriptconfig.nim.o \
c_code/2_2/@mnimconf.nim.o \
c_code/2_2/@mpassaux.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/3_2/@mjsgen.nim.o \
c_code/2_2/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/4_2/stdlib_rst.nim.o \
c_code/4_2/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/4_2/@mdocgen.nim.o \
c_code/3_2/@mdocgen2.nim.o \
c_code/4_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/4_2/stdlib_browsers.nim.o \
c_code/4_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_io.nim.c -o c_code/4_8/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_system.nim.c -o c_code/4_8/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_parseutils.nim.c -o c_code/2_8/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_strutils.nim.c -o c_code/2_8/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_pathnorm.nim.c -o c_code/2_8/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_posix.nim.c -o c_code/4_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_times.nim.c -o c_code/4_8/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_os.nim.c -o c_code/4_8/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_parseopt.nim.c -o c_code/4_8/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_hashes.nim.c -o c_code/2_8/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_strtabs.nim.c -o c_code/2_8/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_terminal.nim.c -o c_code/4_8/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mropes.nim.c -o c_code/4_8/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mlineinfos.nim.c -o c_code/2_8/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mplatform.nim.c -o c_code/4_8/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@moptions.nim.c -o c_code/4_8/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmsgs.nim.c -o c_code/4_8/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_streams.nim.c -o c_code/4_8/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_cpuinfo.nim.c -o c_code/2_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_osproc.nim.c -o c_code/4_8/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_sha1.nim.c -o c_code/4_8/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_json.nim.c -o c_code/4_8/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mextccomp.nim.c -o c_code/4_8/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnimblecmd.nim.c -o c_code/4_8/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@midents.nim.c -o c_code/2_8/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcommands.nim.c -o c_code/4_8/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mllstream.nim.c -o c_code/4_8/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlexer.nim.c -o c_code/4_8/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mparser.nim.c -o c_code/2_8/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mrenderer.nim.c -o c_code/4_8/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mfilter_tmpl.nim.c -o c_code/2_8/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msyntaxes.nim.c -o c_code/4_8/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@srodfiles.nim.c -o c_code/4_8/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@sic.nim.c -o c_code/4_8/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtypes.nim.c -o c_code/4_8/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemfold.nim.c -o c_code/4_8/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmodulepaths.nim.c -o c_code/4_8/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mnimfix@sprettybase.nim.c -o c_code/2_8/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mlookups.nim.c -o c_code/2_8/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msigmatch.nim.c -o c_code/4_8/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mpragmas.nim.c -o c_code/4_8/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mreorder.nim.c -o c_code/2_8/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mtreetab.nim.c -o c_code/2_8/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mndi.nim.c -o c_code/3_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvmdeps.nim.c -o c_code/4_8/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mgorgeimpl.nim.c -o c_code/4_8/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvm.nim.c -o c_code/4_8/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msem.nim.c -o c_code/4_8/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/stdlib_dynlib.nim.c -o c_code/2_8/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcgen.nim.c -o c_code/4_8/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodules.nim.c -o c_code/2_3/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mscriptconfig.nim.c -o c_code/4_8/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mnimconf.nim.c -o c_code/2_8/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mic@sdce.nim.c -o c_code/2_8/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mic@snavigator.nim.c -o c_code/2_8/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@msourcemap.nim.c -o c_code/2_8/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mjsgen.nim.c -o c_code/4_8/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_rst.nim.c -o c_code/4_8/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_rstgen.nim.c -o c_code/4_8/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mtypesrenderer.nim.c -o c_code/2_8/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen.nim.c -o c_code/4_8/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen2.nim.c -o c_code/4_8/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmain.nim.c -o c_code/4_8/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/stdlib_browsers.nim.c -o c_code/4_8/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnim.nim.c -o c_code/4_8/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/4_8/stdlib_io.nim.o \
c_code/4_8/stdlib_system.nim.o \
c_code/2_8/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_8/stdlib_strutils.nim.o \
c_code/2_8/stdlib_pathnorm.nim.o \
c_code/4_1/stdlib_posix.nim.o \
c_code/4_8/stdlib_times.nim.o \
c_code/4_8/stdlib_os.nim.o \
c_code/4_8/stdlib_parseopt.nim.o \
c_code/2_8/stdlib_hashes.nim.o \
c_code/2_8/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/4_8/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/4_8/@mropes.nim.o \
c_code/2_8/@mlineinfos.nim.o \
c_code/4_8/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/4_8/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/4_8/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/4_8/stdlib_streams.nim.o \
c_code/2_1/stdlib_cpuinfo.nim.o \
c_code/4_8/stdlib_osproc.nim.o \
c_code/4_8/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/4_8/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/4_8/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/4_8/@mnimblecmd.nim.o \
c_code/2_8/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/4_8/@mcommands.nim.o \
c_code/4_8/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/4_8/@mlexer.nim.o \
c_code/2_8/@mparser.nim.o \
c_code/4_8/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_8/@mfilter_tmpl.nim.o \
c_code/4_8/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/4_8/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/4_8/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/4_8/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/4_8/@msemfold.nim.o \
c_code/4_8/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_8/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_8/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/4_8/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/4_8/@mpragmas.nim.o \
c_code/2_8/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_8/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/3_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/4_8/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/4_8/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/4_8/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/4_8/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_8/stdlib_dynlib.nim.o \
c_code/4_8/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/2_3/@mmodules.nim.o \
c_code/4_8/@mscriptconfig.nim.o \
c_code/2_8/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_8/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_8/@mic@snavigator.nim.o \
c_code/2_8/@msourcemap.nim.o \
c_code/4_8/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/4_8/stdlib_rst.nim.o \
c_code/4_8/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_8/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/4_8/@mdocgen.nim.o \
c_code/4_8/@mdocgen2.nim.o \
c_code/4_8/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/4_8/stdlib_browsers.nim.o \
c_code/4_8/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_io.nim.c -o c_code/4_9/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_system.nim.c -o c_code/4_9/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_posix.nim.c -o c_code/4_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_times.nim.c -o c_code/4_9/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_os.nim.c -o c_code/4_9/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_parseopt.nim.c -o c_code/4_9/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_hashes.nim.c -o c_code/2_9/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_strtabs.nim.c -o c_code/2_9/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_terminal.nim.c -o c_code/3_6/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mropes.nim.c -o c_code/4_9/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mlineinfos.nim.c -o c_code/2_9/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mplatform.nim.c -o c_code/4_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@moptions.nim.c -o c_code/4_9/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mmsgs.nim.c -o c_code/4_9/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_streams.nim.c -o c_code/3_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_cpuinfo.nim.c -o c_code/2_4/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_osproc.nim.c -o c_code/4_9/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_sha1.nim.c -o c_code/3_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_json.nim.c -o c_code/4_9/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mextccomp.nim.c -o c_code/4_9/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnimblecmd.nim.c -o c_code/4_9/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@midents.nim.c -o c_code/2_9/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mcommands.nim.c -o c_code/4_9/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mllstream.nim.c -o c_code/4_9/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mrenderer.nim.c -o c_code/3_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msyntaxes.nim.c -o c_code/3_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mic@srodfiles.nim.c -o c_code/3_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mic@sic.nim.c -o c_code/4_9/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mpragmas.nim.c -o c_code/4_9/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mtreetab.nim.c -o c_code/2_9/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mndi.nim.c -o c_code/3_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvmdeps.nim.c -o c_code/3_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mgorgeimpl.nim.c -o c_code/3_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mvm.nim.c -o c_code/4_9/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msem.nim.c -o c_code/3_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mcgen.nim.c -o c_code/4_9/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodules.nim.c -o c_code/2_4/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mscriptconfig.nim.c -o c_code/4_9/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@sdce.nim.c -o c_code/2_9/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@snavigator.nim.c -o c_code/2_9/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mjsgen.nim.c -o c_code/3_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_rst.nim.c -o c_code/4_9/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_rstgen.nim.c -o c_code/4_9/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mdocgen.nim.c -o c_code/4_9/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mmain.nim.c -o c_code/4_9/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_browsers.nim.c -o c_code/4_9/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnim.nim.c -o c_code/4_9/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/4_9/stdlib_io.nim.o \
c_code/4_9/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/4_2/stdlib_posix.nim.o \
c_code/4_9/stdlib_times.nim.o \
c_code/4_9/stdlib_os.nim.o \
c_code/4_9/stdlib_parseopt.nim.o \
c_code/2_9/stdlib_hashes.nim.o \
c_code/2_9/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/3_6/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/4_9/@mropes.nim.o \
c_code/2_9/@mlineinfos.nim.o \
c_code/4_9/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/4_9/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/4_9/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/3_6/stdlib_streams.nim.o \
c_code/2_4/stdlib_cpuinfo.nim.o \
c_code/4_9/stdlib_osproc.nim.o \
c_code/3_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/4_9/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/4_9/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/4_9/@mnimblecmd.nim.o \
c_code/2_9/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/4_9/@mcommands.nim.o \
c_code/4_9/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/3_6/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/3_6/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/3_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/4_9/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/4_9/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_9/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/3_2/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/3_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/3_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/4_9/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/3_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/4_9/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/2_4/@mmodules.nim.o \
c_code/4_9/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_9/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_9/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/3_6/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/4_9/stdlib_rst.nim.o \
c_code/4_9/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/4_9/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/4_9/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/4_9/stdlib_browsers.nim.o \
c_code/4_9/@mnim.nim.o $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
freebsd)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_assertions.nim.c -o c_code/2_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_io.nim.c -o c_code/5_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_system.nim.c -o c_code/5_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseutils.nim.c -o c_code/2_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strutils.nim.c -o c_code/2_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_pathnorm.nim.c -o c_code/2_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_posix.nim.c -o c_code/3_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_times.nim.c -o c_code/2_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_os.nim.c -o c_code/5_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_parseopt.nim.c -o c_code/5_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strtabs.nim.c -o c_code/2_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strformat.nim.c -o c_code/2_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_terminal.nim.c -o c_code/2_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplatform.nim.c -o c_code/5_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@moptions.nim.c -o c_code/5_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmsgs.nim.c -o c_code/5_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_streams.nim.c -o c_code/5_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_cpuinfo.nim.c -o c_code/3_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_osproc.nim.c -o c_code/5_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parsejson.nim.c -o c_code/2_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_json.nim.c -o c_code/3_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_jsonutils.nim.c -o c_code/2_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mextccomp.nim.c -o c_code/5_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimblecmd.nim.c -o c_code/5_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcommands.nim.c -o c_code/5_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mllstream.nim.c -o c_code/5_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlexer.nim.c -o c_code/4_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderer.nim.c -o c_code/2_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msyntaxes.nim.c -o c_code/2_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_intsets.nim.c -o c_code/2_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtrees.nim.c -o c_code/2_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mtypes.nim.c -o c_code/3_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msemfold.nim.c -o c_code/3_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodulepaths.nim.c -o c_code/3_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimfix@sprettybase.nim.c -o c_code/2_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msigmatch.nim.c -o c_code/4_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpragmas.nim.c -o c_code/5_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpasses.nim.c -o c_code/2_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtreetab.nim.c -o c_code/2_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mgorgeimpl.nim.c -o c_code/5_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmacrocacheimpl.nim.c -o c_code/2_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvm.nim.c -o c_code/5_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@slocals.nim.c -o c_code/2_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@menumtostr.nim.c -o c_code/2_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msem.nim.c -o c_code/5_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_dynlib.nim.c -o c_code/2_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgen.nim.c -o c_code/4_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodules.nim.c -o c_code/3_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mscriptconfig.nim.c -o c_code/5_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimconf.nim.c -o c_code/3_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpassaux.nim.c -o c_code/2_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mjsgen.nim.c -o c_code/2_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstast.nim.c -o c_code/2_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_rst.nim.c -o c_code/5_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_rstgen.nim.c -o c_code/5_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdocgen.nim.c -o c_code/5_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen2.nim.c -o c_code/3_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmain.nim.c -o c_code/2_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_browsers.nim.c -o c_code/4_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnim.nim.c -o c_code/5_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/5_1/stdlib_io.nim.o \
c_code/5_1/stdlib_system.nim.o \
c_code/2_1/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_1/stdlib_strutils.nim.o \
c_code/2_1/stdlib_pathnorm.nim.o \
c_code/3_1/stdlib_posix.nim.o \
c_code/2_1/stdlib_times.nim.o \
c_code/5_1/stdlib_os.nim.o \
c_code/5_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_1/stdlib_strtabs.nim.o \
c_code/2_1/stdlib_strformat.nim.o \
c_code/2_1/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/5_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/5_1/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/5_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/5_1/stdlib_streams.nim.o \
c_code/3_1/stdlib_cpuinfo.nim.o \
c_code/5_1/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_1/stdlib_parsejson.nim.o \
c_code/3_1/stdlib_json.nim.o \
c_code/2_1/stdlib_jsonutils.nim.o \
c_code/5_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/5_1/@mnimblecmd.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_1/@mast.nim.o \
c_code/5_1/@mcommands.nim.o \
c_code/5_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/4_1/@mlexer.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/2_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_1/stdlib_intsets.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/2_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/3_1/@mtypes.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/3_1/@msemfold.nim.o \
c_code/3_1/@mmodulepaths.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/4_1/@msigmatch.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/5_1/@mpragmas.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mtreetab.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/5_1/@mgorgeimpl.nim.o \
c_code/2_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/5_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_1/@menumtostr.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/5_1/@msem.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/stdlib_dynlib.nim.o \
c_code/4_1/@mcgen.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/3_1/@mmodules.nim.o \
c_code/5_1/@mscriptconfig.nim.o \
c_code/3_1/@mnimconf.nim.o \
c_code/2_1/@mpassaux.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/2_1/@mjsgen.nim.o \
c_code/2_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/5_1/stdlib_rst.nim.o \
c_code/5_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/5_1/@mdocgen.nim.o \
c_code/3_1/@mdocgen2.nim.o \
c_code/2_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/4_1/stdlib_browsers.nim.o \
c_code/5_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_assertions.nim.c -o c_code/2_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_io.nim.c -o c_code/5_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_system.nim.c -o c_code/5_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseutils.nim.c -o c_code/2_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strutils.nim.c -o c_code/2_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_pathnorm.nim.c -o c_code/2_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_times.nim.c -o c_code/5_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_os.nim.c -o c_code/5_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_parseopt.nim.c -o c_code/5_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strtabs.nim.c -o c_code/2_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strformat.nim.c -o c_code/2_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_terminal.nim.c -o c_code/2_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplatform.nim.c -o c_code/5_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptions.nim.c -o c_code/5_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmsgs.nim.c -o c_code/5_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_streams.nim.c -o c_code/5_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_osproc.nim.c -o c_code/5_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parsejson.nim.c -o c_code/2_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_json.nim.c -o c_code/3_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_jsonutils.nim.c -o c_code/2_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mextccomp.nim.c -o c_code/5_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimblecmd.nim.c -o c_code/5_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcommands.nim.c -o c_code/5_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mllstream.nim.c -o c_code/5_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlexer.nim.c -o c_code/4_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderer.nim.c -o c_code/5_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msyntaxes.nim.c -o c_code/5_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_intsets.nim.c -o c_code/2_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtrees.nim.c -o c_code/2_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sic.nim.c -o c_code/5_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mtypes.nim.c -o c_code/3_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msemfold.nim.c -o c_code/3_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodulepaths.nim.c -o c_code/3_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimfix@sprettybase.nim.c -o c_code/2_2/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msigmatch.nim.c -o c_code/4_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpragmas.nim.c -o c_code/5_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpasses.nim.c -o c_code/2_2/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtreetab.nim.c -o c_code/2_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mgorgeimpl.nim.c -o c_code/5_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmacrocacheimpl.nim.c -o c_code/2_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvm.nim.c -o c_code/5_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@slocals.nim.c -o c_code/2_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@menumtostr.nim.c -o c_code/2_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msem.nim.c -o c_code/5_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_dynlib.nim.c -o c_code/2_2/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgen.nim.c -o c_code/4_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodules.nim.c -o c_code/3_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mscriptconfig.nim.c -o c_code/5_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimconf.nim.c -o c_code/3_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpassaux.nim.c -o c_code/2_2/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mjsgen.nim.c -o c_code/5_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rstast.nim.c -o c_code/2_2/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_rst.nim.c -o c_code/5_2/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_rstgen.nim.c -o c_code/5_2/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen.nim.c -o c_code/5_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen2.nim.c -o c_code/3_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmain.nim.c -o c_code/5_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_browsers.nim.c -o c_code/4_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnim.nim.c -o c_code/5_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_2/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/5_2/stdlib_io.nim.o \
c_code/5_2/stdlib_system.nim.o \
c_code/2_2/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_2/stdlib_strutils.nim.o \
c_code/2_2/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/5_2/stdlib_times.nim.o \
c_code/5_2/stdlib_os.nim.o \
c_code/5_2/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_2/stdlib_strtabs.nim.o \
c_code/2_2/stdlib_strformat.nim.o \
c_code/2_2/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/5_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/5_2/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/5_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_2/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/5_2/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_2/stdlib_parsejson.nim.o \
c_code/3_2/stdlib_json.nim.o \
c_code/2_2/stdlib_jsonutils.nim.o \
c_code/5_2/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/5_2/@mnimblecmd.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_2/@mast.nim.o \
c_code/5_2/@mcommands.nim.o \
c_code/5_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_2/@mlexer.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/5_2/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/5_2/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_2/stdlib_intsets.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/2_2/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/5_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_2/@mtypes.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/3_2/@msemfold.nim.o \
c_code/3_2/@mmodulepaths.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/4_2/@msigmatch.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/5_2/@mpragmas.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mtreetab.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/5_2/@mgorgeimpl.nim.o \
c_code/2_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/5_2/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_2/@menumtostr.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/5_2/@msem.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/stdlib_dynlib.nim.o \
c_code/4_2/@mcgen.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/3_2/@mmodules.nim.o \
c_code/5_2/@mscriptconfig.nim.o \
c_code/3_2/@mnimconf.nim.o \
c_code/2_2/@mpassaux.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/5_2/@mjsgen.nim.o \
c_code/2_2/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/5_2/stdlib_rst.nim.o \
c_code/5_2/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/5_2/@mdocgen.nim.o \
c_code/3_2/@mdocgen2.nim.o \
c_code/5_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/4_2/stdlib_browsers.nim.o \
c_code/5_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_io.nim.c -o c_code/5_6/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_system.nim.c -o c_code/5_6/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_os.nim.c -o c_code/5_6/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_parseopt.nim.c -o c_code/5_6/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mplatform.nim.c -o c_code/5_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_streams.nim.c -o c_code/5_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_osproc.nim.c -o c_code/5_6/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/stdlib_sha1.nim.c -o c_code/2_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_json.nim.c -o c_code/3_6/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdeps.nim.c -o c_code/5_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodules.nim.c -o c_code/3_6/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rst.nim.c -o c_code/5_6/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rstgen.nim.c -o c_code/5_6/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_browsers.nim.c -o c_code/4_9/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/5_6/stdlib_io.nim.o \
c_code/5_6/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/5_6/stdlib_os.nim.o \
c_code/5_6/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/5_6/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_6/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/5_6/stdlib_osproc.nim.o \
c_code/2_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/3_6/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/5_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/5_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/3_6/@mmodules.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/5_6/stdlib_rst.nim.o \
c_code/5_6/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/4_9/stdlib_browsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_digitsutils.nim.c -o c_code/2_7/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_assertions.nim.c -o c_code/2_7/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dragonbox.nim.c -o c_code/2_7/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_schubfach.nim.c -o c_code/2_7/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_formatfloat.nim.c -o c_code/2_7/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dollars.nim.c -o c_code/2_7/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_io.nim.c -o c_code/5_7/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_system.nim.c -o c_code/5_7/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parseutils.nim.c -o c_code/2_7/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_math.nim.c -o c_code/2_7/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_unicode.nim.c -o c_code/2_7/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strutils.nim.c -o c_code/2_7/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_pathnorm.nim.c -o c_code/2_7/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_posix.nim.c -o c_code/5_7/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_times.nim.c -o c_code/2_7/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_os.nim.c -o c_code/5_7/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_parseopt.nim.c -o c_code/5_7/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_hashes.nim.c -o c_code/2_7/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strtabs.nim.c -o c_code/2_7/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strformat.nim.c -o c_code/2_7/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_terminal.nim.c -o c_code/2_7/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpathutils.nim.c -o c_code/2_7/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mropes.nim.c -o c_code/2_7/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlineinfos.nim.c -o c_code/2_7/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplatform.nim.c -o c_code/5_7/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprefixmatches.nim.c -o c_code/2_7/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimpaths.nim.c -o c_code/2_7/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_globs.nim.c -o c_code/2_7/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@moptions.nim.c -o c_code/5_7/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mstrutils2.nim.c -o c_code/2_7/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmsgs.nim.c -o c_code/5_7/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcondsyms.nim.c -o c_code/2_7/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_streams.nim.c -o c_code/5_7/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_cpuinfo.nim.c -o c_code/5_7/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_osproc.nim.c -o c_code/5_7/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_sha1.nim.c -o c_code/2_7/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_lexbase.nim.c -o c_code/2_7/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parsejson.nim.c -o c_code/2_7/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_json.nim.c -o c_code/5_7/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_jsonutils.nim.c -o c_code/2_7/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mextccomp.nim.c -o c_code/5_7/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mwordrecg.nim.c -o c_code/2_7/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimblecmd.nim.c -o c_code/5_7/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@midents.nim.c -o c_code/2_7/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mint128.nim.c -o c_code/2_7/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mast.nim.c -o c_code/2_7/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcommands.nim.c -o c_code/5_7/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mllstream.nim.c -o c_code/5_7/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimlexbase.nim.c -o c_code/2_7/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlexer.nim.c -o c_code/5_7/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparser.nim.c -o c_code/2_7/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderer.nim.c -o c_code/2_7/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilters.nim.c -o c_code/2_7/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilter_tmpl.nim.c -o c_code/2_7/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msyntaxes.nim.c -o c_code/2_7/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_packedsets.nim.c -o c_code/2_7/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_intsets.nim.c -o c_code/2_7/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastalgo.nim.c -o c_code/2_7/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtrees.nim.c -o c_code/2_7/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_md5.nim.c -o c_code/2_7/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@srodfiles.nim.c -o c_code/2_7/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@spacked_ast.nim.c -o c_code/2_7/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sic.nim.c -o c_code/2_7/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulegraphs.nim.c -o c_code/2_7/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastmsgs.nim.c -o c_code/2_7/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypes.nim.c -o c_code/5_7/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmagicsys.nim.c -o c_code/2_7/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbitsets.nim.c -o c_code/2_7/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimsets.nim.c -o c_code/2_7/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemfold.nim.c -o c_code/5_7/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodulepaths.nim.c -o c_code/5_7/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdef.nim.c -o c_code/2_7/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemdata.nim.c -o c_code/2_7/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlinter.nim.c -o c_code/2_7/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimfix@sprettybase.nim.c -o c_code/2_7/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_editdistance.nim.c -o c_code/2_7/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlookups.nim.c -o c_code/2_7/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mconcepts.nim.c -o c_code/2_7/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemtypinst.nim.c -o c_code/2_7/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparampatterns.nim.c -o c_code/2_7/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlowerings.nim.c -o c_code/2_7/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msigmatch.nim.c -o c_code/5_7/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mimporter.nim.c -o c_code/2_7/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprocfind.nim.c -o c_code/2_7/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpragmas.nim.c -o c_code/5_7/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mreorder.nim.c -o c_code/2_7/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpasses.nim.c -o c_code/2_7/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msaturate.nim.c -o c_code/2_7/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mguards.nim.c -o c_code/2_7/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypeallowed.nim.c -o c_code/2_7/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@misolation_check.nim.c -o c_code/2_7/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvarpartitions.nim.c -o c_code/2_7/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtreetab.nim.c -o c_code/2_7/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnilcheck.nim.c -o c_code/2_7/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@merrorhandling.nim.c -o c_code/2_7/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msighashes.nim.c -o c_code/2_7/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mndi.nim.c -o c_code/2_7/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgendata.nim.c -o c_code/2_7/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mccgutils.nim.c -o c_code/2_7/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftdestructors.nim.c -o c_code/2_7/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msempass2.nim.c -o c_code/2_7/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgmeth.nim.c -o c_code/2_7/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftlocals.nim.c -o c_code/2_7/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlambdalifting.nim.c -o c_code/2_7/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mclosureiters.nim.c -o c_code/2_7/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtransf.nim.c -o c_code/2_7/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmgen.nim.c -o c_code/2_7/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmdeps.nim.c -o c_code/5_7/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmmarshal.nim.c -o c_code/2_7/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mgorgeimpl.nim.c -o c_code/5_7/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmacrocacheimpl.nim.c -o c_code/2_7/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmprofiler.nim.c -o c_code/2_7/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mevaltempl.nim.c -o c_code/2_7/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvm.nim.c -o c_code/5_7/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@maliases.nim.c -o c_code/2_7/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpatterns.nim.c -o c_code/2_7/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemmacrosanity.nim.c -o c_code/2_7/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpluginsupport.nim.c -o c_code/2_7/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@slocals.nim.c -o c_code/2_7/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sitersgen.nim.c -o c_code/2_7/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sactive.nim.c -o c_code/2_7/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@menumtostr.nim.c -o c_code/2_7/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mspawn.nim.c -o c_code/2_7/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msem.nim.c -o c_code/5_7/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdfa.nim.c -o c_code/2_7/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptimizer.nim.c -o c_code/2_7/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@minjectdestructors.nim.c -o c_code/2_7/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemparallel.nim.c -o c_code/2_7/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dynlib.nim.c -o c_code/2_7/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgen.nim.c -o c_code/5_7/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sreplayer.nim.c -o c_code/2_7/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodules.nim.c -o c_code/5_7/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mscriptconfig.nim.c -o c_code/5_7/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimconf.nim.c -o c_code/5_7/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpassaux.nim.c -o c_code/2_7/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdepends.nim.c -o c_code/2_7/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sdce.nim.c -o c_code/2_7/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@scbackend.nim.c -o c_code/2_7/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sintegrity.nim.c -o c_code/2_7/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@snavigator.nim.c -o c_code/2_7/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msourcemap.nim.c -o c_code/2_7/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mjsgen.nim.c -o c_code/2_7/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_rstast.nim.c -o c_code/2_7/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_highlite.nim.c -o c_code/2_7/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_rst.nim.c -o c_code/5_7/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_rstgen.nim.c -o c_code/5_7/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_xmltree.nim.c -o c_code/2_7/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypesrenderer.nim.c -o c_code/2_7/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderverbatim.nim.c -o c_code/2_7/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_base64.nim.c -o c_code/2_7/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_uri.nim.c -o c_code/2_7/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdocgen.nim.c -o c_code/5_7/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdocgen2.nim.c -o c_code/5_7/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmain.nim.c -o c_code/2_7/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcmdlinehelper.nim.c -o c_code/2_7/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_browsers.nim.c -o c_code/5_7/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnim.nim.c -o c_code/5_7/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_7/stdlib_digitsutils.nim.o \
c_code/2_7/stdlib_assertions.nim.o \
c_code/2_7/stdlib_dragonbox.nim.o \
c_code/2_7/stdlib_schubfach.nim.o \
c_code/2_7/stdlib_formatfloat.nim.o \
c_code/2_7/stdlib_dollars.nim.o \
c_code/5_7/stdlib_io.nim.o \
c_code/5_7/stdlib_system.nim.o \
c_code/2_7/stdlib_parseutils.nim.o \
c_code/2_7/stdlib_math.nim.o \
c_code/2_7/stdlib_unicode.nim.o \
c_code/2_7/stdlib_strutils.nim.o \
c_code/2_7/stdlib_pathnorm.nim.o \
c_code/5_7/stdlib_posix.nim.o \
c_code/2_7/stdlib_times.nim.o \
c_code/5_7/stdlib_os.nim.o \
c_code/5_7/stdlib_parseopt.nim.o \
c_code/2_7/stdlib_hashes.nim.o \
c_code/2_7/stdlib_strtabs.nim.o \
c_code/2_7/stdlib_strformat.nim.o \
c_code/2_7/stdlib_terminal.nim.o \
c_code/2_7/@mpathutils.nim.o \
c_code/2_7/@mropes.nim.o \
c_code/2_7/@mlineinfos.nim.o \
c_code/5_7/@mplatform.nim.o \
c_code/2_7/@mprefixmatches.nim.o \
c_code/2_7/@mnimpaths.nim.o \
c_code/2_7/stdlib_globs.nim.o \
c_code/5_7/@moptions.nim.o \
c_code/2_7/@mstrutils2.nim.o \
c_code/5_7/@mmsgs.nim.o \
c_code/2_7/@mcondsyms.nim.o \
c_code/5_7/stdlib_streams.nim.o \
c_code/5_7/stdlib_cpuinfo.nim.o \
c_code/5_7/stdlib_osproc.nim.o \
c_code/2_7/stdlib_sha1.nim.o \
c_code/2_7/stdlib_lexbase.nim.o \
c_code/2_7/stdlib_parsejson.nim.o \
c_code/5_7/stdlib_json.nim.o \
c_code/2_7/stdlib_jsonutils.nim.o \
c_code/5_7/@mextccomp.nim.o \
c_code/2_7/@mwordrecg.nim.o \
c_code/5_7/@mnimblecmd.nim.o \
c_code/2_7/@midents.nim.o \
c_code/2_7/@mint128.nim.o \
c_code/2_7/@mast.nim.o \
c_code/5_7/@mcommands.nim.o \
c_code/5_7/@mllstream.nim.o \
c_code/2_7/@mnimlexbase.nim.o \
c_code/5_7/@mlexer.nim.o \
c_code/2_7/@mparser.nim.o \
c_code/2_7/@mrenderer.nim.o \
c_code/2_7/@mfilters.nim.o \
c_code/2_7/@mfilter_tmpl.nim.o \
c_code/2_7/@msyntaxes.nim.o \
c_code/2_7/stdlib_packedsets.nim.o \
c_code/2_7/stdlib_intsets.nim.o \
c_code/2_7/@mastalgo.nim.o \
c_code/2_7/@mtrees.nim.o \
c_code/2_7/stdlib_md5.nim.o \
c_code/2_7/@mic@srodfiles.nim.o \
c_code/2_7/@mic@spacked_ast.nim.o \
c_code/2_7/@mic@sic.nim.o \
c_code/2_7/@mmodulegraphs.nim.o \
c_code/2_7/@mastmsgs.nim.o \
c_code/5_7/@mtypes.nim.o \
c_code/2_7/@mmagicsys.nim.o \
c_code/2_7/@mbitsets.nim.o \
c_code/2_7/@mnimsets.nim.o \
c_code/5_7/@msemfold.nim.o \
c_code/5_7/@mmodulepaths.nim.o \
c_code/2_7/@mvmdef.nim.o \
c_code/2_7/@msemdata.nim.o \
c_code/2_7/@mlinter.nim.o \
c_code/2_7/@mnimfix@sprettybase.nim.o \
c_code/2_7/stdlib_editdistance.nim.o \
c_code/2_7/@mlookups.nim.o \
c_code/2_7/@mconcepts.nim.o \
c_code/2_7/@msemtypinst.nim.o \
c_code/2_7/@mparampatterns.nim.o \
c_code/2_7/@mlowerings.nim.o \
c_code/5_7/@msigmatch.nim.o \
c_code/2_7/@mimporter.nim.o \
c_code/2_7/@mprocfind.nim.o \
c_code/5_7/@mpragmas.nim.o \
c_code/2_7/@mreorder.nim.o \
c_code/2_7/@mpasses.nim.o \
c_code/2_7/@msaturate.nim.o \
c_code/2_7/@mguards.nim.o \
c_code/2_7/@mtypeallowed.nim.o \
c_code/2_7/@misolation_check.nim.o \
c_code/2_7/@mvarpartitions.nim.o \
c_code/2_7/@mtreetab.nim.o \
c_code/2_7/@mnilcheck.nim.o \
c_code/2_7/@merrorhandling.nim.o \
c_code/2_7/@msighashes.nim.o \
c_code/2_7/@mndi.nim.o \
c_code/2_7/@mcgendata.nim.o \
c_code/2_7/@mccgutils.nim.o \
c_code/2_7/@mliftdestructors.nim.o \
c_code/2_7/@msempass2.nim.o \
c_code/2_7/@mcgmeth.nim.o \
c_code/2_7/@mliftlocals.nim.o \
c_code/2_7/@mlambdalifting.nim.o \
c_code/2_7/@mclosureiters.nim.o \
c_code/2_7/@mtransf.nim.o \
c_code/2_7/@mvmgen.nim.o \
c_code/5_7/@mvmdeps.nim.o \
c_code/2_7/@mvmmarshal.nim.o \
c_code/5_7/@mgorgeimpl.nim.o \
c_code/2_7/@mmacrocacheimpl.nim.o \
c_code/2_7/@mvmprofiler.nim.o \
c_code/2_7/@mevaltempl.nim.o \
c_code/5_7/@mvm.nim.o \
c_code/2_7/@maliases.nim.o \
c_code/2_7/@mpatterns.nim.o \
c_code/2_7/@msemmacrosanity.nim.o \
c_code/2_7/@mpluginsupport.nim.o \
c_code/2_7/@mplugins@slocals.nim.o \
c_code/2_7/@mplugins@sitersgen.nim.o \
c_code/2_7/@mplugins@sactive.nim.o \
c_code/2_7/@menumtostr.nim.o \
c_code/2_7/@mspawn.nim.o \
c_code/5_7/@msem.nim.o \
c_code/2_7/@mdfa.nim.o \
c_code/2_7/@moptimizer.nim.o \
c_code/2_7/@minjectdestructors.nim.o \
c_code/2_7/@msemparallel.nim.o \
c_code/2_7/stdlib_dynlib.nim.o \
c_code/5_7/@mcgen.nim.o \
c_code/2_7/@mic@sreplayer.nim.o \
c_code/5_7/@mmodules.nim.o \
c_code/5_7/@mscriptconfig.nim.o \
c_code/5_7/@mnimconf.nim.o \
c_code/2_7/@mpassaux.nim.o \
c_code/2_7/@mdepends.nim.o \
c_code/2_7/@mic@sdce.nim.o \
c_code/2_7/@mic@scbackend.nim.o \
c_code/2_7/@mic@sintegrity.nim.o \
c_code/2_7/@mic@snavigator.nim.o \
c_code/2_7/@msourcemap.nim.o \
c_code/2_7/@mjsgen.nim.o \
c_code/2_7/stdlib_rstast.nim.o \
c_code/2_7/stdlib_highlite.nim.o \
c_code/5_7/stdlib_rst.nim.o \
c_code/5_7/stdlib_rstgen.nim.o \
c_code/2_7/stdlib_xmltree.nim.o \
c_code/2_7/@mtypesrenderer.nim.o \
c_code/2_7/@mrenderverbatim.nim.o \
c_code/2_7/stdlib_base64.nim.o \
c_code/2_7/stdlib_uri.nim.o \
c_code/5_7/@mdocgen.nim.o \
c_code/5_7/@mdocgen2.nim.o \
c_code/2_7/@mmain.nim.o \
c_code/2_7/@mcmdlinehelper.nim.o \
c_code/5_7/stdlib_browsers.nim.o \
c_code/5_7/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_io.nim.c -o c_code/5_6/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_system.nim.c -o c_code/5_6/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_os.nim.c -o c_code/5_6/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_parseopt.nim.c -o c_code/5_6/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_hashes.nim.c -o c_code/2_9/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/stdlib_strtabs.nim.c -o c_code/2_9/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mropes.nim.c -o c_code/2_9/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mlineinfos.nim.c -o c_code/2_9/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@mplatform.nim.c -o c_code/5_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@moptions.nim.c -o c_code/5_9/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@mmsgs.nim.c -o c_code/5_9/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_streams.nim.c -o c_code/5_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_osproc.nim.c -o c_code/5_6/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/stdlib_sha1.nim.c -o c_code/2_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_json.nim.c -o c_code/4_9/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@mnimblecmd.nim.c -o c_code/5_9/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@midents.nim.c -o c_code/2_9/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@sic.nim.c -o c_code/2_9/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mtreetab.nim.c -o c_code/2_9/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdeps.nim.c -o c_code/5_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@mvm.nim.c -o c_code/5_9/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mcgen.nim.c -o c_code/4_9/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodules.nim.c -o c_code/3_6/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@sdce.nim.c -o c_code/2_9/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mic@snavigator.nim.c -o c_code/2_9/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/stdlib_rst.nim.c -o c_code/5_9/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/stdlib_rstgen.nim.c -o c_code/5_9/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@mdocgen.nim.c -o c_code/5_9/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_browsers.nim.c -o c_code/4_9/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/5_6/stdlib_io.nim.o \
c_code/5_6/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/5_6/stdlib_os.nim.o \
c_code/5_6/stdlib_parseopt.nim.o \
c_code/2_9/stdlib_hashes.nim.o \
c_code/2_9/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_9/@mropes.nim.o \
c_code/2_9/@mlineinfos.nim.o \
c_code/5_9/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/5_9/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/5_9/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_6/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/5_6/stdlib_osproc.nim.o \
c_code/2_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/4_9/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/5_9/@mnimblecmd.nim.o \
c_code/2_9/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_9/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_9/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/5_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/5_9/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/5_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/4_9/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/3_6/@mmodules.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_9/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_9/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/5_9/stdlib_rst.nim.o \
c_code/5_9/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/5_9/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/4_9/stdlib_browsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_io.nim.c -o c_code/5_11/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_system.nim.c -o c_code/5_11/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_posix.nim.c -o c_code/3_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_os.nim.c -o c_code/5_11/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_parseopt.nim.c -o c_code/5_11/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mplatform.nim.c -o c_code/5_11/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@moptions.nim.c -o c_code/5_11/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmsgs.nim.c -o c_code/5_11/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_streams.nim.c -o c_code/5_11/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_cpuinfo.nim.c -o c_code/3_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_osproc.nim.c -o c_code/5_11/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_sha1.nim.c -o c_code/2_3/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_json.nim.c -o c_code/5_11/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mextccomp.nim.c -o c_code/5_11/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimblecmd.nim.c -o c_code/5_11/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcommands.nim.c -o c_code/5_11/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mllstream.nim.c -o c_code/5_11/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mlexer.nim.c -o c_code/5_11/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtypes.nim.c -o c_code/4_8/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemfold.nim.c -o c_code/4_8/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmodulepaths.nim.c -o c_code/4_8/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msigmatch.nim.c -o c_code/5_11/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mpragmas.nim.c -o c_code/5_11/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvmdeps.nim.c -o c_code/5_11/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mgorgeimpl.nim.c -o c_code/5_11/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvm.nim.c -o c_code/5_11/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msem.nim.c -o c_code/5_11/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcgen.nim.c -o c_code/5_11/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmodules.nim.c -o c_code/5_11/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mscriptconfig.nim.c -o c_code/5_11/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimconf.nim.c -o c_code/5_11/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_rst.nim.c -o c_code/5_11/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_rstgen.nim.c -o c_code/5_11/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mdocgen.nim.c -o c_code/5_11/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen2.nim.c -o c_code/4_8/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_browsers.nim.c -o c_code/5_11/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnim.nim.c -o c_code/5_11/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/5_11/stdlib_io.nim.o \
c_code/5_11/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/3_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/5_11/stdlib_os.nim.o \
c_code/5_11/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/5_11/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/5_11/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/5_11/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/5_11/stdlib_streams.nim.o \
c_code/3_1/stdlib_cpuinfo.nim.o \
c_code/5_11/stdlib_osproc.nim.o \
c_code/2_3/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/5_11/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/5_11/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/5_11/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/5_11/@mcommands.nim.o \
c_code/5_11/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/5_11/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/4_8/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/4_8/@msemfold.nim.o \
c_code/4_8/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/5_11/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/5_11/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/5_11/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/5_11/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/5_11/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/5_11/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/5_11/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/5_11/@mmodules.nim.o \
c_code/5_11/@mscriptconfig.nim.o \
c_code/5_11/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/5_11/stdlib_rst.nim.o \
c_code/5_11/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/5_11/@mdocgen.nim.o \
c_code/4_8/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/5_11/stdlib_browsers.nim.o \
c_code/5_11/@mnim.nim.o $LINK_FLAGS
    ;;
  mipsel)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_io.nim.c -o c_code/5_11/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_system.nim.c -o c_code/5_11/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_posix.nim.c -o c_code/3_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_os.nim.c -o c_code/5_11/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_parseopt.nim.c -o c_code/5_11/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mplatform.nim.c -o c_code/5_12/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@moptions.nim.c -o c_code/5_11/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmsgs.nim.c -o c_code/5_11/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_streams.nim.c -o c_code/5_11/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_cpuinfo.nim.c -o c_code/3_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_osproc.nim.c -o c_code/5_11/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_json.nim.c -o c_code/5_11/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mextccomp.nim.c -o c_code/5_11/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimblecmd.nim.c -o c_code/5_11/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcommands.nim.c -o c_code/5_11/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mllstream.nim.c -o c_code/5_11/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mlexer.nim.c -o c_code/5_11/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtypes.nim.c -o c_code/4_8/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemfold.nim.c -o c_code/4_8/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmodulepaths.nim.c -o c_code/4_8/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msigmatch.nim.c -o c_code/5_11/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mpragmas.nim.c -o c_code/5_11/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvmdeps.nim.c -o c_code/5_11/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mgorgeimpl.nim.c -o c_code/5_11/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvm.nim.c -o c_code/5_11/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msem.nim.c -o c_code/5_11/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcgen.nim.c -o c_code/5_11/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmodules.nim.c -o c_code/5_11/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mscriptconfig.nim.c -o c_code/5_11/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimconf.nim.c -o c_code/5_11/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_rst.nim.c -o c_code/5_11/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_rstgen.nim.c -o c_code/5_11/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mdocgen.nim.c -o c_code/5_11/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen2.nim.c -o c_code/4_8/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_browsers.nim.c -o c_code/5_11/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnim.nim.c -o c_code/5_11/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/5_11/stdlib_io.nim.o \
c_code/5_11/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/3_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/5_11/stdlib_os.nim.o \
c_code/5_11/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/5_12/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/5_11/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/5_11/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/5_11/stdlib_streams.nim.o \
c_code/3_1/stdlib_cpuinfo.nim.o \
c_code/5_11/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/5_11/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/5_11/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/5_11/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/5_11/@mcommands.nim.o \
c_code/5_11/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/5_11/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/4_8/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/4_8/@msemfold.nim.o \
c_code/4_8/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/5_11/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/5_11/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/5_11/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/5_11/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/5_11/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/5_11/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/5_11/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/5_11/@mmodules.nim.o \
c_code/5_11/@mscriptconfig.nim.o \
c_code/5_11/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/5_11/stdlib_rst.nim.o \
c_code/5_11/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/5_11/@mdocgen.nim.o \
c_code/4_8/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/5_11/stdlib_browsers.nim.o \
c_code/5_11/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_io.nim.c -o c_code/5_6/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_system.nim.c -o c_code/5_6/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_os.nim.c -o c_code/5_6/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_parseopt.nim.c -o c_code/5_6/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_13/@mplatform.nim.c -o c_code/5_13/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_streams.nim.c -o c_code/5_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_osproc.nim.c -o c_code/5_6/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/stdlib_sha1.nim.c -o c_code/2_6/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_json.nim.c -o c_code/3_6/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdeps.nim.c -o c_code/5_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodules.nim.c -o c_code/3_6/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rst.nim.c -o c_code/5_6/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rstgen.nim.c -o c_code/5_6/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_browsers.nim.c -o c_code/4_9/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/5_6/stdlib_io.nim.o \
c_code/5_6/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/5_6/stdlib_os.nim.o \
c_code/5_6/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/5_13/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_6/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/5_6/stdlib_osproc.nim.o \
c_code/2_6/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/3_6/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/5_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/5_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/3_6/@mmodules.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/5_6/stdlib_rst.nim.o \
c_code/5_6/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/4_9/stdlib_browsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_io.nim.c -o c_code/5_6/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_system.nim.c -o c_code/5_6/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_os.nim.c -o c_code/5_6/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_parseopt.nim.c -o c_code/5_6/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_14/@mplatform.nim.c -o c_code/5_14/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_streams.nim.c -o c_code/5_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_osproc.nim.c -o c_code/5_6/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_json.nim.c -o c_code/3_6/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdeps.nim.c -o c_code/5_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodules.nim.c -o c_code/3_6/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rst.nim.c -o c_code/5_6/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rstgen.nim.c -o c_code/5_6/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_browsers.nim.c -o c_code/4_9/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/5_6/stdlib_io.nim.o \
c_code/5_6/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/5_6/stdlib_os.nim.o \
c_code/5_6/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/5_14/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_6/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/5_6/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/3_6/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/5_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/5_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/3_6/@mmodules.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/5_6/stdlib_rst.nim.o \
c_code/5_6/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/4_9/stdlib_browsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_assertions.nim.c -o c_code/2_3/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_io.nim.c -o c_code/5_11/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_system.nim.c -o c_code/5_11/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_parseutils.nim.c -o c_code/2_10/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strutils.nim.c -o c_code/2_10/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_pathnorm.nim.c -o c_code/2_10/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_posix.nim.c -o c_code/3_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_times.nim.c -o c_code/2_3/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_os.nim.c -o c_code/5_11/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_parseopt.nim.c -o c_code/5_11/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_strtabs.nim.c -o c_code/2_10/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_strformat.nim.c -o c_code/2_3/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_terminal.nim.c -o c_code/2_3/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mropes.nim.c -o c_code/2_10/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlineinfos.nim.c -o c_code/2_3/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_15/@mplatform.nim.c -o c_code/5_15/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@moptions.nim.c -o c_code/5_11/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmsgs.nim.c -o c_code/5_11/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_streams.nim.c -o c_code/5_11/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_cpuinfo.nim.c -o c_code/3_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_osproc.nim.c -o c_code/5_11/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_sha1.nim.c -o c_code/2_3/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_parsejson.nim.c -o c_code/2_3/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_json.nim.c -o c_code/5_11/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_jsonutils.nim.c -o c_code/2_3/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mextccomp.nim.c -o c_code/5_11/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimblecmd.nim.c -o c_code/5_11/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@midents.nim.c -o c_code/2_3/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcommands.nim.c -o c_code/5_11/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mllstream.nim.c -o c_code/5_11/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mlexer.nim.c -o c_code/5_11/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mparser.nim.c -o c_code/2_10/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mrenderer.nim.c -o c_code/2_10/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mfilter_tmpl.nim.c -o c_code/2_10/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msyntaxes.nim.c -o c_code/2_10/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_intsets.nim.c -o c_code/2_3/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtrees.nim.c -o c_code/2_3/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mic@sic.nim.c -o c_code/2_10/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtypes.nim.c -o c_code/4_8/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmagicsys.nim.c -o c_code/2_3/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimsets.nim.c -o c_code/2_3/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemfold.nim.c -o c_code/4_8/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmodulepaths.nim.c -o c_code/4_8/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mnimfix@sprettybase.nim.c -o c_code/2_10/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mlookups.nim.c -o c_code/2_10/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparampatterns.nim.c -o c_code/2_3/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msigmatch.nim.c -o c_code/5_11/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mpragmas.nim.c -o c_code/5_11/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mreorder.nim.c -o c_code/2_10/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpasses.nim.c -o c_code/2_3/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtreetab.nim.c -o c_code/2_3/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msighashes.nim.c -o c_code/2_3/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgmeth.nim.c -o c_code/2_3/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvmdeps.nim.c -o c_code/5_11/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmmarshal.nim.c -o c_code/2_3/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mgorgeimpl.nim.c -o c_code/5_11/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmacrocacheimpl.nim.c -o c_code/2_3/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmprofiler.nim.c -o c_code/2_3/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvm.nim.c -o c_code/5_11/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@slocals.nim.c -o c_code/2_3/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplugins@sitersgen.nim.c -o c_code/2_3/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@menumtostr.nim.c -o c_code/2_3/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mspawn.nim.c -o c_code/2_3/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msem.nim.c -o c_code/5_11/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/stdlib_dynlib.nim.c -o c_code/2_10/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcgen.nim.c -o c_code/5_11/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sreplayer.nim.c -o c_code/2_3/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmodules.nim.c -o c_code/5_11/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mscriptconfig.nim.c -o c_code/5_11/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimconf.nim.c -o c_code/5_11/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpassaux.nim.c -o c_code/2_3/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@scbackend.nim.c -o c_code/2_3/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@msourcemap.nim.c -o c_code/2_10/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mjsgen.nim.c -o c_code/2_10/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/stdlib_rstast.nim.c -o c_code/2_3/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_rst.nim.c -o c_code/5_11/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_rstgen.nim.c -o c_code/5_11/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mtypesrenderer.nim.c -o c_code/2_10/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mdocgen.nim.c -o c_code/5_11/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen2.nim.c -o c_code/4_8/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcmdlinehelper.nim.c -o c_code/2_3/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/stdlib_browsers.nim.c -o c_code/5_11/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnim.nim.c -o c_code/5_11/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_3/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/5_11/stdlib_io.nim.o \
c_code/5_11/stdlib_system.nim.o \
c_code/2_10/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_10/stdlib_strutils.nim.o \
c_code/2_10/stdlib_pathnorm.nim.o \
c_code/3_1/stdlib_posix.nim.o \
c_code/2_3/stdlib_times.nim.o \
c_code/5_11/stdlib_os.nim.o \
c_code/5_11/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_10/stdlib_strtabs.nim.o \
c_code/2_3/stdlib_strformat.nim.o \
c_code/2_3/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_10/@mropes.nim.o \
c_code/2_3/@mlineinfos.nim.o \
c_code/5_15/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/5_11/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/5_11/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/5_11/stdlib_streams.nim.o \
c_code/3_1/stdlib_cpuinfo.nim.o \
c_code/5_11/stdlib_osproc.nim.o \
c_code/2_3/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_3/stdlib_parsejson.nim.o \
c_code/5_11/stdlib_json.nim.o \
c_code/2_3/stdlib_jsonutils.nim.o \
c_code/5_11/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/5_11/@mnimblecmd.nim.o \
c_code/2_3/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_3/@mast.nim.o \
c_code/5_11/@mcommands.nim.o \
c_code/5_11/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/5_11/@mlexer.nim.o \
c_code/2_10/@mparser.nim.o \
c_code/2_10/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_10/@mfilter_tmpl.nim.o \
c_code/2_10/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_3/stdlib_intsets.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/2_3/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_10/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/4_8/@mtypes.nim.o \
c_code/2_3/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_3/@mnimsets.nim.o \
c_code/4_8/@msemfold.nim.o \
c_code/4_8/@mmodulepaths.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_10/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_10/@mlookups.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mparampatterns.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/5_11/@msigmatch.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/5_11/@mpragmas.nim.o \
c_code/2_10/@mreorder.nim.o \
c_code/2_3/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mtreetab.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_3/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_3/@mcgmeth.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/5_11/@mvmdeps.nim.o \
c_code/2_3/@mvmmarshal.nim.o \
c_code/5_11/@mgorgeimpl.nim.o \
c_code/2_3/@mmacrocacheimpl.nim.o \
c_code/2_3/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/5_11/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_3/@mplugins@slocals.nim.o \
c_code/2_3/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_3/@menumtostr.nim.o \
c_code/2_3/@mspawn.nim.o \
c_code/5_11/@msem.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_10/stdlib_dynlib.nim.o \
c_code/5_11/@mcgen.nim.o \
c_code/2_3/@mic@sreplayer.nim.o \
c_code/5_11/@mmodules.nim.o \
c_code/5_11/@mscriptconfig.nim.o \
c_code/5_11/@mnimconf.nim.o \
c_code/2_3/@mpassaux.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_3/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_10/@msourcemap.nim.o \
c_code/2_10/@mjsgen.nim.o \
c_code/2_3/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/5_11/stdlib_rst.nim.o \
c_code/5_11/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_10/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/5_11/@mdocgen.nim.o \
c_code/4_8/@mdocgen2.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_3/@mcmdlinehelper.nim.o \
c_code/5_11/stdlib_browsers.nim.o \
c_code/5_11/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_io.nim.c -o c_code/5_6/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_system.nim.c -o c_code/5_6/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_os.nim.c -o c_code/5_6/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_parseopt.nim.c -o c_code/5_6/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_16/@mplatform.nim.c -o c_code/5_16/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_streams.nim.c -o c_code/5_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_osproc.nim.c -o c_code/5_6/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_json.nim.c -o c_code/3_6/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdeps.nim.c -o c_code/5_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodules.nim.c -o c_code/3_6/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rst.nim.c -o c_code/5_6/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rstgen.nim.c -o c_code/5_6/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_browsers.nim.c -o c_code/4_9/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/5_6/stdlib_io.nim.o \
c_code/5_6/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/5_6/stdlib_os.nim.o \
c_code/5_6/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/5_16/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_6/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/5_6/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/3_6/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/5_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/5_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/3_6/@mmodules.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/5_6/stdlib_rst.nim.o \
c_code/5_6/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/4_9/stdlib_browsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_digitsutils.nim.c -o c_code/2_17/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_assertions.nim.c -o c_code/2_17/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dragonbox.nim.c -o c_code/2_17/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_schubfach.nim.c -o c_code/2_17/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_formatfloat.nim.c -o c_code/2_17/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dollars.nim.c -o c_code/2_17/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_io.nim.c -o c_code/5_17/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_system.nim.c -o c_code/5_17/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parseutils.nim.c -o c_code/2_17/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_math.nim.c -o c_code/2_17/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_unicode.nim.c -o c_code/2_17/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strutils.nim.c -o c_code/2_17/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_pathnorm.nim.c -o c_code/2_17/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_posix.nim.c -o c_code/3_17/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_times.nim.c -o c_code/2_17/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_os.nim.c -o c_code/5_17/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_parseopt.nim.c -o c_code/5_17/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_hashes.nim.c -o c_code/2_17/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strtabs.nim.c -o c_code/2_17/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strformat.nim.c -o c_code/2_17/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_terminal.nim.c -o c_code/2_17/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpathutils.nim.c -o c_code/2_17/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mropes.nim.c -o c_code/2_17/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlineinfos.nim.c -o c_code/2_17/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mplatform.nim.c -o c_code/5_17/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprefixmatches.nim.c -o c_code/2_17/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimpaths.nim.c -o c_code/2_17/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_globs.nim.c -o c_code/2_17/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@moptions.nim.c -o c_code/5_17/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mstrutils2.nim.c -o c_code/2_17/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mmsgs.nim.c -o c_code/5_17/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcondsyms.nim.c -o c_code/2_17/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_streams.nim.c -o c_code/5_17/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_cpuinfo.nim.c -o c_code/3_17/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_osproc.nim.c -o c_code/5_17/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_sha1.nim.c -o c_code/2_17/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_lexbase.nim.c -o c_code/2_17/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parsejson.nim.c -o c_code/2_17/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_json.nim.c -o c_code/3_17/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_jsonutils.nim.c -o c_code/2_17/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mextccomp.nim.c -o c_code/5_17/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mwordrecg.nim.c -o c_code/2_17/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mnimblecmd.nim.c -o c_code/5_17/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@midents.nim.c -o c_code/2_17/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mint128.nim.c -o c_code/2_17/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mast.nim.c -o c_code/2_17/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mcommands.nim.c -o c_code/5_17/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mllstream.nim.c -o c_code/5_17/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimlexbase.nim.c -o c_code/2_17/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mlexer.nim.c -o c_code/5_17/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparser.nim.c -o c_code/2_17/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderer.nim.c -o c_code/2_17/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilters.nim.c -o c_code/2_17/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilter_tmpl.nim.c -o c_code/2_17/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msyntaxes.nim.c -o c_code/2_17/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_packedsets.nim.c -o c_code/2_17/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_intsets.nim.c -o c_code/2_17/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastalgo.nim.c -o c_code/2_17/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtrees.nim.c -o c_code/2_17/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_md5.nim.c -o c_code/2_17/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@srodfiles.nim.c -o c_code/2_17/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@spacked_ast.nim.c -o c_code/2_17/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sic.nim.c -o c_code/2_17/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulegraphs.nim.c -o c_code/2_17/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastmsgs.nim.c -o c_code/2_17/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mtypes.nim.c -o c_code/3_17/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmagicsys.nim.c -o c_code/2_17/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mbitsets.nim.c -o c_code/2_17/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimsets.nim.c -o c_code/2_17/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msemfold.nim.c -o c_code/3_17/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmodulepaths.nim.c -o c_code/3_17/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmdef.nim.c -o c_code/2_17/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemdata.nim.c -o c_code/2_17/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlinter.nim.c -o c_code/2_17/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimfix@sprettybase.nim.c -o c_code/2_17/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_editdistance.nim.c -o c_code/2_17/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlookups.nim.c -o c_code/2_17/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mconcepts.nim.c -o c_code/2_17/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemtypinst.nim.c -o c_code/2_17/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparampatterns.nim.c -o c_code/2_17/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlowerings.nim.c -o c_code/2_17/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@msigmatch.nim.c -o c_code/5_17/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mimporter.nim.c -o c_code/2_17/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprocfind.nim.c -o c_code/2_17/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mpragmas.nim.c -o c_code/5_17/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mreorder.nim.c -o c_code/2_17/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpasses.nim.c -o c_code/2_17/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msaturate.nim.c -o c_code/2_17/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mguards.nim.c -o c_code/2_17/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypeallowed.nim.c -o c_code/2_17/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@misolation_check.nim.c -o c_code/2_17/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvarpartitions.nim.c -o c_code/2_17/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtreetab.nim.c -o c_code/2_17/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnilcheck.nim.c -o c_code/2_17/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@merrorhandling.nim.c -o c_code/2_17/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msighashes.nim.c -o c_code/2_17/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mndi.nim.c -o c_code/2_17/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgendata.nim.c -o c_code/2_17/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mccgutils.nim.c -o c_code/2_17/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftdestructors.nim.c -o c_code/2_17/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msempass2.nim.c -o c_code/2_17/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgmeth.nim.c -o c_code/2_17/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftlocals.nim.c -o c_code/2_17/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlambdalifting.nim.c -o c_code/2_17/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mclosureiters.nim.c -o c_code/2_17/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtransf.nim.c -o c_code/2_17/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmgen.nim.c -o c_code/2_17/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mvmdeps.nim.c -o c_code/5_17/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmmarshal.nim.c -o c_code/2_17/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mgorgeimpl.nim.c -o c_code/5_17/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmacrocacheimpl.nim.c -o c_code/2_17/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmprofiler.nim.c -o c_code/2_17/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mevaltempl.nim.c -o c_code/2_17/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mvm.nim.c -o c_code/5_17/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliases.nim.c -o c_code/2_17/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpatterns.nim.c -o c_code/2_17/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemmacrosanity.nim.c -o c_code/2_17/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpluginsupport.nim.c -o c_code/2_17/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@slocals.nim.c -o c_code/2_17/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sitersgen.nim.c -o c_code/2_17/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sactive.nim.c -o c_code/2_17/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@menumtostr.nim.c -o c_code/2_17/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mspawn.nim.c -o c_code/2_17/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@msem.nim.c -o c_code/5_17/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdfa.nim.c -o c_code/2_17/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptimizer.nim.c -o c_code/2_17/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@minjectdestructors.nim.c -o c_code/2_17/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemparallel.nim.c -o c_code/2_17/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dynlib.nim.c -o c_code/2_17/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mcgen.nim.c -o c_code/5_17/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sreplayer.nim.c -o c_code/2_17/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmodules.nim.c -o c_code/3_17/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mscriptconfig.nim.c -o c_code/5_17/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnimconf.nim.c -o c_code/3_17/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpassaux.nim.c -o c_code/2_17/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdepends.nim.c -o c_code/2_17/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sdce.nim.c -o c_code/2_17/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@scbackend.nim.c -o c_code/2_17/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sintegrity.nim.c -o c_code/2_17/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@snavigator.nim.c -o c_code/2_17/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msourcemap.nim.c -o c_code/2_17/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mjsgen.nim.c -o c_code/2_17/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_rstast.nim.c -o c_code/2_17/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_highlite.nim.c -o c_code/2_17/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_rst.nim.c -o c_code/5_17/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_rstgen.nim.c -o c_code/5_17/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_xmltree.nim.c -o c_code/2_17/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypesrenderer.nim.c -o c_code/2_17/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderverbatim.nim.c -o c_code/2_17/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_base64.nim.c -o c_code/2_17/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_uri.nim.c -o c_code/2_17/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mdocgen.nim.c -o c_code/5_17/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mdocgen2.nim.c -o c_code/3_17/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmain.nim.c -o c_code/2_17/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcmdlinehelper.nim.c -o c_code/2_17/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_browsers.nim.c -o c_code/5_17/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mnim.nim.c -o c_code/5_17/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_17/stdlib_digitsutils.nim.o \
c_code/2_17/stdlib_assertions.nim.o \
c_code/2_17/stdlib_dragonbox.nim.o \
c_code/2_17/stdlib_schubfach.nim.o \
c_code/2_17/stdlib_formatfloat.nim.o \
c_code/2_17/stdlib_dollars.nim.o \
c_code/5_17/stdlib_io.nim.o \
c_code/5_17/stdlib_system.nim.o \
c_code/2_17/stdlib_parseutils.nim.o \
c_code/2_17/stdlib_math.nim.o \
c_code/2_17/stdlib_unicode.nim.o \
c_code/2_17/stdlib_strutils.nim.o \
c_code/2_17/stdlib_pathnorm.nim.o \
c_code/3_17/stdlib_posix.nim.o \
c_code/2_17/stdlib_times.nim.o \
c_code/5_17/stdlib_os.nim.o \
c_code/5_17/stdlib_parseopt.nim.o \
c_code/2_17/stdlib_hashes.nim.o \
c_code/2_17/stdlib_strtabs.nim.o \
c_code/2_17/stdlib_strformat.nim.o \
c_code/2_17/stdlib_terminal.nim.o \
c_code/2_17/@mpathutils.nim.o \
c_code/2_17/@mropes.nim.o \
c_code/2_17/@mlineinfos.nim.o \
c_code/5_17/@mplatform.nim.o \
c_code/2_17/@mprefixmatches.nim.o \
c_code/2_17/@mnimpaths.nim.o \
c_code/2_17/stdlib_globs.nim.o \
c_code/5_17/@moptions.nim.o \
c_code/2_17/@mstrutils2.nim.o \
c_code/5_17/@mmsgs.nim.o \
c_code/2_17/@mcondsyms.nim.o \
c_code/5_17/stdlib_streams.nim.o \
c_code/3_17/stdlib_cpuinfo.nim.o \
c_code/5_17/stdlib_osproc.nim.o \
c_code/2_17/stdlib_sha1.nim.o \
c_code/2_17/stdlib_lexbase.nim.o \
c_code/2_17/stdlib_parsejson.nim.o \
c_code/3_17/stdlib_json.nim.o \
c_code/2_17/stdlib_jsonutils.nim.o \
c_code/5_17/@mextccomp.nim.o \
c_code/2_17/@mwordrecg.nim.o \
c_code/5_17/@mnimblecmd.nim.o \
c_code/2_17/@midents.nim.o \
c_code/2_17/@mint128.nim.o \
c_code/2_17/@mast.nim.o \
c_code/5_17/@mcommands.nim.o \
c_code/5_17/@mllstream.nim.o \
c_code/2_17/@mnimlexbase.nim.o \
c_code/5_17/@mlexer.nim.o \
c_code/2_17/@mparser.nim.o \
c_code/2_17/@mrenderer.nim.o \
c_code/2_17/@mfilters.nim.o \
c_code/2_17/@mfilter_tmpl.nim.o \
c_code/2_17/@msyntaxes.nim.o \
c_code/2_17/stdlib_packedsets.nim.o \
c_code/2_17/stdlib_intsets.nim.o \
c_code/2_17/@mastalgo.nim.o \
c_code/2_17/@mtrees.nim.o \
c_code/2_17/stdlib_md5.nim.o \
c_code/2_17/@mic@srodfiles.nim.o \
c_code/2_17/@mic@spacked_ast.nim.o \
c_code/2_17/@mic@sic.nim.o \
c_code/2_17/@mmodulegraphs.nim.o \
c_code/2_17/@mastmsgs.nim.o \
c_code/3_17/@mtypes.nim.o \
c_code/2_17/@mmagicsys.nim.o \
c_code/2_17/@mbitsets.nim.o \
c_code/2_17/@mnimsets.nim.o \
c_code/3_17/@msemfold.nim.o \
c_code/3_17/@mmodulepaths.nim.o \
c_code/2_17/@mvmdef.nim.o \
c_code/2_17/@msemdata.nim.o \
c_code/2_17/@mlinter.nim.o \
c_code/2_17/@mnimfix@sprettybase.nim.o \
c_code/2_17/stdlib_editdistance.nim.o \
c_code/2_17/@mlookups.nim.o \
c_code/2_17/@mconcepts.nim.o \
c_code/2_17/@msemtypinst.nim.o \
c_code/2_17/@mparampatterns.nim.o \
c_code/2_17/@mlowerings.nim.o \
c_code/5_17/@msigmatch.nim.o \
c_code/2_17/@mimporter.nim.o \
c_code/2_17/@mprocfind.nim.o \
c_code/5_17/@mpragmas.nim.o \
c_code/2_17/@mreorder.nim.o \
c_code/2_17/@mpasses.nim.o \
c_code/2_17/@msaturate.nim.o \
c_code/2_17/@mguards.nim.o \
c_code/2_17/@mtypeallowed.nim.o \
c_code/2_17/@misolation_check.nim.o \
c_code/2_17/@mvarpartitions.nim.o \
c_code/2_17/@mtreetab.nim.o \
c_code/2_17/@mnilcheck.nim.o \
c_code/2_17/@merrorhandling.nim.o \
c_code/2_17/@msighashes.nim.o \
c_code/2_17/@mndi.nim.o \
c_code/2_17/@mcgendata.nim.o \
c_code/2_17/@mccgutils.nim.o \
c_code/2_17/@mliftdestructors.nim.o \
c_code/2_17/@msempass2.nim.o \
c_code/2_17/@mcgmeth.nim.o \
c_code/2_17/@mliftlocals.nim.o \
c_code/2_17/@mlambdalifting.nim.o \
c_code/2_17/@mclosureiters.nim.o \
c_code/2_17/@mtransf.nim.o \
c_code/2_17/@mvmgen.nim.o \
c_code/5_17/@mvmdeps.nim.o \
c_code/2_17/@mvmmarshal.nim.o \
c_code/5_17/@mgorgeimpl.nim.o \
c_code/2_17/@mmacrocacheimpl.nim.o \
c_code/2_17/@mvmprofiler.nim.o \
c_code/2_17/@mevaltempl.nim.o \
c_code/5_17/@mvm.nim.o \
c_code/2_17/@maliases.nim.o \
c_code/2_17/@mpatterns.nim.o \
c_code/2_17/@msemmacrosanity.nim.o \
c_code/2_17/@mpluginsupport.nim.o \
c_code/2_17/@mplugins@slocals.nim.o \
c_code/2_17/@mplugins@sitersgen.nim.o \
c_code/2_17/@mplugins@sactive.nim.o \
c_code/2_17/@menumtostr.nim.o \
c_code/2_17/@mspawn.nim.o \
c_code/5_17/@msem.nim.o \
c_code/2_17/@mdfa.nim.o \
c_code/2_17/@moptimizer.nim.o \
c_code/2_17/@minjectdestructors.nim.o \
c_code/2_17/@msemparallel.nim.o \
c_code/2_17/stdlib_dynlib.nim.o \
c_code/5_17/@mcgen.nim.o \
c_code/2_17/@mic@sreplayer.nim.o \
c_code/3_17/@mmodules.nim.o \
c_code/5_17/@mscriptconfig.nim.o \
c_code/3_17/@mnimconf.nim.o \
c_code/2_17/@mpassaux.nim.o \
c_code/2_17/@mdepends.nim.o \
c_code/2_17/@mic@sdce.nim.o \
c_code/2_17/@mic@scbackend.nim.o \
c_code/2_17/@mic@sintegrity.nim.o \
c_code/2_17/@mic@snavigator.nim.o \
c_code/2_17/@msourcemap.nim.o \
c_code/2_17/@mjsgen.nim.o \
c_code/2_17/stdlib_rstast.nim.o \
c_code/2_17/stdlib_highlite.nim.o \
c_code/5_17/stdlib_rst.nim.o \
c_code/5_17/stdlib_rstgen.nim.o \
c_code/2_17/stdlib_xmltree.nim.o \
c_code/2_17/@mtypesrenderer.nim.o \
c_code/2_17/@mrenderverbatim.nim.o \
c_code/2_17/stdlib_base64.nim.o \
c_code/2_17/stdlib_uri.nim.o \
c_code/5_17/@mdocgen.nim.o \
c_code/3_17/@mdocgen2.nim.o \
c_code/2_17/@mmain.nim.o \
c_code/2_17/@mcmdlinehelper.nim.o \
c_code/5_17/stdlib_browsers.nim.o \
c_code/5_17/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_assertions.nim.c -o c_code/2_4/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_io.nim.c -o c_code/5_6/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_system.nim.c -o c_code/5_6/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parseutils.nim.c -o c_code/2_4/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strutils.nim.c -o c_code/2_4/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_pathnorm.nim.c -o c_code/2_4/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_times.nim.c -o c_code/2_4/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_os.nim.c -o c_code/5_6/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_parseopt.nim.c -o c_code/5_6/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strtabs.nim.c -o c_code/2_4/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_strformat.nim.c -o c_code/2_4/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_terminal.nim.c -o c_code/2_4/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlineinfos.nim.c -o c_code/2_4/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_19/@mplatform.nim.c -o c_code/5_19/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_streams.nim.c -o c_code/5_6/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_cpuinfo.nim.c -o c_code/3_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_osproc.nim.c -o c_code/5_6/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_parsejson.nim.c -o c_code/2_4/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/stdlib_json.nim.c -o c_code/3_6/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_jsonutils.nim.c -o c_code/2_4/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@midents.nim.c -o c_code/2_4/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mast.nim.c -o c_code/2_4/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_intsets.nim.c -o c_code/2_4/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mastalgo.nim.c -o c_code/2_4/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtrees.nim.c -o c_code/2_4/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmodulegraphs.nim.c -o c_code/2_4/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mtypes.nim.c -o c_code/3_6/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmagicsys.nim.c -o c_code/2_4/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimsets.nim.c -o c_code/2_4/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msemfold.nim.c -o c_code/3_6/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodulepaths.nim.c -o c_code/3_6/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimfix@sprettybase.nim.c -o c_code/2_4/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlookups.nim.c -o c_code/2_4/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mconcepts.nim.c -o c_code/2_4/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemtypinst.nim.c -o c_code/2_4/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparampatterns.nim.c -o c_code/2_4/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlowerings.nim.c -o c_code/2_4/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mimporter.nim.c -o c_code/2_4/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpasses.nim.c -o c_code/2_4/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mguards.nim.c -o c_code/2_4/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvarpartitions.nim.c -o c_code/2_4/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtreetab.nim.c -o c_code/2_4/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnilcheck.nim.c -o c_code/2_4/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msighashes.nim.c -o c_code/2_4/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgendata.nim.c -o c_code/2_4/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftdestructors.nim.c -o c_code/2_4/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msempass2.nim.c -o c_code/2_4/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgmeth.nim.c -o c_code/2_4/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mliftlocals.nim.c -o c_code/2_4/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlambdalifting.nim.c -o c_code/2_4/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mclosureiters.nim.c -o c_code/2_4/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtransf.nim.c -o c_code/2_4/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmgen.nim.c -o c_code/2_4/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdeps.nim.c -o c_code/5_6/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmmarshal.nim.c -o c_code/2_4/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmacrocacheimpl.nim.c -o c_code/2_4/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmprofiler.nim.c -o c_code/2_4/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mevaltempl.nim.c -o c_code/2_4/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpatterns.nim.c -o c_code/2_4/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemmacrosanity.nim.c -o c_code/2_4/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@slocals.nim.c -o c_code/2_4/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplugins@sitersgen.nim.c -o c_code/2_4/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@menumtostr.nim.c -o c_code/2_4/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mspawn.nim.c -o c_code/2_4/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdfa.nim.c -o c_code/2_4/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptimizer.nim.c -o c_code/2_4/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemparallel.nim.c -o c_code/2_4/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_dynlib.nim.c -o c_code/2_4/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sreplayer.nim.c -o c_code/2_4/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmodules.nim.c -o c_code/3_6/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpassaux.nim.c -o c_code/2_4/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sdce.nim.c -o c_code/2_4/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@scbackend.nim.c -o c_code/2_4/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_rstast.nim.c -o c_code/2_4/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rst.nim.c -o c_code/5_6/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/stdlib_rstgen.nim.c -o c_code/5_6/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen2.nim.c -o c_code/3_6/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcmdlinehelper.nim.c -o c_code/2_4/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/stdlib_browsers.nim.c -o c_code/4_9/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_4/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/5_6/stdlib_io.nim.o \
c_code/5_6/stdlib_system.nim.o \
c_code/2_4/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_4/stdlib_strutils.nim.o \
c_code/2_4/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/2_4/stdlib_times.nim.o \
c_code/5_6/stdlib_os.nim.o \
c_code/5_6/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_4/stdlib_strtabs.nim.o \
c_code/2_4/stdlib_strformat.nim.o \
c_code/2_4/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_4/@mlineinfos.nim.o \
c_code/5_19/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_6/stdlib_streams.nim.o \
c_code/3_2/stdlib_cpuinfo.nim.o \
c_code/5_6/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_4/stdlib_parsejson.nim.o \
c_code/3_6/stdlib_json.nim.o \
c_code/2_4/stdlib_jsonutils.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/2_4/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_4/@mast.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_4/stdlib_intsets.nim.o \
c_code/2_4/@mastalgo.nim.o \
c_code/2_4/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_4/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_6/@mtypes.nim.o \
c_code/2_4/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_4/@mnimsets.nim.o \
c_code/3_6/@msemfold.nim.o \
c_code/3_6/@mmodulepaths.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_4/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_4/@mlookups.nim.o \
c_code/2_4/@mconcepts.nim.o \
c_code/2_4/@msemtypinst.nim.o \
c_code/2_4/@mparampatterns.nim.o \
c_code/2_4/@mlowerings.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/2_4/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_4/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_4/@mvarpartitions.nim.o \
c_code/2_4/@mtreetab.nim.o \
c_code/2_4/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_4/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_4/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_4/@mliftdestructors.nim.o \
c_code/2_4/@msempass2.nim.o \
c_code/2_4/@mcgmeth.nim.o \
c_code/2_4/@mliftlocals.nim.o \
c_code/2_4/@mlambdalifting.nim.o \
c_code/2_4/@mclosureiters.nim.o \
c_code/2_4/@mtransf.nim.o \
c_code/2_4/@mvmgen.nim.o \
c_code/5_6/@mvmdeps.nim.o \
c_code/2_4/@mvmmarshal.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/2_4/@mmacrocacheimpl.nim.o \
c_code/2_4/@mvmprofiler.nim.o \
c_code/2_4/@mevaltempl.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_4/@mpatterns.nim.o \
c_code/2_4/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_4/@mplugins@slocals.nim.o \
c_code/2_4/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_4/@menumtostr.nim.o \
c_code/2_4/@mspawn.nim.o \
c_code/5_6/@msem.nim.o \
c_code/2_4/@mdfa.nim.o \
c_code/2_4/@moptimizer.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/2_4/@msemparallel.nim.o \
c_code/2_4/stdlib_dynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/2_4/@mic@sreplayer.nim.o \
c_code/3_6/@mmodules.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_4/@mpassaux.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@mic@sdce.nim.o \
c_code/2_4/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_4/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/5_6/stdlib_rst.nim.o \
c_code/5_6/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/3_6/@mdocgen2.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_4/@mcmdlinehelper.nim.o \
c_code/4_9/stdlib_browsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
netbsd)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_assertions.nim.c -o c_code/2_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_io.nim.c -o c_code/6_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_system.nim.c -o c_code/6_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseutils.nim.c -o c_code/2_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strutils.nim.c -o c_code/2_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_pathnorm.nim.c -o c_code/2_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_posix.nim.c -o c_code/3_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_times.nim.c -o c_code/4_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_os.nim.c -o c_code/6_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseopt.nim.c -o c_code/2_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strtabs.nim.c -o c_code/2_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strformat.nim.c -o c_code/2_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_terminal.nim.c -o c_code/2_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mplatform.nim.c -o c_code/6_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@moptions.nim.c -o c_code/4_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mmsgs.nim.c -o c_code/6_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_streams.nim.c -o c_code/5_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_cpuinfo.nim.c -o c_code/6_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_osproc.nim.c -o c_code/6_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parsejson.nim.c -o c_code/2_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_json.nim.c -o c_code/3_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_jsonutils.nim.c -o c_code/2_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mextccomp.nim.c -o c_code/6_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mnimblecmd.nim.c -o c_code/6_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcommands.nim.c -o c_code/5_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mllstream.nim.c -o c_code/2_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlexer.nim.c -o c_code/4_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderer.nim.c -o c_code/2_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msyntaxes.nim.c -o c_code/2_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_intsets.nim.c -o c_code/2_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtrees.nim.c -o c_code/2_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mtypes.nim.c -o c_code/3_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msemfold.nim.c -o c_code/3_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodulepaths.nim.c -o c_code/3_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimfix@sprettybase.nim.c -o c_code/2_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msigmatch.nim.c -o c_code/4_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mpragmas.nim.c -o c_code/6_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpasses.nim.c -o c_code/2_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtreetab.nim.c -o c_code/2_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mgorgeimpl.nim.c -o c_code/5_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmacrocacheimpl.nim.c -o c_code/2_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mvm.nim.c -o c_code/6_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@slocals.nim.c -o c_code/2_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@menumtostr.nim.c -o c_code/2_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msem.nim.c -o c_code/5_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_dynlib.nim.c -o c_code/2_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgen.nim.c -o c_code/4_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mscriptconfig.nim.c -o c_code/6_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimconf.nim.c -o c_code/2_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpassaux.nim.c -o c_code/2_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mjsgen.nim.c -o c_code/2_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstast.nim.c -o c_code/2_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_rst.nim.c -o c_code/6_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_rstgen.nim.c -o c_code/6_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mdocgen.nim.c -o c_code/6_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen2.nim.c -o c_code/3_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmain.nim.c -o c_code/2_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_browsers.nim.c -o c_code/4_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnim.nim.c -o c_code/2_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/6_1/stdlib_io.nim.o \
c_code/6_1/stdlib_system.nim.o \
c_code/2_1/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_1/stdlib_strutils.nim.o \
c_code/2_1/stdlib_pathnorm.nim.o \
c_code/3_1/stdlib_posix.nim.o \
c_code/4_1/stdlib_times.nim.o \
c_code/6_1/stdlib_os.nim.o \
c_code/2_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_1/stdlib_strtabs.nim.o \
c_code/2_1/stdlib_strformat.nim.o \
c_code/2_1/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/6_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/4_1/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/6_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/5_1/stdlib_streams.nim.o \
c_code/6_1/stdlib_cpuinfo.nim.o \
c_code/6_1/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_1/stdlib_parsejson.nim.o \
c_code/3_1/stdlib_json.nim.o \
c_code/2_1/stdlib_jsonutils.nim.o \
c_code/6_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/6_1/@mnimblecmd.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_1/@mast.nim.o \
c_code/5_1/@mcommands.nim.o \
c_code/2_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/4_1/@mlexer.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/2_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_1/stdlib_intsets.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/2_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/3_1/@mtypes.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/3_1/@msemfold.nim.o \
c_code/3_1/@mmodulepaths.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/4_1/@msigmatch.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/6_1/@mpragmas.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mtreetab.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/5_1/@mgorgeimpl.nim.o \
c_code/2_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/6_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_1/@menumtostr.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/5_1/@msem.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/stdlib_dynlib.nim.o \
c_code/4_1/@mcgen.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/6_1/@mscriptconfig.nim.o \
c_code/2_1/@mnimconf.nim.o \
c_code/2_1/@mpassaux.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/2_1/@mjsgen.nim.o \
c_code/2_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/6_1/stdlib_rst.nim.o \
c_code/6_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/6_1/@mdocgen.nim.o \
c_code/3_1/@mdocgen2.nim.o \
c_code/2_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/4_1/stdlib_browsers.nim.o \
c_code/2_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_assertions.nim.c -o c_code/2_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_io.nim.c -o c_code/6_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_system.nim.c -o c_code/6_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseutils.nim.c -o c_code/2_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strutils.nim.c -o c_code/2_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_pathnorm.nim.c -o c_code/2_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_posix.nim.c -o c_code/3_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_times.nim.c -o c_code/4_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_os.nim.c -o c_code/6_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_parseopt.nim.c -o c_code/6_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strtabs.nim.c -o c_code/2_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strformat.nim.c -o c_code/2_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_terminal.nim.c -o c_code/2_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mplatform.nim.c -o c_code/6_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptions.nim.c -o c_code/4_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mmsgs.nim.c -o c_code/6_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_streams.nim.c -o c_code/5_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_cpuinfo.nim.c -o c_code/6_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_osproc.nim.c -o c_code/6_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parsejson.nim.c -o c_code/2_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_json.nim.c -o c_code/3_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_jsonutils.nim.c -o c_code/2_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mextccomp.nim.c -o c_code/6_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mnimblecmd.nim.c -o c_code/6_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcommands.nim.c -o c_code/5_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mllstream.nim.c -o c_code/6_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlexer.nim.c -o c_code/4_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderer.nim.c -o c_code/5_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msyntaxes.nim.c -o c_code/5_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_intsets.nim.c -o c_code/2_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtrees.nim.c -o c_code/2_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sic.nim.c -o c_code/5_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mtypes.nim.c -o c_code/3_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msemfold.nim.c -o c_code/3_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodulepaths.nim.c -o c_code/3_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimfix@sprettybase.nim.c -o c_code/2_2/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msigmatch.nim.c -o c_code/4_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mpragmas.nim.c -o c_code/6_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpasses.nim.c -o c_code/2_2/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtreetab.nim.c -o c_code/2_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mgorgeimpl.nim.c -o c_code/5_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmacrocacheimpl.nim.c -o c_code/2_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mvm.nim.c -o c_code/6_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@slocals.nim.c -o c_code/2_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@menumtostr.nim.c -o c_code/2_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msem.nim.c -o c_code/5_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_dynlib.nim.c -o c_code/2_2/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgen.nim.c -o c_code/4_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mscriptconfig.nim.c -o c_code/6_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimconf.nim.c -o c_code/2_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpassaux.nim.c -o c_code/2_2/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mjsgen.nim.c -o c_code/5_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rstast.nim.c -o c_code/2_2/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_rst.nim.c -o c_code/6_2/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_rstgen.nim.c -o c_code/6_2/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mdocgen.nim.c -o c_code/6_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen2.nim.c -o c_code/3_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmain.nim.c -o c_code/5_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_browsers.nim.c -o c_code/4_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mnim.nim.c -o c_code/6_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_2/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/6_2/stdlib_io.nim.o \
c_code/6_2/stdlib_system.nim.o \
c_code/2_2/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_2/stdlib_strutils.nim.o \
c_code/2_2/stdlib_pathnorm.nim.o \
c_code/3_2/stdlib_posix.nim.o \
c_code/4_2/stdlib_times.nim.o \
c_code/6_2/stdlib_os.nim.o \
c_code/6_2/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_2/stdlib_strtabs.nim.o \
c_code/2_2/stdlib_strformat.nim.o \
c_code/2_2/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/6_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/4_2/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/6_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_2/stdlib_streams.nim.o \
c_code/6_2/stdlib_cpuinfo.nim.o \
c_code/6_2/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_2/stdlib_parsejson.nim.o \
c_code/3_2/stdlib_json.nim.o \
c_code/2_2/stdlib_jsonutils.nim.o \
c_code/6_2/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/6_2/@mnimblecmd.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_2/@mast.nim.o \
c_code/5_2/@mcommands.nim.o \
c_code/6_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_2/@mlexer.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/5_2/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/5_2/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_2/stdlib_intsets.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/2_2/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/5_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_2/@mtypes.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/3_2/@msemfold.nim.o \
c_code/3_2/@mmodulepaths.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/4_2/@msigmatch.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/6_2/@mpragmas.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mtreetab.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/5_2/@mgorgeimpl.nim.o \
c_code/2_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/6_2/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_2/@menumtostr.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/5_2/@msem.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/stdlib_dynlib.nim.o \
c_code/4_2/@mcgen.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/6_2/@mscriptconfig.nim.o \
c_code/2_2/@mnimconf.nim.o \
c_code/2_2/@mpassaux.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/5_2/@mjsgen.nim.o \
c_code/2_2/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/6_2/stdlib_rst.nim.o \
c_code/6_2/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/6_2/@mdocgen.nim.o \
c_code/3_2/@mdocgen2.nim.o \
c_code/5_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/4_2/stdlib_browsers.nim.o \
c_code/6_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
openbsd)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_assertions.nim.c -o c_code/2_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_io.nim.c -o c_code/6_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_system.nim.c -o c_code/6_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseutils.nim.c -o c_code/2_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strutils.nim.c -o c_code/2_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_pathnorm.nim.c -o c_code/2_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_1/stdlib_posix.nim.c -o c_code/7_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_times.nim.c -o c_code/2_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_1/stdlib_os.nim.c -o c_code/7_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseopt.nim.c -o c_code/2_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strtabs.nim.c -o c_code/2_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strformat.nim.c -o c_code/2_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_terminal.nim.c -o c_code/2_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_1/@mplatform.nim.c -o c_code/7_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@moptions.nim.c -o c_code/4_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mmsgs.nim.c -o c_code/6_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_streams.nim.c -o c_code/5_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_cpuinfo.nim.c -o c_code/6_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_1/stdlib_osproc.nim.c -o c_code/7_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parsejson.nim.c -o c_code/2_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_json.nim.c -o c_code/3_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_jsonutils.nim.c -o c_code/2_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_1/@mextccomp.nim.c -o c_code/7_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mnimblecmd.nim.c -o c_code/6_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcommands.nim.c -o c_code/5_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mllstream.nim.c -o c_code/2_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlexer.nim.c -o c_code/4_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderer.nim.c -o c_code/2_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msyntaxes.nim.c -o c_code/2_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_intsets.nim.c -o c_code/2_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtrees.nim.c -o c_code/2_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mtypes.nim.c -o c_code/3_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msemfold.nim.c -o c_code/3_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodulepaths.nim.c -o c_code/3_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimfix@sprettybase.nim.c -o c_code/2_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msigmatch.nim.c -o c_code/4_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mpragmas.nim.c -o c_code/6_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpasses.nim.c -o c_code/2_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtreetab.nim.c -o c_code/2_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mgorgeimpl.nim.c -o c_code/5_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmacrocacheimpl.nim.c -o c_code/2_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_1/@mvm.nim.c -o c_code/7_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@slocals.nim.c -o c_code/2_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@menumtostr.nim.c -o c_code/2_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msem.nim.c -o c_code/5_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_dynlib.nim.c -o c_code/2_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgen.nim.c -o c_code/4_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mscriptconfig.nim.c -o c_code/6_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimconf.nim.c -o c_code/2_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpassaux.nim.c -o c_code/2_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mjsgen.nim.c -o c_code/2_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstast.nim.c -o c_code/2_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_rst.nim.c -o c_code/6_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_rstgen.nim.c -o c_code/6_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_1/@mdocgen.nim.c -o c_code/7_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen2.nim.c -o c_code/3_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmain.nim.c -o c_code/2_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_browsers.nim.c -o c_code/4_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnim.nim.c -o c_code/2_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/6_1/stdlib_io.nim.o \
c_code/6_1/stdlib_system.nim.o \
c_code/2_1/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_1/stdlib_strutils.nim.o \
c_code/2_1/stdlib_pathnorm.nim.o \
c_code/7_1/stdlib_posix.nim.o \
c_code/2_1/stdlib_times.nim.o \
c_code/7_1/stdlib_os.nim.o \
c_code/2_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_1/stdlib_strtabs.nim.o \
c_code/2_1/stdlib_strformat.nim.o \
c_code/2_1/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/7_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/4_1/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/6_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/5_1/stdlib_streams.nim.o \
c_code/6_1/stdlib_cpuinfo.nim.o \
c_code/7_1/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_1/stdlib_parsejson.nim.o \
c_code/3_1/stdlib_json.nim.o \
c_code/2_1/stdlib_jsonutils.nim.o \
c_code/7_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/6_1/@mnimblecmd.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_1/@mast.nim.o \
c_code/5_1/@mcommands.nim.o \
c_code/2_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/4_1/@mlexer.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/2_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_1/stdlib_intsets.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/2_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/3_1/@mtypes.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/3_1/@msemfold.nim.o \
c_code/3_1/@mmodulepaths.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/4_1/@msigmatch.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/6_1/@mpragmas.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mtreetab.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/5_1/@mgorgeimpl.nim.o \
c_code/2_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/7_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_1/@menumtostr.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/5_1/@msem.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/stdlib_dynlib.nim.o \
c_code/4_1/@mcgen.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/6_1/@mscriptconfig.nim.o \
c_code/2_1/@mnimconf.nim.o \
c_code/2_1/@mpassaux.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/2_1/@mjsgen.nim.o \
c_code/2_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/6_1/stdlib_rst.nim.o \
c_code/6_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/7_1/@mdocgen.nim.o \
c_code/3_1/@mdocgen2.nim.o \
c_code/2_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/4_1/stdlib_browsers.nim.o \
c_code/2_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_assertions.nim.c -o c_code/2_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_io.nim.c -o c_code/6_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_system.nim.c -o c_code/6_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseutils.nim.c -o c_code/2_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strutils.nim.c -o c_code/2_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_pathnorm.nim.c -o c_code/2_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/stdlib_posix.nim.c -o c_code/7_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/stdlib_times.nim.c -o c_code/7_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/stdlib_os.nim.c -o c_code/7_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_parseopt.nim.c -o c_code/6_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strtabs.nim.c -o c_code/2_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strformat.nim.c -o c_code/2_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_terminal.nim.c -o c_code/2_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/@mplatform.nim.c -o c_code/7_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptions.nim.c -o c_code/4_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mmsgs.nim.c -o c_code/6_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_streams.nim.c -o c_code/5_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_cpuinfo.nim.c -o c_code/6_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/stdlib_osproc.nim.c -o c_code/7_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parsejson.nim.c -o c_code/2_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_json.nim.c -o c_code/3_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_jsonutils.nim.c -o c_code/2_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/@mextccomp.nim.c -o c_code/7_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mnimblecmd.nim.c -o c_code/6_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcommands.nim.c -o c_code/5_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mllstream.nim.c -o c_code/6_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlexer.nim.c -o c_code/4_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderer.nim.c -o c_code/5_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msyntaxes.nim.c -o c_code/5_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_intsets.nim.c -o c_code/2_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtrees.nim.c -o c_code/2_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sic.nim.c -o c_code/5_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mtypes.nim.c -o c_code/3_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msemfold.nim.c -o c_code/3_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodulepaths.nim.c -o c_code/3_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimfix@sprettybase.nim.c -o c_code/2_2/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_editdistance.nim.c -o c_code/1_2/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msigmatch.nim.c -o c_code/4_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mpragmas.nim.c -o c_code/6_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpasses.nim.c -o c_code/2_2/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtreetab.nim.c -o c_code/2_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mgorgeimpl.nim.c -o c_code/5_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmacrocacheimpl.nim.c -o c_code/2_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/@mvm.nim.c -o c_code/7_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@slocals.nim.c -o c_code/2_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@menumtostr.nim.c -o c_code/2_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msem.nim.c -o c_code/5_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_dynlib.nim.c -o c_code/2_2/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgen.nim.c -o c_code/4_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mscriptconfig.nim.c -o c_code/6_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimconf.nim.c -o c_code/2_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpassaux.nim.c -o c_code/2_2/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mjsgen.nim.c -o c_code/5_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_rstast.nim.c -o c_code/2_2/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_highlite.nim.c -o c_code/1_2/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_rst.nim.c -o c_code/6_2/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_rstgen.nim.c -o c_code/6_2/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_xmltree.nim.c -o c_code/1_2/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_base64.nim.c -o c_code/1_2/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_uri.nim.c -o c_code/1_2/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_2/@mdocgen.nim.c -o c_code/7_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen2.nim.c -o c_code/3_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmain.nim.c -o c_code/5_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/stdlib_browsers.nim.c -o c_code/4_2/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mnim.nim.c -o c_code/6_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/stdlib_digitsutils.nim.o \
c_code/2_2/stdlib_assertions.nim.o \
c_code/1_2/stdlib_dragonbox.nim.o \
c_code/1_2/stdlib_schubfach.nim.o \
c_code/1_2/stdlib_formatfloat.nim.o \
c_code/1_2/stdlib_dollars.nim.o \
c_code/6_2/stdlib_io.nim.o \
c_code/6_2/stdlib_system.nim.o \
c_code/2_2/stdlib_parseutils.nim.o \
c_code/2_2/stdlib_math.nim.o \
c_code/2_2/stdlib_unicode.nim.o \
c_code/2_2/stdlib_strutils.nim.o \
c_code/2_2/stdlib_pathnorm.nim.o \
c_code/7_2/stdlib_posix.nim.o \
c_code/7_2/stdlib_times.nim.o \
c_code/7_2/stdlib_os.nim.o \
c_code/6_2/stdlib_parseopt.nim.o \
c_code/1_2/stdlib_hashes.nim.o \
c_code/2_2/stdlib_strtabs.nim.o \
c_code/2_2/stdlib_strformat.nim.o \
c_code/2_2/stdlib_terminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/7_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/stdlib_globs.nim.o \
c_code/4_2/@moptions.nim.o \
c_code/2_2/@mstrutils2.nim.o \
c_code/6_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/5_2/stdlib_streams.nim.o \
c_code/6_2/stdlib_cpuinfo.nim.o \
c_code/7_2/stdlib_osproc.nim.o \
c_code/2_4/stdlib_sha1.nim.o \
c_code/1_2/stdlib_lexbase.nim.o \
c_code/2_2/stdlib_parsejson.nim.o \
c_code/3_2/stdlib_json.nim.o \
c_code/2_2/stdlib_jsonutils.nim.o \
c_code/7_2/@mextccomp.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/6_2/@mnimblecmd.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/2_2/@mast.nim.o \
c_code/5_2/@mcommands.nim.o \
c_code/6_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/4_2/@mlexer.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/5_2/@mrenderer.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/5_2/@msyntaxes.nim.o \
c_code/1_2/stdlib_packedsets.nim.o \
c_code/2_2/stdlib_intsets.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/2_2/@mtrees.nim.o \
c_code/1_2/stdlib_md5.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/5_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/3_2/@mtypes.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/3_2/@msemfold.nim.o \
c_code/3_2/@mmodulepaths.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@mnimfix@sprettybase.nim.o \
c_code/1_2/stdlib_editdistance.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/4_2/@msigmatch.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/6_2/@mpragmas.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mpasses.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mtreetab.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/5_2/@mgorgeimpl.nim.o \
c_code/2_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/7_2/@mvm.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/2_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/2_2/@menumtostr.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/5_2/@msem.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/stdlib_dynlib.nim.o \
c_code/4_2/@mcgen.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/6_2/@mscriptconfig.nim.o \
c_code/2_2/@mnimconf.nim.o \
c_code/2_2/@mpassaux.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/5_2/@mjsgen.nim.o \
c_code/2_2/stdlib_rstast.nim.o \
c_code/1_2/stdlib_highlite.nim.o \
c_code/6_2/stdlib_rst.nim.o \
c_code/6_2/stdlib_rstgen.nim.o \
c_code/1_2/stdlib_xmltree.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/stdlib_base64.nim.o \
c_code/1_2/stdlib_uri.nim.o \
c_code/7_2/@mdocgen.nim.o \
c_code/3_2/@mdocgen2.nim.o \
c_code/5_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/4_2/stdlib_browsers.nim.o \
c_code/6_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_digitsutils.nim.c -o c_code/2_7/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_assertions.nim.c -o c_code/2_7/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dragonbox.nim.c -o c_code/2_7/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_schubfach.nim.c -o c_code/2_7/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_formatfloat.nim.c -o c_code/2_7/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dollars.nim.c -o c_code/2_7/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_io.nim.c -o c_code/7_7/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_system.nim.c -o c_code/7_7/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parseutils.nim.c -o c_code/2_7/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_math.nim.c -o c_code/2_7/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_unicode.nim.c -o c_code/2_7/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strutils.nim.c -o c_code/2_7/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_pathnorm.nim.c -o c_code/2_7/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_posix.nim.c -o c_code/7_7/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_times.nim.c -o c_code/2_7/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_os.nim.c -o c_code/7_7/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parseopt.nim.c -o c_code/2_7/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_hashes.nim.c -o c_code/2_7/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strtabs.nim.c -o c_code/2_7/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_strformat.nim.c -o c_code/2_7/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_terminal.nim.c -o c_code/2_7/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpathutils.nim.c -o c_code/2_7/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mropes.nim.c -o c_code/2_7/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlineinfos.nim.c -o c_code/2_7/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mplatform.nim.c -o c_code/7_7/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprefixmatches.nim.c -o c_code/2_7/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimpaths.nim.c -o c_code/2_7/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_globs.nim.c -o c_code/2_7/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@moptions.nim.c -o c_code/7_7/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mstrutils2.nim.c -o c_code/2_7/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mmsgs.nim.c -o c_code/7_7/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcondsyms.nim.c -o c_code/2_7/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_streams.nim.c -o c_code/5_7/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_cpuinfo.nim.c -o c_code/7_7/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_osproc.nim.c -o c_code/7_7/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_sha1.nim.c -o c_code/2_7/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_lexbase.nim.c -o c_code/2_7/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_parsejson.nim.c -o c_code/2_7/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_json.nim.c -o c_code/5_7/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_jsonutils.nim.c -o c_code/2_7/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mextccomp.nim.c -o c_code/7_7/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mwordrecg.nim.c -o c_code/2_7/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mnimblecmd.nim.c -o c_code/7_7/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@midents.nim.c -o c_code/2_7/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mint128.nim.c -o c_code/2_7/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mast.nim.c -o c_code/2_7/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcommands.nim.c -o c_code/5_7/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mllstream.nim.c -o c_code/2_7/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimlexbase.nim.c -o c_code/2_7/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlexer.nim.c -o c_code/5_7/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparser.nim.c -o c_code/2_7/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderer.nim.c -o c_code/2_7/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilters.nim.c -o c_code/2_7/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilter_tmpl.nim.c -o c_code/2_7/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msyntaxes.nim.c -o c_code/2_7/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_packedsets.nim.c -o c_code/2_7/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_intsets.nim.c -o c_code/2_7/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastalgo.nim.c -o c_code/2_7/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtrees.nim.c -o c_code/2_7/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_md5.nim.c -o c_code/2_7/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@srodfiles.nim.c -o c_code/2_7/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@spacked_ast.nim.c -o c_code/2_7/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sic.nim.c -o c_code/2_7/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulegraphs.nim.c -o c_code/2_7/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastmsgs.nim.c -o c_code/2_7/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypes.nim.c -o c_code/5_7/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmagicsys.nim.c -o c_code/2_7/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbitsets.nim.c -o c_code/2_7/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimsets.nim.c -o c_code/2_7/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemfold.nim.c -o c_code/5_7/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodulepaths.nim.c -o c_code/5_7/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdef.nim.c -o c_code/2_7/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemdata.nim.c -o c_code/2_7/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlinter.nim.c -o c_code/2_7/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimfix@sprettybase.nim.c -o c_code/2_7/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_editdistance.nim.c -o c_code/2_7/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlookups.nim.c -o c_code/2_7/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mconcepts.nim.c -o c_code/2_7/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemtypinst.nim.c -o c_code/2_7/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparampatterns.nim.c -o c_code/2_7/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlowerings.nim.c -o c_code/2_7/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msigmatch.nim.c -o c_code/5_7/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mimporter.nim.c -o c_code/2_7/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprocfind.nim.c -o c_code/2_7/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mpragmas.nim.c -o c_code/7_7/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mreorder.nim.c -o c_code/2_7/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpasses.nim.c -o c_code/2_7/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msaturate.nim.c -o c_code/2_7/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mguards.nim.c -o c_code/2_7/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypeallowed.nim.c -o c_code/2_7/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@misolation_check.nim.c -o c_code/2_7/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvarpartitions.nim.c -o c_code/2_7/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtreetab.nim.c -o c_code/2_7/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnilcheck.nim.c -o c_code/2_7/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@merrorhandling.nim.c -o c_code/2_7/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msighashes.nim.c -o c_code/2_7/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mndi.nim.c -o c_code/2_7/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgendata.nim.c -o c_code/2_7/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mccgutils.nim.c -o c_code/2_7/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftdestructors.nim.c -o c_code/2_7/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msempass2.nim.c -o c_code/2_7/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgmeth.nim.c -o c_code/2_7/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftlocals.nim.c -o c_code/2_7/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlambdalifting.nim.c -o c_code/2_7/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mclosureiters.nim.c -o c_code/2_7/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtransf.nim.c -o c_code/2_7/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmgen.nim.c -o c_code/2_7/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmdeps.nim.c -o c_code/5_7/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmmarshal.nim.c -o c_code/2_7/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mgorgeimpl.nim.c -o c_code/5_7/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmacrocacheimpl.nim.c -o c_code/2_7/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmprofiler.nim.c -o c_code/2_7/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mevaltempl.nim.c -o c_code/2_7/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mvm.nim.c -o c_code/7_7/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@maliases.nim.c -o c_code/2_7/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpatterns.nim.c -o c_code/2_7/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemmacrosanity.nim.c -o c_code/2_7/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpluginsupport.nim.c -o c_code/2_7/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@slocals.nim.c -o c_code/2_7/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sitersgen.nim.c -o c_code/2_7/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sactive.nim.c -o c_code/2_7/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@menumtostr.nim.c -o c_code/2_7/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mspawn.nim.c -o c_code/2_7/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msem.nim.c -o c_code/5_7/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdfa.nim.c -o c_code/2_7/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptimizer.nim.c -o c_code/2_7/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@minjectdestructors.nim.c -o c_code/2_7/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemparallel.nim.c -o c_code/2_7/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_dynlib.nim.c -o c_code/2_7/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgen.nim.c -o c_code/5_7/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sreplayer.nim.c -o c_code/2_7/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodules.nim.c -o c_code/2_7/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mscriptconfig.nim.c -o c_code/7_7/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimconf.nim.c -o c_code/2_7/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpassaux.nim.c -o c_code/2_7/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdepends.nim.c -o c_code/2_7/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sdce.nim.c -o c_code/2_7/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@scbackend.nim.c -o c_code/2_7/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sintegrity.nim.c -o c_code/2_7/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@snavigator.nim.c -o c_code/2_7/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msourcemap.nim.c -o c_code/2_7/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mjsgen.nim.c -o c_code/2_7/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_rstast.nim.c -o c_code/2_7/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_highlite.nim.c -o c_code/2_7/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_rst.nim.c -o c_code/7_7/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/stdlib_rstgen.nim.c -o c_code/7_7/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_xmltree.nim.c -o c_code/2_7/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypesrenderer.nim.c -o c_code/2_7/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderverbatim.nim.c -o c_code/2_7/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_base64.nim.c -o c_code/2_7/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/stdlib_uri.nim.c -o c_code/2_7/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_7/@mdocgen.nim.c -o c_code/7_7/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdocgen2.nim.c -o c_code/5_7/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmain.nim.c -o c_code/2_7/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcmdlinehelper.nim.c -o c_code/2_7/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/stdlib_browsers.nim.c -o c_code/5_7/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnim.nim.c -o c_code/2_7/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_7/stdlib_digitsutils.nim.o \
c_code/2_7/stdlib_assertions.nim.o \
c_code/2_7/stdlib_dragonbox.nim.o \
c_code/2_7/stdlib_schubfach.nim.o \
c_code/2_7/stdlib_formatfloat.nim.o \
c_code/2_7/stdlib_dollars.nim.o \
c_code/7_7/stdlib_io.nim.o \
c_code/7_7/stdlib_system.nim.o \
c_code/2_7/stdlib_parseutils.nim.o \
c_code/2_7/stdlib_math.nim.o \
c_code/2_7/stdlib_unicode.nim.o \
c_code/2_7/stdlib_strutils.nim.o \
c_code/2_7/stdlib_pathnorm.nim.o \
c_code/7_7/stdlib_posix.nim.o \
c_code/2_7/stdlib_times.nim.o \
c_code/7_7/stdlib_os.nim.o \
c_code/2_7/stdlib_parseopt.nim.o \
c_code/2_7/stdlib_hashes.nim.o \
c_code/2_7/stdlib_strtabs.nim.o \
c_code/2_7/stdlib_strformat.nim.o \
c_code/2_7/stdlib_terminal.nim.o \
c_code/2_7/@mpathutils.nim.o \
c_code/2_7/@mropes.nim.o \
c_code/2_7/@mlineinfos.nim.o \
c_code/7_7/@mplatform.nim.o \
c_code/2_7/@mprefixmatches.nim.o \
c_code/2_7/@mnimpaths.nim.o \
c_code/2_7/stdlib_globs.nim.o \
c_code/7_7/@moptions.nim.o \
c_code/2_7/@mstrutils2.nim.o \
c_code/7_7/@mmsgs.nim.o \
c_code/2_7/@mcondsyms.nim.o \
c_code/5_7/stdlib_streams.nim.o \
c_code/7_7/stdlib_cpuinfo.nim.o \
c_code/7_7/stdlib_osproc.nim.o \
c_code/2_7/stdlib_sha1.nim.o \
c_code/2_7/stdlib_lexbase.nim.o \
c_code/2_7/stdlib_parsejson.nim.o \
c_code/5_7/stdlib_json.nim.o \
c_code/2_7/stdlib_jsonutils.nim.o \
c_code/7_7/@mextccomp.nim.o \
c_code/2_7/@mwordrecg.nim.o \
c_code/7_7/@mnimblecmd.nim.o \
c_code/2_7/@midents.nim.o \
c_code/2_7/@mint128.nim.o \
c_code/2_7/@mast.nim.o \
c_code/5_7/@mcommands.nim.o \
c_code/2_7/@mllstream.nim.o \
c_code/2_7/@mnimlexbase.nim.o \
c_code/5_7/@mlexer.nim.o \
c_code/2_7/@mparser.nim.o \
c_code/2_7/@mrenderer.nim.o \
c_code/2_7/@mfilters.nim.o \
c_code/2_7/@mfilter_tmpl.nim.o \
c_code/2_7/@msyntaxes.nim.o \
c_code/2_7/stdlib_packedsets.nim.o \
c_code/2_7/stdlib_intsets.nim.o \
c_code/2_7/@mastalgo.nim.o \
c_code/2_7/@mtrees.nim.o \
c_code/2_7/stdlib_md5.nim.o \
c_code/2_7/@mic@srodfiles.nim.o \
c_code/2_7/@mic@spacked_ast.nim.o \
c_code/2_7/@mic@sic.nim.o \
c_code/2_7/@mmodulegraphs.nim.o \
c_code/2_7/@mastmsgs.nim.o \
c_code/5_7/@mtypes.nim.o \
c_code/2_7/@mmagicsys.nim.o \
c_code/2_7/@mbitsets.nim.o \
c_code/2_7/@mnimsets.nim.o \
c_code/5_7/@msemfold.nim.o \
c_code/5_7/@mmodulepaths.nim.o \
c_code/2_7/@mvmdef.nim.o \
c_code/2_7/@msemdata.nim.o \
c_code/2_7/@mlinter.nim.o \
c_code/2_7/@mnimfix@sprettybase.nim.o \
c_code/2_7/stdlib_editdistance.nim.o \
c_code/2_7/@mlookups.nim.o \
c_code/2_7/@mconcepts.nim.o \
c_code/2_7/@msemtypinst.nim.o \
c_code/2_7/@mparampatterns.nim.o \
c_code/2_7/@mlowerings.nim.o \
c_code/5_7/@msigmatch.nim.o \
c_code/2_7/@mimporter.nim.o \
c_code/2_7/@mprocfind.nim.o \
c_code/7_7/@mpragmas.nim.o \
c_code/2_7/@mreorder.nim.o \
c_code/2_7/@mpasses.nim.o \
c_code/2_7/@msaturate.nim.o \
c_code/2_7/@mguards.nim.o \
c_code/2_7/@mtypeallowed.nim.o \
c_code/2_7/@misolation_check.nim.o \
c_code/2_7/@mvarpartitions.nim.o \
c_code/2_7/@mtreetab.nim.o \
c_code/2_7/@mnilcheck.nim.o \
c_code/2_7/@merrorhandling.nim.o \
c_code/2_7/@msighashes.nim.o \
c_code/2_7/@mndi.nim.o \
c_code/2_7/@mcgendata.nim.o \
c_code/2_7/@mccgutils.nim.o \
c_code/2_7/@mliftdestructors.nim.o \
c_code/2_7/@msempass2.nim.o \
c_code/2_7/@mcgmeth.nim.o \
c_code/2_7/@mliftlocals.nim.o \
c_code/2_7/@mlambdalifting.nim.o \
c_code/2_7/@mclosureiters.nim.o \
c_code/2_7/@mtransf.nim.o \
c_code/2_7/@mvmgen.nim.o \
c_code/5_7/@mvmdeps.nim.o \
c_code/2_7/@mvmmarshal.nim.o \
c_code/5_7/@mgorgeimpl.nim.o \
c_code/2_7/@mmacrocacheimpl.nim.o \
c_code/2_7/@mvmprofiler.nim.o \
c_code/2_7/@mevaltempl.nim.o \
c_code/7_7/@mvm.nim.o \
c_code/2_7/@maliases.nim.o \
c_code/2_7/@mpatterns.nim.o \
c_code/2_7/@msemmacrosanity.nim.o \
c_code/2_7/@mpluginsupport.nim.o \
c_code/2_7/@mplugins@slocals.nim.o \
c_code/2_7/@mplugins@sitersgen.nim.o \
c_code/2_7/@mplugins@sactive.nim.o \
c_code/2_7/@menumtostr.nim.o \
c_code/2_7/@mspawn.nim.o \
c_code/5_7/@msem.nim.o \
c_code/2_7/@mdfa.nim.o \
c_code/2_7/@moptimizer.nim.o \
c_code/2_7/@minjectdestructors.nim.o \
c_code/2_7/@msemparallel.nim.o \
c_code/2_7/stdlib_dynlib.nim.o \
c_code/5_7/@mcgen.nim.o \
c_code/2_7/@mic@sreplayer.nim.o \
c_code/2_7/@mmodules.nim.o \
c_code/7_7/@mscriptconfig.nim.o \
c_code/2_7/@mnimconf.nim.o \
c_code/2_7/@mpassaux.nim.o \
c_code/2_7/@mdepends.nim.o \
c_code/2_7/@mic@sdce.nim.o \
c_code/2_7/@mic@scbackend.nim.o \
c_code/2_7/@mic@sintegrity.nim.o \
c_code/2_7/@mic@snavigator.nim.o \
c_code/2_7/@msourcemap.nim.o \
c_code/2_7/@mjsgen.nim.o \
c_code/2_7/stdlib_rstast.nim.o \
c_code/2_7/stdlib_highlite.nim.o \
c_code/7_7/stdlib_rst.nim.o \
c_code/7_7/stdlib_rstgen.nim.o \
c_code/2_7/stdlib_xmltree.nim.o \
c_code/2_7/@mtypesrenderer.nim.o \
c_code/2_7/@mrenderverbatim.nim.o \
c_code/2_7/stdlib_base64.nim.o \
c_code/2_7/stdlib_uri.nim.o \
c_code/7_7/@mdocgen.nim.o \
c_code/5_7/@mdocgen2.nim.o \
c_code/2_7/@mmain.nim.o \
c_code/2_7/@mcmdlinehelper.nim.o \
c_code/5_7/stdlib_browsers.nim.o \
c_code/2_7/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_digitsutils.nim.c -o c_code/2_17/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_assertions.nim.c -o c_code/2_17/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dragonbox.nim.c -o c_code/2_17/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_schubfach.nim.c -o c_code/2_17/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_formatfloat.nim.c -o c_code/2_17/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dollars.nim.c -o c_code/2_17/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_io.nim.c -o c_code/7_17/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_system.nim.c -o c_code/7_17/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parseutils.nim.c -o c_code/2_17/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_math.nim.c -o c_code/2_17/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_unicode.nim.c -o c_code/2_17/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strutils.nim.c -o c_code/2_17/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_pathnorm.nim.c -o c_code/2_17/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_posix.nim.c -o c_code/7_17/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_times.nim.c -o c_code/2_17/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_os.nim.c -o c_code/7_17/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parseopt.nim.c -o c_code/2_17/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_hashes.nim.c -o c_code/2_17/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strtabs.nim.c -o c_code/2_17/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_strformat.nim.c -o c_code/2_17/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_terminal.nim.c -o c_code/2_17/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpathutils.nim.c -o c_code/2_17/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mropes.nim.c -o c_code/2_17/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlineinfos.nim.c -o c_code/2_17/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mplatform.nim.c -o c_code/7_17/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprefixmatches.nim.c -o c_code/2_17/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimpaths.nim.c -o c_code/2_17/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_globs.nim.c -o c_code/2_17/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@moptions.nim.c -o c_code/7_17/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mstrutils2.nim.c -o c_code/2_17/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mmsgs.nim.c -o c_code/7_17/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcondsyms.nim.c -o c_code/2_17/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_streams.nim.c -o c_code/5_17/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_cpuinfo.nim.c -o c_code/7_17/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_osproc.nim.c -o c_code/7_17/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_sha1.nim.c -o c_code/2_17/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_lexbase.nim.c -o c_code/2_17/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_parsejson.nim.c -o c_code/2_17/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/stdlib_json.nim.c -o c_code/3_17/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_jsonutils.nim.c -o c_code/2_17/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mextccomp.nim.c -o c_code/7_17/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mwordrecg.nim.c -o c_code/2_17/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mnimblecmd.nim.c -o c_code/7_17/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@midents.nim.c -o c_code/2_17/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mint128.nim.c -o c_code/2_17/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mast.nim.c -o c_code/2_17/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mcommands.nim.c -o c_code/5_17/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mllstream.nim.c -o c_code/2_17/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimlexbase.nim.c -o c_code/2_17/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mlexer.nim.c -o c_code/5_17/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparser.nim.c -o c_code/2_17/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderer.nim.c -o c_code/2_17/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilters.nim.c -o c_code/2_17/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilter_tmpl.nim.c -o c_code/2_17/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msyntaxes.nim.c -o c_code/2_17/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_packedsets.nim.c -o c_code/2_17/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_intsets.nim.c -o c_code/2_17/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastalgo.nim.c -o c_code/2_17/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtrees.nim.c -o c_code/2_17/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_md5.nim.c -o c_code/2_17/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@srodfiles.nim.c -o c_code/2_17/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@spacked_ast.nim.c -o c_code/2_17/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sic.nim.c -o c_code/2_17/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulegraphs.nim.c -o c_code/2_17/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastmsgs.nim.c -o c_code/2_17/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mtypes.nim.c -o c_code/3_17/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmagicsys.nim.c -o c_code/2_17/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mbitsets.nim.c -o c_code/2_17/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimsets.nim.c -o c_code/2_17/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msemfold.nim.c -o c_code/3_17/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmodulepaths.nim.c -o c_code/3_17/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmdef.nim.c -o c_code/2_17/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemdata.nim.c -o c_code/2_17/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlinter.nim.c -o c_code/2_17/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimfix@sprettybase.nim.c -o c_code/2_17/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_editdistance.nim.c -o c_code/2_17/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlookups.nim.c -o c_code/2_17/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mconcepts.nim.c -o c_code/2_17/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemtypinst.nim.c -o c_code/2_17/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparampatterns.nim.c -o c_code/2_17/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlowerings.nim.c -o c_code/2_17/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@msigmatch.nim.c -o c_code/5_17/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mimporter.nim.c -o c_code/2_17/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprocfind.nim.c -o c_code/2_17/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mpragmas.nim.c -o c_code/7_17/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mreorder.nim.c -o c_code/2_17/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpasses.nim.c -o c_code/2_17/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msaturate.nim.c -o c_code/2_17/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mguards.nim.c -o c_code/2_17/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypeallowed.nim.c -o c_code/2_17/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@misolation_check.nim.c -o c_code/2_17/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvarpartitions.nim.c -o c_code/2_17/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtreetab.nim.c -o c_code/2_17/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnilcheck.nim.c -o c_code/2_17/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@merrorhandling.nim.c -o c_code/2_17/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msighashes.nim.c -o c_code/2_17/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mndi.nim.c -o c_code/2_17/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgendata.nim.c -o c_code/2_17/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mccgutils.nim.c -o c_code/2_17/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftdestructors.nim.c -o c_code/2_17/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msempass2.nim.c -o c_code/2_17/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgmeth.nim.c -o c_code/2_17/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftlocals.nim.c -o c_code/2_17/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlambdalifting.nim.c -o c_code/2_17/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mclosureiters.nim.c -o c_code/2_17/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtransf.nim.c -o c_code/2_17/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmgen.nim.c -o c_code/2_17/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mvmdeps.nim.c -o c_code/5_17/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmmarshal.nim.c -o c_code/2_17/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mgorgeimpl.nim.c -o c_code/5_17/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmacrocacheimpl.nim.c -o c_code/2_17/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmprofiler.nim.c -o c_code/2_17/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mevaltempl.nim.c -o c_code/2_17/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mvm.nim.c -o c_code/7_17/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliases.nim.c -o c_code/2_17/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpatterns.nim.c -o c_code/2_17/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemmacrosanity.nim.c -o c_code/2_17/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpluginsupport.nim.c -o c_code/2_17/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@slocals.nim.c -o c_code/2_17/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sitersgen.nim.c -o c_code/2_17/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sactive.nim.c -o c_code/2_17/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@menumtostr.nim.c -o c_code/2_17/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mspawn.nim.c -o c_code/2_17/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@msem.nim.c -o c_code/5_17/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdfa.nim.c -o c_code/2_17/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptimizer.nim.c -o c_code/2_17/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@minjectdestructors.nim.c -o c_code/2_17/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemparallel.nim.c -o c_code/2_17/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_dynlib.nim.c -o c_code/2_17/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/@mcgen.nim.c -o c_code/5_17/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sreplayer.nim.c -o c_code/2_17/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodules.nim.c -o c_code/2_17/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mscriptconfig.nim.c -o c_code/7_17/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimconf.nim.c -o c_code/2_17/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpassaux.nim.c -o c_code/2_17/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdepends.nim.c -o c_code/2_17/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sdce.nim.c -o c_code/2_17/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@scbackend.nim.c -o c_code/2_17/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sintegrity.nim.c -o c_code/2_17/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@snavigator.nim.c -o c_code/2_17/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msourcemap.nim.c -o c_code/2_17/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mjsgen.nim.c -o c_code/2_17/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_rstast.nim.c -o c_code/2_17/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_highlite.nim.c -o c_code/2_17/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_rst.nim.c -o c_code/7_17/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/stdlib_rstgen.nim.c -o c_code/7_17/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_xmltree.nim.c -o c_code/2_17/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypesrenderer.nim.c -o c_code/2_17/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderverbatim.nim.c -o c_code/2_17/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_base64.nim.c -o c_code/2_17/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/stdlib_uri.nim.c -o c_code/2_17/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/7_17/@mdocgen.nim.c -o c_code/7_17/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mdocgen2.nim.c -o c_code/3_17/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmain.nim.c -o c_code/2_17/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcmdlinehelper.nim.c -o c_code/2_17/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_17/stdlib_browsers.nim.c -o c_code/5_17/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnim.nim.c -o c_code/2_17/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_17/stdlib_digitsutils.nim.o \
c_code/2_17/stdlib_assertions.nim.o \
c_code/2_17/stdlib_dragonbox.nim.o \
c_code/2_17/stdlib_schubfach.nim.o \
c_code/2_17/stdlib_formatfloat.nim.o \
c_code/2_17/stdlib_dollars.nim.o \
c_code/7_17/stdlib_io.nim.o \
c_code/7_17/stdlib_system.nim.o \
c_code/2_17/stdlib_parseutils.nim.o \
c_code/2_17/stdlib_math.nim.o \
c_code/2_17/stdlib_unicode.nim.o \
c_code/2_17/stdlib_strutils.nim.o \
c_code/2_17/stdlib_pathnorm.nim.o \
c_code/7_17/stdlib_posix.nim.o \
c_code/2_17/stdlib_times.nim.o \
c_code/7_17/stdlib_os.nim.o \
c_code/2_17/stdlib_parseopt.nim.o \
c_code/2_17/stdlib_hashes.nim.o \
c_code/2_17/stdlib_strtabs.nim.o \
c_code/2_17/stdlib_strformat.nim.o \
c_code/2_17/stdlib_terminal.nim.o \
c_code/2_17/@mpathutils.nim.o \
c_code/2_17/@mropes.nim.o \
c_code/2_17/@mlineinfos.nim.o \
c_code/7_17/@mplatform.nim.o \
c_code/2_17/@mprefixmatches.nim.o \
c_code/2_17/@mnimpaths.nim.o \
c_code/2_17/stdlib_globs.nim.o \
c_code/7_17/@moptions.nim.o \
c_code/2_17/@mstrutils2.nim.o \
c_code/7_17/@mmsgs.nim.o \
c_code/2_17/@mcondsyms.nim.o \
c_code/5_17/stdlib_streams.nim.o \
c_code/7_17/stdlib_cpuinfo.nim.o \
c_code/7_17/stdlib_osproc.nim.o \
c_code/2_17/stdlib_sha1.nim.o \
c_code/2_17/stdlib_lexbase.nim.o \
c_code/2_17/stdlib_parsejson.nim.o \
c_code/3_17/stdlib_json.nim.o \
c_code/2_17/stdlib_jsonutils.nim.o \
c_code/7_17/@mextccomp.nim.o \
c_code/2_17/@mwordrecg.nim.o \
c_code/7_17/@mnimblecmd.nim.o \
c_code/2_17/@midents.nim.o \
c_code/2_17/@mint128.nim.o \
c_code/2_17/@mast.nim.o \
c_code/5_17/@mcommands.nim.o \
c_code/2_17/@mllstream.nim.o \
c_code/2_17/@mnimlexbase.nim.o \
c_code/5_17/@mlexer.nim.o \
c_code/2_17/@mparser.nim.o \
c_code/2_17/@mrenderer.nim.o \
c_code/2_17/@mfilters.nim.o \
c_code/2_17/@mfilter_tmpl.nim.o \
c_code/2_17/@msyntaxes.nim.o \
c_code/2_17/stdlib_packedsets.nim.o \
c_code/2_17/stdlib_intsets.nim.o \
c_code/2_17/@mastalgo.nim.o \
c_code/2_17/@mtrees.nim.o \
c_code/2_17/stdlib_md5.nim.o \
c_code/2_17/@mic@srodfiles.nim.o \
c_code/2_17/@mic@spacked_ast.nim.o \
c_code/2_17/@mic@sic.nim.o \
c_code/2_17/@mmodulegraphs.nim.o \
c_code/2_17/@mastmsgs.nim.o \
c_code/3_17/@mtypes.nim.o \
c_code/2_17/@mmagicsys.nim.o \
c_code/2_17/@mbitsets.nim.o \
c_code/2_17/@mnimsets.nim.o \
c_code/3_17/@msemfold.nim.o \
c_code/3_17/@mmodulepaths.nim.o \
c_code/2_17/@mvmdef.nim.o \
c_code/2_17/@msemdata.nim.o \
c_code/2_17/@mlinter.nim.o \
c_code/2_17/@mnimfix@sprettybase.nim.o \
c_code/2_17/stdlib_editdistance.nim.o \
c_code/2_17/@mlookups.nim.o \
c_code/2_17/@mconcepts.nim.o \
c_code/2_17/@msemtypinst.nim.o \
c_code/2_17/@mparampatterns.nim.o \
c_code/2_17/@mlowerings.nim.o \
c_code/5_17/@msigmatch.nim.o \
c_code/2_17/@mimporter.nim.o \
c_code/2_17/@mprocfind.nim.o \
c_code/7_17/@mpragmas.nim.o \
c_code/2_17/@mreorder.nim.o \
c_code/2_17/@mpasses.nim.o \
c_code/2_17/@msaturate.nim.o \
c_code/2_17/@mguards.nim.o \
c_code/2_17/@mtypeallowed.nim.o \
c_code/2_17/@misolation_check.nim.o \
c_code/2_17/@mvarpartitions.nim.o \
c_code/2_17/@mtreetab.nim.o \
c_code/2_17/@mnilcheck.nim.o \
c_code/2_17/@merrorhandling.nim.o \
c_code/2_17/@msighashes.nim.o \
c_code/2_17/@mndi.nim.o \
c_code/2_17/@mcgendata.nim.o \
c_code/2_17/@mccgutils.nim.o \
c_code/2_17/@mliftdestructors.nim.o \
c_code/2_17/@msempass2.nim.o \
c_code/2_17/@mcgmeth.nim.o \
c_code/2_17/@mliftlocals.nim.o \
c_code/2_17/@mlambdalifting.nim.o \
c_code/2_17/@mclosureiters.nim.o \
c_code/2_17/@mtransf.nim.o \
c_code/2_17/@mvmgen.nim.o \
c_code/5_17/@mvmdeps.nim.o \
c_code/2_17/@mvmmarshal.nim.o \
c_code/5_17/@mgorgeimpl.nim.o \
c_code/2_17/@mmacrocacheimpl.nim.o \
c_code/2_17/@mvmprofiler.nim.o \
c_code/2_17/@mevaltempl.nim.o \
c_code/7_17/@mvm.nim.o \
c_code/2_17/@maliases.nim.o \
c_code/2_17/@mpatterns.nim.o \
c_code/2_17/@msemmacrosanity.nim.o \
c_code/2_17/@mpluginsupport.nim.o \
c_code/2_17/@mplugins@slocals.nim.o \
c_code/2_17/@mplugins@sitersgen.nim.o \
c_code/2_17/@mplugins@sactive.nim.o \
c_code/2_17/@menumtostr.nim.o \
c_code/2_17/@mspawn.nim.o \
c_code/5_17/@msem.nim.o \
c_code/2_17/@mdfa.nim.o \
c_code/2_17/@moptimizer.nim.o \
c_code/2_17/@minjectdestructors.nim.o \
c_code/2_17/@msemparallel.nim.o \
c_code/2_17/stdlib_dynlib.nim.o \
c_code/5_17/@mcgen.nim.o \
c_code/2_17/@mic@sreplayer.nim.o \
c_code/2_17/@mmodules.nim.o \
c_code/7_17/@mscriptconfig.nim.o \
c_code/2_17/@mnimconf.nim.o \
c_code/2_17/@mpassaux.nim.o \
c_code/2_17/@mdepends.nim.o \
c_code/2_17/@mic@sdce.nim.o \
c_code/2_17/@mic@scbackend.nim.o \
c_code/2_17/@mic@sintegrity.nim.o \
c_code/2_17/@mic@snavigator.nim.o \
c_code/2_17/@msourcemap.nim.o \
c_code/2_17/@mjsgen.nim.o \
c_code/2_17/stdlib_rstast.nim.o \
c_code/2_17/stdlib_highlite.nim.o \
c_code/7_17/stdlib_rst.nim.o \
c_code/7_17/stdlib_rstgen.nim.o \
c_code/2_17/stdlib_xmltree.nim.o \
c_code/2_17/@mtypesrenderer.nim.o \
c_code/2_17/@mrenderverbatim.nim.o \
c_code/2_17/stdlib_base64.nim.o \
c_code/2_17/stdlib_uri.nim.o \
c_code/7_17/@mdocgen.nim.o \
c_code/3_17/@mdocgen2.nim.o \
c_code/2_17/@mmain.nim.o \
c_code/2_17/@mcmdlinehelper.nim.o \
c_code/5_17/stdlib_browsers.nim.o \
c_code/2_17/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
dragonfly)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_digitsutils.nim.c -o c_code/1_1/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_assertions.nim.c -o c_code/2_1/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dragonbox.nim.c -o c_code/1_1/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_schubfach.nim.c -o c_code/1_1/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_formatfloat.nim.c -o c_code/1_1/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_dollars.nim.c -o c_code/1_1/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_io.nim.c -o c_code/5_1/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/stdlib_system.nim.c -o c_code/8_1/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseutils.nim.c -o c_code/2_1/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_math.nim.c -o c_code/2_1/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_unicode.nim.c -o c_code/2_1/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strutils.nim.c -o c_code/2_1/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_pathnorm.nim.c -o c_code/2_1/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/stdlib_posix.nim.c -o c_code/8_1/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_times.nim.c -o c_code/2_1/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/stdlib_os.nim.c -o c_code/8_1/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parseopt.nim.c -o c_code/2_1/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_hashes.nim.c -o c_code/1_1/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strtabs.nim.c -o c_code/2_1/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_strformat.nim.c -o c_code/2_1/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_terminal.nim.c -o c_code/2_1/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/@mplatform.nim.c -o c_code/8_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_globs.nim.c -o c_code/2_1/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/@moptions.nim.c -o c_code/8_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mstrutils2.nim.c -o c_code/2_1/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmsgs.nim.c -o c_code/5_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_streams.nim.c -o c_code/5_1/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/stdlib_cpuinfo.nim.c -o c_code/8_1/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/stdlib_osproc.nim.c -o c_code/8_1/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_sha1.nim.c -o c_code/2_1/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_lexbase.nim.c -o c_code/1_1/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_parsejson.nim.c -o c_code/2_1/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/stdlib_json.nim.c -o c_code/3_1/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_jsonutils.nim.c -o c_code/2_1/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/@mextccomp.nim.c -o c_code/8_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mnimblecmd.nim.c -o c_code/6_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcommands.nim.c -o c_code/5_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mllstream.nim.c -o c_code/5_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlexer.nim.c -o c_code/4_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderer.nim.c -o c_code/2_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msyntaxes.nim.c -o c_code/2_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_packedsets.nim.c -o c_code/1_1/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_intsets.nim.c -o c_code/2_1/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtrees.nim.c -o c_code/2_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_md5.nim.c -o c_code/1_1/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mtypes.nim.c -o c_code/3_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msemfold.nim.c -o c_code/3_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodulepaths.nim.c -o c_code/3_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimfix@sprettybase.nim.c -o c_code/2_1/@mnimfix@sprettybase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_editdistance.nim.c -o c_code/1_1/stdlib_editdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msigmatch.nim.c -o c_code/4_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mpragmas.nim.c -o c_code/6_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpasses.nim.c -o c_code/2_1/@mpasses.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtreetab.nim.c -o c_code/2_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mgorgeimpl.nim.c -o c_code/5_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmacrocacheimpl.nim.c -o c_code/2_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/@mvm.nim.c -o c_code/6_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@slocals.nim.c -o c_code/2_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@menumtostr.nim.c -o c_code/2_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msem.nim.c -o c_code/5_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_dynlib.nim.c -o c_code/2_1/stdlib_dynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgen.nim.c -o c_code/4_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodules.nim.c -o c_code/3_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_1/@mscriptconfig.nim.c -o c_code/8_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimconf.nim.c -o c_code/3_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpassaux.nim.c -o c_code/2_1/@mpassaux.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mjsgen.nim.c -o c_code/2_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/stdlib_rstast.nim.c -o c_code/2_1/stdlib_rstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_highlite.nim.c -o c_code/1_1/stdlib_highlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/stdlib_rst.nim.c -o c_code/5_1/stdlib_rst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_1/stdlib_rstgen.nim.c -o c_code/6_1/stdlib_rstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_xmltree.nim.c -o c_code/1_1/stdlib_xmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_base64.nim.c -o c_code/1_1/stdlib_base64.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/stdlib_uri.nim.c -o c_code/1_1/stdlib_uri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdocgen.nim.c -o c_code/5_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen2.nim.c -o c_code/3_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmain.nim.c -o c_code/2_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/stdlib_browsers.nim.c -o c_code/4_1/stdlib_browsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnim.nim.c -o c_code/2_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/stdlib_digitsutils.nim.o \
c_code/2_1/stdlib_assertions.nim.o \
c_code/1_1/stdlib_dragonbox.nim.o \
c_code/1_1/stdlib_schubfach.nim.o \
c_code/1_1/stdlib_formatfloat.nim.o \
c_code/1_1/stdlib_dollars.nim.o \
c_code/5_1/stdlib_io.nim.o \
c_code/8_1/stdlib_system.nim.o \
c_code/2_1/stdlib_parseutils.nim.o \
c_code/2_1/stdlib_math.nim.o \
c_code/2_1/stdlib_unicode.nim.o \
c_code/2_1/stdlib_strutils.nim.o \
c_code/2_1/stdlib_pathnorm.nim.o \
c_code/8_1/stdlib_posix.nim.o \
c_code/2_1/stdlib_times.nim.o \
c_code/8_1/stdlib_os.nim.o \
c_code/2_1/stdlib_parseopt.nim.o \
c_code/1_1/stdlib_hashes.nim.o \
c_code/2_1/stdlib_strtabs.nim.o \
c_code/2_1/stdlib_strformat.nim.o \
c_code/2_1/stdlib_terminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/8_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/stdlib_globs.nim.o \
c_code/8_1/@moptions.nim.o \
c_code/2_1/@mstrutils2.nim.o \
c_code/5_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/5_1/stdlib_streams.nim.o \
c_code/8_1/stdlib_cpuinfo.nim.o \
c_code/8_1/stdlib_osproc.nim.o \
c_code/2_1/stdlib_sha1.nim.o \
c_code/1_1/stdlib_lexbase.nim.o \
c_code/2_1/stdlib_parsejson.nim.o \
c_code/3_1/stdlib_json.nim.o \
c_code/2_1/stdlib_jsonutils.nim.o \
c_code/8_1/@mextccomp.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/6_1/@mnimblecmd.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/2_1/@mast.nim.o \
c_code/5_1/@mcommands.nim.o \
c_code/5_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/4_1/@mlexer.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mrenderer.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/2_1/@msyntaxes.nim.o \
c_code/1_1/stdlib_packedsets.nim.o \
c_code/2_1/stdlib_intsets.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/2_1/@mtrees.nim.o \
c_code/1_1/stdlib_md5.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/3_1/@mtypes.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/3_1/@msemfold.nim.o \
c_code/3_1/@mmodulepaths.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@mnimfix@sprettybase.nim.o \
c_code/1_1/stdlib_editdistance.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/4_1/@msigmatch.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/6_1/@mpragmas.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mpasses.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mtreetab.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/5_1/@mgorgeimpl.nim.o \
c_code/2_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/6_1/@mvm.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/2_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/2_1/@menumtostr.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/5_1/@msem.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/stdlib_dynlib.nim.o \
c_code/4_1/@mcgen.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/3_1/@mmodules.nim.o \
c_code/8_1/@mscriptconfig.nim.o \
c_code/3_1/@mnimconf.nim.o \
c_code/2_1/@mpassaux.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/2_1/@mjsgen.nim.o \
c_code/2_1/stdlib_rstast.nim.o \
c_code/1_1/stdlib_highlite.nim.o \
c_code/5_1/stdlib_rst.nim.o \
c_code/6_1/stdlib_rstgen.nim.o \
c_code/1_1/stdlib_xmltree.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/stdlib_base64.nim.o \
c_code/1_1/stdlib_uri.nim.o \
c_code/5_1/@mdocgen.nim.o \
c_code/3_1/@mdocgen2.nim.o \
c_code/2_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/4_1/stdlib_browsers.nim.o \
c_code/2_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_digitsutils.nim.c -o c_code/1_2/stdlib_digitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_assertions.nim.c -o c_code/2_2/stdlib_assertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dragonbox.nim.c -o c_code/1_2/stdlib_dragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_schubfach.nim.c -o c_code/1_2/stdlib_schubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_formatfloat.nim.c -o c_code/1_2/stdlib_formatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_dollars.nim.c -o c_code/1_2/stdlib_dollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_io.nim.c -o c_code/5_2/stdlib_io.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/stdlib_system.nim.c -o c_code/8_2/stdlib_system.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parseutils.nim.c -o c_code/2_2/stdlib_parseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_math.nim.c -o c_code/2_2/stdlib_math.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_unicode.nim.c -o c_code/2_2/stdlib_unicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strutils.nim.c -o c_code/2_2/stdlib_strutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_pathnorm.nim.c -o c_code/2_2/stdlib_pathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/stdlib_posix.nim.c -o c_code/8_2/stdlib_posix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_times.nim.c -o c_code/5_2/stdlib_times.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/stdlib_os.nim.c -o c_code/8_2/stdlib_os.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/stdlib_parseopt.nim.c -o c_code/6_2/stdlib_parseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_hashes.nim.c -o c_code/1_2/stdlib_hashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strtabs.nim.c -o c_code/2_2/stdlib_strtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_strformat.nim.c -o c_code/2_2/stdlib_strformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_terminal.nim.c -o c_code/2_2/stdlib_terminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/@mplatform.nim.c -o c_code/8_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_globs.nim.c -o c_code/2_2/stdlib_globs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/@moptions.nim.c -o c_code/8_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mstrutils2.nim.c -o c_code/2_2/@mstrutils2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmsgs.nim.c -o c_code/5_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/stdlib_streams.nim.c -o c_code/5_2/stdlib_streams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/stdlib_cpuinfo.nim.c -o c_code/8_2/stdlib_cpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/stdlib_osproc.nim.c -o c_code/8_2/stdlib_osproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/stdlib_sha1.nim.c -o c_code/2_4/stdlib_sha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_lexbase.nim.c -o c_code/1_2/stdlib_lexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_parsejson.nim.c -o c_code/2_2/stdlib_parsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/stdlib_json.nim.c -o c_code/3_2/stdlib_json.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_jsonutils.nim.c -o c_code/2_2/stdlib_jsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/8_2/@mextccomp.nim.c -o c_code/8_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/6_2/@mnimblecmd.nim.c -o c_code/6_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcommands.nim.c -o c_code/5_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mllstream.nim.c -o c_code/5_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlexer.nim.c -o c_code/4_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderer.nim.c -o c_code/5_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msyntaxes.nim.c -o c_code/5_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_packedsets.nim.c -o c_code/1_2/stdlib_packedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/stdlib_intsets.nim.c -o c_code/2_2/stdlib_intsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtrees.nim.c -o c_code/2_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/stdlib_md5.nim.c -o c_code/1_2/stdlib_md5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sic.nim.c -o c_code/5_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mtypes.nim.c -o c_code/3_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAG