#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <libnjb.h>

#define PL_CREATE	1
#define PL_DELETE	2
#define PL_RENAME	3

void usage(void);

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	playlist_t *playlist;
	playlist_track_t *pl_track;
	int i, n, opt, mode, debug;
	char *name, *newname;
	extern int optind, njb_error;
	extern char *optarg;
	char *endptr;
	char *lang;

	debug= 0;
	mode= 0;
	name= NULL;
	newname = NULL;
	while ( (opt= getopt(argc, argv, "d:r:c:")) != -1 ) {
		switch (opt) {
		case 'c':
			mode= PL_CREATE;
			break;
		case 'd':
			mode= PL_DELETE;
			break;
		case 'r':
			mode= PL_RENAME;
			break;
		case 'D':
			debug= atoi(optarg);
			break;
		case '?':
		default:
			usage();
			return 1;
		}
		name= optarg;
	}
	argc-= optind;
	argv+= optind;

	if ( debug ) NJB_Set_Debug(debug);

	/*
	 * Check environment variables $LANG and $LC_CTYPE
	 * to see if we want to support UTF-8 unicode
	 * $LANG = "xx_XX.UTF-8" or $LC_CTYPE = "?"
	 * trigger unicode support.
	 */
	lang = getenv("LANG");
	if (lang != NULL) {
	  if (strlen(lang) > 5) {
	    if (!strcmp(&lang[strlen(lang)-5], "UTF-8")) {
	       NJB_Set_Unicode(NJB_UC_UTF8);
	    }
	  }
	}

	if ( ! mode ) {
		usage();
		return 1;
	}

	playlist = NULL;
	if ( mode == PL_CREATE ) {
		playlist= playlist_new();
		if ( playlist == NULL ) {
			perror("playlist_new");
			return 1;
		}

		if ( playlist_set_name(playlist, name) == -1 ) {
			njb_error_dump(stderr);
		} else {
			for (i= 0; i< argc; i++) {
				u_int32_t trid= strtoul(argv[i], &endptr, 10);
				if ( *endptr != '\0' ) {
					fprintf(stderr, "invalid track id %s",
						argv[i]);
					return 1;
				}

				pl_track= playlist_track_new(trid);
				if ( pl_track == NULL ) {
					perror("playlist_track_new");
					return 1;
				}

				playlist_addtrack(playlist, pl_track,
					NJB_PL_END);
			}

			playlist_dump(playlist, stdout);
		}
	} else if ( mode == PL_RENAME ) {
		newname= argv[0];
	}

	if ( NJB_Discover(njbs, 0, &n) == -1 ) njb_error_dump(stderr);
	if ( n == 0 ) {
		fprintf(stderr, "XXX no NJB devices found\n");
		return 0;
	}

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	if ( NJB_Capture(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	if ( mode == PL_CREATE ) {
		if ( NJB_Update_Playlist(njb, playlist) == -1 )
			njb_error_dump(stderr);
	} else {
		int status = 0;
		int repeat= 1;

		NJB_Reset_Get_Playlist(njb);
		while ( repeat ) {
			playlist= NJB_Get_Playlist(njb);
			if ( playlist == NULL ) { 
				repeat= 0;
			} else {
				repeat = strcmp(name, playlist->name);
				if ( repeat )
					playlist_destroy(playlist);
			}
		}

		if ( playlist == NULL ) {
			if ( njb_error == EO_EOM ) {
				fprintf(stderr, "XXX playlist \"%s\" not found\n",
					name);
			} else {
				njb_error_dump(stderr);
			}
		} else {
			if ( mode == PL_DELETE ) {
				status= NJB_Delete_Playlist(njb,
					playlist->plid);
			} else {
				if ( playlist_set_name(playlist, newname) == -1 ) {
					status= -1;
				} else {
					status= NJB_Update_Playlist(njb,
						playlist);
				}
			}
		}

		if ( status == -1 ) njb_error_dump(stderr);
	}

	NJB_Release(njb);

	NJB_Close(njb);

	return 0;
}

void usage (void)
{
	fprintf(stderr, "usage: njbplaylist [ -D debuglvl ] -d name\n\
       njbplaylist [ -D debuglvl ] -r oldname newname\n\
       njbplaylist [ -D debuglvl ] -c name trackid < trackid2 trackid3 ... >\n");
}

