#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <libnjb.h>

char *prompt (const char *prompt, char *buffer, size_t bufsz, int required);
int progress (u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data);
void usage(void);

char *strfrom(char *s);

int main(int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	int n, opt, debug;
	extern int optind;
	extern char *optarg;
	char *path;
	//char num[80];
	char *partist, *ptitle, *pgenre, *pcodec, *palbum; // *pnum;
	u_int32_t tracknum, length, size;
	struct stat sb;
	int trackid;
	char *lang;

	partist = "Unknown Artist";
	ptitle = "Unknown Title";
	pgenre = "Unknown";
	pcodec = "MP3";
	palbum = "Unknown Album";
	trackid = 0;
	tracknum = 0;
	length = 0;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:t:a:l:c:g:n:d:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		case 't':
			ptitle = strfrom(optarg);
			break;
		case 'a':
			partist = strfrom(optarg);
			break;
		case 'l':
			palbum = strfrom(optarg);
			break;
		case 'c':
			pcodec = strfrom(optarg); // XXX DSM check for MP3, WAV or WMA
			break;
		case 'g':
			pgenre = strfrom(optarg);
			break;
		case 'n':
			tracknum = atoi(optarg);
			break;
		case 'd':
			length = atoi(optarg);
			break;
		default:
			usage();
		}
	}
	argc-= optind;
	argv+= optind;

	if ( argc != 1 ) usage();
	if ( debug ) NJB_Set_Debug(debug);

	/*
	 * Check environment variables $LANG and $LC_CTYPE
	 * to see if we want to support UTF-8 unicode
	 * $LANG = "xx_XX.UTF-8" or $LC_CTYPE = "?"
	 * trigger unicode support.
	 */
	lang = getenv("LANG");
	if (lang != NULL) {
	  if (strlen(lang) > 5) {
	    if (!strcmp(&lang[strlen(lang)-5], "UTF-8")) {
	       NJB_Set_Unicode(NJB_UC_UTF8);
	    }
	  }
	}

	path= argv[0];

	if ( stat(path, &sb) == -1 ) {
		fprintf(stderr, "XXX %s: ", path);
		perror("stat");
		return 1;
	}
	size= (u_int32_t) sb.st_size;

	/*
	if ( (pcodec= prompt("Codec", codec, 80, 1)) == NULL ) return 1;

	if ( (ptitle= prompt("Title", title, 80, 0)) == NULL ) return 1;
	if ( ! strlen(ptitle) ) ptitle= NULL;

	if ( (palbum= prompt("Album", album, 80, 0)) == NULL ) return 1;
	if ( ! strlen(palbum) ) palbum= NULL;

	if ( (partist= prompt("Artist", artist, 80, 0)) == NULL ) return 1;
	if ( ! strlen(partist) ) partist= NULL;

	if ( (pgenre= prompt("Genre", genre, 80, 0)) == NULL ) return 1;
	if ( ! strlen(pgenre) ) pgenre= NULL;

	if ( (pnum= prompt("Track number", num, 80, 0)) == NULL ) return 1;
	if ( strlen(pnum) ) {
		tracknum= strtoul(pnum, 0, 10);
	} else {
		tracknum= 0;
	}

	if ( (pnum= prompt("Length", num, 80, 0)) == NULL ) return 1;
	if ( strlen(pnum) ) {
		length= strtoul(pnum, 0, 10);
	} else {
		length= 0;
	}
	*/

	if (!(ptitle && partist && palbum && pcodec && pgenre)) {
		usage();
		exit(1);
	}
	printf("Sending track:\n");
	printf("Codec:     %s\n", pcodec);
	if (ptitle) printf("Title:     %s\n", ptitle);
	if (palbum) printf("Album:     %s\n", palbum);
	if (partist) printf("Artist:    %s\n", partist);
	if (pgenre) printf("Genre:     %s\n", pgenre);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}
	if ( n == 0 ) {
		fprintf(stderr, "XXX no NJB devices found\n");
		return 0;
	} 

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	NJB_Capture(njb);

	if ( NJB_Send_Track(njb, path, pcodec, ptitle, palbum, pgenre,
		partist, length, tracknum, NULL, 0, progress, NULL, &trackid) == -1 ) {
		//printf("\n");
		//njb_error_dump(stderr);
	} else {
		printf("NJB ID:%u\n", trackid);
		fflush(stdout);
	}
	printf("\n");

	NJB_Release(njb);
	NJB_Close(njb);

	return 0;
}

char *strfrom (char* s)
{
	char *r;

	r = (char *)malloc(strlen(s)+1);
	strcpy(r,s);
	return s;
}

int progress (u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data)
{
	printf("|%qu|%qu|\n", sent, total);
	fflush(stdout);
	return 0;
}

char *prompt (const char *prompt, char *buffer, size_t bufsz, int required)
{
	char *cp, *bp;

	while (1) {
		fprintf(stdout, "%s> ", prompt);
		if ( fgets(buffer, bufsz, stdin) == NULL ) {
			if (ferror(stdin)) {
				perror("fgets");
			} else {
				fprintf(stderr, "EOF on stdin\n");
			}
			return NULL;
		}

		cp= strrchr(buffer, '\n');
		if ( cp != NULL ) *cp= '\0';

		bp= buffer;
		while ( bp != cp ) {
			if ( *bp != ' ' && *bp != '\t' ) return bp;
			bp++;
		}

		if (! required) return bp;
	}
}

void usage (void)
{
	fprintf(stderr, "usage: njbputtrack [ -D debuglvl ] -t <title> -a <artist> -l <album> -c <codec> -g <genre> -n <track number> -d <duration in seconds> <path>\n");
	exit(1);
}
