/* Reimplemented NoSQL column operator
 * Copyright (c) 2003 Micah Stetson <micah@cnm-vra.com>
 * 
 * Permission is hereby granted, free of charge, to any
 * person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the
 * Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice
 * shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 $Id: getcolumn.c,v 1.2 2005/04/08 15:29:04 carlo Exp $
 *
 * Minor modifications by Carlo Strozzi. The relavant code is
 * marked with 'CS'.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <libgen.h>
#include <errno.h>
#include "util.h"

#ifndef HELPDIR
#define HELPDIR "/usr/local/nosql/help"
#endif
#ifndef HELPFILE
#define HELPFILE (HELPDIR "/getcolumn.txt")
#endif

void
usage(void)
{
	fprintf(stderr, "Usage: %s [-i input] [-o output] [-lNhr] [getcolumn ...]\n", argv0);
	exit(1);
}

int
main(int argc, char **argv)
{
	char **f;
	char *l;
	int *fields;
	int nicol, nocol, nf;
	int line, i, j;
	int last = 0;
	int header = 1;
	int invert = 0;
	int allocsiz = 0;			/* CS 2005-03-23 */

	l = estrdup(argv[0]);
	if (strcmp(basename(l), "rmcolumn") == 0 || \
	    strcmp(basename(l), "notcolumn") == 0)
		invert = 1;
	free(l);

	ARGBEGIN{
	case 'i':
		efreopen(EARGF(usage()), "r", stdin);
		break;
	case 'o':
		efreopen(EARGF(usage()), "w", stdout);
		break;
	case 'l':
		last = 1;
		break;
	case 'h':
		execlp("grep", "grep", "-v", "^#", HELPFILE, NULL);
		fatal("Couldn't exec() grep: %s", strerror(errno));
		break;
	case 'n':
	case 'N':
		header=0;
		break;
	case 'r':
		invert = invert ? 0 : 1;
		break;
	default:
		usage();
	}ARGEND

	if (!invert && argc == 0)
		exit(0);

	l = frdstr(stdin, '\n', 1);
	if (l == NULL || l[0] != '\001')
		fatal("not a valid table");

	for (i=0,nicol=0; l[i] != '\0'; i++)
		if (l[i] == '\001')
			nicol++;

	/* extra column for detecting corrupt rows */
	f = emalloc((nicol+1) * sizeof(char *));

	allocsiz = argc > nicol ? argc : nicol;		/* CS 2005-03-23 */

	fields = emalloc(allocsiz * sizeof(int));	/* CS 2005-03-23 */

	nf = getfields(l, f, nicol+1, 0, "\t");
	if (nf != nicol)
		fatal("corrupt header line");

	/* CS 2005-01-12: truncate column names at the first blank char */

	for (j=0; j<nicol; j++) {
		i=0;
		while (f[j][i]) {
		      if (f[j][i] == ' ') {
			 f[j][i] = '\0';
			 break;
		      }
		      i++;
		}
	}

	/* CS 2005-01-12: end */

	if (invert) {
		int ocol = 0;
		nocol = nicol - argc;			/* CS 2005-03-23 */
		for (j=0; j<nicol; j++) {
			int match = 0;
			for (i=0; i<argc; i++) {
				if (strcmp(argv[i], f[j]+1) == 0) {	/* +1 skips \001 */
					match = 1;
					break;
				}
			}
			if (!match)
				fields[ocol++] = j;
		}
		if (ocol != nocol)	/* multiple columns with the same name */
			nocol = ocol;
	} else {
		nocol = argc;				/* CS 2005-03-23 */
		for (i=0; i<argc; i++) {
			fields[i] = -1;
			for (j=0; j<nicol; j++) {
				if (strcmp(argv[i], f[j]+1) == 0) {	/* +1 skips \001 */
					fields[i] = j;
					if (!last)
						break;
				}
			}
		}
	}

	if (nocol <= 0) exit(0);			/* CS 2005-03-23 */

	if (header) {
		for (i=0; i<nocol; i++) {
			if (i > 0)
				putc('\t', stdout);
			if (fields[i] >= 0)
				fputs(f[fields[i]], stdout);
			else {
				fputc('\001', stdout);
				fputs(argv[i], stdout);
			}
		}
		putc('\n', stdout);
	}

	free(l);

	for (line=2; (l=frdstr(stdin, '\n', 1)) != NULL; free(l), line++) {
		/* We look for an extra column in case the table is corrupt. */
		nf = getfields(l, f, nicol+1, 0, "\t");
		if (nf != nicol) {
			warn("wrong number of columns on line %d, skipping", line);
			continue;
		}
		for (i=0; i<nocol; i++) {
			if (i > 0)
				putc('\t', stdout);

			if (fields[i] >= 0) {

			   /* CS 2005-01-02: trim trailing blanks
			      from every table column. */

			   for (j = strlen(f[fields[i]])-1;j >= 0 ;j--) {
			       if (*(f[fields[i]]+j) == ' ')
					*(f[fields[i]]+j) = '\0';
			       else break;
			   }
			   /* CS 2005-01-02: end */

			   fputs(f[fields[i]], stdout);
			}
		}
		putc('\n', stdout);
	}

	return 0;
}
