/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __RCX_Image_h
#define __RCX_Image_h

#ifndef __RCX_Result_h
#include "RCX_Result.h"
#endif

#ifndef __PTypes_h
#include "PTypes.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

#ifndef __RCX_Target_h
#include "RCX_Target.h"
#endif

#ifndef _STDIO_H
#include <stdio.h>
#endif

#include <vector>
using std::vector;

#include <string>
using std::string;

class RCX_Link;
class RCX_Printer;

class RCX_Image
{
public:
				RCX_Image();
				~RCX_Image()	{ Clear(); }
	
	RCX_Result	Read(const char *filename);
	bool		Write(const char *filename);

	RCX_Result	Download(RCX_Link *link, int programNumber=0) const;
	void		Print(RCX_Printer *dst) const;

	void		SetFragmentCount(int count);
	int			GetFragmentCount() const	{ return fFragmentCount; }
	void		SetFragment(int index, RCX_FragmentType type, UByte number, const UByte *data,
							int length, const char *name);

	void		SetVariable(int index, const char *name);
	void		SetTargetType(RCX_TargetType t) { fTargetType = t; }
	
	void		Clear();
	int			GetSize() const;

private:
	std::string*		GetNameString(UByte type, UByte index);
	
	class	Fragment
	{
	public:
				Fragment();
				~Fragment();
		
		// partial ordering for sorting
		bool	operator<(const Fragment &rhs) const;
		
		int		fLength;
		UByte*	fData;
		UByte	fNumber;
		RCX_FragmentType fType;
		string	fName;
	};
	
	struct	Variable
	{
		int		fIndex;
		string	fName;
	};
	
	const	Fragment**	BuildIndex() const;
	
	Fragment*			fFragments;
	int					fFragmentCount;
	vector<Variable>	fVars;
	RCX_TargetType		fTargetType;
};


#endif
