/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

#ifdef DEBUG

int debug_fd;
unsigned int debug_instance;

void debug_init()
{
   struct timeval tv;
   int temp;

   debug_fd = open(DEBUG_PATH, O_WRONLY|O_CREAT|O_APPEND, DEBUG_PERM);
   if (debug_fd < 0)
     {
	write(1, "Cannot open debug file.\n", 24);
	write(1, "[ Press enter to continue ]\n", 28);
	read(0, &temp, 3);
	return;
     }
   gettimeofday(&tv, NULL);
   debug_instance = tv.tv_sec;
   write(debug_fd, "nTAIM instance ", 15);
   {
      char *tmpstr = (char*)alloca(11);
      itoa(tmpstr, 11, debug_instance);
      write(debug_fd, tmpstr, strlen(tmpstr));
   }
   write(debug_fd, " started\n", 9);

   return;
}

void debug_close()
{
   char *tmpstr = (char*)alloca(11);
   
   write(debug_fd, "nTAIM instance ", 15);
   itoa(tmpstr, 11, debug_instance);
   write(debug_fd, tmpstr, strlen(tmpstr));
   write(debug_fd, " stopped\n", 9);
   close(debug_fd);
   return;
}

void *debug_malloc(size_t size, char *identity)
{
   void *memory_ptr;

   if (debug_fd > 0)
     {
	char *tmpstr = (char*)alloca(11);
	itoa(tmpstr, 11, debug_instance);
	write(debug_fd, tmpstr, strlen(tmpstr));
	write(debug_fd, " : ", 3);
	write(debug_fd, identity, strlen(identity));
	write(debug_fd, " requested ", 11);
	itoa(tmpstr, 11, size);
	write(debug_fd, tmpstr, strlen(tmpstr));
	
	memory_ptr = malloc(size);

	write(debug_fd, " and got pointer addr ", 22);
	itoa(tmpstr, 11, (int)memory_ptr);
	write(debug_fd, tmpstr, strlen(tmpstr));
	write(debug_fd, "\n", 1);

	return memory_ptr;
     }
   return NULL;
}

void debug_free(void *memory_ptr, char *identity)
{
   if (debug_fd > 0)
     {
	char *tmpstr = (char*)alloca(11);

	itoa(tmpstr, 11, debug_instance);
	write(debug_fd, tmpstr, strlen(tmpstr));
	write(debug_fd, " : ", 3);
	write(debug_fd, identity, strlen(identity));
	write(debug_fd, " freed the pointer addr ", 24);
	itoa(tmpstr, 11, (int)memory_ptr);
	write(debug_fd, tmpstr, strlen(tmpstr));
	write(debug_fd, "\n", 1);
	
	free(memory_ptr);
     }
   return;
}

int itoa(char *s, int size, int i)
{
   char *tmp;
   int j = 0;
   
   s[--size] = 0;
   
   tmp = s + size;
   
   if(!i)
     {
	*(--tmp)='0';
	j = 1;
     }
   
   while( (tmp > s) && (i) )
     {
	tmp--;
	*tmp = i % 10 + '0';
	i = i / 10;
	j++;
     }
   
   memmove(s, tmp, j + 1);
   
   return j;
}

#endif
