/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern preferences pref;
extern window_node *main_window;
extern window_node *current_window;
extern buddylist_node *buddylist_head;

void buddy_online(void *c, const char * const who)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   buddylist_node buddy_to_add;
   buddylist_node *buddy;

   buddy = findbuddybyscreenname((char*)who);

   if(buddy == NULL)
     {
	strcpy(buddy_to_add.screenname, who);
	buddy_to_add.buddy_alias[0] = '\0';
	buddy_to_add.online = TRUE;
	buddy_to_add.away   = FALSE;
	buddy_to_add.isroom = FALSE;
	buddy_to_add.idle_time = 0;
	buddy_to_add.when_last_awaymessage_sent = 0;

	if(addbuddytolist(buddy_to_add))
	  {
	     alert("error adding buddy to list.");
	     return;
	  }
     }
   else
     {
	buddy->online = TRUE;
     }

   if(pref.verbose)
     {
	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(main_window->window, "%s %s has signed on.\n", tbuff, who);
	if(main_window->window == current_window->window)
	  wrefresh(current_window->window);
     }

     {
	char *alias = getbuddyalias((char*)who);

	if(alias)
	  addbuddyalias((char*)who, alias);
	else
	  update_buddywin();
     }

   checkforbuddypounce((char*)who, SIGNON);
}

void buddy_offline(void *c, const char * const who)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   buddylist_node *buddy;

   buddy = findbuddybyscreenname((char*)who);
   if(buddy == NULL) /* should never happen... but... */
     {
	buddylist_node buddy_to_add;

	strcpy(buddy_to_add.screenname, who);
	buddy_to_add.buddy_alias[0] = '\0';
	buddy_to_add.online = FALSE;
	buddy_to_add.away   = FALSE;
	buddy_to_add.isroom = FALSE;
	buddy_to_add.idle_time = 0;
	buddy_to_add.when_last_awaymessage_sent = 0;
	addbuddytolist(buddy_to_add);
     }
   else
     {
	buddy->online = FALSE;
	buddy->away = FALSE;
	buddy->idle_time = 0;
     }

   if(pref.verbose)
     {
	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime( tbuff, 9, "%X", time_info);
	wprintw(main_window->window, "%s %s has signed off.\n", tbuff, who);
	if(main_window->window == current_window->window)
	  wrefresh(current_window->window);
     }

   update_buddywin();
   checkforbuddypounce((char*)who, SIGNOFF);
}

void buddy_away(void *c, const char * const who)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   buddylist_node *buddy;

   buddy = findbuddybyscreenname((char*)who);
   if(buddy == NULL) /* should never happen but... */
     {
	buddylist_node buddy_to_add;

	strcpy(buddy_to_add.screenname, who);
	buddy_to_add.buddy_alias[0] = '\0';
	buddy_to_add.online = TRUE;
	buddy_to_add.away   = TRUE;
	buddy_to_add.isroom = FALSE;
	buddy_to_add.idle_time = 0;
	buddy_to_add.when_last_awaymessage_sent = 0;
	addbuddytolist(buddy_to_add);
     }
   else
     {
	buddy->away = TRUE;
     }

   if(pref.verbose)
     {
	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime( tbuff, 9, "%X", time_info);
	wprintw(main_window->window, "%s %s is now away.\n", tbuff, who);
	if(main_window->window == current_window->window)
	  wrefresh(current_window->window);
     }

   update_buddywin();
   checkforbuddypounce((char*)who, GOAWAY);
}

void buddy_unaway(void *c, const char * const who)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   buddylist_node *buddy;

   buddy = findbuddybyscreenname((char*)who);
   if(buddy == NULL) /* should never happen but... */
     {
	buddylist_node buddy_to_add;

	strcpy(buddy_to_add.screenname, who);
	buddy_to_add.buddy_alias[0] = '\0';
	buddy_to_add.online = TRUE;
	buddy_to_add.away   = TRUE;
	buddy_to_add.isroom = FALSE;
	buddy_to_add.idle_time = 0;
	buddy_to_add.when_last_awaymessage_sent = 0;
	addbuddytolist(buddy_to_add);
     }
   else
     {
	buddy->away = FALSE;
     }

   if(pref.verbose)
     {
	time_value = time(NULL);
	time_info = localtime(&time_value) ;
	strftime( tbuff, 9, "%X", time_info);
	wprintw(main_window->window, "%s %s is no longer away.\n", tbuff, who);
	if(main_window->window == current_window->window)
	  wrefresh(current_window->window);
     }

   update_buddywin();
   checkforbuddypounce((char*)who, UNAWAY);
}

void got_idle(void *c, const char * const who, const long idletime)
{
   buddylist_node *buddy;

   buddy = findbuddybyscreenname((char*)who);
   if(buddy == NULL) /* should never happen but... */
     {
	buddylist_node buddy_to_add;

	strcpy(buddy_to_add.screenname, who);
	buddy_to_add.buddy_alias[0] = '\0';
	buddy_to_add.online = TRUE;
	buddy_to_add.away   = TRUE;
	buddy_to_add.isroom = FALSE;
	buddy_to_add.idle_time = 0;
	buddy_to_add.when_last_awaymessage_sent = 0;
	addbuddytolist(buddy_to_add);
     }
   else
     {
	buddy->idle_time = idletime;
     }

   update_buddywin();
   checkforbuddypounce((char*)who, UNIDLE);
}
