/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern window_node *current_window;
extern WINDOW *buddy_win;
extern WINDOW *chat_win;
extern color_pref colors;
int commandnum;

char *command_list[] =
{
   "/logoff\0" ": logs off AIM server\0",
     "/makewin\0" "[screenname] : makes a new window\0",
     "/closewin\0" ": closes current window\0",
     "/setwindowname\0" "<screenname> : sets current window name\0",
     "/getwindowname\0" ": sets queried user to window screenname\0",
     "/logon\0" ": brings up login window to logon\0",
     "/msg\0" "<sn> <\"message\"> : send message\0",
     "/query\0" "<sn> : query person to talk to\0",
     "/aliascommand\0" "<aliasname> <\"arguments\"> : adds or replaces an alias\0",
     "/printcommandaliases\0" ": prints the current aliases\0",
     "/deletecommandalias\0" "<aliasname> : deletes the corresponding alias\0",
     "/clearcommandaliases\0" ": clears the current aliases\0",
     "/addpounce\0" " <who> <when> <type> <otherstuff>\0",
     "/printpounces\0" ": prints current queued pounces\0",
     "/removepounce\0" " <number of pounce>\0",
     "/savebuddyaliases\0" ": saves buddy aliases\0",
     "/addbuddyalias\0" " <buddyname> <alias>\0",
     "/savebuddylist\0" ": saves your current buddylist to disk\0",
     "/help\0" ": Prints a help message\0",
     "/timestamp\0" "<on|off> : turns on/off time-stamping\0",
     "/autoreconnect\0" "<on|off> : turns on/off auto reconnecting\0",
     "/tardtips\0" "<on|off> : turns on/off tard tips\0",
     "/beep\0" "<on|off> : turns on/off beep\0",
     "/multi_windows\0" "<on|off> : turn on/off multi windows\0",
     "/popup_windows\0" "<on|off> : turn on/off popup windows\0",
     "/historycount\0" "<count> : number of history entries to keep\0",
     "/away\0" "<message> : set away w/ message\0",
     "/notaway\0" ": no longer away\0",
     "/clear\0" ": clears main window\0",
     "/setinfo\0" "<\"info\"> : sets info/profile to \"info\"\0",
     "/addbuddy\0" "<\"buddy\"> : add \"buddy\" to buddy list\0",
     "/delbuddy\0" "<\"buddy\"> : removes \"buddy\" from buddy list\0",
     "/getinfo\0" "<\"sn\"> : get info about \"sn\"\0",
     "/upload\0" ": upload 'buddylist'\0",
     "/buddyblurb\0" "<sn> or /bb <sn> : sends random buddy blurb to sn\0",
     "/verbose\0" "<on|off> : turns on/off verbose mode\0",
     "/saveprefs\0" ": saves settings/prefs\0",
     "/loadprefs\0" ": loads settings/prefs\0",
     "/quit\0" ": Quits nTAIM\0",
     "/logging\0" "<on|off> : toggles logging\0",
     "/warn\0" "<screenname> : warn someone\0",
     "/adddeny\0" "<screenname> : add to deny list\0",
     "/removedeny\0" "<screenname> : remove from deny list\0",
     "/joinroom\0" "<room> : join chat room\0",
     "/partroom\0" "<room> : part chat room\0",
     "/invitetoroom\0" "<room> <who> <message> : invite who to room\0",
     "/printawaymessages\0" ": prints away messages currently stored\0",
     "/addawaymessage\0" "<message> : adds an away message to list\0",
     "/removeawaymessage\0" "<#> : remove away message number\0",
     "/saveawaymessages\0" ": saves away messages to file\0",
     "/setawaymessage\0" ":<#> set away message to #\0",
     "/setautoaway\0" ":<# of minutes> for auto away\0",
     "END\0" "END\0"
};

void display_help(void)
{
   int i, y = 3, x = 2;
   WINDOW *help_win;

   help_win = newwin(LINES, COLS, 0, 0);
   wbkgd(help_win, CP(colors.helpfore, colors.helpback));
   box(help_win, ACS_VLINE, ACS_HLINE);
   wattrset(help_win, CP(colors.helphdrfore, colors.helphdrback)|A_BOLD);
   mvwaddstr(help_win, 1, 2, "Help window:");

   wattrset(help_win, CP(colors.helpnamefore, colors.helpnameback));   
   for (i = 0; i < commandnum; i++)
     {
	if(y + 1 >= LINES)
	  {
	     y = 3;
	     x += 22;
	  }
	mvwaddstr(help_win, y, x, command_list[i]);
	y++;
     }
   
/*      wattrset(help_win, CP(colors.helpusagefore, colors.helpusageback));
	mvwaddstr(help_win, i+3, 3 + oldlength, currstr); */

   wrefresh(help_win);

   read(0, &i, 3);

   werase(help_win);
   wrefresh(help_win);
   delwin(help_win);

   touchwin(current_window->window);
   wrefresh(current_window->window);

   touchwin(buddy_win);
   wrefresh(buddy_win);

   touchwin(chat_win);
   wrefresh(chat_win);
}

int countcommands(void)
{
   int i = 0, done = 0;
   char *command, *description;
   
   while(!done)
     {
	command = command_list[i];
	description = command_list[i] + strlen(command_list[i]) + 1;
	
	if(!strcmp("END", command) && !strcmp("END", description))
	  done = 1;
	else
	  i++;
     }
   return i;
}
