/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern preferences pref;
history_node *history_head = NULL;
history_node *history_tail = NULL;
history_node *current_history = NULL;

int addhistorynode(char *command)
{
   int command_len = strlen(command) + 1;
   static unsigned short history_count = 1;
   history_node *cur;

   if(history_head == NULL)
     {
	history_head = (history_node*) MALLOC(sizeof(history_node), "addhistorynode");
	history_head->next = NULL;
	history_head->prev = NULL;
	history_head->command = (char*) MALLOC(command_len, "addhistorynode");
	memcpy(history_head->command, command, command_len);
	history_count++;
	history_tail = history_head;
	return 0;
     }

   if(history_count > pref.history_count)
     {
	for( ; history_count > pref.history_count; history_count--)
	  {
	     cur = history_tail;
	     history_tail = history_tail->prev;
	     history_tail->next = NULL;
	     FREE(cur->command, "addhistorynode"); 
	     FREE(cur, "addhistorynode");
	  }
     }

   cur = (history_node*) MALLOC(sizeof(history_node), "addhistorynode");
   if(cur == NULL)
     {
	alert("error allocating memory for history node.");
	return 1;
     }
   history_head->prev = cur;
   cur->next = history_head;
   cur->prev = NULL;
   cur->command = (char*) MALLOC(command_len, "addhistorynode");
   if(cur->command == NULL)
     {
	alert("error allocating memory for history command.");
	FREE(cur, "addhistorynode");
	return 1;
     } 
   memcpy(cur->command, command, command_len);
   history_head = cur;
   history_count++;

   return 0;
}

void clearhistory(void)
{
   history_node *tmpnode;

   while(history_head)
     {
	if(history_head->next)
	  tmpnode = history_head->next;
	else
	  tmpnode = NULL;
	FREE(history_head->command, "clearhistory command");
	FREE(history_head, "clearhistory node");
	history_head = tmpnode;
     }

   return;
}
