/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

char username[64];
char password[64];

extern window_node *main_window;
extern void *handle;
extern WINDOW *chat_win;
extern color_pref colors;
extern preferences pref;
extern awaymessage_node *away_message;

void login(void)
{
   int i;
   char tmp;
   WINDOW *login_win;

   login_win = newwin( LINES/2, COLS/2, LINES/4, COLS/4 );

   wbkgd(login_win, CP(colors.loginfore, colors.loginback));

   mvwhline(login_win, 0, 1, '-', login_win->_maxx-1);
   mvwhline(login_win, login_win->_maxy, 1, '-', login_win->_maxx-1);
   mvwvline(login_win, 1, 0, '|', login_win->_maxy-1);
   mvwvline(login_win, 1, login_win->_maxx, '|', login_win->_maxy-1);

   mvwprintw(login_win, 1, (COLS/4 - 8) , "Welcome to nTAIM");
   mvwprintw(login_win, 2, (COLS/4 -  8), "coded by: [bile]");
   mvwprintw(login_win, 4, (COLS/4 - 19), "----------===Please Login===----------");

   echo();
   mvwprintw(login_win, 7, 1, "Password: ");
   mvwprintw(login_win, 5, 1, "Username: ");
   wmove(login_win, 5, 11);
   wgetnstr(login_win, username, 64);
   wmove(login_win, 7, 11);
   noecho();
   wgetnstr(login_win, password, 64);

   delwin(login_win);
   erase();
   refresh();

   firetalk_disconnect(handle);
   info("Attempting to login...");

   i = firetalk_signon(handle, NULL, 0, username, password);

   load_pref();
   
   away_message = setawaymessage(pref.current_away_message);

   tmp = pref.auto_reconnect;
   pref.auto_reconnect = 0;

   if(i == FE_SUCCESS)
     {
	info("Login Successful.");
	loadinfo();
     }
   else
     alert("Login Failed!");

   pref.auto_reconnect = tmp;

   touchwin(chat_win);
   wrefresh(chat_win);
   update_buddywin();
}
