/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

int parse_text(char **args, char *string)
{
  static char outstring[1024];
  unsigned short inquote = 0;
  unsigned short inescape = 0;
  int curarg = 1;
  int len = strlen(string);
  int i;
  int outstringpos = 0;

  args[0] = outstring;
                  
  for (i = 0; i < len; i++) 
     {
	if (curarg > 127)
	  return curarg - 1;
	if (string[i] == ' ' && !inquote && !inescape) 
	  {
	     outstring[outstringpos++] = '\0';
	     args[curarg++] = &outstring[outstringpos];
	  } 
	else if (string[i] == '"' && !inescape)
	  inquote = !inquote;
	else if (string[i] == '\\' && !inescape)
	  inescape = 1;
	else
	  {
	     outstring[outstringpos++] = string[i];
	     inescape = 0;
	  }
     }
   outstring[outstringpos] = '\0';
   return curarg - 1;
}
