/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern char username[];
extern preferences pref;
extern char ntaim_path[];

void load_pref(void)
{
   char path[PATHSIZE];
   int fd;

   strcpy(path, ntaim_path);
   strcat(path, "/");
   strcat(path, username);
   strcat(path, ".cfg");

   fd = open(path, O_RDONLY);
   if(fd < 0)
     {
	alert("Configure file doesn't exist... creating one.");
	save_pref();
	return;
     }
   else
     {
	read(fd, &pref, sizeof(pref));
	close(fd);
	info("Settings loaded successfully.");
     }
   return;
}

void save_pref(void)
{
   char path[PATHSIZE];
   int fd;

   strcpy(path, ntaim_path);
   strcat(path, "/");
   strcat(path, username);
   strcat(path, ".cfg");

   fd = open(path, O_WRONLY|O_CREAT, 0644);
   if(fd < 0) /* if we cant open the file for some reason see whats wrong */
     {
	switch(errno)
	  {
	   case EACCES:
	     alert("Could not save preferences, did not have permission.");
	     break;
	   default:
	     alert("Could not save preferences.");
	     break;
	  }
     }
   else /* if we got a file discriptor */
     {
	write(fd, &pref, sizeof(pref));
	close(fd);
	info("Settings saved.");
     }
   return;
}
