/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern void *handle;
extern char username[];
extern char password[];
extern history_node *history_head;
extern history_node *current_history;
extern window_node *window_head;
extern window_node *current_window;
extern window_node *main_window;
extern WINDOW *buddy_win;
extern WINDOW *chat_win;
extern color_pref colors;
extern buddylist_node *scrolled_buddy;

preferences pref =
{    0,   /* beep */
     0,   /* verbose */
     0,   /* timestamp */
     0,   /* tardtips */
     0,   /* multi_windows */
     0,   /* window_popup_on_mesg */
     0,   /* log */
     0,   /* auto reconnect */
     0,   /* away timer */
     0,   /* current away message */
     10   /* history_count */
};

awaymessage_node *away_message = NULL;
char last_message_sender[64] = {0};
char last_room_invite[64] = {0};

int away = 0;

char buddy_blurb[] =
{
   "TARDWAGON CHARGE!!!\0"
     "my moo, myy moom, my mom sayz... \"HEY BUDDY!! YOUR REALLY SPECIAL!! Not only did you increase your IQ 100 fraction, but  you have a shinny new tardcard!\"\0"
     "SUMBODY GIV MEE A HUGG!!\0"
     "MaUH waeao maEui ahAa neaAaa deDomaeaohn\0"
     "I choked you like you were a choking victum!\0"
     "nah Nah NAh NAH, NAH NAH, NNNAAAHHH!!!\0"
     "GIVE DA GROUND A HUG!!\0"
     "TARD CARD!!\0"
     "mya mam my moom my mom sayz... \"HEY BUDDY!! WHY YOU FIGHTING!! YOU SHOULD BE ON THE TARDWAGON!!\"\0"
     "XXY!! XXY!!\0"
};

inline void process_keypress(int c)
{
   static char input_string[MAX_MESSAGE];
   static int current_input_pos = 0;
   char **args;
   int numargs;

   /* if we currently have an active tard tip, clear it before dealing
      with the char */
   if(pref.tardtips)
     handle_tard_tips(NULL, 0, TARDTIPDESTROY);

   switch(c)
     {
      case CTRL('c'):
	removewindowfromlist(current_window);
	break;

      case KEY_LEFT:
      case CTRL('b'):
	scroll_buddies(input_string, current_input_pos, SCROLLLEFT);
	break;

      case KEY_RIGHT:
      case CTRL('f'):
	scroll_buddies(input_string, current_input_pos, SCROLLRIGHT);
	break;

      case KEY_PPAGE:
      case CTRL('x'):
	if(!pref.multi_windows)
	  break;

	if(current_window->next)
	  current_window = current_window->next;

	touchwin(current_window->window);
	wrefresh(current_window->window);

	if(current_window->screenname[0])
	  {
	     scrolled_buddy = findbuddybybuddy_alias(current_window->screenname);
	     if(scrolled_buddy == NULL)
	       scrolled_buddy = findbuddybyscreenname(current_window->screenname);
	  }

	werase(chat_win);
	input_string[current_input_pos] = '\0';
	if(scrolled_buddy)
	  {
	     if(scrolled_buddy->buddy_alias[0])
	       mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->buddy_alias, input_string);
	     else
	       mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->screenname, input_string);
	  }
	wrefresh(chat_win);
	break;

      case KEY_NPAGE:
      case CTRL('z'):
	if(!pref.multi_windows)
	  break;

	if(current_window->prev)
	  current_window = current_window->prev;

	touchwin(current_window->window);
	wrefresh(current_window->window);

	if(current_window->screenname[0])
	  {
	     scrolled_buddy = findbuddybybuddy_alias(current_window->screenname);
	     if(scrolled_buddy == NULL)
	       scrolled_buddy = findbuddybyscreenname(current_window->screenname);
	  }

	werase(chat_win);
	input_string[current_input_pos] = '\0';
	if(scrolled_buddy)
	  {
	     if(scrolled_buddy->buddy_alias[0])
	       mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->buddy_alias, input_string);
	     else
	       mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->screenname, input_string);
	  }
	wrefresh(chat_win);
	break;

      case KEY_UP:
      case CTRL('p'):
	  {
	     if(current_history)
	       if(current_history->next)
		 current_history = current_history->next;

	     if(current_history == NULL)
	       current_history = history_head;

	     if(current_history)
	       {
		  werase(chat_win);
		  strcpy(input_string, current_history->command);
		  if(scrolled_buddy)
		    {
		       if(scrolled_buddy->buddy_alias[0])
			 mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->buddy_alias, input_string);
		       else
			 mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->screenname, input_string);
		    }
		  else
		    mvwprintw(chat_win, 0, 0, "%s", input_string);

		  wrefresh(chat_win);
		  current_input_pos = strlen(input_string);
	       }
	  }
	break;

      case KEY_DOWN:
      case CTRL('n'):
	  {
	     if(current_history)
	       {
		  if(current_history->prev)
		    {
		       current_history = current_history->prev;
		       werase(chat_win);
		       strcpy(input_string, current_history->command);
		       if(scrolled_buddy)
			 {
			    if(scrolled_buddy->buddy_alias[0])
			      mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->buddy_alias, input_string);
			    else
			      mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->screenname, input_string);
			 }
		       else
			 mvwprintw(chat_win, 0, 0, "%s", input_string);

		       wrefresh(chat_win);
		    }
		  else
		    {
		       current_input_pos = 0;
		       current_history = NULL;
		       werase(chat_win);
		       if(scrolled_buddy)
			 {
			    if(scrolled_buddy->buddy_alias[0])
			      mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
			    else
			      mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
			 }

		       wrefresh(chat_win);
		    }
	       }
	  }
	break;

      case CTRL('k'):
	current_input_pos = 0;
	werase(chat_win);
	if(scrolled_buddy)
	  {
	     if(scrolled_buddy->buddy_alias[0])
	       wprintw(chat_win, "[%s] ", scrolled_buddy->buddy_alias);
	     else
	       wprintw(chat_win, "[%s] ", scrolled_buddy->screenname);
	  }
	wrefresh(chat_win);
	break;

      case CTRL('r'): /* ctrl r */
	if(last_message_sender[0])
	  {
	     scrolled_buddy = findbuddybyscreenname(last_message_sender);

	     if(scrolled_buddy == NULL)
	       {
		  firetalk_im_add_buddy(handle, last_message_sender);
		  sleep(1);
		  scrolled_buddy = findbuddybyscreenname(last_message_sender);
	       }

	     werase(chat_win);
	     if(current_input_pos)
	       {
		  input_string[current_input_pos] = '\0';
		  if(scrolled_buddy)
		    {
		       if(scrolled_buddy->buddy_alias[0])
			 mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->buddy_alias, input_string);
		       else
			 mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->screenname, input_string);
		    }
	       }
	     else
	       {
		  if(scrolled_buddy)
		    {
		       if(scrolled_buddy->buddy_alias[0])
			 mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
		       else
			 mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
		    }
	       }

	     if(!strcmp(getenv("TERM"), "xterm") || !strcmp(getenv("TERM"), "rxvt"))
	       {
		  if(scrolled_buddy)
		    {
		       if(scrolled_buddy->buddy_alias[0])
			 printf("\e]2;%s\a", scrolled_buddy->buddy_alias);
		       else
			 printf("\e]2;%s\a", scrolled_buddy->screenname);
		    }
	       }

	     wrefresh(chat_win);
	  }
	break;

      case CTRL('u'):
	if(last_room_invite[0])
	  firetalk_chat_join(handle, last_room_invite);
	break;

      case CTRL('l'):
	touchwin(current_window->window);
	wclear(buddy_win);
	wrefresh(chat_win);
	wrefresh(current_window->window);
	update_buddywin();
	break;

      case CTRL('e'):
	werase(current_window->window);
	wrefresh(current_window->window);
	break;

      case KEY_DC:
      case KEY_BACKSPACE:
      case '\b':
	if(current_input_pos > 0)
	  {
	     current_input_pos--;
	     wprintw(chat_win, "\b \b");
	     wrefresh(chat_win);
	  }
	break;

      case '\t': /* tab */
	  {
	     int arg_count = 0;
	     char *strptr = input_string;

	     input_string[current_input_pos] = '\0';

	     while(*strptr)
	       {
		  if(*strptr == ' ')
		    arg_count++;
		  strptr++;
	       }

	     args = (char**)alloca( (arg_count + 1) * sizeof(char*) );
	     numargs = parse_text(args, input_string);
	     if (find_tabbed_string(args[numargs], input_string))
	       {
		  int backspace_length;
		  unsigned short backspace_count;

	     /* for quotes we need to reprint the whole string, so backspace
	        to the begining of the word.  There might be a better way of
	        doing this, ie. printing to a specified location. */
		  backspace_length = strlen(args[numargs]);
		  for (backspace_count = 0; backspace_count < backspace_length; backspace_count++)
		    wprintw(chat_win, "\b");

		  wprintw(chat_win, "%s", input_string + current_input_pos - backspace_length);
		  current_input_pos += strlen( input_string + current_input_pos );
		  wrefresh(current_window->window);

		  if(pref.tardtips)
		    handle_tard_tips(input_string, current_input_pos, TARDTIPCREATE);
		  else
		    wrefresh(chat_win);
	       }
	  }

	break;

      case '\n':
	  {
	     int arg_count = 0;
	     char *strptr = input_string;

	     if(current_input_pos == 0)
	       break;
	     input_string[current_input_pos] = '\0';

	     /* add to history */
	     addhistorynode(input_string);
	     current_history = NULL;

	     werase(chat_win);
	     if(scrolled_buddy)
	       {
		  if(scrolled_buddy->buddy_alias[0])
		    mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
		  else
		    mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
	       }
	     wrefresh(chat_win);

	     while(*strptr)
	       {
		  if(*strptr == ' ')
		    arg_count++;
		  strptr++;
	       }

	     args = (char**)alloca( (arg_count + 1) * sizeof(char*) );
	     numargs = parse_text(args, input_string);
	     current_input_pos = 0;

	     if(!strcmp(args[0], "/logoff"))
	       {
		  char tmp = pref.auto_reconnect;

		  pref.auto_reconnect = 0;
		  firetalk_disconnect(handle);
		  pref.auto_reconnect = tmp;
	       }

	     else if(!strcmp(args[0], "/makewin"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    addwindowtolist(args[1], FALSE);
		  else
		    addwindowtolist("", FALSE);
	       }

	     else if(!strcmp(args[0], "/closewin"))
	       removewindowfromlist(current_window);

	     else if(!strcmp(args[0], "/setwindowname"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    {
		       if(pref.multi_windows && current_window)
			 {
			    if(!windowfor(args[1], FALSE))
			      strcpy(current_window->screenname, args[1]);
			    else
			      alert("window already exists for user.");
			 }
		       else
			 alert("not in multi window mode.");
		    }
	       }

	     else if(!strcmp(args[0], "/getwindowname"))
	       {
		  if(strcmp(current_window->screenname, ""))
		    {
		       scrolled_buddy = findbuddybyscreenname(current_window->screenname);
		       if(scrolled_buddy == NULL)
			 scrolled_buddy = findbuddybybuddy_alias(current_window->screenname);
		       if(scrolled_buddy == NULL)
			 firetalk_im_add_buddy(handle, current_window->screenname);

		       werase(chat_win);
		       if(scrolled_buddy)
			 {
			    if(scrolled_buddy->buddy_alias[0])
			      mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
			    else
			      mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
			 }
		       wrefresh(chat_win);
		    }
		  else
		    info("window has no name.");
	       }

	     else if(!strcmp(args[0], "/logon"))
	       login();

	     else if(!strcmp(args[0], "/msg"))
	       {
		  if(numargs >= 2)
		    {
		       input_string[current_input_pos] = '\0';
		       send_message(args[1], input_string + strlen(args[1]) + strlen(args[0]) + 2, 0);
		    }
	       }

	     else if(!strcmp(args[0], "/query"))
	       {
		  if(numargs && args[1][0])
		    {
		       scrolled_buddy = findbuddybyscreenname(args[1]);
		       if(scrolled_buddy == NULL)
			 scrolled_buddy = findbuddybybuddy_alias(args[1]);
		       if(scrolled_buddy == NULL)
			 firetalk_im_add_buddy(handle, args[1]);

		       werase(chat_win);
		       if(scrolled_buddy)
			 {
			    if(scrolled_buddy->buddy_alias[0])
			      mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
			    else
			      mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
			 }
		       wrefresh(chat_win);
		    }
	       }

	     else if(!strcmp(args[0], "/aliascommand"))
	       {
		  if (numargs == 2)
		    addcommandalias(args[1], args[2]);
	       }

	     else if(!strcmp(args[0], "/printcommandaliases"))
	       printcommandaliases();

             else if(!strcmp(args[0], "/deletecommandalias"))
	       {
		  int tmp;
		  if(numargs)
		    {
		       for(tmp = 1; tmp <= numargs; tmp++)
			 deletecommandalias(args[tmp]);
		    }
	       }

             else if(!strcmp(args[0], "/clearcommandaliases"))
	       clearcommandaliases();

	     else if(!strcmp(args[0], "/addpounce"))
	       addbuddypouncenode(args, numargs);

	     else if(!strcmp(args[0], "/printpounces"))
	       print_pounces();

	     else if(!strcmp(args[0], "/removepounce"))
	       {
		  if(numargs >= 1)
		    remove_pounce(atoi(args[1]));
	       }

	     else if(!strcmp(args[0], "/savebuddyaliases"))
	       savebuddyaliases();

	     else if(!strcmp(args[0], "/addbuddyalias"))
	       {
		  if(numargs >= 2)
		    addbuddyalias(args[1], args[2]);
	       }

	     else if(!strcmp(args[0], "/savebuddylist"))
	       savebuddylist();

	     else if(!strcmp(args[0], "/help"))
	       display_help();

             else if(!strcmp(args[0], "/timestamp"))
               {
		  pref.timestamp = !pref.timestamp;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/autoreconnect"))
	       {
		  pref.auto_reconnect = !pref.auto_reconnect;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/tardtips"))
	       {
		  pref.tardtips = !pref.tardtips;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/beep"))
	       {
		  pref.beep = !pref.beep;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/multi_windows"))
	       {
		  pref.multi_windows = !pref.multi_windows;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/popup_windows"))
	       {
		  pref.window_popup_on_mesg = !pref.window_popup_on_mesg;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/historycount"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    {
		       pref.history_count = atoi(args[1]);
		       if(pref.history_count == 0)
			 pref.history_count = 1;

		       update_buddywin();
		    }
	       }

	     else if(!strcmp(args[0], "/away"))
	       {
		  int success;
		  char mesg[] = "away...";
		  char *ptrtomesg;

		  if(numargs)
		    {
		       success = firetalk_set_away(handle, input_string + 6);
		       ptrtomesg = input_string + 6;
		       addawaymessage(input_string + 6);
		    }
		  else if(away_message)
		    {
		       success = firetalk_set_away(handle, away_message->message);
		       ptrtomesg = away_message->message;
		    }
		  else
		    {
		       success = firetalk_set_away(handle, mesg);
		       ptrtomesg = mesg;
		       addawaymessage(mesg);
		    }

		  if(success == FE_SUCCESS)
		    {
		       wprintw(current_window->window, "Now away: ");
		       print_html(current_window, ptrtomesg);
		       waddch(current_window->window, '\n');
		       wrefresh(current_window->window);
		       away = 1;
		    }
		  else
		    alert("could not set away.");
	       }

	     else if(!strcmp(args[0], "/notaway"))
	       {
		  firetalk_set_away(handle, NULL);
		  wprintw(current_window->window, "No longer away.\n");
		  wrefresh(current_window->window);
		  away = 0;
	       }

	     else if(!strcmp(args[0], "/clear"))
	       {
		  werase(current_window->window);
		  wrefresh(current_window->window);
	       }

	     else if(!strcmp(args[0], "/setinfo"))
	       {
		  if(numargs)
		    {
		       firetalk_set_info(handle, input_string + 9);
		       saveinfo(input_string + 9);
		       wprintw(current_window->window, "Info now set to: ");
		       print_html(current_window, input_string + 9);
		       waddch(current_window->window, '\n');
		       wrefresh(current_window->window);
		    }
	       }

	     else if(!strcmp(args[0], "/addbuddy"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    firetalk_im_add_buddy(handle, input_string + 10);
	       }

	     else if(!strcmp(args[0], "/delbuddy"))
	       {
		  int test;
		  if(numargs && strcmp(args[1], ""))
		    {
		       test = firetalk_im_remove_buddy(handle, input_string + 10);
		       if(test == FE_SUCCESS)
			 {
			    buddy_offline(handle, input_string + 10);
			    update_buddywin();
			 }
		    }
	       }

	     else if(!strcmp(args[0], "/getinfo"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    firetalk_get_info(handle, input_string + 9);
		  else if(scrolled_buddy)
		    firetalk_get_info(handle, scrolled_buddy->stripedname);
	       }

	     else if(!strcmp(args[0], "/upload"))
	       {
		  if(numargs)
		    {
		       if(!strcmp(args[1], "buddylist"))
			 {
			    int j = firetalk_im_upload_buddies(handle);
			    if(j == FE_SUCCESS)
			      {
				 wattrset(current_window->window, CP(colors.upbudfore, colors.upbudback)|A_BOLD);
				 wprintw(current_window->window, "Successfully uploaded buddy list.\n");
				 wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
			      }
			 }

		       else if(!strcmp(args[1], "denylist"))
			 {
			    int j = firetalk_im_upload_denies(handle);
			    if(j == FE_SUCCESS)
			      {
				 wattrset(current_window->window, CP(colors.updenfore, colors.updenback)|A_BOLD);
				 wprintw(current_window->window, "Successsfully uploaded deny list.\n");
				 wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
			      }
			 }
		       wrefresh(current_window->window);
		    }
	       }

	     else if(!strcmp(args[0], "/buddyblurb") || !strcmp(args[0], "/bb"))
	       {
		  int randnum, j;
		  char *buddyblurb = buddy_blurb, blurb[256];
		  srand((int)time(NULL));
		  randnum = random() % 9;

		  for(j = 1; j < randnum; j++)
		    buddyblurb += strlen(buddyblurb) + 1;

		  strcpy(blurb, "[random Buddy blurb]: ");
		  strcat(blurb, buddyblurb);

		  if(numargs == 1)
		    send_message(args[1], blurb, 0);
		  else if(numargs == 0 && scrolled_buddy)
		    {
		       if(scrolled_buddy->isroom)
			 send_room_message(NULL, blurb, 0);
		       else
			 send_message(NULL, blurb, 0);
		    }
	       }

	     else if(!strcmp(args[0], "/verbose"))
	       {
		  pref.verbose = !pref.verbose;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/saveprefs"))
	       save_pref();

	     else if(!strcmp(args[0], "/loadprefs"))
	       load_pref();

	     else if(!strcmp(args[0], "/quit"))
	       {
		  pref.auto_reconnect = 0;
		  firetalk_disconnect(handle);
		  shutdown_env(0);
	       }

	     else if(!strcmp(args[0], "/logging"))
	       {
		  pref.logging = !pref.logging;
		  update_buddywin();
	       }

	     else if(!strcmp(args[0], "/warn"))
	       {
		  if(numargs == 1)
		    firetalk_im_evil(handle, input_string + strlen(args[0]) + 1);
	       }

	     else if(!strcmp(args[0], "/adddeny"))
	       {
		  if(numargs == 1)
		    firetalk_im_add_deny(handle, input_string + strlen(args[0]) + 1);
	       }

	     else if(!strcmp(args[0], "/removedeny"))
	       {
		  if(numargs == 1)
		    firetalk_im_remove_deny(handle, input_string + strlen(args[0]) + 1);
	       }

	     else if(!strcmp(args[0], "/joinroom"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    firetalk_chat_join(handle, args[1]);
	       }

	     else if(!strcmp(args[0], "/partroom"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    firetalk_chat_part(handle, args[1]);
		  else if(scrolled_buddy)
		    {
		       if(scrolled_buddy->isroom)
			 firetalk_chat_part(handle, scrolled_buddy->screenname);
		    }
	       }

	     else if(!strcmp(args[0], "/invitetoroom"))
	       {
		  if(numargs >= 3)
		    {
		       buddylist_node *room, *buddy = NULL;

		       room = findbuddybyscreenname(args[1]);
		       buddy = findbuddybyscreenname(args[2]);

		       if(buddy == NULL)
			 buddy = findbuddybybuddy_alias(args[2]);

		       if(room == NULL)
			 firetalk_chat_join(handle, args[1]);
		       else if(room->isroom)
			 firetalk_chat_invite(handle, args[1], buddy == NULL ? args[2] : buddy->stripedname,
					      (input_string + 14 + strlen(args[1]) + 1 + strlen(args[2]) + 1));
		    }
		  else if(numargs == 2 && scrolled_buddy)
		    {
		       if(scrolled_buddy->isroom)
			 firetalk_chat_invite(handle, scrolled_buddy->screenname, args[1],
					      (input_string + 14 + strlen(args[1])));
		       else
			 {
			    buddylist_node *room = findbuddybyscreenname(args[1]);

			    if(room == NULL)
			      firetalk_chat_join(handle, args[1]);
			    else if(room->isroom)
			      firetalk_chat_invite(handle, args[1], scrolled_buddy->stripedname,
						   (input_string + 14 + strlen(args[1])));
			 }
		    }
	       }

	     else if(!strcmp(args[0], "/printawaymessages"))
	       printawaymessages();

	     else if(!strcmp(args[0], "/addawaymessage"))
	       addawaymessage(input_string + 16);

	     else if(!strcmp(args[0], "/removeawaymessage"))
	       removeawaymessage(atoi(args[1]));

	     else if(!strcmp(args[0], "/saveawaymessages"))
	       {
		  if(!saveawaymessages())
		    info("away messages saved.");
	       }

	     else if(!strcmp(args[0], "/setawaymessage"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    {
		       pref.current_away_message = atoi(args[1]);
		       away_message = setawaymessage(pref.current_away_message);
		       wprintw(current_window->window, "Away message set to: %s\n", away_message->message);
		       wrefresh(current_window->window);
		       update_buddywin();
		    }
		  else
		    {
		       if(away_message)
			 {
			    wprintw(current_window->window, "Away message is currently set to: %s\n", away_message->message);
			    wrefresh(current_window->window);
			 }
		       else
			 {
			    away_message = setawaymessage(0);
			    if(away_message == NULL)
			      {
				 addawaymessage("away...");
				 away_message = setawaymessage(0);
			      }
			 }
		    }
	       }

	     else if(!strcmp(args[0], "/setautoaway"))
	       {
		  if(numargs && strcmp(args[1], ""))
		    {
		       pref.away_timer = 60 * atoi(args[1]);
		       alarm(pref.away_timer);
		       update_buddywin();
		    }
	       }

	     else if (args[0][0] == '/') /* if it's a command check the aliases */
	       {
		  commandalias_node *curralias;
		  char tmp_input_string[MAX_MESSAGE] = {0};

		  if ( (curralias = findcommandalias(args[0])) )
		    {
		       strcpy(tmp_input_string, curralias->command);
		       strcat(tmp_input_string, " ");
		       strcat(tmp_input_string, input_string + strlen(curralias->name) + 1);
		       strcpy(input_string, tmp_input_string);
		       current_input_pos = strlen(input_string);
		       process_keypress('\n');
		    }
	       }

	     else
	       {
		  if(scrolled_buddy)
		    {
		       if(scrolled_buddy->isroom)
			 send_room_message(NULL, input_string, 0);
		       else
			 send_message(NULL, input_string, 0);
		    }
	       }
	  }
	break;

      default:
	  {
	     input_string[current_input_pos++] = c;
	     waddch(chat_win, c);

	     if(pref.tardtips)                     /* if tard tips are active */
	       handle_tard_tips(input_string, current_input_pos, TARDTIPCREATE);
             else
	       wrefresh(chat_win);
	  }
	break;
     }
}

