/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"


#ifdef RESIZEABLE

extern window_node *current_window;
extern window_node *window_head;
extern WINDOW *buddy_win;
extern WINDOW *chat_win;

void resize_window(int sig)
{
#ifdef HASRESIZETERM
   struct winsize win;
   window_node *window = window_head;
   
   ioctl(STDIN_FILENO, TIOCGWINSZ, &win);
   
   resizeterm(win.ws_row, win.ws_col);
   
   wresize(chat_win, 2, COLS);
   chat_win->_begy = LINES-2;
   chat_win->_begx = 0;
   
   wresize(buddy_win, LINES-2, (int)((COLS*.2375) + .5));
   buddy_win->_begy = 0;
   buddy_win->_begx = (int)(COLS-(COLS*.2375));
   
   while(window)
     {
	wresize(window->window, LINES-2, (int)(COLS-(COLS*.2375) + .5));
	window = window->next;
     }

   process_keypress(CTRL('l'));
   process_keypress(CTRL('k'));
#else   
   char *tty = NULL;
   int fd, result;
   struct winsize win;

   tty = ttyname(0);
   if(tty == NULL)
     return;
   
   fd = open(tty, O_RDWR);
   if(fd < 0)
     return;
   
   result = ioctl(fd, TIOCGWINSZ, &win);

   clearwindows();
   delwin(buddy_win);
   delwin(chat_win);
   endwin();
   
   COLS = win.ws_col;
   LINES = win.ws_row;
   
   setup_env();

   touchwin(current_window->window);
   wclear(buddy_win);
   wrefresh(chat_win);
   wrefresh(current_window->window);
   update_buddywin();
   
   close(fd);
#endif
}
#endif
