/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern WINDOW *buddy_win;
extern buddylist_node *buddylist_head;
extern preferences pref;
extern color_pref colors;

void update_buddywin(void)
{
   int row = 1;
   char chr;
   buddylist_node *current_buddy = buddylist_head;

   werase(buddy_win);
   wattrset(buddy_win, CP(colors.budfore, colors.budback)|A_BOLD);

   while(current_buddy)
     {
	if(current_buddy->online)
	  {
	     if(!current_buddy->away && !current_buddy->isroom)
	       {
		  if(current_buddy->buddy_alias[0])
		    mvwprintw(buddy_win, row, 1, "%s %d", current_buddy->buddy_alias, current_buddy->idle_time);
		  else
		    mvwprintw(buddy_win, row, 1, "%s %d", current_buddy->screenname, current_buddy->idle_time);
		  row++;
	       }
	  }
	current_buddy = current_buddy->next;
     }

   wattrset(buddy_win, CP(colors.budwinfore, colors.budwinback));
   mvwhline(buddy_win, row++, 1, ACS_HLINE, buddy_win->_maxx-1);
   wattrset(buddy_win, CP(colors.budfore, colors.budback));

   current_buddy = buddylist_head;
   while(current_buddy)
     {
	if(current_buddy->online)
	  {
	     if(current_buddy->away)
	       {
		  if(current_buddy->buddy_alias[0])
		    mvwprintw(buddy_win, row, 1, "%s %d", current_buddy->buddy_alias, current_buddy->idle_time);
		  else
		    mvwprintw(buddy_win, row, 1, "%s %d", current_buddy->screenname, current_buddy->idle_time);
		  row++;
	       }
	  }
	current_buddy = current_buddy->next;
     }

   wattrset(buddy_win, CP(colors.budwinfore, colors.budwinback));
   mvwhline(buddy_win, row++, 1, ACS_HLINE, buddy_win->_maxx-1);
   wattrset(buddy_win, CP(COLOR_BLUE, COLOR_BLACK)|A_BOLD);

   current_buddy = buddylist_head;
   while(current_buddy)
     {
	if(current_buddy->isroom)
	  {
	     mvwprintw(buddy_win, row, 1, "%s", current_buddy->screenname);
	     row++;
	  }
	current_buddy = current_buddy->next;
     }

   wattrset(buddy_win, CP(colors.budwinfore, colors.budwinback));

   wmove(buddy_win, buddy_win->_maxy - 1, 1);
   pref.beep ? (wattron(buddy_win, A_BOLD), chr = 'B')
     : (wattroff(buddy_win, A_BOLD), chr = 'b');
   waddch(buddy_win, chr);

   pref.verbose ? (wattron(buddy_win, A_BOLD), chr = 'V')
     : (wattroff(buddy_win, A_BOLD), chr = 'v');
   waddch(buddy_win, chr);

   pref.timestamp ? (wattron(buddy_win, A_BOLD), chr = 'T')
     : (wattroff(buddy_win, A_BOLD), chr = 't');
   waddch(buddy_win, chr);
   
   pref.tardtips ? (wattron(buddy_win, A_BOLD), chr = 'T')
     : (wattroff(buddy_win, A_BOLD), chr = 't');
   waddch(buddy_win, chr);

   pref.multi_windows ? (wattron(buddy_win, A_BOLD), chr = 'W')
     : (wattroff(buddy_win, A_BOLD), chr = 'w');
   waddch(buddy_win, chr);

   pref.window_popup_on_mesg ? (wattron(buddy_win, A_BOLD), chr = 'P')
     : (wattroff(buddy_win, A_BOLD), chr = 'p');
   waddch(buddy_win, chr);

   pref.logging ? (wattron(buddy_win, A_BOLD), chr = 'L')
     : (wattroff(buddy_win, A_BOLD), chr = 'l');
   waddch(buddy_win, chr);

   pref.auto_reconnect ? (wattron(buddy_win, A_BOLD), chr = 'A')
     : (wattroff(buddy_win, A_BOLD), chr = 'a');
   waddch(buddy_win, chr);

   wattroff(buddy_win, A_BOLD);
   wprintw(buddy_win, " %d %d %d", pref.current_away_message,
	   pref.away_timer/60, pref.history_count);

   while(buddy_win->_curx < buddy_win->_maxx)
     waddch(buddy_win, ' ');

   box(buddy_win, ACS_VLINE, ACS_HLINE);  /* '|', '-'); */

   wrefresh(buddy_win);
}
