/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>

#include "prototypes.h"


extern void debug(const char *fmt,...);
extern int rx_fd;
extern struct in_addr ipaddr;
extern unsigned short localport;
extern int checksum_active;

int xsockrecv()
{
    ntheader *header;
    void *buf;
    static u_char rcvbuffer[MAX_PACKET_SIZE];
    static u_char decryptbuf[MAX_PACKET_SIZE];
    char *rcvbuf = rcvbuffer;
    struct sockaddr_in from;
    int fromlen;
    int bytes;
    struct timeval t;
    debug("recv\n");

    fromlen = sizeof(struct sockaddr);
    bytes = recvfrom(rx_fd, rcvbuffer, 1024,
		     0, (struct sockaddr *) &from, &fromlen);

    debug("got %d bytes\n", bytes);
    /*perform decryption if required */
    if (Null_Key() == 0) {
	bytes = Decrypt(rcvbuffer, decryptbuf, bytes);
	rcvbuf = decryptbuf;
	debug("decrypting to %s\n", rcvbuf);
    } else {
	rcvbuf = rcvbuffer;
    }



    header = (ntheader *) rcvbuf;
    buf = (void *) &rcvbuf[sizeof(ntheader)];

    if (ntohl(from.sin_addr.s_addr) == ipaddr.s_addr && from.sin_port == localport)
	return 0;


    if (header->checkbyte != (unsigned char) NT_PROTOCOL_CHECKBYTE) {
	debug("Unknown packet received\n");
	return -1;
    }
    if (header->version_no != CURRENT_PROTOCOL_VERSION) {
	debug("Later version of protocol received - please update your software\n");
	return -1;
    }
    debug("Mesage type: %d\n", header->msgtype);

    ntohtime(&(header->timestamp), &t);
    clock_sync(&t);
    switch (header->msgtype) {
    case LINEMSG:
	parse_line((netline *) buf, &t);
	break;
    case BLOCKMSG:
	parse_block((netblock *) buf, &t);
	break;
    case SESSIONMSG:
	parse_session_message((netsession *) buf);
	break;
    case RTX_ADVERT:
	parse_rtx_advert((netrtxadvert *) buf, &(from.sin_addr), &t);
	break;
    case RTX_REQUEST:
	parse_rtx_request((netrtxrequest *) buf, &t);
	break;
    case RTX_SPECIFIC_REQUEST:
	parse_rtx_specific_request((netrtxspecificrequest *) buf);
	break;
    case PAGE_INFO_REQUEST:
	parse_page_request((netpagerequest *) buf);
	break;
    case LEAVE_CONF:
	parse_leave_message((netsession *) buf);
	break;
    case POINTERMSG:
	parse_pointer((netpointer *) buf);
	break;
    case RECENT_ADVERT:
	parse_recent_list((netrecentadvert *) buf);
	break;
	/* NEW CASES ADDED FOR PAGE CHECKSUM-ing */
    case PAGE_INFO:
	if (checksum_active == 1) {	/* this check is included for all checksum messages *//* so that user can turn them off from user interface */
	    parse_page_info((netpageinfo *) buf);
	}
	break;
    case BLOCK_INFO_REQUEST:
	if (checksum_active == 1) {
	    parse_blockinfo_request((netblockinforequest *) buf);
	}
	break;
    case BLOCK_INFO_REQUEST2:	/* new for checksum version 2 */
	if (checksum_active == 1) {
	    parse_blockinfo_request2();
	}
	break;
    case BLOCK_INFO:
	if (checksum_active == 1) {
	    parse_blockinfo((netblockinfo *) buf);
	}
	break;
    case BLOCK_RTX_REQUEST:
	if (checksum_active == 1) {
	    parse_blockrtx_request((netblockrtxrequest *) buf);
	}
	break;
	/* end of checksum stuff */
    default:

	debug("Unknown message type received\n");
	return -1;
    }
    return 0;
}
