/*****************************************************************************
Testing for qfDES



Saleem N. Bhatti
February 1993

Intel/Linux mods courtesy of Mark Handley
2 August 1996, Saleem
*****************************************************************************/

#include <stdio.h>
#include "qfDES.h"
#include <memory.h>
#include <malloc.h>

#if defined(_intel_)

#include <sys/types.h>
#include <netinet/in.h>

#define CLOCKS_PER_SEC 100

#else

#define CLOCKS_PER_SEC 1e6

#endif


#if defined(__cplusplus)
extern "C" {
extern long clock();
}
#endif

typedef unsigned long Word;

/*
** The following data is taken from:
**
** "Security for Computer Networks", D.W. Davies & W.L. Price, [1984]
** John Wiley & Sons Limited, UK.
*/

Word testKey[2][2] = {{0x08192a3b, 0x4c5d6e7f}, {0x0, 0x0}};
Word testEnc[2][2] = {{0x0, 0x0}, {0x0, 0x1}};
Word testDec[2][2] = {{0x25ddac3e, 0x96176467}, {0x1bdd1834, 0x1626fb43}};

/* Test with different data sizes */
unsigned int sizes[] = {16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 0};

#define ITERATIONS 1000

#if defined(__STDC__) || defined(__cplusplus)
main(int argc, char *argv[])
#else
main(argc, argv)
int argc;
char *argv[];
#endif
{
    register
    int i, j, k;
    register
    Word *text;
    register
    unsigned int *size, s;

    register
    long t0, t1;

    double t, rate, meanCBC[2], meanECB[2];
#define _E 0
#define _D 1

    char buffer[8], tmp[8], iVector[8], *bp;

#if defined(_intel_)
    for(i = 0; i < 2; ++i) {
        for(j = 0; j < 2; ++j) {
            testKey[i][j] = htonl(testKey[i][j]);
            testEnc[i][j] = htonl(testEnc[i][j]);
            testDec[i][j] = htonl(testDec[i][j]);
        }
    }
#endif

    /* Check that it works ... */
    bp = buffer;
    i = 0; j = 1;
    memcpy((void *) bp, (void *) testEnc[i], 8);
    memset((void *) iVector, 0, 8);
    if (qfDES((char *) testKey[i], bp, 8, qfDES_encrypt, qfDES_cbc, iVector)
        != 0)
        printf("Error in qfDES()\n");
    else {
        text = (Word *) buffer;
        printf("Check: %08x %08x : %08x %08x", text[0], text[1], testDec[i][0],
               testDec[i][1]);
        printf("  encryption %s!\n",
               (text[0] == testDec[i][0] && text[1] == testDec[i][1]) ?
               "ok" : "failed");
    }

    /* single call to force intermediate keys to be re-evaluated */
    qfDES((char *) testKey[j], tmp, 8, qfDES_encrypt, qfDES_cbc, iVector);

    memset((void *) iVector, 0, 8);
    if (qfDES((char *) testKey[i], bp, 8, qfDES_decrypt, qfDES_cbc, iVector)
        != 0)
        printf("Error in qfDES()\n");
    else {
        text = (Word *) buffer;
        printf("Check: %08x %08x : %08x %08x", text[0], text[1], testEnc[i][0],
               testEnc[i][1]);
        printf("  decryption %s!\n",
               (text[0] == testEnc[i][0] && text[1] == testEnc[i][1]) ?
               "ok" : "failed");
    }

    printf("\n");

    /*
    ** The moment of truth - timings.
    ** Is clock(3) the best thing to use here?
    */
    if (argc == 2)
        i = atoi(argv[1]);
    else
        i = ITERATIONS;

    meanCBC[_E] = meanCBC[_D] = meanECB[_E] = meanECB[_E] = 0;
    printf("Timings - mean from %d repetitions\n\n", i);

    for(k = 0, size = sizes; *size != 0; ++size, ++k) {

        s = qfDES_malloc(&bp, *size - 8);
        printf("%4d bytes\n", s);
        memset((void *) bp, 0, s);
        memset((void *) iVector, 0, 8);

        /* CBC encryption */
        t0 = clock();
        for(j = 0; j < i; ++j)
            qfDES_CBC_e((char *) testKey[0], bp, s, iVector);
        t1 = clock();

        t = (1e6 * ((double) t1 - (double) t0)) / ((double) i * CLOCKS_PER_SEC);
        rate = ((double) s)/(t / 1e6);
        printf("    CBC Encryption: %5.2lf us (%5.2lf bytes/s)\n", t, rate);
        meanCBC[_E] += rate;

        /* CBC decryption */
        t0 = clock();
        for(j = 0; j < i; ++j)
            qfDES_CBC_d((char *) testKey[1], bp, s, iVector);
        t1 = clock();

        t = (1e6 * ((double) t1 - (double) t0)) / ((double) i * CLOCKS_PER_SEC);
        rate = ((double) s)/(t / 1e6);
        printf("    CBC Decryption: %5.2lf us (%5.2lf bytes/s)\n", t, rate);
        meanCBC[_D] += rate;

        /* ECB encryption */
        t0 = clock();
        for(j = 0; j < i; ++j)
            qfDES_ECB_e((char *) testKey[0], bp, s);
        t1 = clock();

        t = (1e6 * ((double) t1 - (double) t0)) / ((double) i * CLOCKS_PER_SEC);
        rate = ((double) s)/(t / 1e6);
        printf("    ECB Encryption: %5.2lf us (%5.2lf bytes/s)\n", t, rate);
        meanECB[_E] += rate;

        /* ECB decryption */
        t0 = clock();
        for(j = 0; j < i; ++j)
            qfDES_ECB_d((char *) testKey[1], bp, s);
        t1 = clock();

        t = (1e6 * ((double) t1 - (double) t0)) / ((double) i * CLOCKS_PER_SEC);
        rate = ((double) s)/(t / 1e6);
        printf("    ECB Decryption: %5.2lf us (%5.2lf bytes/s)\n", t, rate);
        meanECB[_D] += rate;

        qfDES_free(bp);
    }

    meanCBC[_E] /= (double) k; meanCBC[_D] /= (double) k;
    meanECB[_E] /= (double) k; meanECB[_D] /= (double) k;

    printf("\nMeans of rates:\n");
    printf("CBC: Encryption: %5.2lf bytes/s  Decryption: %5.2lf bytes/s\n",
           meanCBC[_E], meanCBC[_D]);
    printf("ECB: Encryption: %5.2lf bytes/s  Decryption: %5.2lf bytes/s\n",
           meanECB[_E], meanECB[_D]);

}

/*
** Misc. code fragments
*/

#if 0
    if ((fd = open("t-plain", O_RDWR)) < 0)
        printf("open(t-plain) failed\n");

    else {

        if (write(fd, buffer, 8) != 8)
            printf("write(t-plain) failed\n");
        else
            printf("write(t-plain) ok\n");

        close(fd);
    }
#endif

#if 0
    if ((fd = open("t-encrypted", O_RDWR)) < 0)
        printf("open(t-encrypted) failed\n");

    else {

        if (write(fd, buffer, 8) != 8)
            printf("write(t-encrypted) failed\n");
        else
            printf("write(t-encrypted) ok\n");

        close(fd);
    }
#endif
