// file kernel/n/ppc32/cmp.S: comparison of natural integers
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                              Comparaison                              |
 |                                                                       |
 +-----------------------------------------------------------------------*/

; long xn(cmp)(chiffre *a, long la, chiffre *b, long lb)
;
; entre :
; a = naturel de longueur la
; b = naturel de longueur lb
;
; sortie :
; 1 si a > b, 0 si a = b, -1 si a < b

#ifdef assembly_sn_cmp
#undef L
#define L(x) .Lsn_cmp##x
.globl _sn_cmp
_sn_cmp:

        ; supprime les zros de tte du plus long argument
	subf.  r2,  r6,  r4	; r2 <- la - lb
	beq    L(compare)
	mr     r4,  r2		; r4 <- |la-lb|
	mr     r7,  r3		; r7 <- &a si la > lb, &b sinon
	bgt    1f
	add    r6,  r2,  r6	; r6 <- min(la,lb)
	mr     r7,  r5
	neg    r4,  r4
1:
	add    r8,  r4,  r6	; r7 <- &(a_ou_b)[max(la,lb)]
	slwi   r8,  r8,  2
	add    r7,  r7,  r8
	mtctr  r4		; ctr <- |la-lb|
1:
	lwzu   r8, -4(r7)	; cherche le dernier chiffre non nul
	and.   r8,  r8,  r8
	bdnzt  eq,  1b
	beq    L(compare)
	srawi  r3,  r2,  31	; si trouv, r3 <- sgn(la-lb)
	ori    r3,  r3,  1
	blr

	; cas la = lb
L(compare):
	and.   r6,  r6,  r6	; si l6 = 0, la comparaison est termine
	beq    L(equal)
	mtctr  r6		; ctr <- la
	slwi   r6,  r6,  2
	add    r3,  r3,  r6	;  a += la
	add    r5,  r5,  r6
1:
	lwzu   r7,  -4(r3)	; compare a et b chiffre  chiffre
	lwzu   r8,  -4(r5)
	cmp    cr0,  r7,  r8
	bdnzt  eq,   1b
	beq    L(equal)

	subfc  r8,  r8,  r7	; sinon, r3 <- sgn(a-b)
	subfe  r3,  r3,  r3
	ori    r3,  r3,  1
	blr

L(equal):
	li     r3,  0
	blr

#undef L
#endif /* assembly_sn_cmp */
