/* NVClock 0.5.0 - Linux overclocker for NVIDIA cards
 *
 * site: http://nvclock.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "backend.h"
#include "io.h"

int openDevMem(int number)
{
    int fd;

    if(root == 0)
    {
	char nvcard[12];
	sprintf(nvcard, "/dev/nvidia%d", number);
	if ( (fd = open(nvcard, O_RDWR)) == -1 )
	{
	    printf("GetSpeed: unable to open %s\n", nvcard);
	    return -1;
	}
    }
    
    else
    {
	if ( (fd = open("/dev/mem",O_RDWR)) == -1 )
	{
	    printf("GetSpeed: unable to open /dev/mem\n");
	    return -1;
	}
    }

    return fd;
}


/* -------- mmap on devices -------- */
/* This piece of code is from nvtv a linux program for tvout */
/* The author of nvtv got this from xfree86's os-support/linux/lnx_video.c
/* and he modified it a little  */


void *mapDevMem (int fd, unsigned long Base, unsigned long Size)
{
  void *base;
  int mapflags = MAP_SHARED;
  unsigned long realBase, alignOff;

  realBase = Base & ~(getpagesize() - 1);
  alignOff = Base - realBase;

  base = mmap((caddr_t)0, Size + alignOff, PROT_READ|PROT_WRITE,
	      mapflags, fd, (off_t)realBase);
//    fprintf(stderr, "error: %s\n", strerror(errno));
  return (void *) ((char *)base + alignOff);
}

void unmapDevMem (unsigned long Base, unsigned long Size)
{
  unsigned long alignOff = Base - (Base & ~(getpagesize() - 1));

  munmap((caddr_t)(Base - alignOff), (Size + alignOff));
}

