#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "backend.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"

int card_number = 0;
int debug = 0;
float memclk = 0;
float nvclk = 0;

void nvclock_exit(void)
{
    gtk_main_quit();
}

void debug_info(GtkToggleButton *check_button)
{
    debug = gtk_toggle_button_get_active(check_button);
}

void update_core()
{
    gchar *value;
    value = g_strdup_printf("%d",  (gint)GTK_ADJUSTMENT(value_core)->value);
    gtk_entry_set_text(GTK_ENTRY(entry_core), value);
    nvclk = GTK_ADJUSTMENT(value_core)->value;
    g_free(value);
}

void update_mem()
{
    gchar *value;
    value = g_strdup_printf("%d",  (gint)GTK_ADJUSTMENT(value_mem)->value);
    gtk_entry_set_text(GTK_ENTRY(entry_mem), value);
    memclk = GTK_ADJUSTMENT(value_mem)->value;
    g_free(value);
}

void update_info()
{
    gchar *text;
    GetSpeed(&memclk, &nvclk, card_number, 0);

    text = g_strdup_printf("%0.3f", memclk);
    (gint)GTK_ADJUSTMENT(value_mem)->lower = card[card_number].memclk_min;
    (gint)GTK_ADJUSTMENT(value_mem)->upper = card[card_number].memclk_max;
    (gint)GTK_ADJUSTMENT(value_mem)->value = (memclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_mem), memclk);
    gtk_entry_set_text(GTK_ENTRY(entry_mem), text);
    g_free(text);
	
    text = g_strdup_printf("%0.3f", nvclk);
    (gint)GTK_ADJUSTMENT(value_core)->lower = card[card_number].nvclk_min;
    (gint)GTK_ADJUSTMENT(value_core)->upper = card[card_number].nvclk_max;
    (gint)GTK_ADJUSTMENT(value_core)->value = (nvclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_core), nvclk);
    gtk_entry_set_text(GTK_ENTRY(entry_core), text);
    g_free(text);
}

void update(gfloat memclk, gfloat nvclk)
{
    gchar *text;
	
    text = g_strdup_printf("%0.3f", memclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_mem), memclk);
    gtk_entry_set_text(GTK_ENTRY(entry_mem), text);
    g_free(text);
	
    text = g_strdup_printf("%0.3f", nvclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_core), nvclk);
    gtk_entry_set_text(GTK_ENTRY(entry_core), text);
    g_free(text);

}

void change_speeds(GtkButton *button, gpointer data)
{
    ChangeSpeeds(memclk, nvclk, card_number, debug);
    GetSpeed(&memclk, &nvclk, card_number, debug);
    update(memclk, nvclk);
}
