/*
 * nzb
 *
 * Copyright (C) 2004-2006 Mattias Nordstrom <matta at ftlight net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Authors:
 *   Mattias Nordstrom <matta at ftlight net>
 *
 * $Id: nzbdata.h,v 1.11 2006/05/14 10:37:53 mnordstr Exp $
 *   This file provides the nzb data classes.
 */


#ifndef NZBDATA_H
#define NZBDATA_H

#include <QtGui>
#include <QtXml>

#define NZB_VERSION		"0.1.7"

#define NZB_UNDEF		0

#define NZB_NONE		15
#define NZB_DOWNLOADING		1
#define NZB_DOWNLOADED		2
#define NZB_DL_SKIPPED		19
#define NZB_DEC_SKIPPED		20
#define NZB_DECODING		3
#define NZB_DECODED		4
#define NZB_PROCESSING		5
#define NZB_DONE		6

#define NZB_ENC_YENC		16
#define NZB_ENC_UENC		17
#define NZB_ENC_ERROR		18

#define NZB_YRES_OK		7	// Ok
#define NZB_YRES_ERRSIZE	8	// Part size mismatch
#define NZB_YRES_ERRTOTSIZE	9	// Total filesize mismatch
#define NZB_YRES_ERRPCRC32	10	// Part CRC32 error
#define NZB_YRES_ERROR		11	// General/Unknown error
#define NZB_YRES_ERRPART	12	// Part number mismatch

#define NZB_URES_OK		13	// Ok
#define NZB_URES_ERROR		14	// General/Unknown error


class NzbSeg
{
public:
	NzbSeg(int bytes, QString msgid);
	int getBytes() const { return bytes; }
	QString getMsgid() const { return msgid; }
	QString* getData() { return &data; }
	QByteArray* getDecoded() { return &decoded; }
	int getStatus() const { return status; }
	void setData(QString data) { this->data = data; }
	void setDecoded(QByteArray decoded) { this->decoded = decoded; }
	void setStatus(int status) { this->status = status; }
	int getEncoding() const { return encoding; }
	QString getFilename() const { return filename; }
	int getPart() const { return part; }
	long getSize() const { return size; }
	int getTotal() const { return total; }
	long getTotalSize() const { return total_size; }
	QString getCrc32() const { return crc32; }
	long getBlockBegin() const { return block_begin; }
	long getBlockEnd() const { return block_end; }
	void setEncoding(int encoding) { this->encoding = encoding; }
	void setFilename(QString filename) { this->filename = filename; }
	void setPart(int part) { this->part = part; }
	void setSize(long size) { this->size = size; }
	void setTotal(int total) { this->total = total; }
	void setTotalSize(long total_size) { this->total_size = total_size; }
	void setCrc32(QString crc32) { this->crc32 = crc32; }
	void setBlockBegin(long block_begin) { this->block_begin = block_begin; }
	void setBlockEnd(long block_end) { this->block_end = block_end; }
	int getEncStatus() const { return enc_status; }
	void setEncStatus(int enc_status) { this->enc_status = enc_status; }
private:
	int bytes;
	QString msgid;
	QString data;
	QByteArray decoded;
	int status;
	int enc_status;
	int encoding;
	QString filename;
	int part;
	long size;
	int total;
	long total_size;
	QString crc32;
	long block_begin;
	long block_end;
};

class NzbFile
{
public:
	NzbFile();
	NzbFile(QString poster, QDateTime date, QString subject);
	void addGroup(QString group) { groups.append(group); }
	void addSegment(NzbSeg newseg);
	QString getPoster() const { return poster; }
	QDateTime getDate() const { return date; }
	QString getSubject() const { return subject; }
	QStringList getGroups() const { return groups; }
	QList<NzbSeg>* getSegments() { return &segments; }
	NzbSeg* getSegment(int seg) { return &(segments[seg]); }
	QString getNzbFileName() const { return nzbFileName; }
	void setNzbFileName(QString nzbFile) { this->nzbFileName = nzbFile; }
	static bool subjectLessThan(const NzbFile &nf1, const NzbFile &nf2);
	int getBytes() const { return bytes; }
	int getEncoding() const { return encoding; }
	void setEncoding(int encoding) { this->encoding = encoding; }
private:
	QString poster;
	QDateTime date;
	QString subject;
	QStringList groups;
	QList<NzbSeg> segments;
	QString nzbFileName;
	int bytes;
	int encoding;
};

class NzbList
{
public:
	void importNzb(QFile *nzbfile);
	void addFile(NzbFile file) { files.append(file); }
	QList<NzbFile>* getList() { return &files; }
	NzbFile* getFile(int file) { return &(files[file]); }
	void clearList() { files.clear(); }
	void sortList();
	int totalParts();
	qint64 totalSize();
private:
	QList<NzbFile> files;
};

class NzbHandler : public QXmlDefaultHandler
{
public:
	NzbHandler(NzbList *parent, QString nzbfile);

	bool startElement(const QString &namespaceURI, const QString &localName,
		const QString &qName, const QXmlAttributes &attributes);
	bool endElement(const QString &namespaceURI, const QString &localName,
		const QString &qName);
	bool characters(const QString &str);
	bool fatalError(const QXmlParseException &exception);
	QString errorString() const;

private:
	QString nzbFileName;
	QString currentText;
	NzbFile currentFile;
	int currentBytes;
	QString errorStr;
	bool metNzbTag;
	NzbList *parent;
};

#endif
