/*

## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/
#include <vtkXRenderWindowInteractor.h>
#include <vtkXOpenGLRenderWindow.h>
#include <Xm/Protocols.h>
#include <vtkCommand.h>
#include <vtkCallbackCommand.h>
#undef Complex
#include <octave/oct.h>

vtkCallbackCommand* InteractorExitCallbackCommand = NULL;

// The following must be defined for recent versions of Octave.
#define TYPEID_HAS_CLASS
#include <octave/oct.h>
#include "octaviz.h"


// Function called when WM_DELETE_WINDOW protocol is passed
void CloseAppCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	cout << "WM_DELETE_WINDOW hello!" << endl << std::flush;
}

void ExitCallback(vtkObject*, unsigned long eid, void* clientdata, void *calldata)
{

}
	
DEFUN_DLD (vtkInitializeInteractor, args, ,
  "Returns app context.")
{
  octave_value retval;

  if ( args(0).type_id() != vtk_object::static_type_id() )
	{
		error("The parameter has to be vtkRenderWindowInteractor");
		return retval;
	}
  
	vtkObjectBase* vtk_pointer = reinterpret_cast<vtkObjectBase*>( args(0).uint_value() );
	
	if ( !vtk_pointer->IsA("vtkXRenderWindowInteractor") )
	{
		error("The parameter has to be vtkXRenderWindowInteractor");
		return retval;
	}
	
	vtkXRenderWindowInteractor* CurrentInteractor = reinterpret_cast<vtkXRenderWindowInteractor*>(vtk_pointer);
  
  if ( InteractorExitCallbackCommand == NULL )
	{
		InteractorExitCallbackCommand = vtkCallbackCommand::New();
		InteractorExitCallbackCommand->SetCallback( ExitCallback );	
	}
	CurrentInteractor->Initialize(vtk_app_context);
	CurrentInteractor->AddObserver(vtkCommand::ExitEvent, InteractorExitCallbackCommand, 0.0f );
	
	vtkXOpenGLRenderWindow* RenderWindow = reinterpret_cast<vtkXOpenGLRenderWindow*>(CurrentInteractor->GetRenderWindow());
	Widget widg = CurrentInteractor->GetWidget();
	Atom wm_delete_window = XInternAtom(XtDisplay(widg), "WM_DELETE_WINDOW", False);
	vtk_delete_window_atoms[wm_delete_window] = reinterpret_cast<unsigned int>(RenderWindow);
    // turn off default delete response
	XSetWMProtocols(XtDisplay(widg), XtWindow(widg), &wm_delete_window, 1);
  return retval;
}


/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; End: ***
*/
 
