vtk_init
% In this example vtkClipPolyData is used to cut a polygonal model;
% of a cow in half. In addition, the open clip is closed by triangulating;
% the resulting complex polygons.;

% First start by reading a cow model. We also generate surface normals for;
% prettier rendering.;
cow = vtkBYUReader();
##cow.SetGeometryFileName("/usr/share/vtkdata/Data/Viewpoint/cow.g");
VTK_DATA_ROOT = vtkGetDataRoot();
cow.SetGeometryFileName(strcat(VTK_DATA_ROOT,"/Data/Viewpoint/cow.g"));
cowNormals = vtkPolyDataNormals();
cowNormals.SetInput(cow.GetOutput());

% We clip with an implicit function. Here we use a plane positioned near;
% the center of the cow model and oriented at an arbitrary angle.;
plane = vtkPlane();
plane.SetOrigin(0.25, 0, 0);
plane.SetNormal(-1, -1, 0);

% vtkClipPolyData requires an implicit function to define what it is to;
% clip with. Any implicit function, including complex boolean combinations;
% can be used. Notice that we can specify the value of the implicit function;
% with the SetValue method.;
clipper = vtkClipPolyData();
clipper.SetInput(cowNormals.GetOutput());
clipper.SetClipFunction(plane);
clipper.GenerateClipScalarsOn();
clipper.GenerateClippedOutputOn();
clipper.SetValue(0.5);
clipMapper = vtkPolyDataMapper();
clipMapper.SetInput(clipper.GetOutput());
clipMapper.ScalarVisibilityOff();
backProp = vtkProperty();
backProp.SetDiffuseColor(1,0,0);
clipActor = vtkActor();
clipActor.SetMapper(clipMapper);
clipActor.GetProperty().SetColor(1,0,0);
clipActor.SetBackfaceProperty(backProp);

% Here we are cutting the cow. Cutting creates lines where the cut;
% function intersects the model. (Clipping removes a portion of the;
% model but the dimension of the data does not change.);
%;
% The reason we are cutting is to generate a closed polygon at the;
% boundary of the clipping process. The cutter generates line;
% segments, the stripper then puts them together into polylines. We;
% then pull a trick and define polygons using the closed line;
% segements that the stripper created.;
cutEdges = vtkCutter();
cutEdges.SetInput(cowNormals.GetOutput());
cutEdges.SetCutFunction(plane);
cutEdges.GenerateCutScalarsOn();
cutEdges.SetValue(0, 0.5);
cutStrips = vtkStripper();
cutStrips.SetInput(cutEdges.GetOutput());
cutStrips.Update();
cutPoly = vtkPolyData();
cutPoly.SetPoints(cutStrips.GetOutput().GetPoints());
cutPoly.SetPolys(cutStrips.GetOutput().GetLines());

% Triangle filter is robust enough to ignore the duplicate point at;
% the beginning and end of the polygons and triangulate them.;
cutTriangles = vtkTriangleFilter();
cutTriangles.SetInput(cutPoly);
cutMapper = vtkPolyDataMapper();
cutMapper.SetInput(cutPoly);
cutMapper.SetInput(cutTriangles.GetOutput());
cutActor = vtkActor();
cutActor.SetMapper(cutMapper);
cutActor.GetProperty().SetColor(0,0,1);

% The clipped part of the cow is rendered wireframe.;
restMapper = vtkPolyDataMapper();
restMapper.SetInput(clipper.GetClippedOutput());
restMapper.ScalarVisibilityOff();
restActor = vtkActor();
restActor.SetMapper(restMapper);
restActor.GetProperty().SetRepresentationToWireframe();

f = vtk_figure(0);
% Create graphics stuff;
ren = f.renderer;

% Add the actors to the renderer, set the background and size;
ren.AddActor(clipActor);
ren.AddActor(cutActor);
ren.AddActor(restActor);
%ren.SetBackground(1, 1, 1);
ren.GetActiveCamera().Azimuth(30);
ren.GetActiveCamera().Elevation(30);
ren.GetActiveCamera().Dolly(1.5);
ren.ResetCameraClippingRange();

%renWin.SetSize(300, 300);

vtk_update(f);