// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#ifndef PROP_MATRIX_H
#define PROP_MATRIX_H

#include "property.h"
#include "ref_pointer.h"

class Matrix : public Property {
public:
  Matrix(ocpl::Real *v,const long r,const long c);
  Matrix(const Matrix& mat); //!< copies the data
  Matrix(const Matrix& mat,int); //!< dummy argument, does not copy the data
  Matrix& operator=(const Matrix& right);
  //~ ocpl::Real* GetVal(void) {return (*Value)();}
  //~ ocpl::Real* operator()() {return (*Value)();} //!< returns the pointer to the data
  ocpl::Real  operator[](const long idx) {return (*Value)[idx];} //!< single index
  ocpl::Real  operator()(const long idx) {return (*Value)[idx];} //!< single index
  ocpl::Real  operator()(const long row, const long col) 
  {return (*Value)[col*_nr+row];}
  ~Matrix() { _DEBUG_PRINT("In ~Mat\n");delete Value; }
  long nr() {return _nr;}
  long nc() {return _nc;}
  long len() {return _nr*_nc;}
  void Get(ocpl::command&);
  void Set(ocpl::command&);
private:
  RefPointer<ocpl::Real>* Value;
  long _nc,_nr;
};


// Helper functions
Matrix* Real2Matrix(ocpl::Real x1, ocpl::Real x2);
Matrix* Real2Matrix(ocpl::Real x1, ocpl::Real x2, ocpl::Real x3);
Matrix* Real2Matrix(ocpl::Real x1, ocpl::Real x2, ocpl::Real x3, ocpl::Real x4);

#endif
