/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "DisablePatchEvent.h"
#include "Om.h"
#include "OmApp.h"
#include "OSCSender.h"
#include "OutputNode.h"
#include "OutputPort.h"
#include "util.h"
#include "ObjectStore.h"

namespace Om {


DisablePatchEvent::DisablePatchEvent(Request* request, const string& patch_path)
: SlowEvent(request),
  m_patch_path(patch_path),
  m_patch(NULL)
{
}


void
DisablePatchEvent::prepare()
{
	m_patch = om->object_store()->find_patch(m_patch_path);
	
	SlowEvent::prepare();
}


void
DisablePatchEvent::execute(uint sample_offset)
{
	if (m_patch != NULL)
		m_patch->process(false);
	
	// Write output buffers to 0
	for (List<OutputNode*>::iterator i = m_patch->output_nodes().begin();
			i != m_patch->output_nodes().end(); ++i) {
		Om::write_buffer((*i)->external_port()->buffer(0), 0.0f, 0,
			(*i)->external_port()->buffer_size());
	}

	SlowEvent::execute(sample_offset);
}


void
DisablePatchEvent::post_process()
{	
	if (m_patch != NULL) {
		m_request->respond_ok();
		om->osc_sender()->send_patch_disable(m_patch_path);
	} else {
		m_request->respond_error("Patch not found");
	}
}


} // namespace Om

