/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef METADATABASE_H
#define METADATABASE_H

#include <map>
#include <string>
#include <iostream>
using std::cerr; using std::cout; using std::endl;
using std::map; using std::string;


/* This is a trivial wrapper around the C++ STL map right now, but
 * at some point it will support more than just integer values.
 */

/** Database of metadata for an OmObject.
 *
 * Absolutely nothing in this class is realtime safe, it exists precisely to
 * store data that should be as far away from the audio processing etc. as
 * possible.
 *
 * Things like graphical module locations (for a modular synth GUI client)
 * that the engine really shouldn't be dealing with will be stored here.
 */
class MetaDataBase
{
public:
	MetaDataBase() : m_not_found_result("") {}
	
	const string& get(const string& key)
	{
		//cout << "[MetaDataBase] Getting " << key << endl;
		if (m_data.find(key) != m_data.end()) {
			return m_data[key];
		} else {
			cerr << "[MetaDataBase::get] " << key << " not found." << endl;
			return m_not_found_result;
		}
	}
	
	void set(const string& key, const string& value)
	{
		//cout << "[MetaDataBase] Setting " << key << " = " << value << endl;
		m_data[key] = value;
	}
	
	void remove(const string& key)
	{
		m_data.erase(key);
	}

	// FIXME: why even have this stupid class if this is here?!
	// make a MetaData type, but just use a map directly in objects
	const map<string, string>& data() const { return m_data; }
	
private:
	const string        m_not_found_result;
	map<string, string> m_data;
};

 #endif // METADATABASE_H
