#!/usr/bin/perl
#    OpaL Perl Modules
#    Copyright (C) 2000  Ola Lundqvist
#    $Id: where.pm,v 1.4 2002/01/22 21:14:46 ola Exp $
#    For full COPYRIGHT notice see the COPYING document.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of either:
#
#	a) the GNU General Public License as published by the Free
#	Software Foundation; either version 1, or (at your option) any
#	later version, or
#
#	b) the "Artistic License" which comes with this Kit.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either
#    the GNU General Public License or the Artistic License for more details.
#
#
#    For more information take a look at the official homepage at:
#      http://www.opal.dhs.org/programs/opalmod
#    or contact the author at:
#      opal@debian.org
#

package OpaL::where;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use POSIX qw(strftime);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw( );
@EXPORT_OK = qw(which);

# If you are using CVS/RCS this can be quite handy.
#$VERSION = do{my@r=q$Revision: 1.4 $=~/\d+/g;sprintf '%d.'.'%02d'x$#r,@r};

# If that is not what you want use this instead. Will be rewritten by
# create release.
my $version = '0.01';
$VERSION = $version;

###############################################################################
############################ PACKAGE GLOBALS ##################################
###############################################################################
# First exported ones (those in @EXPORT or @EXPORT_OK)

# Then package other global ones. (not exported ones)
# Can be accessed through $OpaL::where::variablename

# All file-scooped variables must be created before any method that uses them.
# my $myvar = '';

###############################################################################
########################### PRELOADED METHODS #################################
###############################################################################
# Preloaded methods go here.





# Autoload methods go after =cut, and are processed by the autosplit program.

# Modules must return true.
1;
__END__

###############################################################################
############################# DOCUMENTATION ###################################
###############################################################################
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

OpaL::where - Perl extension for locating system resources.

=head1 SYNOPSIS

  use OpaL::where qw(which);

=head1 DESCRIPTION

OpaL::where is a module for locating system resources.

=head1 FUNCTIONS

=over 4

=item B<which>

Which takes a program name and searches for that in the PATH environment
variable and returns the path to the executable. If no program is found with
that name undef is returned instead.

This is similar to the program with the same name. See L<which(1)>.

USAGE:
    $t = C<which>("perl");

=back

=head1 AUTHOR

Ola Lundqvist <opal@debian.org>

=head1 SEE ALSO

perl(1), which(1).

=cut

###############################################################################
########################### AUTOLOAD METHODS ##################################
###############################################################################

###############################################################################
# Name:		which
# Description:	Searches for a program in the PATH. Returns the path to the
#		file if found, undef else.
# Arguments:	A program to search for.
# Requres:	$ENV{'PATH'}
# Author:	Ola Lundqvist <opal@debian.org>
# Date:		2000-07-09	Wrote it!
###############################################################################
sub which {
    my $s = shift;
    my $d;
    foreach $d (split /:/, $ENV{'PATH'}) {
	if (-f "$d/$s") {
	    return "$d/$s";
	}
    }
    return undef;
}
