// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBlend_SurfCurvEvolRadInv_HeaderFile
#define _BRepBlend_SurfCurvEvolRadInv_HeaderFile

#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Handle_Adaptor2d_HCurve2d_HeaderFile
#include <Handle_Adaptor2d_HCurve2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Law_Function_HeaderFile
#include <Handle_Law_Function.hxx>
#endif
#ifndef _Blend_SurfCurvFuncInv_HeaderFile
#include <Blend_SurfCurvFuncInv.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Adaptor3d_HSurface;
class Adaptor3d_HCurve;
class Adaptor2d_HCurve2d;
class Law_Function;
class math_Vector;
class math_Matrix;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Class     used   to   compute  a    solution   of  the <br>
//!          surfRstConstRad  problem  on a done restriction of the <br>
//!          surface. <br>
//!          The vector  <X> used in  Value, Values and Derivatives <br>
//!          methods  has   to  be the   vector  of  the parametric <br>
//!          coordinates  wguide, wcurv, wrst  where  wguide is the <br>
//!          parameter on the guide line, wcurv is the parameter on <br>
//!          the curve, wrst is the parameter on the restriction on <br>
//!          the surface. <br>
class BRepBlend_SurfCurvEvolRadInv  : public Blend_SurfCurvFuncInv {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepBlend_SurfCurvEvolRadInv(const Handle(Adaptor3d_HSurface)& S,const Handle(Adaptor3d_HCurve)& C,const Handle(Adaptor3d_HCurve)& Cg,const Handle(Law_Function)& Evol);


Standard_EXPORT   void Set(const Standard_Integer Choix) ;

//! returns 3. <br>
Standard_EXPORT   Standard_Integer NbEquations() const;

//! computes the values <F> of the Functions for the <br>
//!          variable <X>. <br>
//!          Returns True if the computation was done successfully, <br>
//!          False otherwise. <br>
Standard_EXPORT   Standard_Boolean Value(const math_Vector& X,math_Vector& F) ;

//! returns the values <D> of the derivatives for the <br>
//!          variable <X>. <br>
//!          Returns True if the computation was done successfully, <br>
//!          False otherwise. <br>
Standard_EXPORT   Standard_Boolean Derivatives(const math_Vector& X,math_Matrix& D) ;

//! returns the values <F> of the functions and the derivatives <br>
//!          <D> for the variable <X>. <br>
//!          Returns True if the computation was done successfully, <br>
//!          False otherwise. <br>
Standard_EXPORT   Standard_Boolean Values(const math_Vector& X,math_Vector& F,math_Matrix& D) ;

//! Set the restriction on which a solution has to be found. <br>
Standard_EXPORT   void Set(const Handle(Adaptor2d_HCurve2d)& Rst) ;

//! Returns in the vector Tolerance the parametric tolerance <br>
//!          for each of the 3 variables; <br>
//!          Tol is the tolerance used in 3d space. <br>
Standard_EXPORT   void GetTolerance(math_Vector& Tolerance,const Standard_Real Tol) const;

//! Returns in the vector InfBound the lowest values allowed <br>
//!          for each of the 3 variables. <br>
//!          Returns in the vector SupBound the greatest values allowed <br>
//!          for each of the 3 variables. <br>
Standard_EXPORT   void GetBounds(math_Vector& InfBound,math_Vector& SupBound) const;

//! Returns Standard_True if Sol is a zero of the function. <br>
//!          Tol is the tolerance used in 3d space. <br>
Standard_EXPORT   Standard_Boolean IsSolution(const math_Vector& Sol,const Standard_Real Tol) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Adaptor3d_HSurface surf;
Handle_Adaptor3d_HCurve curv;
Handle_Adaptor3d_HCurve guide;
Handle_Adaptor2d_HCurve2d rst;
Standard_Real ray;
Standard_Integer choix;
Handle_Law_Function tevol;
Standard_Real sg1;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
