// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakePrism_HeaderFile
#define _BRepPrimAPI_MakePrism_HeaderFile

#ifndef _BRepSweep_Prism_HeaderFile
#include <BRepSweep_Prism.hxx>
#endif
#ifndef _BRepPrimAPI_MakeSweep_HeaderFile
#include <BRepPrimAPI_MakeSweep.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Shape;
class gp_Vec;
class gp_Dir;
class BRepSweep_Prism;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build linear swept topologies, called prisms. <br>
//! A prism is defined by: <br>
//! -   a basis shape, which is swept, and <br>
//! -   a sweeping direction, which is: <br>
//!   -   a vector for finite prisms, or <br>
//!   -   a direction for infinite or semi-infinite prisms. <br>
//! The basis shape must not contain any solids. <br>
//! The profile generates objects according to the following rules: <br>
//! -   Vertices generate Edges <br>
//! -   Edges generate Faces. <br>
//! -   Wires generate Shells. <br>
//! -   Faces generate Solids. <br>
//! -   Shells generate Composite Solids <br>
//! A MakePrism object provides a framework for: <br>
//! -   defining the construction of a prism, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepPrimAPI_MakePrism  : public BRepPrimAPI_MakeSweep {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Builds the prism of base S and vector V. If C is true, <br>
//!          S is copied. If Canonize is true then generated surfaces <br>
//!          are attempted to be canonized in simple types <br>
Standard_EXPORT BRepPrimAPI_MakePrism(const TopoDS_Shape& S,const gp_Vec& V,const Standard_Boolean Copy = Standard_False,const Standard_Boolean Canonize = Standard_True);

//! Builds a semi-infinite or an infinite prism of base S. <br>
//!          If Inf is true the prism  is infinite, if Inf is false <br>
//!          the prism is semi-infinite (in the direction D).  If C <br>
//!          is true S is copied (for semi-infinite prisms). <br>
//!          If Canonize is true then generated surfaces <br>
//!          are attempted to be canonized in simple types <br>
Standard_EXPORT BRepPrimAPI_MakePrism(const TopoDS_Shape& S,const gp_Dir& D,const Standard_Boolean Inf = Standard_True,const Standard_Boolean Copy = Standard_False,const Standard_Boolean Canonize = Standard_True);

//! Returns the internal sweeping algorithm. <br>
//! <br>
Standard_EXPORT  const BRepSweep_Prism& Prism() const;

//! Builds the resulting shape (redefined from MakeShape). <br>
Standard_EXPORT virtual  void Build() ;

//! Returns the  TopoDS  Shape of the bottom of the prism. <br>
Standard_EXPORT   TopoDS_Shape FirstShape() ;

//! Returns the TopoDS Shape of the top of the prism. <br>
//! In the case of a finite prism, FirstShape returns the <br>
//! basis of the prism, in other words, S if Copy is false; <br>
//! otherwise, the copy of S belonging to the prism. <br>
//! LastShape returns the copy of S translated by V at the <br>
//! time of construction. <br>
Standard_EXPORT   TopoDS_Shape LastShape() ;

//! Returns ListOfShape from TopTools. <br>
Standard_EXPORT virtual const TopTools_ListOfShape& Generated(const TopoDS_Shape& S) ;

//! Returns the TopoDS Shape of the bottom  of the  prism. <br>
//!          generated  with  theShape (subShape of the  generating shape). <br>
Standard_EXPORT   TopoDS_Shape FirstShape(const TopoDS_Shape& theShape) ;

//! Returns the  TopoDS  Shape of the top  of  the  prism. <br>
//!          generated  with  theShape (subShape of the  generating shape). <br>
Standard_EXPORT   TopoDS_Shape LastShape(const TopoDS_Shape& theShape) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepSweep_Prism myPrism;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
