// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BooleanOperations_AncestorsSeqAndSuccessorsSeq_HeaderFile
#define _BooleanOperations_AncestorsSeqAndSuccessorsSeq_HeaderFile

#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! provide all the ancestors and  successors of a -- <br>
//!          given shape.  Exemple : for  an edge the ancestors <br>
//!           -- are the wires  that hold it and the successors <br>
//!          are -- its vertices.  As  we don't know the number <br>
//!          of -- ancestors of a given shape we first put them <br>
//!           in a -- sequence  of integers (our data structure <br>
//!          -- defining      the shapes does not   have   back <br>
//!          pointers). Then  we   transfer these data  in  the <br>
//!          class AncestorsAndSuccessors. <br>
class BooleanOperations_AncestorsSeqAndSuccessorsSeq  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BooleanOperations_AncestorsSeqAndSuccessorsSeq();

//! to display the fields. <br>
Standard_EXPORT   void Dump() const;

  Standard_Integer GetAncestor(const Standard_Integer AncestorIndex) const;

  Standard_Integer GetSuccessor(const Standard_Integer SuccessorIndex) const;

  TopAbs_Orientation GetOrientation(const Standard_Integer OrientationIndex) const;

  Standard_Integer NumberOfAncestors() const;

  Standard_Integer NumberOfSuccessors() const;
//! appends AncestorNumber in the sequence. <br>
  void SetNewAncestor(const Standard_Integer AncestorNumber) ;
//! appends SuccessorNumber in the array refering to <mySuccessorsInserted>. <br>
  void SetNewSuccessor(const Standard_Integer SuccessorNumber) ;
//! appends SuccessorNumber in the array refering to <mySuccessorsInserted>. <br>
  void SetNewOrientation(const TopAbs_Orientation theOrientation) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TColStd_SequenceOfInteger myAncestors;
TColStd_SequenceOfInteger mySuccessors;
TColStd_SequenceOfInteger myOrientations;


};


#include <BooleanOperations_AncestorsSeqAndSuccessorsSeq.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
