// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2d_BoundedCurve_HeaderFile
#define _Geom2d_BoundedCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom2d_BoundedCurve_HeaderFile
#include <Handle_Geom2d_BoundedCurve.hxx>
#endif

#ifndef _Geom2d_Curve_HeaderFile
#include <Geom2d_Curve.hxx>
#endif
class gp_Pnt2d;


//! The abstract class BoundedCurve describes the <br>
//! common behavior of bounded curves in 2D space. A <br>
//! bounded curve is limited by two finite values of the <br>
//! parameter, termed respectively "first parameter" and <br>
//! "last parameter". The "first parameter" gives the "start <br>
//! point" of the bounded curve, and the "last parameter" <br>
//! gives the "end point" of the bounded curve. <br>
//! The length of a bounded curve is finite. <br>
//! The Geom2d package provides three concrete <br>
//! classes of bounded curves: <br>
//! - two frequently used mathematical formulations of complex curves: <br>
//!   - Geom2d_BezierCurve, <br>
//!   - Geom2d_BSplineCurve, and <br>
//! - Geom2d_TrimmedCurve to trim a curve, i.e. to <br>
//!   only take part of the curve limited by two values of <br>
//!   the parameter of the basis curve. <br>
class Geom2d_BoundedCurve : public Geom2d_Curve {

public:
 // Methods PUBLIC
 // 


//!  Returns the end point of the curve. <br>
//!  The end point is the value of the curve for the <br>
//!  "LastParameter" of the curve. <br>
Standard_EXPORT virtual  gp_Pnt2d EndPoint() const = 0;


//!  Returns the start point of the curve. <br>
//!  The start point is the value of the curve for the <br>
//!  "FirstParameter" of the curve. <br>
Standard_EXPORT virtual  gp_Pnt2d StartPoint() const = 0;
//Standard_EXPORT ~Geom2d_BoundedCurve();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
